/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.OreDictionaryEntries;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusHelper;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.construct.ItemTurretPlacer;
import thaumcraft.common.entities.construct.golem.ItemGolemBell;
import thaumcraft.common.entities.construct.golem.ItemGolemPlacer;
import thaumcraft.common.entities.construct.golem.seals.ItemSealPlacer;
import thaumcraft.common.entities.construct.golem.seals.SealBreaker;
import thaumcraft.common.entities.construct.golem.seals.SealButcher;
import thaumcraft.common.entities.construct.golem.seals.SealEmpty;
import thaumcraft.common.entities.construct.golem.seals.SealEmptyAdvanced;
import thaumcraft.common.entities.construct.golem.seals.SealFill;
import thaumcraft.common.entities.construct.golem.seals.SealFillAdvanced;
import thaumcraft.common.entities.construct.golem.seals.SealGuard;
import thaumcraft.common.entities.construct.golem.seals.SealGuardAdvanced;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.seals.SealHarvest;
import thaumcraft.common.entities.construct.golem.seals.SealLumber;
import thaumcraft.common.entities.construct.golem.seals.SealPickup;
import thaumcraft.common.entities.construct.golem.seals.SealPickupAdvanced;
import thaumcraft.common.entities.construct.golem.seals.SealProvide;
import thaumcraft.common.entities.construct.golem.seals.SealUse;
import thaumcraft.common.items.IThaumcraftItems;
import thaumcraft.common.items.ItemTCBase;
import thaumcraft.common.items.armor.ItemBootsTraveller;
import thaumcraft.common.items.armor.ItemCultistBoots;
import thaumcraft.common.items.armor.ItemCultistLeaderArmor;
import thaumcraft.common.items.armor.ItemCultistPlateArmor;
import thaumcraft.common.items.armor.ItemCultistRobeArmor;
import thaumcraft.common.items.armor.ItemFortressArmor;
import thaumcraft.common.items.armor.ItemGoggles;
import thaumcraft.common.items.armor.ItemRobeArmor;
import thaumcraft.common.items.armor.ItemThaumiumArmor;
import thaumcraft.common.items.armor.ItemVoidArmor;
import thaumcraft.common.items.armor.ItemVoidRobeArmor;
import thaumcraft.common.items.baubles.ItemAmuletVis;
import thaumcraft.common.items.baubles.ItemBaubles;
import thaumcraft.common.items.baubles.ItemCloudRing;
import thaumcraft.common.items.baubles.ItemCuriosityBand;
import thaumcraft.common.items.baubles.ItemVerdantCharm;
import thaumcraft.common.items.baubles.ItemVoidseerCharm;
import thaumcraft.common.items.casters.ItemCaster;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.items.casters.ItemFocusPouch;
import thaumcraft.common.items.casters.foci.FEffectBreak;
import thaumcraft.common.items.casters.foci.FEffectCurse;
import thaumcraft.common.items.casters.foci.FEffectExchange;
import thaumcraft.common.items.casters.foci.FEffectFire;
import thaumcraft.common.items.casters.foci.FEffectFrost;
import thaumcraft.common.items.casters.foci.FEffectMagic;
import thaumcraft.common.items.casters.foci.FEffectRift;
import thaumcraft.common.items.casters.foci.FMediumBolt;
import thaumcraft.common.items.casters.foci.FMediumProjectile;
import thaumcraft.common.items.casters.foci.FMediumTouch;
import thaumcraft.common.items.casters.foci.FModChain;
import thaumcraft.common.items.casters.foci.FModCharge;
import thaumcraft.common.items.casters.foci.FModFortune;
import thaumcraft.common.items.casters.foci.FModFrugal;
import thaumcraft.common.items.casters.foci.FModLingering;
import thaumcraft.common.items.casters.foci.FModPotency;
import thaumcraft.common.items.casters.foci.FModScatter;
import thaumcraft.common.items.casters.foci.FModSilkTouch;
import thaumcraft.common.items.consumables.ItemAlumentum;
import thaumcraft.common.items.consumables.ItemBathSalts;
import thaumcraft.common.items.consumables.ItemBottleTaint;
import thaumcraft.common.items.consumables.ItemBucketDeath;
import thaumcraft.common.items.consumables.ItemBucketPure;
import thaumcraft.common.items.consumables.ItemChunksEdible;
import thaumcraft.common.items.consumables.ItemLabel;
import thaumcraft.common.items.consumables.ItemPhial;
import thaumcraft.common.items.consumables.ItemSanitySoap;
import thaumcraft.common.items.consumables.ItemTripleMeatTreat;
import thaumcraft.common.items.consumables.ItemZombieBrain;
import thaumcraft.common.items.curios.ItemCurio;
import thaumcraft.common.items.curios.ItemLootBag;
import thaumcraft.common.items.curios.ItemPechWand;
import thaumcraft.common.items.curios.ItemPrimordialPearl;
import thaumcraft.common.items.curios.ItemThaumonomicon;
import thaumcraft.common.items.misc.ItemCreativeFluxSponge;
import thaumcraft.common.items.resources.ItemCrystalEssence;
import thaumcraft.common.items.resources.ItemMagicDust;
import thaumcraft.common.items.tools.ItemCrimsonBlade;
import thaumcraft.common.items.tools.ItemElementalAxe;
import thaumcraft.common.items.tools.ItemElementalHoe;
import thaumcraft.common.items.tools.ItemElementalPickaxe;
import thaumcraft.common.items.tools.ItemElementalShovel;
import thaumcraft.common.items.tools.ItemElementalSword;
import thaumcraft.common.items.tools.ItemHandMirror;
import thaumcraft.common.items.tools.ItemPrimalCrusher;
import thaumcraft.common.items.tools.ItemResonator;
import thaumcraft.common.items.tools.ItemSanityChecker;
import thaumcraft.common.items.tools.ItemScribingTools;
import thaumcraft.common.items.tools.ItemThaumiumAxe;
import thaumcraft.common.items.tools.ItemThaumiumHoe;
import thaumcraft.common.items.tools.ItemThaumiumPickaxe;
import thaumcraft.common.items.tools.ItemThaumiumShovel;
import thaumcraft.common.items.tools.ItemThaumiumSword;
import thaumcraft.common.items.tools.ItemThaumometer;
import thaumcraft.common.items.tools.ItemVoidAxe;
import thaumcraft.common.items.tools.ItemVoidHoe;
import thaumcraft.common.items.tools.ItemVoidPickaxe;
import thaumcraft.common.items.tools.ItemVoidShovel;
import thaumcraft.common.items.tools.ItemVoidSword;
import thaumcraft.common.lib.CreativeTabThaumcraft;

public class ConfigItems {
    public static ItemStack startBook = new ItemStack(Items.field_151164_bB);
    public static CreativeTabs TABTC = new CreativeTabThaumcraft(CreativeTabs.getNextID(), "thaumcraft");
    public static final List<IThaumcraftItems> ITEM_VARIANT_HOLDERS = new ArrayList<IThaumcraftItems>();
    public static ItemStack AIR_CRYSTAL;
    public static ItemStack FIRE_CRYSTAL;
    public static ItemStack WATER_CRYSTAL;
    public static ItemStack EARTH_CRYSTAL;
    public static ItemStack ORDER_CRYSTAL;
    public static ItemStack ENTROPY_CRYSTAL;
    public static ItemStack FLUX_CRYSTAL;

    public static void preInit() {
        ConfigItems.initializeItems();
        OreDictionaryEntries.initializeOreDictionary();
        AIR_CRYSTAL = ThaumcraftApiHelper.makeCrystal(Aspect.AIR);
        FIRE_CRYSTAL = ThaumcraftApiHelper.makeCrystal(Aspect.FIRE);
        WATER_CRYSTAL = ThaumcraftApiHelper.makeCrystal(Aspect.WATER);
        EARTH_CRYSTAL = ThaumcraftApiHelper.makeCrystal(Aspect.EARTH);
        ORDER_CRYSTAL = ThaumcraftApiHelper.makeCrystal(Aspect.ORDER);
        ENTROPY_CRYSTAL = ThaumcraftApiHelper.makeCrystal(Aspect.ENTROPY);
        FLUX_CRYSTAL = ThaumcraftApiHelper.makeCrystal(Aspect.FLUX);
        OreDictionary.registerOre((String)"shardAir", (ItemStack)AIR_CRYSTAL);
        OreDictionary.registerOre((String)"shardFire", (ItemStack)AIR_CRYSTAL);
        OreDictionary.registerOre((String)"shardWater", (ItemStack)WATER_CRYSTAL);
        OreDictionary.registerOre((String)"shardEarth", (ItemStack)EARTH_CRYSTAL);
        OreDictionary.registerOre((String)"shardOrder", (ItemStack)ORDER_CRYSTAL);
        OreDictionary.registerOre((String)"shardEntropy", (ItemStack)ENTROPY_CRYSTAL);
        OreDictionary.registerOre((String)"shardTainted", (ItemStack)FLUX_CRYSTAL);
        NBTTagCompound contents = new NBTTagCompound();
        contents.func_74768_a("generation", 3);
        contents.func_74778_a("title", I18n.func_74838_a((String)"book.start.title"));
        NBTTagList pages = new NBTTagList();
        pages.func_74742_a((NBTBase)new NBTTagString(I18n.func_74838_a((String)"book.start.1")));
        pages.func_74742_a((NBTBase)new NBTTagString(I18n.func_74838_a((String)"book.start.2")));
        pages.func_74742_a((NBTBase)new NBTTagString(I18n.func_74838_a((String)"book.start.3")));
        contents.func_74782_a("pages", (NBTBase)pages);
        startBook.func_77982_d(contents);
    }

    private static void initializeItems() {
        ItemsTC.thaumonomicon = new ItemThaumonomicon();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumonomicon);
        ItemsTC.curio = new ItemCurio();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.curio);
        ItemsTC.lootBag = new ItemLootBag();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.lootBag);
        ItemsTC.primordialPearl = new ItemPrimordialPearl();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.primordialPearl);
        ItemsTC.pechWand = new ItemPechWand();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.pechWand);
        ItemsTC.amber = new ItemTCBase("amber", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.amber);
        ItemsTC.quicksilver = new ItemTCBase("quicksilver", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.quicksilver);
        ItemsTC.ingots = new ItemTCBase("ingot", "thaumium", "void", "brass");
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.ingots);
        ItemsTC.nuggets = new ItemTCBase("nugget", "iron", "copper", "tin", "silver", "lead", "quicksilver", "thaumium", "void", "brass", "quartz", "rareearth");
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.nuggets);
        ItemsTC.clusters = new ItemTCBase("cluster", "iron", "gold", "copper", "tin", "silver", "lead", "cinnabar", "quartz");
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.clusters);
        ItemsTC.fabric = new ItemTCBase("fabric", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.fabric);
        ItemsTC.visResonator = new ItemTCBase("vis_resonator", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.visResonator);
        ItemsTC.tallow = new ItemTCBase("tallow", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.tallow);
        ItemsTC.gear = new ItemTCBase("gear", "brass", "thaumium", "void");
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.gear);
        ItemsTC.plate = new ItemTCBase("plate", "brass", "iron", "thaumium", "void");
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.plate);
        ItemsTC.filter = new ItemTCBase("filter", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.filter);
        ItemsTC.morphicResonator = new ItemTCBase("morphic_resonator", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.morphicResonator);
        ItemsTC.salisMundus = new ItemMagicDust();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.salisMundus);
        ItemsTC.mirroredGlass = new ItemTCBase("mirrored_glass", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.mirroredGlass);
        ItemsTC.voidSeed = new ItemTCBase("void_seed", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidSeed);
        ItemsTC.mind = new ItemTCBase("mind", "clockwork", "biothaumic");
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.mind);
        ItemsTC.modules = new ItemTCBase("module", "vision", "aggression");
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.modules);
        ItemsTC.crystalEssence = new ItemCrystalEssence();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crystalEssence);
        ItemsTC.chunks = new ItemChunksEdible();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.chunks);
        ItemsTC.tripleMeatTreat = new ItemTripleMeatTreat();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.tripleMeatTreat);
        ItemsTC.brain = new ItemZombieBrain();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.brain);
        ItemsTC.label = new ItemLabel();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.label);
        ItemsTC.phial = new ItemPhial();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.phial);
        ItemsTC.alumentum = new ItemAlumentum();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.alumentum);
        ItemsTC.jarBrace = new ItemTCBase("jar_brace", new String[0]);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.jarBrace);
        ItemsTC.bucketDeath = new ItemBucketDeath();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.bucketDeath);
        ItemsTC.bucketPure = new ItemBucketPure();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.bucketPure);
        ItemsTC.bottleTaint = new ItemBottleTaint();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.bottleTaint);
        ItemsTC.sanitySoap = new ItemSanitySoap();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.sanitySoap);
        ItemsTC.bathSalts = new ItemBathSalts();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.bathSalts);
        ItemsTC.turretPlacer = new ItemTurretPlacer();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.turretPlacer);
        ItemsTC.scribingTools = new ItemScribingTools();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.scribingTools);
        ItemsTC.thaumometer = new ItemThaumometer();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumometer);
        ItemsTC.resonator = new ItemResonator();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.resonator);
        ItemsTC.sanityChecker = new ItemSanityChecker();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.sanityChecker);
        ItemsTC.handMirror = new ItemHandMirror();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.handMirror);
        ItemsTC.thaumiumAxe = new ItemThaumiumAxe(ThaumcraftMaterials.TOOLMAT_THAUMIUM);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumiumAxe);
        ItemsTC.thaumiumSword = new ItemThaumiumSword(ThaumcraftMaterials.TOOLMAT_THAUMIUM);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumiumSword);
        ItemsTC.thaumiumShovel = new ItemThaumiumShovel(ThaumcraftMaterials.TOOLMAT_THAUMIUM);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumiumShovel);
        ItemsTC.thaumiumPick = new ItemThaumiumPickaxe(ThaumcraftMaterials.TOOLMAT_THAUMIUM);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumiumPick);
        ItemsTC.thaumiumHoe = new ItemThaumiumHoe(ThaumcraftMaterials.TOOLMAT_THAUMIUM);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumiumHoe);
        ItemsTC.voidAxe = new ItemVoidAxe(ThaumcraftMaterials.TOOLMAT_VOID);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidAxe);
        ItemsTC.voidSword = new ItemVoidSword(ThaumcraftMaterials.TOOLMAT_VOID);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidSword);
        ItemsTC.voidShovel = new ItemVoidShovel(ThaumcraftMaterials.TOOLMAT_VOID);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidShovel);
        ItemsTC.voidPick = new ItemVoidPickaxe(ThaumcraftMaterials.TOOLMAT_VOID);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidPick);
        ItemsTC.voidHoe = new ItemVoidHoe(ThaumcraftMaterials.TOOLMAT_VOID);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidHoe);
        ItemsTC.elementalAxe = new ItemElementalAxe(ThaumcraftMaterials.TOOLMAT_ELEMENTAL);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.elementalAxe);
        ItemsTC.elementalSword = new ItemElementalSword(ThaumcraftMaterials.TOOLMAT_ELEMENTAL);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.elementalSword);
        ItemsTC.elementalShovel = new ItemElementalShovel(ThaumcraftMaterials.TOOLMAT_ELEMENTAL);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.elementalShovel);
        ItemsTC.elementalPick = new ItemElementalPickaxe(ThaumcraftMaterials.TOOLMAT_ELEMENTAL);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.elementalPick);
        ItemsTC.elementalHoe = new ItemElementalHoe(ThaumcraftMaterials.TOOLMAT_ELEMENTAL);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.elementalHoe);
        ItemsTC.primalCrusher = new ItemPrimalCrusher();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.primalCrusher);
        ItemsTC.crimsonBlade = new ItemCrimsonBlade();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonBlade);
        ItemsTC.goggles = new ItemGoggles();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.goggles);
        ItemsTC.thaumiumHelm = new ItemThaumiumArmor("thaumium_helm", ThaumcraftMaterials.ARMORMAT_THAUMIUM, 2, EntityEquipmentSlot.HEAD);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumiumHelm);
        ItemsTC.thaumiumChest = new ItemThaumiumArmor("thaumium_chest", ThaumcraftMaterials.ARMORMAT_THAUMIUM, 2, EntityEquipmentSlot.CHEST);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumiumChest);
        ItemsTC.thaumiumLegs = new ItemThaumiumArmor("thaumium_legs", ThaumcraftMaterials.ARMORMAT_THAUMIUM, 2, EntityEquipmentSlot.LEGS);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumiumLegs);
        ItemsTC.thaumiumBoots = new ItemThaumiumArmor("thaumium_boots", ThaumcraftMaterials.ARMORMAT_THAUMIUM, 2, EntityEquipmentSlot.FEET);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.thaumiumBoots);
        ItemsTC.clothChest = new ItemRobeArmor("cloth_chest", ThaumcraftMaterials.ARMORMAT_SPECIAL, 1, EntityEquipmentSlot.CHEST);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.clothChest);
        ItemsTC.clothLegs = new ItemRobeArmor("cloth_legs", ThaumcraftMaterials.ARMORMAT_SPECIAL, 2, EntityEquipmentSlot.LEGS);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.clothLegs);
        ItemsTC.clothBoots = new ItemRobeArmor("cloth_boots", ThaumcraftMaterials.ARMORMAT_SPECIAL, 1, EntityEquipmentSlot.FEET);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.clothBoots);
        ItemsTC.travellerBoots = new ItemBootsTraveller();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.travellerBoots);
        ItemsTC.fortressHelm = new ItemFortressArmor("fortress_helm", ThaumcraftMaterials.ARMORMAT_FORTRESS, 4, EntityEquipmentSlot.HEAD);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.fortressHelm);
        ItemsTC.fortressChest = new ItemFortressArmor("fortress_chest", ThaumcraftMaterials.ARMORMAT_FORTRESS, 4, EntityEquipmentSlot.CHEST);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.fortressChest);
        ItemsTC.fortressLegs = new ItemFortressArmor("fortress_legs", ThaumcraftMaterials.ARMORMAT_FORTRESS, 4, EntityEquipmentSlot.LEGS);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.fortressLegs);
        ItemsTC.voidHelm = new ItemVoidArmor("void_helm", ThaumcraftMaterials.ARMORMAT_VOID, 2, EntityEquipmentSlot.HEAD);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidHelm);
        ItemsTC.voidChest = new ItemVoidArmor("void_chest", ThaumcraftMaterials.ARMORMAT_VOID, 2, EntityEquipmentSlot.CHEST);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidChest);
        ItemsTC.voidLegs = new ItemVoidArmor("void_legs", ThaumcraftMaterials.ARMORMAT_VOID, 2, EntityEquipmentSlot.LEGS);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidLegs);
        ItemsTC.voidBoots = new ItemVoidArmor("void_boots", ThaumcraftMaterials.ARMORMAT_VOID, 2, EntityEquipmentSlot.FEET);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidBoots);
        ItemsTC.voidRobeHelm = new ItemVoidRobeArmor("void_robe_helm", ThaumcraftMaterials.ARMORMAT_VOID, 4, EntityEquipmentSlot.HEAD);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidRobeHelm);
        ItemsTC.voidRobeChest = new ItemVoidRobeArmor("void_robe_chest", ThaumcraftMaterials.ARMORMAT_VOID, 4, EntityEquipmentSlot.CHEST);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidRobeChest);
        ItemsTC.voidRobeLegs = new ItemVoidRobeArmor("void_robe_legs", ThaumcraftMaterials.ARMORMAT_VOID, 4, EntityEquipmentSlot.LEGS);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.voidRobeLegs);
        ItemsTC.crimsonPlateHelm = new ItemCultistPlateArmor("crimson_plate_helm", ItemArmor.ArmorMaterial.IRON, 4, EntityEquipmentSlot.HEAD);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonPlateHelm);
        ItemsTC.crimsonPlateChest = new ItemCultistPlateArmor("crimson_plate_chest", ItemArmor.ArmorMaterial.IRON, 4, EntityEquipmentSlot.CHEST);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonPlateChest);
        ItemsTC.crimsonPlateLegs = new ItemCultistPlateArmor("crimson_plate_legs", ItemArmor.ArmorMaterial.IRON, 4, EntityEquipmentSlot.LEGS);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonPlateLegs);
        ItemsTC.crimsonBoots = new ItemCultistBoots();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonBoots);
        ItemsTC.crimsonRobeHelm = new ItemCultistRobeArmor("crimson_robe_helm", ItemArmor.ArmorMaterial.IRON, 4, EntityEquipmentSlot.HEAD);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonRobeHelm);
        ItemsTC.crimsonRobeChest = new ItemCultistRobeArmor("crimson_robe_chest", ItemArmor.ArmorMaterial.IRON, 4, EntityEquipmentSlot.CHEST);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonRobeChest);
        ItemsTC.crimsonRobeLegs = new ItemCultistRobeArmor("crimson_robe_legs", ItemArmor.ArmorMaterial.IRON, 4, EntityEquipmentSlot.LEGS);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonRobeLegs);
        ItemsTC.crimsonPraetorHelm = new ItemCultistLeaderArmor("crimson_praetor_helm", 4, EntityEquipmentSlot.HEAD);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonPraetorHelm);
        ItemsTC.crimsonPraetorChest = new ItemCultistLeaderArmor("crimson_praetor_chest", 4, EntityEquipmentSlot.CHEST);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonPraetorChest);
        ItemsTC.crimsonPraetorLegs = new ItemCultistLeaderArmor("crimson_praetor_legs", 4, EntityEquipmentSlot.LEGS);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.crimsonPraetorLegs);
        ItemsTC.baubles = new ItemBaubles();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.baubles);
        ItemsTC.amuletVis = new ItemAmuletVis();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.amuletVis);
        ItemsTC.charmVerdant = new ItemVerdantCharm();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.charmVerdant);
        ItemsTC.bandCuriosity = new ItemCuriosityBand();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.bandCuriosity);
        ItemsTC.charmVoidseer = new ItemVoidseerCharm();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.charmVoidseer);
        ItemsTC.ringCloud = new ItemCloudRing();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.ringCloud);
        ItemsTC.creativeFluxSponge = new ItemCreativeFluxSponge();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.creativeFluxSponge);
        ItemsTC.casterBasic = new ItemCaster("caster_basic", 0);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.casterBasic);
        ItemsTC.focusBlank = new ItemTCBase("focus_blank", new String[0]).func_77625_d(1).func_77637_a(TABTC);
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.focusBlank);
        ItemsTC.focus = new ItemFocus();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.focus);
        ItemsTC.focusPouch = new ItemFocusPouch();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.focusPouch);
        ItemsTC.golemBell = new ItemGolemBell();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.golemBell);
        ItemsTC.golemPlacer = new ItemGolemPlacer();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.golemPlacer);
        ItemsTC.seals = new ItemSealPlacer();
        GameRegistry.register((IForgeRegistryEntry)ItemsTC.seals);
    }

    public static void init() {
        FocusHelper.POTENCY = new FModPotency();
        FocusHelper.registerFocusPart(FocusHelper.POTENCY, new IFocusPart[0]);
        FocusHelper.LINGERING = new FModLingering();
        FocusHelper.registerFocusPart(FocusHelper.LINGERING, new IFocusPart[0]);
        FocusHelper.FRUGAL = new FModFrugal();
        FocusHelper.registerFocusPart(FocusHelper.FRUGAL, new IFocusPart[0]);
        FocusHelper.SCATTER = new FModScatter();
        FocusHelper.registerFocusPart(FocusHelper.SCATTER, new IFocusPart[0]);
        FocusHelper.CHAIN = new FModChain();
        FocusHelper.registerFocusPart(FocusHelper.CHAIN, new IFocusPart[0]);
        FocusHelper.SILKTOUCH = new FModSilkTouch();
        FocusHelper.registerFocusPart(FocusHelper.SILKTOUCH, new IFocusPart[0]);
        FocusHelper.FORTUNE = new FModFortune();
        FocusHelper.registerFocusPart(FocusHelper.FORTUNE, new IFocusPart[0]);
        FocusHelper.CHARGE = new FModCharge();
        FocusHelper.registerFocusPart(FocusHelper.CHARGE, new IFocusPart[0]);
        FocusHelper.TOUCH = new FMediumTouch();
        FocusHelper.registerFocusPart(FocusHelper.TOUCH, new IFocusPart[0]);
        FocusHelper.BOLT = new FMediumBolt();
        FocusHelper.registerFocusPart(FocusHelper.BOLT, FocusHelper.CHAIN, FocusHelper.CHARGE);
        FocusHelper.PROJECTILE = new FMediumProjectile();
        FocusHelper.registerFocusPart(FocusHelper.PROJECTILE, FocusHelper.SCATTER, FocusHelper.CHARGE);
        FocusHelper.FIRE = new FEffectFire();
        FocusHelper.registerFocusPart(FocusHelper.FIRE, FocusHelper.POTENCY, FocusHelper.FRUGAL, FocusHelper.LINGERING);
        FocusHelper.FROST = new FEffectFrost();
        FocusHelper.registerFocusPart(FocusHelper.FROST, FocusHelper.POTENCY, FocusHelper.FRUGAL, FocusHelper.LINGERING);
        FocusHelper.MAGIC = new FEffectMagic();
        FocusHelper.registerFocusPart(FocusHelper.MAGIC, FocusHelper.POTENCY, FocusHelper.FRUGAL);
        FocusHelper.CURSE = new FEffectCurse();
        FocusHelper.registerFocusPart(FocusHelper.CURSE, FocusHelper.POTENCY, FocusHelper.FRUGAL, FocusHelper.LINGERING);
        FocusHelper.BREAK = new FEffectBreak();
        FocusHelper.registerFocusPart(FocusHelper.BREAK, FocusHelper.FORTUNE, FocusHelper.FRUGAL, FocusHelper.SILKTOUCH);
        FocusHelper.EXCHANGE = new FEffectExchange();
        FocusHelper.registerFocusPart(FocusHelper.EXCHANGE, FocusHelper.FORTUNE, FocusHelper.FRUGAL, FocusHelper.SILKTOUCH);
        FocusHelper.RIFT = new FEffectRift();
        FocusHelper.registerFocusPart(FocusHelper.RIFT, FocusHelper.POTENCY, FocusHelper.FRUGAL, FocusHelper.LINGERING);
    }

    public static void preInitSeals() {
        SealHandler.registerSeal(new SealPickup());
        SealHandler.registerSeal(new SealPickupAdvanced());
        SealHandler.registerSeal(new SealFill());
        SealHandler.registerSeal(new SealFillAdvanced());
        SealHandler.registerSeal(new SealEmpty());
        SealHandler.registerSeal(new SealEmptyAdvanced());
        SealHandler.registerSeal(new SealHarvest());
        SealHandler.registerSeal(new SealButcher());
        SealHandler.registerSeal(new SealGuard());
        SealHandler.registerSeal(new SealGuardAdvanced());
        SealHandler.registerSeal(new SealLumber());
        SealHandler.registerSeal(new SealBreaker());
        SealHandler.registerSeal(new SealUse());
        SealHandler.registerSeal(new SealProvide());
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModelsAndVariants() {
        for (IThaumcraftItems itemVariantHolder : ITEM_VARIANT_HOLDERS) {
            ConfigItems.initModelAndVariants(itemVariantHolder);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void initModelAndVariants(IThaumcraftItems item) {
        if (item.getCustomMesh() != null) {
            ModelLoader.setCustomMeshDefinition((Item)item.getItem(), (ItemMeshDefinition)item.getCustomMesh());
            for (int i = 0; i < item.getVariantNames().length; ++i) {
                ModelBakery.registerItemVariants((Item)item.getItem(), (ResourceLocation[])new ResourceLocation[]{item.getCustomModelResourceLocation(item.getVariantNames()[i])});
            }
        } else if (item.getItem() == ItemsTC.seals) {
            for (int i = 0; i < item.getVariantNames().length; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)item.getItem(), (int)item.getVariantMeta()[i], (ModelResourceLocation)new ModelResourceLocation(item.getItem().getRegistryName() + "_" + item.getVariantNames()[i], null));
            }
        } else if (!item.getItem().func_77614_k()) {
            ModelLoader.setCustomModelResourceLocation((Item)item.getItem(), (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getItem().getRegistryName(), null));
        } else {
            for (int i = 0; i < item.getVariantNames().length; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)item.getItem(), (int)item.getVariantMeta()[i], (ModelResourceLocation)item.getCustomModelResourceLocation(item.getVariantNames()[i]));
            }
        }
    }
}

