/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.Part;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.golems.GolemHelper;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigAspects;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.consumables.ItemPhial;
import thaumcraft.common.lib.crafting.DustTriggerMultiblock;
import thaumcraft.common.lib.crafting.DustTriggerSimple;
import thaumcraft.common.lib.crafting.InfusionEnchantmentRecipe;
import thaumcraft.common.lib.crafting.InfusionRunicAugmentRecipe;
import thaumcraft.common.lib.crafting.RecipeMagicDust;
import thaumcraft.common.lib.crafting.RecipeTripleMeatTreat;
import thaumcraft.common.lib.crafting.RecipesRobeArmorDyes;
import thaumcraft.common.lib.crafting.RecipesVoidRobeArmorDyes;
import thaumcraft.common.lib.crafting.ShapelessNBTOreRecipe;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;

public class ConfigRecipes {
    public static void postInit() {
        ConfigRecipes.initializeSmelting();
        ConfigRecipes.initializeNormalRecipes();
        ConfigRecipes.initializeArcaneRecipes();
        ConfigRecipes.initializeInfusionRecipes();
        ConfigRecipes.initializeAlchemyRecipes();
        ConfigRecipes.initializeCompoundRecipes();
        RecipeSorter.register((String)"forge:shapelessorenbt", ShapelessNBTOreRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"forge:robearmordye", RecipesRobeArmorDyes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessorenbt");
        RecipeSorter.register((String)"forge:shapelessarcanerecipe", ShapelessArcaneRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessorenbt");
        RecipeSorter.register((String)"forge:voidrobearmordye", RecipesVoidRobeArmorDyes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:robearmordye");
        RecipeSorter.register((String)"forge:triplemeattreat", RecipeTripleMeatTreat.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:voidrobearmordye");
        RecipeSorter.register((String)"forge:salismundus", RecipeMagicDust.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:triplemeattreat");
        RecipeSorter.register((String)"forge:arcanerecipe", ShapedArcaneRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
    }

    private static void initializeCompoundRecipes() {
        IDustTrigger.registerDustTrigger(new DustTriggerSimple("!gotdream", Blocks.field_150342_X, new ItemStack(ItemsTC.thaumonomicon)));
        IDustTrigger.registerDustTrigger(new DustTriggerSimple("FIRSTSTEPS@1", Blocks.field_150462_ai, new ItemStack(BlocksTC.arcaneWorkbench)));
        IDustTrigger.registerDustTrigger(new DustTriggerSimple("UNLOCKALCHEMY@1", (Block)Blocks.field_150383_bp, new ItemStack(BlocksTC.crucible)));
        Part NB = new Part(Blocks.field_150385_bj, new ItemStack(BlocksTC.placeholder, 1, 0));
        Part OB = new Part(Blocks.field_150343_Z, new ItemStack(BlocksTC.placeholder, 1, 1));
        Part IB = new Part(Blocks.field_150411_aY, "AIR");
        Part LA = new Part(Material.field_151587_i, BlocksTC.infernalFurnace, true);
        Part[][][] infernalFurnaceBlueprint = new Part[][][]{{{NB, OB, NB}, {OB, null, OB}, {NB, OB, NB}}, {{NB, OB, NB}, {OB, LA, OB}, {NB, IB, NB}}, {{NB, OB, NB}, {OB, OB, OB}, {NB, OB, NB}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("INFERNALFURNACE", infernalFurnaceBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog("thaumcraft:infernalfurnace", new ThaumcraftApi.BluePrint("INFERNALFURNACE", infernalFurnaceBlueprint, new ItemStack(Blocks.field_150385_bj, 12), new ItemStack(Blocks.field_150343_Z, 12), new ItemStack(Blocks.field_150411_aY), new ItemStack(Items.field_151129_at)));
        Part IM = new Part(BlocksTC.infusionMatrix, null);
        Part SNT = new Part(BlocksTC.stoneArcane, "AIR");
        Part SNB1 = new Part(BlocksTC.stoneArcane, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.NORMAL, EnumFacing.EAST)));
        Part SNB2 = new Part(BlocksTC.stoneArcane, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.NORMAL, EnumFacing.NORTH)));
        Part SNB3 = new Part(BlocksTC.stoneArcane, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.NORMAL, EnumFacing.SOUTH)));
        Part SNB4 = new Part(BlocksTC.stoneArcane, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.NORMAL, EnumFacing.WEST)));
        Part PN = new Part(BlocksTC.pedestal.func_176203_a(0), null);
        Part[][][] infusionAltarNormalBlueprint = new Part[][][]{{{null, null, null}, {null, IM, null}, {null, null, null}}, {{SNT, null, SNT}, {null, null, null}, {SNT, null, SNT}}, {{SNB1, null, SNB2}, {null, PN, null}, {SNB3, null, SNB4}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("INFUSION", infusionAltarNormalBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog("thaumcraft:infusionaltar", new ThaumcraftApi.BluePrint("INFUSION", infusionAltarNormalBlueprint, new ItemStack(BlocksTC.stoneArcane, 8), new ItemStack(BlocksTC.pedestal), new ItemStack(BlocksTC.infusionMatrix)));
        Part SAT = new Part(BlocksTC.stoneAncient, "AIR");
        Part SAB1 = new Part(BlocksTC.stoneAncient, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.ANCIENT, EnumFacing.EAST)));
        Part SAB2 = new Part(BlocksTC.stoneAncient, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.ANCIENT, EnumFacing.NORTH)));
        Part SAB3 = new Part(BlocksTC.stoneAncient, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.ANCIENT, EnumFacing.SOUTH)));
        Part SAB4 = new Part(BlocksTC.stoneAncient, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.ANCIENT, EnumFacing.WEST)));
        Part PA = new Part(BlocksTC.pedestal.func_176203_a(2), null);
        Part[][][] infusionAltarAncientBlueprint = new Part[][][]{{{null, null, null}, {null, IM, null}, {null, null, null}}, {{SAT, null, SAT}, {null, null, null}, {SAT, null, SAT}}, {{SAB1, null, SAB2}, {null, PA, null}, {SAB3, null, SAB4}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("INFUSIONANCIENT", infusionAltarAncientBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog("thaumcraft:infusionaltarancient", new ThaumcraftApi.BluePrint("INFUSIONANCIENT", infusionAltarAncientBlueprint, new ItemStack(BlocksTC.stoneAncient, 8), new ItemStack(BlocksTC.pedestal, 1, 2), new ItemStack(BlocksTC.infusionMatrix)));
        Part SET = new Part(BlocksTC.stoneEldritchTile, "AIR");
        Part SEB1 = new Part(BlocksTC.stoneEldritchTile, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.ELDRITCH, EnumFacing.EAST)));
        Part SEB2 = new Part(BlocksTC.stoneEldritchTile, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.ELDRITCH, EnumFacing.NORTH)));
        Part SEB3 = new Part(BlocksTC.stoneEldritchTile, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.ELDRITCH, EnumFacing.SOUTH)));
        Part SEB4 = new Part(BlocksTC.stoneEldritchTile, new ItemStack(BlocksTC.pillar, 1, BlockPillar.calcMeta(BlockPillar.PillarType.ELDRITCH, EnumFacing.WEST)));
        Part PE = new Part(BlocksTC.pedestal.func_176203_a(1), null);
        Part[][][] infusionAltarEldritchBlueprint = new Part[][][]{{{null, null, null}, {null, IM, null}, {null, null, null}}, {{SET, null, SET}, {null, null, null}, {SET, null, SET}}, {{SEB1, null, SEB2}, {null, PE, null}, {SEB3, null, SEB4}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("INFUSIONELDRITCH", infusionAltarEldritchBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog("thaumcraft:infusionaltareldritch", new ThaumcraftApi.BluePrint("INFUSIONELDRITCH", infusionAltarEldritchBlueprint, new ItemStack(BlocksTC.stoneEldritchTile, 8), new ItemStack(BlocksTC.pedestal, 1, 1), new ItemStack(BlocksTC.infusionMatrix)));
        Part TH1 = new Part(BlocksTC.metal.func_176203_a(2), BlocksTC.thaumatoriumTop).setApplyPlayerFacing(true);
        Part TH2 = new Part(BlocksTC.metal.func_176203_a(2), BlocksTC.thaumatorium).setApplyPlayerFacing(true);
        Part TH3 = new Part(BlocksTC.crucible, null);
        Part[][][] thaumotoriumBlueprint = new Part[][][]{{{TH1}}, {{TH2}}, {{TH3}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("THAUMATORIUM", thaumotoriumBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog("thaumcraft:Thaumatorium", new ThaumcraftApi.BluePrint("THAUMATORIUM", thaumotoriumBlueprint, new ItemStack(BlocksTC.metal, 2, 2), new ItemStack(BlocksTC.crucible)));
        Part GP1 = new Part(Blocks.field_150411_aY, new ItemStack(BlocksTC.placeholder, 1, 2));
        Part GP2 = new Part(Blocks.field_150383_bp, new ItemStack(BlocksTC.placeholder, 1, 4));
        Part GP3 = new Part(Blocks.field_150331_J.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.UP), BlocksTC.golemBuilder);
        Part GP4 = new Part(Blocks.field_150467_bQ, new ItemStack(BlocksTC.placeholder, 1, 3));
        Part GP5 = new Part(BlocksTC.tableStone, new ItemStack(BlocksTC.placeholder, 1, 5));
        Part[][][] golempressBlueprint = new Part[][][]{{{null, null}, {GP1, null}}, {{GP2, GP4}, {GP3, GP5}}};
        IDustTrigger.registerDustTrigger(new DustTriggerMultiblock("MINDCLOCKWORK", golempressBlueprint));
        ThaumcraftApi.addMultiblockRecipeToCatalog("thaumcraft:GolemPress", new ThaumcraftApi.BluePrint("MINDCLOCKWORK", new ItemStack(BlocksTC.golemBuilder), golempressBlueprint, new ItemStack(Blocks.field_150411_aY), new ItemStack(Items.field_151066_bu), new ItemStack((Block)Blocks.field_150331_J), new ItemStack(Blocks.field_150467_bQ), new ItemStack(BlocksTC.tableStone)));
    }

    private static void initializeAlchemyRecipes() {
        CrucibleRecipe[] cre = new CrucibleRecipe[Aspect.aspects.size()];
        int idx = 0;
        for (Aspect aspect : Aspect.aspects.values()) {
            cre[idx] = new CrucibleRecipe("BASEALCHEMY", ThaumcraftApiHelper.makeCrystal(aspect), (Object)"nuggetQuartz", new AspectList().add(aspect, 2));
            ++idx;
        }
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:vis_crystals", false, cre);
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:nitor", false, new CrucibleRecipe("UNLOCKALCHEMY@3", new ItemStack(BlocksTC.nitor, 1, 4), (Object)"dustGlowstone", new AspectList().merge(Aspect.ENERGY, 10).merge(Aspect.FIRE, 10).merge(Aspect.LIGHT, 10)));
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        ShapelessOreRecipe[] re = new ShapelessOreRecipe[16];
        for (int a = 0; a < 16; ++a) {
            re[a] = ConfigRecipes.shapelessOreDictRecipe(new ItemStack(BlocksTC.nitor, 1, a), new Object[]{"dye" + dyes[15 - a], "nitor"});
        }
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:nitorcolor", false, (IRecipe[])re);
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:alumentum", false, new CrucibleRecipe("ALUMENTUM@2", new ItemStack(ItemsTC.alumentum), (Object)new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.ENERGY, 10).merge(Aspect.FIRE, 10).merge(Aspect.ENTROPY, 5)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:brassingot", false, new CrucibleRecipe("METALLURGY@1", new ItemStack(ItemsTC.ingots, 1, 2), (Object)"ingotIron", new AspectList().merge(Aspect.TOOL, 5)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:thaumiumingot", false, new CrucibleRecipe("METALLURGY@2", new ItemStack(ItemsTC.ingots, 1, 0), (Object)"ingotIron", new AspectList().merge(Aspect.MAGIC, 5).merge(Aspect.EARTH, 5)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:voidingot", false, new CrucibleRecipe("METALLURGY@4", new ItemStack(ItemsTC.ingots, 1, 1), (Object)new ItemStack(ItemsTC.voidSeed), new AspectList().merge(Aspect.METAL, 10).merge(Aspect.FLUX, 5)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:voidseed", false, new CrucibleRecipe("METALLURGY@4", new ItemStack(ItemsTC.voidSeed), (Object)new ItemStack(Items.field_151014_N), new AspectList().merge(Aspect.DARKNESS, 5).merge(Aspect.VOID, 5).merge(Aspect.ELDRITCH, 5).merge(Aspect.MAGIC, 5)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:hedge_1", false, new CrucibleRecipe("HEDGEALCHEMY@1", new ItemStack(ItemsTC.tallow), (Object)new ItemStack(Items.field_151078_bh), new AspectList().merge(Aspect.FIRE, 1)), new CrucibleRecipe("HEDGEALCHEMY@1", new ItemStack(Items.field_151116_aA), (Object)new ItemStack(Items.field_151078_bh), new AspectList().merge(Aspect.AIR, 3).merge(Aspect.BEAST, 3)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:focus_blank", false, new CrucibleRecipe("UNLOCKAUROMANCY", new ItemStack(ItemsTC.focusBlank), (Object)ConfigItems.ORDER_CRYSTAL, new AspectList().merge(Aspect.CRYSTAL, 20).merge(Aspect.MAGIC, 10).merge(Aspect.AURA, 5)));
        ArrayList<CrucibleRecipe> rl = new ArrayList<CrucibleRecipe>();
        rl.add(new CrucibleRecipe("METALPURIFICATION", new ItemStack(ItemsTC.clusters, 1, 0), (Object)"oreIron", new AspectList().merge(Aspect.METAL, 5).merge(Aspect.ORDER, 5)));
        rl.add(new CrucibleRecipe("METALPURIFICATION", new ItemStack(ItemsTC.clusters, 1, 1), (Object)"oreGold", new AspectList().merge(Aspect.METAL, 5).merge(Aspect.ORDER, 5)));
        rl.add(new CrucibleRecipe("METALPURIFICATION", new ItemStack(ItemsTC.clusters, 1, 6), (Object)"oreCinnabar", new AspectList().merge(Aspect.METAL, 5).merge(Aspect.ORDER, 5)));
        if (Config.foundCopperOre) {
            rl.add(new CrucibleRecipe("METALPURIFICATION", new ItemStack(ItemsTC.clusters, 1, 2), (Object)"oreCopper", new AspectList().merge(Aspect.METAL, 5).merge(Aspect.ORDER, 5)));
        }
        if (Config.foundTinOre) {
            rl.add(new CrucibleRecipe("METALPURIFICATION", new ItemStack(ItemsTC.clusters, 1, 3), (Object)"oreTin", new AspectList().merge(Aspect.METAL, 5).merge(Aspect.ORDER, 5)));
        }
        if (Config.foundSilverOre) {
            rl.add(new CrucibleRecipe("METALPURIFICATION", new ItemStack(ItemsTC.clusters, 1, 4), (Object)"oreSilver", new AspectList().merge(Aspect.METAL, 5).merge(Aspect.ORDER, 5)));
        }
        if (Config.foundLeadOre) {
            rl.add(new CrucibleRecipe("METALPURIFICATION", new ItemStack(ItemsTC.clusters, 1, 5), (Object)"oreLead", new AspectList().merge(Aspect.METAL, 5).merge(Aspect.ORDER, 5)));
        }
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:metal_purification", false, rl.toArray(new CrucibleRecipe[0]));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:LiquidDeath", false, new CrucibleRecipe("LIQUIDDEATH", new ItemStack(ItemsTC.bucketDeath), (Object)new ItemStack(Items.field_151133_ar), new AspectList().add(Aspect.DEATH, 100).add(Aspect.ALCHEMY, 20).add(Aspect.ENTROPY, 50)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:BottleTaint", false, new CrucibleRecipe("BOTTLETAINT", new ItemStack(ItemsTC.bottleTaint), (Object)ItemPhial.makeFilledPhial(Aspect.FLUX), new AspectList().add(Aspect.FLUX, 30).add(Aspect.WATER, 30)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:BathSalts", false, new CrucibleRecipe("BATHSALTS", new ItemStack(ItemsTC.bathSalts), (Object)new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.MIND, 40).add(Aspect.AIR, 40).add(Aspect.ORDER, 40).add(Aspect.LIFE, 40)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SaneSoap", false, new CrucibleRecipe("SANESOAP", new ItemStack(ItemsTC.sanitySoap), (Object)new ItemStack(BlocksTC.fleshBlock), new AspectList().add(Aspect.MIND, 75).add(Aspect.ELDRITCH, 50).add(Aspect.ORDER, 75).add(Aspect.LIFE, 50)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealCollect", false, new CrucibleRecipe("SEALCOLLECT", GolemHelper.getSealStack("thaumcraft:pickup"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.DESIRE, 10)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealCollectAdv", false, new CrucibleRecipe(new String[]{"SEALCOLLECT", "MINDBIOTHAUMIC"}, GolemHelper.getSealStack("thaumcraft:pickup_advanced"), (Object)GolemHelper.getSealStack("thaumcraft:pickup"), new AspectList().add(Aspect.SENSES, 10).add(Aspect.MIND, 10)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealStore", false, new CrucibleRecipe("SEALSTORE", GolemHelper.getSealStack("thaumcraft:fill"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.AVERSION, 10)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealStoreAdv", false, new CrucibleRecipe(new String[]{"SEALSTORE", "MINDBIOTHAUMIC"}, GolemHelper.getSealStack("thaumcraft:fill_advanced"), (Object)GolemHelper.getSealStack("thaumcraft:fill"), new AspectList().add(Aspect.SENSES, 10).add(Aspect.MIND, 10)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealEmpty", false, new CrucibleRecipe("SEALEMPTY", GolemHelper.getSealStack("thaumcraft:empty"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.VOID, 10)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealEmptyAdv", false, new CrucibleRecipe(new String[]{"SEALEMPTY", "MINDBIOTHAUMIC"}, GolemHelper.getSealStack("thaumcraft:empty_advanced"), (Object)GolemHelper.getSealStack("thaumcraft:empty"), new AspectList().add(Aspect.SENSES, 10).add(Aspect.MIND, 10)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealProvide", false, new CrucibleRecipe("SEALPROVIDE", GolemHelper.getSealStack("thaumcraft:provider"), (Object)GolemHelper.getSealStack("thaumcraft:empty_advanced"), new AspectList().add(Aspect.EXCHANGE, 10).add(Aspect.DESIRE, 10)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealGuard", false, new CrucibleRecipe("SEALGUARD", GolemHelper.getSealStack("thaumcraft:guard"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.AVERSION, 20).add(Aspect.PROTECT, 20)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealGuardAdv", false, new CrucibleRecipe(new String[]{"SEALGUARD", "MINDBIOTHAUMIC"}, GolemHelper.getSealStack("thaumcraft:guard_advanced"), (Object)GolemHelper.getSealStack("thaumcraft:guard"), new AspectList().add(Aspect.SENSES, 20).add(Aspect.MIND, 20)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealLumber", false, new CrucibleRecipe("SEALLUMBER", GolemHelper.getSealStack("thaumcraft:lumber"), (Object)GolemHelper.getSealStack("thaumcraft:breaker"), new AspectList().add(Aspect.PLANT, 40).add(Aspect.SENSES, 20)));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:SealUse", false, new CrucibleRecipe("SEALUSE", GolemHelper.getSealStack("thaumcraft:use"), (Object)new ItemStack(ItemsTC.seals), new AspectList().add(Aspect.CRAFT, 20).add(Aspect.SENSES, 10).add(Aspect.MIND, 20)));
    }

    private static void initializeArcaneRecipes() {
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:vis_resonator", false, new ShapelessArcaneRecipe("UNLOCKAUROMANCY@2", new ItemStack(ItemsTC.visResonator), 50, new ItemStack[]{ConfigItems.WATER_CRYSTAL, ConfigItems.AIR_CRYSTAL}, "plateIron", "gemQuartz"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:activatorrail", false, new ShapelessArcaneRecipe("FIRSTSTEPS", new ItemStack(BlocksTC.activatorRail), 10, new ItemStack[0], new ItemStack(Blocks.field_150408_cc)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:thaumometer", false, new ShapedArcaneRecipe("FIRSTSTEPS@2", new ItemStack(ItemsTC.thaumometer), 20, new ItemStack[]{ConfigItems.AIR_CRYSTAL, ConfigItems.EARTH_CRYSTAL, ConfigItems.FIRE_CRYSTAL, ConfigItems.WATER_CRYSTAL, ConfigItems.ORDER_CRYSTAL, ConfigItems.ENTROPY_CRYSTAL}, " I ", "IGI", " I ", Character.valueOf('I'), "ingotGold", Character.valueOf('G'), new ItemStack(Blocks.field_150410_aZ)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:sanitychecker", false, new ShapedArcaneRecipe("WARP", new ItemStack(ItemsTC.sanityChecker), 20, new ItemStack[]{ConfigItems.ORDER_CRYSTAL, ConfigItems.ENTROPY_CRYSTAL}, "BN ", "M N", "BN ", Character.valueOf('N'), "nuggetBrass", Character.valueOf('B'), new ItemStack(ItemsTC.brain), Character.valueOf('M'), new ItemStack(ItemsTC.mirroredGlass)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:rechargepedestal", false, new ShapedArcaneRecipe("RECHARGEPEDESTAL", new ItemStack(BlocksTC.rechargePedestal), 100, new ItemStack[]{ThaumcraftApiHelper.makeCrystal(Aspect.AIR, 2), ThaumcraftApiHelper.makeCrystal(Aspect.ORDER, 2)}, " R ", "DRD", "SSS", Character.valueOf('I'), "ingotGold", Character.valueOf('D'), "gemDiamond", Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('S'), "stone"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:workbenchcharger", false, new ShapedArcaneRecipe("WORKBENCHCHARGER", new ItemStack(BlocksTC.arcaneWorkbenchCharger), 200, new ItemStack[]{ThaumcraftApiHelper.makeCrystal(Aspect.AIR, 2), ThaumcraftApiHelper.makeCrystal(Aspect.ORDER, 4)}, " R ", "W W", "I I", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('W'), new ItemStack(BlocksTC.plank)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:wand_workbench", false, new ShapedArcaneRecipe("BASEAUROMANCY@2", new ItemStack(BlocksTC.wandWorkbench), 100, new ItemStack[]{ConfigItems.WATER_CRYSTAL, ConfigItems.EARTH_CRYSTAL}, "ISI", "BRB", "GTG", Character.valueOf('S'), new ItemStack(BlocksTC.slabStone), Character.valueOf('T'), new ItemStack(BlocksTC.tableStone), Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('B'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('G'), "ingotGold", Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:caster_basic", false, new ShapedArcaneRecipe("UNLOCKAUROMANCY@2", new ItemStack(ItemsTC.casterBasic), 100, new ItemStack[]{ConfigItems.AIR_CRYSTAL, ConfigItems.EARTH_CRYSTAL, ConfigItems.FIRE_CRYSTAL, ConfigItems.WATER_CRYSTAL, ConfigItems.ORDER_CRYSTAL, ConfigItems.ENTROPY_CRYSTAL}, "III", "LRL", "LTL", Character.valueOf('T'), new ItemStack(ItemsTC.thaumometer), Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('L'), new ItemStack(Items.field_179555_bs), Character.valueOf('I'), "ingotIron"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:EnchantedFabric", false, new ShapedArcaneRecipe("BASEINFUSION", new ItemStack(ItemsTC.fabric), 5, new ItemStack[0], " S ", "SCS", " S ", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('C'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:RobeChest", false, new ShapedArcaneRecipe("BASEINFUSION", new ItemStack(ItemsTC.clothChest, 1), 100, new ItemStack[0], "I I", "III", "III", Character.valueOf('I'), new ItemStack(ItemsTC.fabric)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:RobeLegs", false, new ShapedArcaneRecipe("BASEINFUSION", new ItemStack(ItemsTC.clothLegs, 1), 100, new ItemStack[0], "III", "I I", "I I", Character.valueOf('I'), new ItemStack(ItemsTC.fabric)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:RobeBoots", false, new ShapedArcaneRecipe("BASEINFUSION", new ItemStack(ItemsTC.clothBoots, 1), 100, new ItemStack[0], "I I", "I I", Character.valueOf('I'), new ItemStack(ItemsTC.fabric)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:Goggles", false, new ShapedArcaneRecipe("UNLOCKARTIFICE@2", new ItemStack(ItemsTC.goggles), 50, new ItemStack[0], "LGL", "L L", "TGT", Character.valueOf('T'), new ItemStack(ItemsTC.thaumometer, 1, Short.MAX_VALUE), Character.valueOf('G'), "ingotBrass", Character.valueOf('L'), Items.field_151116_aA));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:SealBlank", false, new ShapelessArcaneRecipe("CONTROLSEALS", new ItemStack(ItemsTC.seals, 3), 20, new ItemStack[]{ConfigItems.AIR_CRYSTAL}, new ItemStack(Items.field_151119_aD), new ItemStack(ItemsTC.tallow), "dyeRed", "nitor"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:modvision", false, new ShapedArcaneRecipe("GOLEMVISION", new ItemStack(ItemsTC.modules, 1, 0), 50, new ItemStack[]{ConfigItems.WATER_CRYSTAL}, "B B", "E E", "PGP", Character.valueOf('B'), new ItemStack(Items.field_151069_bo), Character.valueOf('E'), new ItemStack(Items.field_151071_bq), Character.valueOf('P'), "plateBrass", Character.valueOf('G'), "gearBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:modaggression", false, new ShapedArcaneRecipe("SEALGUARD", new ItemStack(ItemsTC.modules, 1, 1), 50, new ItemStack[]{ConfigItems.FIRE_CRYSTAL}, " R ", "RTR", "PGP", Character.valueOf('R'), "paneGlass", Character.valueOf('T'), new ItemStack(Items.field_151065_br), Character.valueOf('P'), "plateBrass", Character.valueOf('G'), "gearBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:mirrorglass", false, new ShapelessArcaneRecipe("BASEARTIFICE", new ItemStack(ItemsTC.mirroredGlass), 50, new ItemStack[]{ConfigItems.WATER_CRYSTAL, ConfigItems.ORDER_CRYSTAL}, new ItemStack(ItemsTC.quicksilver), "paneGlass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:ArcaneSpa", false, new ShapedArcaneRecipe("ARCANESPA", new ItemStack(BlocksTC.spa), 50, new ItemStack[]{ConfigItems.WATER_CRYSTAL}, "QIQ", "SJS", "SPS", Character.valueOf('P'), "gearBrass", Character.valueOf('J'), new ItemStack(BlocksTC.jarNormal), Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('Q'), new ItemStack(Blocks.field_150371_ca), Character.valueOf('I'), new ItemStack(Blocks.field_150411_aY)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:Tube", false, new ShapedArcaneRecipe("TUBES", new ItemStack(BlocksTC.tube, 8, 0), 10, new ItemStack[0], " Q ", "IGI", " B ", Character.valueOf('I'), "plateIron", Character.valueOf('B'), new ItemStack(ItemsTC.nuggets, 1, 8), Character.valueOf('G'), "blockGlass", Character.valueOf('Q'), new ItemStack(ItemsTC.nuggets, 1, 5)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:Resonator", false, new ShapedArcaneRecipe("TUBES", new ItemStack(ItemsTC.resonator), 50, new ItemStack[0], "I I", "INI", " S ", Character.valueOf('I'), "plateIron", Character.valueOf('N'), Items.field_151128_bU, Character.valueOf('S'), "stickWood"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:TubeValve", false, new ShapelessArcaneRecipe("TUBES", new ItemStack(BlocksTC.tubeValve), 10, new ItemStack[0], new ItemStack(BlocksTC.tube), new ItemStack(Blocks.field_150442_at)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:TubeFilter", false, new ShapelessArcaneRecipe("TUBES", new ItemStack(BlocksTC.tubeFilter), 10, new ItemStack[0], new ItemStack(BlocksTC.tube, 1, 0), new ItemStack(ItemsTC.filter)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:TubeRestrict", false, new ShapelessArcaneRecipe("TUBES", new ItemStack(BlocksTC.tubeRestrict), 10, new ItemStack[]{ConfigItems.EARTH_CRYSTAL}, new ItemStack(BlocksTC.tube)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:TubeOneway", false, new ShapelessArcaneRecipe("TUBES", new ItemStack(BlocksTC.tubeOneway), 10, new ItemStack[]{ConfigItems.WATER_CRYSTAL}, new ItemStack(BlocksTC.tube)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:TubeBuffer", false, new ShapedArcaneRecipe("TUBES", new ItemStack(BlocksTC.tubeBuffer), 25, new ItemStack[0], "PVP", "TWT", "PRP", Character.valueOf('T'), new ItemStack(BlocksTC.tube), Character.valueOf('V'), new ItemStack(BlocksTC.tubeValve), Character.valueOf('W'), "plateIron", Character.valueOf('R'), new ItemStack(BlocksTC.tubeRestrict), Character.valueOf('P'), new ItemStack(ItemsTC.phial)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:WardedJar", false, new ShapedArcaneRecipe("WARDEDJARS", new ItemStack(BlocksTC.jarNormal), 5, new ItemStack[0], "GWG", "G G", "GGG", Character.valueOf('W'), "slabWood", Character.valueOf('G'), "paneGlass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:JarVoid", false, new ShapedArcaneRecipe("WARDEDJARS", new ItemStack(BlocksTC.jarVoid), 50, new ItemStack[]{ConfigItems.ENTROPY_CRYSTAL}, "J", Character.valueOf('J'), new ItemStack(BlocksTC.jarNormal)));
        IArcaneRecipe[] re = new ShapedArcaneRecipe[16];
        for (int a = 0; a < 16; ++a) {
            ItemStack banner = new ItemStack(BlocksTC.banner, 1, 0);
            banner.func_77982_d(new NBTTagCompound());
            banner.func_77978_p().func_74774_a("color", (byte)a);
            re[a] = new ShapedArcaneRecipe("BASEARTIFICE", banner, 10, new ItemStack[0], "WS", "WS", "WB", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, 15 - a), Character.valueOf('S'), "stickWood", Character.valueOf('B'), "slabWood");
        }
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:Banners", false, re);
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:PaveBarrier", false, new ShapedArcaneRecipe("PAVINGSTONES", new ItemStack(BlocksTC.pavingStone, 4, 0), 50, new ItemStack[]{ConfigItems.FIRE_CRYSTAL, ConfigItems.ORDER_CRYSTAL}, "SS", "SS", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcaneBrick)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:PaveTravel", false, new ShapedArcaneRecipe("PAVINGSTONES", new ItemStack(BlocksTC.pavingStone, 4, 1), 50, new ItemStack[]{ConfigItems.AIR_CRYSTAL, ConfigItems.EARTH_CRYSTAL}, "SS", "SS", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcaneBrick)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:ArcaneLamp", false, new ShapedArcaneRecipe("ARCANELAMP", new ItemStack(BlocksTC.lampArcane), 50, new ItemStack[]{ConfigItems.AIR_CRYSTAL, ConfigItems.FIRE_CRYSTAL}, " I ", "IAI", " I ", Character.valueOf('A'), new ItemStack(BlocksTC.translucent), Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:Levitator", false, new ShapedArcaneRecipe("LEVITATOR", new ItemStack(BlocksTC.levitator), 35, new ItemStack[]{ConfigItems.AIR_CRYSTAL}, "WIW", "BNB", "WGW", Character.valueOf('I'), "plateThaumium", Character.valueOf('N'), "nitor", Character.valueOf('W'), "plankWood", Character.valueOf('B'), "plateIron", Character.valueOf('G'), "gearBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:RedstoneRelay", false, new ShapedArcaneRecipe("REDSTONERELAY", new ItemStack(BlocksTC.redstoneRelay), 10, new ItemStack[]{ConfigItems.ORDER_CRYSTAL}, "   ", "GTG", "SSS", Character.valueOf('T'), new ItemStack(Blocks.field_150429_aA), Character.valueOf('G'), "gearBrass", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:ArcaneEar", false, new ShapedArcaneRecipe("ARCANEEAR", new ItemStack(BlocksTC.arcaneEar), 15, new ItemStack[]{ConfigItems.AIR_CRYSTAL}, "   ", "PGP", "WRW", Character.valueOf('W'), "slabWood", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), "gearBrass", Character.valueOf('P'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:InfusionMatrix", false, new ShapedArcaneRecipe("INFUSION@2", new ItemStack(BlocksTC.infusionMatrix), 150, new ItemStack[]{ConfigItems.AIR_CRYSTAL, ConfigItems.EARTH_CRYSTAL, ConfigItems.FIRE_CRYSTAL, ConfigItems.WATER_CRYSTAL, ConfigItems.ORDER_CRYSTAL, ConfigItems.ENTROPY_CRYSTAL}, "S S", " N ", "S S", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcaneBrick), Character.valueOf('N'), "nitor"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:MatrixMotion", false, new ShapedArcaneRecipe("INFUSIONBOOST", new ItemStack(BlocksTC.matrixSpeed), 500, new ItemStack[]{ConfigItems.ORDER_CRYSTAL, ConfigItems.AIR_CRYSTAL}, "SNS", "NGN", "SNS", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('N'), "nitor", Character.valueOf('G'), new ItemStack(Blocks.field_150484_ah)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:MatrixCost", false, new ShapedArcaneRecipe("INFUSIONBOOST", new ItemStack(BlocksTC.matrixCost), 500, new ItemStack[]{ConfigItems.ORDER_CRYSTAL, ConfigItems.WATER_CRYSTAL}, "SAS", "AGA", "SAS", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('A'), new ItemStack(ItemsTC.alumentum), Character.valueOf('G'), new ItemStack(Blocks.field_150484_ah)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:ArcanePedestal", false, new ShapedArcaneRecipe("INFUSION", new ItemStack(BlocksTC.pedestal), 10, new ItemStack[0], "SSS", " B ", "SSS", Character.valueOf('S'), new ItemStack(BlocksTC.slabStone), Character.valueOf('B'), new ItemStack(BlocksTC.stoneArcane)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:AncientPedestal", false, new ShapedArcaneRecipe("INFUSIONANCIENT", new ItemStack(BlocksTC.pedestal, 1, 2), 150, new ItemStack[0], "SSS", " B ", "SSS", Character.valueOf('S'), new ItemStack(BlocksTC.slabStone, 1, 2), Character.valueOf('B'), new ItemStack(BlocksTC.stoneAncient)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:EldritchPedestal", false, new ShapedArcaneRecipe("INFUSIONELDRITCH", new ItemStack(BlocksTC.pedestal, 1, 1), 150, new ItemStack[0], "SSS", " B ", "SSS", Character.valueOf('S'), new ItemStack(BlocksTC.slabStone, 1, 3), Character.valueOf('B'), new ItemStack(BlocksTC.stoneEldritchTile)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:FocusPouch", false, new ShapedArcaneRecipe("FOCUSPOUCH", new ItemStack(ItemsTC.focusPouch), 25, new ItemStack[0], "LGL", "LBL", "LLL", Character.valueOf('B'), new ItemStack(ItemsTC.baubles, 1, 2), Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('G'), Items.field_151043_k));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:dioptra", false, new ShapedArcaneRecipe("DIOPTRA", new ItemStack(BlocksTC.dioptra), 50, new ItemStack[]{ConfigItems.AIR_CRYSTAL, ConfigItems.WATER_CRYSTAL}, "APA", "IGI", "AAA", Character.valueOf('A'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('G'), new ItemStack(ItemsTC.thaumometer), Character.valueOf('P'), new ItemStack(ItemsTC.visResonator), Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:HungryChest", false, new ShapedArcaneRecipe("HUNGRYCHEST", new ItemStack(BlocksTC.hungryChest), 15, new ItemStack[]{ConfigItems.WATER_CRYSTAL}, "WTW", "W W", "WWW", Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('T'), new ItemStack(Blocks.field_150415_aT)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:Filter", false, new ShapedArcaneRecipe("BASEALCHEMY", new ItemStack(ItemsTC.filter, 2, 0), 15, new ItemStack[]{ConfigItems.WATER_CRYSTAL}, "GWG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('W'), new ItemStack(BlocksTC.plank, 1, 1)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:MorphicResonator", false, new ShapedArcaneRecipe("BASEALCHEMY", new ItemStack(ItemsTC.morphicResonator), 50, new ItemStack[]{ConfigItems.ORDER_CRYSTAL}, " G ", "BSB", " G ", Character.valueOf('G'), "paneGlass", Character.valueOf('B'), "plateBrass", Character.valueOf('S'), new ItemStack(ItemsTC.nuggets, 1, 10)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:Alembic", false, new ShapedArcaneRecipe("ESSENTIASMELTER", new ItemStack(BlocksTC.alembic), 50, new ItemStack[]{ConfigItems.WATER_CRYSTAL}, "WFW", "SBS", "WFW", Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('F'), new ItemStack(ItemsTC.filter), Character.valueOf('S'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:EssentiaSmelter", false, new ShapedArcaneRecipe("ESSENTIASMELTER@2", new ItemStack(BlocksTC.smelterBasic), 50, new ItemStack[]{ConfigItems.FIRE_CRYSTAL}, "BCB", "SFS", "SSS", Character.valueOf('C'), new ItemStack(BlocksTC.crucible), Character.valueOf('F'), new ItemStack(Blocks.field_150460_al), Character.valueOf('S'), "cobblestone", Character.valueOf('B'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:EssentiaSmelterThaumium", false, new ShapedArcaneRecipe("ESSENTIASMELTERTHAUMIUM", new ItemStack(BlocksTC.smelterThaumium), 250, new ItemStack[]{ConfigItems.FIRE_CRYSTAL}, "BFB", "IGI", "III", Character.valueOf('C'), new ItemStack(BlocksTC.crucible), Character.valueOf('F'), new ItemStack(BlocksTC.smelterBasic), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2), Character.valueOf('I'), "plateThaumium", Character.valueOf('B'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:EssentiaSmelterVoid", false, new ShapedArcaneRecipe("ESSENTIASMELTERVOID", new ItemStack(BlocksTC.smelterVoid), 750, new ItemStack[]{ConfigItems.FIRE_CRYSTAL}, "BFB", "IGI", "III", Character.valueOf('C'), new ItemStack(BlocksTC.crucible), Character.valueOf('F'), new ItemStack(BlocksTC.smelterBasic), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 3), Character.valueOf('I'), "plateVoid", Character.valueOf('B'), "plateBrass"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:AlchemicalConstruct", false, new ShapedArcaneRecipe("TUBES", new ItemStack(BlocksTC.metal, 1, 2), 75, new ItemStack[]{ConfigItems.WATER_CRYSTAL, ConfigItems.ORDER_CRYSTAL}, "IVI", "TWT", "IVI", Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('V'), new ItemStack(BlocksTC.tubeValve), Character.valueOf('T'), new ItemStack(BlocksTC.tube), Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:AdvAlchemyConstruct", false, new ShapedArcaneRecipe("ESSENTIASMELTERVOID@1", new ItemStack(BlocksTC.metal, 1, 3), 200, new ItemStack[]{ConfigItems.FIRE_CRYSTAL, ConfigItems.EARTH_CRYSTAL}, "VAV", "APA", "VAV", Character.valueOf('A'), new ItemStack(BlocksTC.metal, 1, 2), Character.valueOf('V'), "plateVoid", Character.valueOf('P'), new ItemStack(ItemsTC.primordialPearl)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:SmelterAux", false, new ShapedArcaneRecipe("IMPROVEDSMELTING", new ItemStack(BlocksTC.smelterAux), 100, new ItemStack[]{ConfigItems.WATER_CRYSTAL}, "WTW", "RGR", "IBI", Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('B'), new ItemStack(BlocksTC.bellows), Character.valueOf('R'), "plateBrass", Character.valueOf('T'), new ItemStack(BlocksTC.tubeFilter), Character.valueOf('I'), "plateIron", Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:SmelterVent", false, new ShapedArcaneRecipe("IMPROVEDSMELTING2", new ItemStack(BlocksTC.smelterVent), 150, new ItemStack[]{ConfigItems.AIR_CRYSTAL}, "IBI", "MGF", "IBI", Character.valueOf('I'), "plateIron", Character.valueOf('B'), "plateBrass", Character.valueOf('F'), new ItemStack(ItemsTC.filter), Character.valueOf('M'), new ItemStack(ItemsTC.filter), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:EssentiaTransportIn", false, new ShapedArcaneRecipe("ESSENTIATRANSPORT", new ItemStack(BlocksTC.essentiaTransportInput), 100, new ItemStack[]{ConfigItems.WATER_CRYSTAL, ConfigItems.AIR_CRYSTAL}, "   ", "BQB", "IGI", Character.valueOf('I'), "plateIron", Character.valueOf('B'), "plateBrass", Character.valueOf('Q'), new ItemStack(Blocks.field_150367_z, 1, 0), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:EssentiaTransportOut", false, new ShapedArcaneRecipe("ESSENTIATRANSPORT", new ItemStack(BlocksTC.essentiaTransportOutput), 100, new ItemStack[]{ConfigItems.WATER_CRYSTAL, ConfigItems.AIR_CRYSTAL}, "   ", "BQB", "IGI", Character.valueOf('I'), "plateIron", Character.valueOf('B'), "plateBrass", Character.valueOf('Q'), new ItemStack((Block)Blocks.field_150438_bZ, 1, 0), Character.valueOf('G'), new ItemStack(BlocksTC.metal, 1, 2)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:Bellows", false, new ShapedArcaneRecipe("BELLOWS", new ItemStack(BlocksTC.bellows, 1, 0), 25, new ItemStack[]{ConfigItems.AIR_CRYSTAL}, "WW ", "LLI", "WW ", Character.valueOf('W'), "plankWood", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), Items.field_151116_aA));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:Centrifuge", false, new ShapedArcaneRecipe("CENTRIFUGE", new ItemStack(BlocksTC.centrifuge), 100, new ItemStack[]{ConfigItems.ENTROPY_CRYSTAL, ConfigItems.ORDER_CRYSTAL}, " T ", "RCP", " T ", Character.valueOf('T'), new ItemStack(BlocksTC.tube), Character.valueOf('P'), "gearBrass", Character.valueOf('R'), new ItemStack(ItemsTC.morphicResonator), Character.valueOf('C'), new ItemStack(BlocksTC.metal, 1, 2)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:MnemonicMatrix", false, new ShapedArcaneRecipe("THAUMATORIUM", new ItemStack(BlocksTC.brainBox), 50, new ItemStack[]{ConfigItems.ORDER_CRYSTAL}, "IAI", "ABA", "IAI", Character.valueOf('B'), new ItemStack(ItemsTC.mind, 1, 0), Character.valueOf('A'), "gemAmber", Character.valueOf('I'), "plateIron"));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:MindClockwork", false, new ShapedArcaneRecipe("MINDCLOCKWORK@2", new ItemStack(ItemsTC.mind, 1, 0), 25, new ItemStack[]{ConfigItems.ORDER_CRYSTAL, ConfigItems.FIRE_CRYSTAL}, " P ", "PGP", "BCB", Character.valueOf('G'), "gearBrass", Character.valueOf('B'), "plateBrass", Character.valueOf('P'), "paneGlass", Character.valueOf('C'), new ItemStack(Items.field_151132_bS)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:AutomatedCrossbow", false, new ShapedArcaneRecipe("BASICTURRET", new ItemStack(ItemsTC.turretPlacer, 1, 0), 100, new ItemStack[]{ConfigItems.AIR_CRYSTAL}, "BGI", "WMW", "S S", Character.valueOf('G'), "gearBrass", Character.valueOf('I'), "plateIron", Character.valueOf('S'), "stickWood", Character.valueOf('M'), new ItemStack(ItemsTC.mind), Character.valueOf('B'), new ItemStack((Item)Items.field_151031_f), Character.valueOf('W'), new ItemStack(BlocksTC.plank)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:AdvancedCrossbow", false, new ShapedArcaneRecipe("ADVANCEDTURRET", new ItemStack(ItemsTC.turretPlacer, 1, 1), 150, new ItemStack[]{ConfigItems.AIR_CRYSTAL}, "PMP", "PTP", "BGB", Character.valueOf('G'), "gearBrass", Character.valueOf('T'), new ItemStack(ItemsTC.turretPlacer, 1, 0), Character.valueOf('P'), "plateIron", Character.valueOf('B'), "plateBrass", Character.valueOf('M'), new ItemStack(ItemsTC.mind, 1, 1)));
        ThaumcraftApi.addArcaneCraftingRecipe("thaumcraft:patterncrafter", false, new ShapedArcaneRecipe("ARCANEPATTERNCRAFTER", new ItemStack(BlocksTC.patternCrafter), 50, new ItemStack[]{ConfigItems.ORDER_CRYSTAL, ConfigItems.EARTH_CRYSTAL, ConfigItems.WATER_CRYSTAL}, "VH ", "GCG", " W ", Character.valueOf('H'), new ItemStack((Block)Blocks.field_150438_bZ), Character.valueOf('W'), new ItemStack(BlocksTC.plank), Character.valueOf('G'), "gearBrass", Character.valueOf('V'), new ItemStack(ItemsTC.visResonator), Character.valueOf('C'), new ItemStack(Blocks.field_150462_ai)));
    }

    private static void initializeInfusionRecipes() {
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:SealHarvest", false, new InfusionRecipe("SEALHARVEST", GolemHelper.getSealStack("thaumcraft:harvest"), 0, new AspectList().add(Aspect.PLANT, 10).add(Aspect.SENSES, 10).add(Aspect.MAN, 10), new ItemStack(ItemsTC.seals), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151080_bb), new ItemStack(Items.field_151081_bc), new ItemStack(Items.field_151100_aR, 1, 3), new ItemStack(Items.field_151120_aE), new ItemStack((Block)Blocks.field_150434_aF)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:SealButcher", false, new InfusionRecipe("SEALBUTCHER", GolemHelper.getSealStack("thaumcraft:butcher"), 0, new AspectList().add(Aspect.BEAST, 10).add(Aspect.SENSES, 10).add(Aspect.MAN, 10), GolemHelper.getSealStack("thaumcraft:guard"), new Object[]{new ItemStack(Items.field_151116_aA), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new ItemStack(Items.field_179555_bs), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_151082_bd)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:SealBreak", false, new InfusionRecipe("SEALBREAK", GolemHelper.getSealStack("thaumcraft:breaker"), 1, new AspectList().add(Aspect.TOOL, 10).add(Aspect.ENTROPY, 10).add(Aspect.MAN, 10), new ItemStack(ItemsTC.seals), new Object[]{new ItemStack(Items.field_151006_E), new ItemStack(Items.field_151005_D), new ItemStack(Items.field_151011_C)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:Clusters", false, new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalAir), 0, new AspectList().add(Aspect.AIR, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.AIR), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalFire), 0, new AspectList().add(Aspect.FIRE, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.FIRE), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalWater), 0, new AspectList().add(Aspect.WATER, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.WATER), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalEarth), 0, new AspectList().add(Aspect.EARTH, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.EARTH), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalOrder), 0, new AspectList().add(Aspect.ORDER, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.ORDER), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalEntropy), 0, new AspectList().add(Aspect.ENTROPY, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.ENTROPY), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}), new InfusionRecipe("CRYSTALFARMER", new ItemStack(BlocksTC.crystalTaint), 4, new AspectList().add(Aspect.FLUX, 10).add(Aspect.CRYSTAL, 10).add(Aspect.TRAP, 5), ThaumcraftApiHelper.makeCrystal(Aspect.FLUX), new Object[]{new ItemStack(Items.field_151014_N), new ItemStack(ItemsTC.salisMundus)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:EverfullUrn", false, new InfusionRecipe("EVERFULLURN", new ItemStack(BlocksTC.everfullUrn), 1, new AspectList().add(Aspect.WATER, 40).add(Aspect.CRAFT, 20).add(Aspect.EARTH, 20), new ItemStack(Blocks.field_150405_ch), new Object[]{new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151131_as), "shardWater", new ItemStack(ItemsTC.salisMundus)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:JarBrain", false, new InfusionRecipe("JARBRAIN", new ItemStack(BlocksTC.jarBrain), 4, new AspectList().add(Aspect.MIND, 25).add(Aspect.SENSES, 25).add(Aspect.UNDEAD, 25), new ItemStack(BlocksTC.jarNormal), new ItemStack[]{new ItemStack(ItemsTC.brain), new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151070_bp)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:VisAmulet", false, new InfusionRecipe("VISAMULET", new ItemStack(ItemsTC.amuletVis, 1, 1), 6, new AspectList().add(Aspect.AURA, 50).add(Aspect.ENERGY, 100).add(Aspect.VOID, 50), new ItemStack(ItemsTC.baubles, 1, 0), new Object[]{new ItemStack(ItemsTC.visResonator), ThaumcraftApiHelper.makeCrystal(Aspect.AIR), ThaumcraftApiHelper.makeCrystal(Aspect.FIRE), ThaumcraftApiHelper.makeCrystal(Aspect.WATER), ThaumcraftApiHelper.makeCrystal(Aspect.EARTH), ThaumcraftApiHelper.makeCrystal(Aspect.ORDER)}));
        InfusionRunicAugmentRecipe ra = new InfusionRunicAugmentRecipe();
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:RunicArmor", false, ra);
        InfusionRecipe[] rar = new InfusionRunicAugmentRecipe[5];
        for (int a = 0; a <= 4; ++a) {
            ItemStack in = new ItemStack(ItemsTC.baubles, 1, 1);
            if (a > 0) {
                in.func_77983_a("TC.RUNIC", (NBTBase)new NBTTagByte((byte)a));
            }
            rar[a] = new InfusionRunicAugmentRecipe(in);
        }
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:RunicArmorFake", true, rar);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:Mirror", false, new InfusionRecipe("MIRROR", new ItemStack(BlocksTC.mirror), 1, new AspectList().add(Aspect.MOTION, 25).add(Aspect.DARKNESS, 25).add(Aspect.EXCHANGE, 25), new ItemStack(ItemsTC.mirroredGlass), new Object[]{"ingotGold", "ingotGold", "ingotGold", new ItemStack(Items.field_151079_bi)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:MirrorHand", false, new InfusionRecipe("MIRRORHAND", new ItemStack(ItemsTC.handMirror), 5, new AspectList().add(Aspect.TOOL, 50).add(Aspect.MOTION, 50), new ItemStack(BlocksTC.mirror), new Object[]{"stickWood", new ItemStack(Items.field_151111_aL), new ItemStack((Item)Items.field_151148_bJ)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:MirrorEssentia", false, new InfusionRecipe("MIRRORESSENTIA", new ItemStack(BlocksTC.mirrorEssentia), 2, new AspectList().add(Aspect.MOTION, 25).add(Aspect.WATER, 25).add(Aspect.EXCHANGE, 25), new ItemStack(ItemsTC.mirroredGlass), new Object[]{"ingotIron", "ingotIron", "ingotIron", new ItemStack(Items.field_151079_bi)}));
        ItemStack isEA = new ItemStack(ItemsTC.elementalAxe);
        EnumInfusionEnchantment.addInfusionEnchantment(isEA, EnumInfusionEnchantment.COLLECTOR, 1);
        EnumInfusionEnchantment.addInfusionEnchantment(isEA, EnumInfusionEnchantment.BURROWING, 1);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:ElementalAxe", false, new InfusionRecipe("ELEMENTALTOOLS", isEA, 1, new AspectList().add(Aspect.WATER, 60).add(Aspect.PLANT, 30), new ItemStack(ItemsTC.thaumiumAxe), new Object[]{"shardWater", "shardWater", new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(BlocksTC.plank)}));
        ItemStack isEP = new ItemStack(ItemsTC.elementalPick);
        EnumInfusionEnchantment.addInfusionEnchantment(isEP, EnumInfusionEnchantment.REFINING, 1);
        EnumInfusionEnchantment.addInfusionEnchantment(isEP, EnumInfusionEnchantment.SOUNDING, 2);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:ElementalPick", false, new InfusionRecipe("ELEMENTALTOOLS", isEP, 1, new AspectList().add(Aspect.FIRE, 30).add(Aspect.METAL, 30).add(Aspect.SENSES, 30), new ItemStack(ItemsTC.thaumiumPick), new Object[]{"shardFire", "shardFire", new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(BlocksTC.plank)}));
        ItemStack isESW = new ItemStack(ItemsTC.elementalSword);
        EnumInfusionEnchantment.addInfusionEnchantment(isESW, EnumInfusionEnchantment.ARCING, 2);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:ElementalSword", false, new InfusionRecipe("ELEMENTALTOOLS", isESW, 1, new AspectList().add(Aspect.AIR, 30).add(Aspect.MOTION, 30).add(Aspect.AVERSION, 30), new ItemStack(ItemsTC.thaumiumSword), new Object[]{"shardAir", "shardAir", new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(BlocksTC.plank)}));
        ItemStack isES = new ItemStack(ItemsTC.elementalShovel);
        EnumInfusionEnchantment.addInfusionEnchantment(isES, EnumInfusionEnchantment.DESTRUCTIVE, 1);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:ElementalShovel", false, new InfusionRecipe("ELEMENTALTOOLS", isES, 1, new AspectList().add(Aspect.EARTH, 60).add(Aspect.CRAFT, 30), new ItemStack(ItemsTC.thaumiumShovel), new Object[]{"shardEarth", "shardEarth", new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(BlocksTC.plank)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:ElementalHoe", false, new InfusionRecipe("ELEMENTALTOOLS", new ItemStack(ItemsTC.elementalHoe), 1, new AspectList().add(Aspect.ORDER, 30).add(Aspect.PLANT, 30).add(Aspect.ENTROPY, 30), new ItemStack(ItemsTC.thaumiumHoe), new Object[]{"shardOrder", "shardEntropy", new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(BlocksTC.plank)}));
        InfusionEnchantmentRecipe IEBURROWING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.BURROWING, new AspectList().add(Aspect.SENSES, 80).add(Aspect.EARTH, 150), new Object[]{new ItemStack((Item)Items.field_151134_bR), new ItemStack(Items.field_179556_br)});
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEBURROWING", false, IEBURROWING);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEBURROWINGFAKE", true, new InfusionEnchantmentRecipe(IEBURROWING, new ItemStack(Items.field_151039_o)));
        InfusionEnchantmentRecipe IECOLLECTOR = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.COLLECTOR, new AspectList().add(Aspect.DESIRE, 80).add(Aspect.WATER, 100), new Object[]{new ItemStack((Item)Items.field_151134_bR), new ItemStack(Items.field_151058_ca)});
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IECOLLECTOR", false, IECOLLECTOR);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IECOLLECTORFAKE", true, new InfusionEnchantmentRecipe(IECOLLECTOR, new ItemStack(Items.field_151049_t)));
        InfusionEnchantmentRecipe IEDESTRUCTIVE = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.DESTRUCTIVE, new AspectList().add(Aspect.AVERSION, 200).add(Aspect.ENTROPY, 250), new Object[]{new ItemStack((Item)Items.field_151134_bR), new ItemStack(Blocks.field_150335_W)});
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEDESTRUCTIVE", false, IEDESTRUCTIVE);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEDESTRUCTIVEFAKE", true, new InfusionEnchantmentRecipe(IEDESTRUCTIVE, new ItemStack(Items.field_151050_s)));
        InfusionEnchantmentRecipe IEREFINING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.REFINING, new AspectList().add(Aspect.ORDER, 80).add(Aspect.EXCHANGE, 60), new Object[]{new ItemStack((Item)Items.field_151134_bR), new ItemStack(ItemsTC.salisMundus)});
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEREFINING", false, IEREFINING);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEREFININGFAKE", true, new InfusionEnchantmentRecipe(IEREFINING, new ItemStack(Items.field_151035_b)));
        InfusionEnchantmentRecipe IESOUNDING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.SOUNDING, new AspectList().add(Aspect.SENSES, 40).add(Aspect.FIRE, 60), new Object[]{new ItemStack((Item)Items.field_151134_bR), new ItemStack((Item)Items.field_151148_bJ)});
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IESOUNDING", false, IESOUNDING);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IESOUNDINGFAKE", true, new InfusionEnchantmentRecipe(IESOUNDING, new ItemStack(Items.field_151005_D)));
        InfusionEnchantmentRecipe IEARCING = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.ARCING, new AspectList().add(Aspect.ENERGY, 40).add(Aspect.AIR, 60), new Object[]{new ItemStack((Item)Items.field_151134_bR), new ItemStack(Blocks.field_150451_bX)});
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEARCING", false, IEARCING);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEARCINGFAKE", true, new InfusionEnchantmentRecipe(IEARCING, new ItemStack(Items.field_151041_m)));
        InfusionEnchantmentRecipe IEESSENCE = new InfusionEnchantmentRecipe(EnumInfusionEnchantment.ESSENCE, new AspectList().add(Aspect.BEAST, 40).add(Aspect.FLUX, 60), new Object[]{new ItemStack((Item)Items.field_151134_bR), new ItemStack(ItemsTC.crystalEssence)});
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEESSENCE", false, IEESSENCE);
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:IEESSENCEFAKE", true, new InfusionEnchantmentRecipe(IEBURROWING, new ItemStack(Items.field_151052_q)));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:BootsTraveller", false, new InfusionRecipe("BOOTSTRAVELLER", new ItemStack(ItemsTC.travellerBoots), 1, new AspectList().add(Aspect.FLIGHT, 100).add(Aspect.MOTION, 100), new ItemStack((Item)Items.field_151021_T), new Object[]{"shardAir", "shardAir", new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.fabric), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:MindBiothaumic", false, new InfusionRecipe("MINDBIOTHAUMIC", new ItemStack(ItemsTC.mind, 1, 1), 4, new AspectList().add(Aspect.MIND, 50).add(Aspect.MECHANISM, 25), new ItemStack(ItemsTC.mind, 1, 0), new Object[]{new ItemStack(ItemsTC.brain), new ItemStack(Items.field_151113_aN)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:ArcaneBore", false, new InfusionRecipe("ARCANEBORE", new ItemStack(ItemsTC.turretPlacer, 1, 2), 4, new AspectList().add(Aspect.ENERGY, 25).add(Aspect.EARTH, 25).add(Aspect.MECHANISM, 100).add(Aspect.VOID, 25).add(Aspect.MOTION, 25), new ItemStack(ItemsTC.turretPlacer), new Object[]{new ItemStack(BlocksTC.plank), new ItemStack(BlocksTC.plank), "gearBrass", "plateBrass", new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151047_v), new ItemStack(ItemsTC.morphicResonator), new ItemStack(ItemsTC.nuggets, 1, 10)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:LampGrowth", false, new InfusionRecipe("LAMPGROWTH", new ItemStack(BlocksTC.lampGrowth), 4, new AspectList().add(Aspect.PLANT, 20).add(Aspect.LIGHT, 15).add(Aspect.LIFE, 15).add(Aspect.TOOL, 15), new ItemStack(BlocksTC.lampArcane), new Object[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 15), "shardEarth", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 15), "shardEarth"}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:LampFertility", false, new InfusionRecipe("LAMPFERTILITY", new ItemStack(BlocksTC.lampFertility), 4, new AspectList().add(Aspect.BEAST, 20).add(Aspect.LIGHT, 15).add(Aspect.LIFE, 15).add(Aspect.DESIRE, 15), new ItemStack(BlocksTC.lampArcane), new Object[]{new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151015_O), "shardFire", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151172_bF), "shardFire"}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:ThaumiumFortressHelm", false, new InfusionRecipe("ARMORFORTRESS", new ItemStack(ItemsTC.fortressHelm), 3, new AspectList().add(Aspect.METAL, 50).add(Aspect.PROTECT, 20).add(Aspect.ENERGY, 25), new ItemStack(ItemsTC.thaumiumHelm), new Object[]{"plateThaumium", "plateThaumium", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151166_bC)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:ThaumiumFortressChest", false, new InfusionRecipe("ARMORFORTRESS", new ItemStack(ItemsTC.fortressChest), 3, new AspectList().add(Aspect.METAL, 50).add(Aspect.PROTECT, 30).add(Aspect.ENERGY, 25), new ItemStack(ItemsTC.thaumiumChest), new Object[]{"plateThaumium", "plateThaumium", "plateThaumium", "plateThaumium", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151116_aA)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:ThaumiumFortressLegs", false, new InfusionRecipe("ARMORFORTRESS", new ItemStack(ItemsTC.fortressLegs), 3, new AspectList().add(Aspect.METAL, 50).add(Aspect.PROTECT, 25).add(Aspect.ENERGY, 25), new ItemStack(ItemsTC.thaumiumLegs), new Object[]{"plateThaumium", "plateThaumium", "plateThaumium", new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151116_aA)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:HelmGoggles", false, new InfusionRecipe("FORTRESSMASK", new Object[]{"goggles", new NBTTagByte(1)}, 5, new AspectList().add(Aspect.SENSES, 40).add(Aspect.AURA, 20).add(Aspect.PROTECT, 20), new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151123_aH), new ItemStack(ItemsTC.goggles, 1, Short.MAX_VALUE)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:MaskGrinningDevil", false, new InfusionRecipe("FORTRESSMASK", new Object[]{"mask", new NBTTagInt(0)}, 8, new AspectList().add(Aspect.MIND, 80).add(Aspect.LIFE, 80).add(Aspect.PROTECT, 20), new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151100_aR, 1, 0), "plateIron", new ItemStack(Items.field_151116_aA), new ItemStack(BlocksTC.shimmerleaf), new ItemStack(ItemsTC.brain), "plateIron"}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:MaskAngryGhost", false, new InfusionRecipe("FORTRESSMASK", new Object[]{"mask", new NBTTagInt(1)}, 8, new AspectList().add(Aspect.ENTROPY, 80).add(Aspect.DEATH, 80).add(Aspect.PROTECT, 20), new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151100_aR, 1, 15), "plateIron", new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151170_bI), new ItemStack(Items.field_151144_bL, 1, 1), "plateIron"}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:MaskSippingFiend", false, new InfusionRecipe("FORTRESSMASK", new Object[]{"mask", new NBTTagInt(2)}, 8, new AspectList().add(Aspect.UNDEAD, 80).add(Aspect.LIFE, 80).add(Aspect.PROTECT, 20), new ItemStack(ItemsTC.fortressHelm, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151100_aR, 1, 1), "plateIron", new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151073_bk), new ItemStack(Items.field_151117_aB), "plateIron"}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:VerdantHeart", false, new InfusionRecipe("VERDANTCHARMS", new ItemStack(ItemsTC.charmVerdant), 5, new AspectList().add(Aspect.LIFE, 60).add(Aspect.ORDER, 30).add(Aspect.PLANT, 60), new ItemStack(ItemsTC.baubles, 1, 4), new Object[]{new ItemStack(ItemsTC.nuggets, 1, 10), ThaumcraftApiHelper.makeCrystal(Aspect.LIFE), new ItemStack(Items.field_151117_aB), ThaumcraftApiHelper.makeCrystal(Aspect.PLANT)}));
        ItemStack pis1 = new ItemStack((Item)Items.field_151068_bn);
        pis1.func_77983_a("Potion", (NBTBase)new NBTTagString("minecraft:strong_healing"));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:VerdantHeartLife", false, new InfusionRecipe("VERDANTCHARMS", new Object[]{"type", new NBTTagByte(1)}, 5, new AspectList().add(Aspect.LIFE, 80).add(Aspect.MAN, 80), new ItemStack(ItemsTC.charmVerdant, 1, Short.MAX_VALUE), new Object[]{new ItemStack(Items.field_151153_ao), ThaumcraftApiHelper.makeCrystal(Aspect.LIFE), pis1, ThaumcraftApiHelper.makeCrystal(Aspect.MAN)}));
        ItemStack pis2 = new ItemStack((Item)Items.field_151068_bn);
        pis2.func_77983_a("Potion", (NBTBase)new NBTTagString("minecraft:strong_regeneration"));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:VerdantHeartSustain", false, new InfusionRecipe("VERDANTCHARMS", new Object[]{"type", new NBTTagByte(2)}, 5, new AspectList().add(Aspect.DESIRE, 80).add(Aspect.AIR, 80), new ItemStack(ItemsTC.charmVerdant, 1, Short.MAX_VALUE), new Object[]{new ItemStack(ItemsTC.tripleMeatTreat), ThaumcraftApiHelper.makeCrystal(Aspect.DESIRE), pis2, ThaumcraftApiHelper.makeCrystal(Aspect.AIR)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:CLOUDRING", false, new InfusionRecipe("CLOUDRING", new ItemStack(ItemsTC.ringCloud), 1, new AspectList().add(Aspect.AIR, 50), new ItemStack(ItemsTC.baubles, 1, 1), new Object[]{"shardAir", new ItemStack(Items.field_151008_G)}));
        ThaumcraftApi.addInfusionCraftingRecipe("thaumcraft:CuriosityBand", false, new InfusionRecipe("CURIOSITYBAND", new ItemStack(ItemsTC.bandCuriosity), 5, new AspectList().add(Aspect.MIND, 150).add(Aspect.VOID, 50).add(Aspect.TRAP, 100), new ItemStack(ItemsTC.baubles, 1, 6), new Object[]{new ItemStack(Items.field_151166_bC), new ItemStack(Items.field_151099_bA), new ItemStack(Items.field_151166_bC), new ItemStack(Items.field_151099_bA), new ItemStack(Items.field_151166_bC), new ItemStack(Items.field_151099_bA), new ItemStack(Items.field_151166_bC), new ItemStack(Items.field_151099_bA)}));
    }

    private static void initializeNormalRecipes() {
        GameRegistry.addRecipe((IRecipe)new RecipesRobeArmorDyes());
        GameRegistry.addRecipe((IRecipe)new RecipesVoidRobeArmorDyes());
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 0), new Object[]{"#", Character.valueOf('#'), Items.field_151042_j});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 6), new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 0)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 7), new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 1)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 8), new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 2)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 9), new Object[]{"#", Character.valueOf('#'), Items.field_151128_bU});
        ConfigRecipes.oreDictRecipe(new ItemStack(Items.field_151042_j), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetIron"});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 1, 0), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetThaumium"});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 1, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetVoid"});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 1, 2), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetBrass"});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.quicksilver), new Object[]{"###", "###", "###", Character.valueOf('#'), "nuggetQuicksilver"});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.nuggets, 9, 5), new Object[]{"#", Character.valueOf('#'), new ItemStack(ItemsTC.quicksilver)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.metal, 1, 0), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 0)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 9, 0), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.metal, 1, 0)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.metal, 1, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 1)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 9, 1), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.metal, 1, 1)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.metal, 1, 4), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ItemsTC.ingots, 1, 2)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.ingots, 9, 2), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.metal, 1, 4)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.fleshBlock), new Object[]{"###", "###", "###", Character.valueOf('#'), Items.field_151078_bh});
        ConfigRecipes.oreDictRecipe(new ItemStack(Items.field_151078_bh, 9, 0), new Object[]{"#", Character.valueOf('#'), BlocksTC.fleshBlock});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.translucent, 1, 0), new Object[]{"###", "###", "###", Character.valueOf('#'), "gemAmber"});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.translucent, 4, 1), new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(BlocksTC.translucent, 1, 0)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.translucent, 4, 0), new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(BlocksTC.translucent, 1, 1)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.amber, 9, 0), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.translucent, 1, 0)});
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:ironplate", false, ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.plate, 3, 1), new Object[]{"BBB", Character.valueOf('B'), "ingotIron"}));
        ThaumcraftApi.addRecipeUnlinked("thaumcraft:ironplate");
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:brassstuff", false, ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.plate, 3, 0), new Object[]{"BBB", Character.valueOf('B'), "ingotBrass"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.gear, 1, 0), new Object[]{" B ", "BIB", " B ", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "ingotBrass"}));
        ThaumcraftApi.addRecipeUnlinked("thaumcraft:brassstuff");
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:thaumiumstuff", false, ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.plate, 3, 2), new Object[]{"BBB", Character.valueOf('B'), "ingotThaumium"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.gear, 1, 1), new Object[]{" B ", "BIB", " B ", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "ingotThaumium"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumHelm, 1), new Object[]{"III", "I I", Character.valueOf('I'), "ingotThaumium"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumChest, 1), new Object[]{"I I", "III", "III", Character.valueOf('I'), "ingotThaumium"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumLegs, 1), new Object[]{"III", "I I", "I I", Character.valueOf('I'), "ingotThaumium"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumBoots, 1), new Object[]{"I I", "I I", Character.valueOf('I'), "ingotThaumium"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumShovel, 1), new Object[]{"I", "S", "S", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumPick, 1), new Object[]{"III", " S ", " S ", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumAxe, 1), new Object[]{"II", "SI", "S ", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumHoe, 1), new Object[]{"II", "S ", "S ", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.thaumiumSword, 1), new Object[]{"I", "I", "S", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ThaumcraftApi.addRecipeUnlinked("thaumcraft:thaumiumstuff");
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:voidstuff", false, ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.plate, 3, 3), new Object[]{"BBB", Character.valueOf('B'), "ingotVoid"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.gear, 1, 2), new Object[]{" B ", "BIB", " B ", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "ingotVoid"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidHelm, 1), new Object[]{"III", "I I", Character.valueOf('I'), "ingotVoid"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidChest, 1), new Object[]{"I I", "III", "III", Character.valueOf('I'), "ingotVoid"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidLegs, 1), new Object[]{"III", "I I", "I I", Character.valueOf('I'), "ingotVoid"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidBoots, 1), new Object[]{"I I", "I I", Character.valueOf('I'), "ingotVoid"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidShovel, 1), new Object[]{"I", "S", "S", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidPick, 1), new Object[]{"III", " S ", " S ", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidAxe, 1), new Object[]{"II", "SI", "S ", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidHoe, 1), new Object[]{"II", "S ", "S ", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.voidSword, 1), new Object[]{"I", "I", "S", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:mundanebaubles", false, ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 0), new Object[]{" S ", "S S", " I ", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('I'), "ingotBrass"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 1), new Object[]{"NNN", "N N", "NNN", Character.valueOf('N'), "nuggetBrass"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 2), new Object[]{" L ", "L L", " I ", Character.valueOf('L'), new ItemStack(Items.field_151116_aA), Character.valueOf('I'), "ingotBrass"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 4), new Object[]{" S ", "SGS", " I ", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('G'), new ItemStack(Items.field_151045_i), Character.valueOf('I'), "ingotGold"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 5), new Object[]{"NGN", "N N", "NNN", Character.valueOf('G'), new ItemStack(Items.field_151045_i), Character.valueOf('N'), "nuggetGold"}), ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.baubles, 1, 6), new Object[]{" L ", "LGL", " I ", Character.valueOf('L'), new ItemStack(Items.field_151116_aA), Character.valueOf('G'), new ItemStack(Items.field_151045_i), Character.valueOf('I'), "ingotGold"}));
        ThaumcraftApi.addRecipeUnlinked("thaumcraft:mundanebaubles");
        CraftingManager.func_77594_a().func_180302_a((IRecipe)new RecipeTripleMeatTreat());
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:triplemeattreat", true, new IRecipe[]{new ShapelessOreRecipe(new ItemStack(ItemsTC.tripleMeatTreat), new Object[]{new ItemStack(ItemsTC.chunks, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.chunks, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.chunks, 1, Short.MAX_VALUE), new ItemStack(Items.field_151102_aT)})});
        ThaumcraftApi.addRecipeUnlinked("thaumcraft:triplemeattreat");
        CraftingManager.func_77594_a().func_180302_a((IRecipe)new RecipeMagicDust());
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:salismundus", true, new IRecipe[]{new ShapelessOreRecipe(new ItemStack(ItemsTC.salisMundus), new Object[]{Items.field_151145_ak, Items.field_151054_z, Items.field_151137_ax, new ItemStack(ItemsTC.crystalEssence, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.crystalEssence, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.crystalEssence, 1, Short.MAX_VALUE)})});
        ThaumcraftApi.addRecipeUnlinked("thaumcraft:salismundus");
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ItemsTC.quicksilver), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.shimmerleaf)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(Items.field_151065_br), new Object[]{"#", Character.valueOf('#'), new ItemStack(BlocksTC.cinderpearl)});
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:JarLabel", false, ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.label, 4, 0), new Object[]{"dyeBlack", "slimeball", Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF}));
        int count = 0;
        IRecipe[] jre = new IRecipe[Aspect.aspects.size()];
        for (Aspect aspect : Aspect.aspects.values()) {
            ItemStack output = new ItemStack(ItemsTC.label, 1, 1);
            ((IEssentiaContainerItem)output.func_77973_b()).setAspects(output, new AspectList().add(aspect, 1));
            jre[count] = ConfigRecipes.shapelessNBTOreRecipe(output, new Object[]{new ItemStack(ItemsTC.label), ItemPhial.makeFilledPhial(aspect)});
            ++count;
        }
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:JarLabelEssence", false, jre);
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:JarLabelNull", false, ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.label), new Object[]{new ItemStack(ItemsTC.label, 1, 1)}));
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:PlankGreatwood", false, GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.plank, 4, 0), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(BlocksTC.log, 1, 0)}));
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:PlankSilverwood", false, GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.plank, 4, 1), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(BlocksTC.log, 1, 3)}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsGreatwood, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plank, 1, 0)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsSilverwood, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plank, 1, 1)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsArcane, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcane)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsArcaneBrick, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcaneBrick)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stairsAncient, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneAncient)});
        ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.stoneArcane, 9), new Object[]{"KKK", "KCK", "KKK", Character.valueOf('K'), "stone", Character.valueOf('C'), new ItemStack(ItemsTC.crystalEssence)});
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:arcane_stone", true, new IRecipe[]{new ShapedOreRecipe(new ItemStack(BlocksTC.stoneArcane, 9), new Object[]{"KKK", "KCK", "KKK", Character.valueOf('K'), "stone", Character.valueOf('C'), new ItemStack(ItemsTC.crystalEssence, 1, Short.MAX_VALUE)})});
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:arcane_brick", false, GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.stoneArcaneBrick, 4), (Object[])new Object[]{"KK", "KK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcane)}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabWood, 6, 0), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plank, 1, 0)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabWood, 6, 1), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.plank, 1, 1)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 0), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcane)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 1), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneArcaneBrick)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 2), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneAncient)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BlocksTC.slabStone, 6, 3), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(BlocksTC.stoneEldritchTile)});
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:phial", false, ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.phial, 8, 0), new Object[]{" C ", "G G", " G ", Character.valueOf('G'), "blockGlass", Character.valueOf('C'), Items.field_151119_aD}));
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:tablewood", false, ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.tableWood), new Object[]{"SSS", "W W", Character.valueOf('S'), "slabWood", Character.valueOf('W'), "plankWood"}));
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:tablestone", false, ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.tableStone), new Object[]{"SSS", "W W", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('W'), "stone"}));
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:scribetools", false, ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.scribingTools), new Object[]{new ItemStack(ItemsTC.phial, 1, 0), Items.field_151008_G, "dyeBlack"}), ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.scribingTools), new Object[]{Items.field_151069_bo, Items.field_151008_G, "dyeBlack"}), ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ItemsTC.scribingTools), new Object[]{new ItemStack(ItemsTC.scribingTools, 1, Short.MAX_VALUE), "dyeBlack"}));
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:GolemBell", false, ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.golemBell), new Object[]{" QQ", " QQ", "S  ", Character.valueOf('S'), "stickWood", Character.valueOf('Q'), "gemQuartz"}));
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:TallowCandle", false, ConfigRecipes.oreDictRecipe(new ItemStack(BlocksTC.candle, 3, 0), new Object[]{" S ", " T ", " T ", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('T'), new ItemStack(ItemsTC.tallow)}));
        IRecipe[] trs = new IRecipe[16];
        for (int a = 1; a < 16; ++a) {
            trs[a] = ConfigRecipes.shapelessOreDictRecipe(new ItemStack(BlocksTC.candle, 1, a), new Object[]{ConfigAspects.dyes[15 - a], new ItemStack(BlocksTC.candle, 1, 0)});
        }
        trs[0] = ConfigRecipes.shapelessOreDictRecipe(new ItemStack(BlocksTC.candle, 1, 0), new Object[]{new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(BlocksTC.candle, 1, Short.MAX_VALUE)});
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:TallowCandleDye", false, trs);
        ThaumcraftApi.addIRecipeToCatalog("thaumcraft:BrassBrace", false, ConfigRecipes.oreDictRecipe(new ItemStack(ItemsTC.jarBrace, 2), new Object[]{"NSN", "S S", "NSN", Character.valueOf('N'), "nuggetBrass", Character.valueOf('S'), "stickWood"}));
    }

    private static void initializeSmelting() {
        GameRegistry.addSmelting((Block)BlocksTC.oreCinnabar, (ItemStack)new ItemStack(ItemsTC.quicksilver), (float)1.0f);
        GameRegistry.addSmelting((Block)BlocksTC.oreAmber, (ItemStack)new ItemStack(ItemsTC.amber), (float)1.0f);
        GameRegistry.addSmelting((Block)BlocksTC.oreQuartz, (ItemStack)new ItemStack(Items.field_151128_bU), (float)1.0f);
        GameRegistry.addSmelting((Block)BlocksTC.log, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.5f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTC.clusters, 1, 0), (ItemStack)new ItemStack(Items.field_151042_j, 2, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTC.clusters, 1, 1), (ItemStack)new ItemStack(Items.field_151043_k, 2, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTC.clusters, 1, 6), (ItemStack)new ItemStack(ItemsTC.quicksilver, 2, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsTC.clusters, 1, 7), (ItemStack)new ItemStack(Items.field_151128_bU, 2, 0), (float)1.0f);
        ThaumcraftApi.addSmeltingBonus("oreGold", new ItemStack(Items.field_151074_bl));
        ThaumcraftApi.addSmeltingBonus("oreIron", new ItemStack(ItemsTC.nuggets));
        ThaumcraftApi.addSmeltingBonus("oreCinnabar", new ItemStack(ItemsTC.nuggets, 1, 5));
        ThaumcraftApi.addSmeltingBonus("oreCopper", new ItemStack(ItemsTC.nuggets, 1, 1));
        ThaumcraftApi.addSmeltingBonus("oreTin", new ItemStack(ItemsTC.nuggets, 1, 2));
        ThaumcraftApi.addSmeltingBonus("oreSilver", new ItemStack(ItemsTC.nuggets, 1, 3));
        ThaumcraftApi.addSmeltingBonus("oreLead", new ItemStack(ItemsTC.nuggets, 1, 4));
        ThaumcraftApi.addSmeltingBonus("oreQuartz", new ItemStack(ItemsTC.nuggets, 1, 9));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 0), new ItemStack(ItemsTC.nuggets));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 1), new ItemStack(Items.field_151074_bl));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 6), new ItemStack(ItemsTC.nuggets, 1, 5));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 2), new ItemStack(ItemsTC.nuggets, 1, 1));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 3), new ItemStack(ItemsTC.nuggets, 1, 2));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 4), new ItemStack(ItemsTC.nuggets, 1, 3));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 5), new ItemStack(ItemsTC.nuggets, 1, 4));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, 7), new ItemStack(ItemsTC.nuggets, 1, 9));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151082_bd), new ItemStack(ItemsTC.chunks, 1, 0));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151076_bf), new ItemStack(ItemsTC.chunks, 1, 1));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151147_al), new ItemStack(ItemsTC.chunks, 1, 2));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.chunks, 1, 3));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_179558_bo), new ItemStack(ItemsTC.chunks, 1, 4));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.field_179561_bm), new ItemStack(ItemsTC.chunks, 1, 5));
        ThaumcraftApi.addSmeltingBonus("oreDiamond", new ItemStack(ItemsTC.nuggets, 1, 10), 0.025f);
        ThaumcraftApi.addSmeltingBonus("oreRedstone", new ItemStack(ItemsTC.nuggets, 1, 10), 0.01f);
        ThaumcraftApi.addSmeltingBonus("oreLapis", new ItemStack(ItemsTC.nuggets, 1, 10), 0.01f);
        ThaumcraftApi.addSmeltingBonus("oreEmerald", new ItemStack(ItemsTC.nuggets, 1, 10), 0.025f);
        ThaumcraftApi.addSmeltingBonus("oreGold", new ItemStack(ItemsTC.nuggets, 1, 10), 0.02f);
        ThaumcraftApi.addSmeltingBonus("oreIron", new ItemStack(ItemsTC.nuggets, 1, 10), 0.01f);
        ThaumcraftApi.addSmeltingBonus("oreCinnabar", new ItemStack(ItemsTC.nuggets, 1, 10), 0.025f);
        ThaumcraftApi.addSmeltingBonus("oreCopper", new ItemStack(ItemsTC.nuggets, 1, 10), 0.01f);
        ThaumcraftApi.addSmeltingBonus("oreTin", new ItemStack(ItemsTC.nuggets, 1, 10), 0.01f);
        ThaumcraftApi.addSmeltingBonus("oreSilver", new ItemStack(ItemsTC.nuggets, 1, 10), 0.02f);
        ThaumcraftApi.addSmeltingBonus("oreLead", new ItemStack(ItemsTC.nuggets, 1, 10), 0.01f);
        ThaumcraftApi.addSmeltingBonus("oreQuartz", new ItemStack(ItemsTC.nuggets, 1, 10), 0.01f);
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ItemsTC.clusters, 1, Short.MAX_VALUE), new ItemStack(ItemsTC.nuggets, 1, 10), 0.02f);
    }

    static IRecipe oreDictRecipe(ItemStack res, Object[] params) {
        ShapedOreRecipe rec = new ShapedOreRecipe(res, params);
        CraftingManager.func_77594_a().func_77592_b().add(rec);
        return rec;
    }

    static IRecipe shapelessOreDictRecipe(ItemStack res, Object[] params) {
        ShapelessOreRecipe rec = new ShapelessOreRecipe(res, params);
        CraftingManager.func_77594_a().func_77592_b().add(rec);
        return rec;
    }

    static IRecipe shapelessNBTOreRecipe(ItemStack res, Object[] params) {
        ShapelessNBTOreRecipe rec = new ShapelessNBTOreRecipe(res, params);
        CraftingManager.func_77594_a().func_77592_b().add(rec);
        return rec;
    }

    public static void postAspects() {
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:hedge_2", false, new CrucibleRecipe("HEDGEALCHEMY@2", new ItemStack(Items.field_151016_H, 2, 0), (Object)new ItemStack(Items.field_151016_H), new AspectList(new ItemStack(Items.field_151016_H))), new CrucibleRecipe("HEDGEALCHEMY@2", new ItemStack(Items.field_151123_aH, 2, 0), (Object)new ItemStack(Items.field_151123_aH), new AspectList(new ItemStack(Items.field_151123_aH))), new CrucibleRecipe("HEDGEALCHEMY@2", new ItemStack(Items.field_151114_aO, 2, 0), (Object)"dustGlowstone", new AspectList(new ItemStack(Items.field_151114_aO))), new CrucibleRecipe("HEDGEALCHEMY@2", new ItemStack(Items.field_151100_aR, 2, 0), (Object)new ItemStack(Items.field_151100_aR, 1, 0), new AspectList(new ItemStack(Items.field_151100_aR))));
        ThaumcraftApi.addCrucibleRecipe("thaumcraft:hedge_3", false, new CrucibleRecipe("HEDGEALCHEMY@3", new ItemStack(Items.field_151119_aD, 1, 0), (Object)new ItemStack(Blocks.field_150346_d), new AspectList(new ItemStack(Items.field_151119_aD, 1, 0)).remove(new AspectList(new ItemStack(Blocks.field_150346_d)))), new CrucibleRecipe("HEDGEALCHEMY@3", new ItemStack(Items.field_151007_F), (Object)new ItemStack(Items.field_151015_O), new AspectList(new ItemStack(Items.field_151007_F)).remove(new AspectList(new ItemStack(Items.field_151015_O)))), new CrucibleRecipe("HEDGEALCHEMY@3", new ItemStack(Blocks.field_150321_G), (Object)new ItemStack(Items.field_151007_F), new AspectList(new ItemStack(Blocks.field_150321_G)).remove(new AspectList(new ItemStack(Items.field_151007_F)))), new CrucibleRecipe("HEDGEALCHEMY@3", new ItemStack(Blocks.field_150341_Y), (Object)new ItemStack(Blocks.field_150347_e), new AspectList(new ItemStack(Blocks.field_150341_Y)).remove(new AspectList(new ItemStack(Blocks.field_150347_e)))), new CrucibleRecipe("HEDGEALCHEMY@3", new ItemStack(Items.field_151129_at), (Object)new ItemStack(Items.field_151133_ar), new AspectList(new ItemStack(Items.field_151129_at))));
    }
}

