/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.IGolemAPI;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.entities.construct.golem.seals.SealFiltered;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.utils.InventoryUtils;

public class SealFill
extends SealFiltered {
    int delay = new Random(System.nanoTime()).nextInt(50);
    int watchedTask = Integer.MIN_VALUE;
    protected ISealConfigToggles.SealToggle[] props = new ISealConfigToggles.SealToggle[]{new ISealConfigToggles.SealToggle(true, "pmeta", "golem.prop.meta"), new ISealConfigToggles.SealToggle(true, "pnbt", "golem.prop.nbt"), new ISealConfigToggles.SealToggle(false, "pore", "golem.prop.ore"), new ISealConfigToggles.SealToggle(false, "pmod", "golem.prop.mod"), new ISealConfigToggles.SealToggle(false, "pexist", "golem.prop.exist")};
    ResourceLocation icon = new ResourceLocation("thaumcraft", "items/seals/seal_fill");

    @Override
    public String getKey() {
        return "thaumcraft:fill";
    }

    @Override
    public void tickSeal(World world, ISealEntity seal) {
        if (this.delay++ % 20 != 0) {
            return;
        }
        Task oldTask = TaskHandler.getTask(world.field_73011_w.getDimension(), this.watchedTask);
        if (oldTask == null || oldTask.isReserved() || oldTask.isSuspended() || oldTask.isCompleted()) {
            Task task = new Task(seal.getSealPos(), seal.getSealPos().pos);
            task.setPriority(seal.getPriority());
            TaskHandler.addTask(world.field_73011_w.getDimension(), task);
            this.watchedTask = task.getId();
        }
    }

    @Override
    public void onTaskStarted(World world, IGolemAPI golem, Task task) {
        ISealEntity se = SealHandler.getSealEntity(world.field_73011_w.getDimension(), task.getSealPos());
        if (se != null && !se.isStoppedByRedstone(world)) {
            Task newTask = new Task(task.getSealPos(), task.getSealPos().pos);
            newTask.setPriority(se.getPriority());
            TaskHandler.addTask(world.field_73011_w.getDimension(), newTask);
            this.watchedTask = newTask.getId();
        }
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        TileEntity te = world.func_175625_s(task.getSealPos().pos);
        if (te != null && te instanceof IInventory) {
            Tuple<ItemStack, ItemStack> tuple = InventoryUtils.findFirstMatchFromFilterTuple(this.getInv(), this.isBlacklist(), golem.getCarrying(), !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
            if (tuple.func_76341_a() != null) {
                int limit = ((ItemStack)tuple.func_76341_a()).field_77994_a;
                if (this.hasStacksizeLimiters() && tuple.func_76340_b() != null && ((ItemStack)tuple.func_76340_b()).field_77994_a > 0) {
                    int c = InventoryUtils.inventoryContainsAmount((IInventory)te, (ItemStack)tuple.func_76340_b(), task.getSealPos().face, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
                    limit = c < ((ItemStack)tuple.func_76340_b()).field_77994_a ? ((ItemStack)tuple.func_76340_b()).field_77994_a - c : 0;
                }
                if (limit > 0) {
                    ItemStack t = ((ItemStack)tuple.func_76341_a()).func_77946_l();
                    t.field_77994_a = limit;
                    ItemStack s = golem.dropItem(t);
                    golem.holdItem(InventoryUtils.placeItemStackIntoInventory(s, (IInventory)te, task.getSealPos().face, true));
                    ((Entity)golem).func_184185_a(SoundEvents.field_187638_cR, 0.125f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 1.0f);
                    golem.addRankXp(1);
                    golem.swingArm();
                }
            }
        } else {
            Tuple<ItemStack, ItemStack> tuple = InventoryUtils.findFirstMatchFromFilterTuple(this.getInv(), this.isBlacklist(), golem.getCarrying(), !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
            if (tuple.func_76341_a() != null) {
                int limit = ((ItemStack)tuple.func_76341_a()).field_77994_a;
                if (this.hasStacksizeLimiters() && tuple.func_76340_b() != null && ((ItemStack)tuple.func_76340_b()).field_77994_a > 0) {
                    int c = InventoryUtils.countItemsInWorld(golem.getGolemWorld(), task.getSealPos().pos, (ItemStack)tuple.func_76340_b(), 1.5, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
                    limit = c < ((ItemStack)tuple.func_76340_b()).field_77994_a ? ((ItemStack)tuple.func_76340_b()).field_77994_a - c : 0;
                }
                if (limit > 0) {
                    ItemStack t = ((ItemStack)tuple.func_76341_a()).func_77946_l();
                    t.field_77994_a = limit;
                    ItemStack s = golem.dropItem(t);
                    EntityItem ie = new EntityItem(world, (double)task.getSealPos().pos.func_177958_n() + 0.5 + (double)task.getSealPos().face.func_82601_c(), (double)task.getSealPos().pos.func_177956_o() + 0.5 + (double)task.getSealPos().face.func_96559_d(), (double)task.getSealPos().pos.func_177952_p() + 0.5 + (double)task.getSealPos().face.func_82599_e(), s);
                    ie.field_70159_w /= 5.0;
                    ie.field_70181_x /= 2.0;
                    ie.field_70179_y /= 5.0;
                    world.func_72838_d((Entity)ie);
                    ((Entity)golem).func_184185_a(SoundEvents.field_187638_cR, 0.125f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 1.0f);
                    golem.swingArm();
                }
            }
        }
        task.setSuspended(true);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        TileEntity te = golem.getGolemWorld().func_175625_s(task.getSealPos().pos);
        if (te != null && te instanceof IInventory) {
            Tuple<ItemStack, ItemStack> tuple = InventoryUtils.findFirstMatchFromFilterTuple(this.getInv(), this.isBlacklist(), golem.getCarrying(), !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
            if (tuple.func_76341_a() != null && this.props[4].value && InventoryUtils.inventoryContainsAmount((IInventory)te, (ItemStack)tuple.func_76341_a(), task.getSealPos().face, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value) <= 0) {
                return false;
            }
            if (tuple.func_76341_a() == null) return false;
            if (!InventoryUtils.hasRoomFor((ItemStack)tuple.func_76341_a(), (IInventory)te, task.getSealPos().face)) return false;
            if (!this.hasStacksizeLimiters()) return true;
            if (tuple.func_76340_b() == null) return true;
            if (((ItemStack)tuple.func_76340_b()).field_77994_a <= 0) return true;
            if (InventoryUtils.inventoryContainsAmount((IInventory)te, (ItemStack)tuple.func_76340_b(), task.getSealPos().face, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value) >= ((ItemStack)tuple.func_76340_b()).field_77994_a) return false;
            return true;
        }
        Tuple<ItemStack, ItemStack> tuple = InventoryUtils.findFirstMatchFromFilterTuple(this.getInv(), this.isBlacklist(), golem.getCarrying(), !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value);
        if (tuple.func_76341_a() == null) return false;
        if (!this.hasStacksizeLimiters()) return true;
        if (tuple.func_76340_b() == null) return true;
        if (((ItemStack)tuple.func_76340_b()).field_77994_a <= 0) return true;
        if (InventoryUtils.countItemsInWorld(golem.getGolemWorld(), task.getSealPos().pos, (ItemStack)tuple.func_76340_b(), 1.5, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value) >= ((ItemStack)tuple.func_76340_b()).field_77994_a) return false;
        return true;
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        return !world.func_175623_d(pos);
    }

    @Override
    public ResourceLocation getSealIcon() {
        return this.icon;
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{1, 0, 4};
    }

    @Override
    public EnumGolemTrait[] getRequiredTags() {
        return null;
    }

    @Override
    public EnumGolemTrait[] getForbiddenTags() {
        return new EnumGolemTrait[]{EnumGolemTrait.CLUMSY};
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }

    @Override
    public boolean hasStacksizeLimiters() {
        return !this.isBlacklist();
    }
}

