/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.GolemHelper;
import thaumcraft.api.golems.IGolemAPI;
import thaumcraft.api.golems.ProvisionRequest;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.entities.construct.golem.EntityThaumcraftGolem;
import thaumcraft.common.entities.construct.golem.seals.SealFiltered;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.utils.InventoryUtils;

public class SealProvide
extends SealFiltered
implements ISealConfigToggles {
    int delay = new Random(System.nanoTime()).nextInt(88);
    HashMap<Integer, ProvisionRequest> cache = new HashMap();
    ResourceLocation icon = new ResourceLocation("thaumcraft", "items/seals/seal_provider");
    protected ISealConfigToggles.SealToggle[] props = new ISealConfigToggles.SealToggle[]{new ISealConfigToggles.SealToggle(true, "pmeta", "golem.prop.meta"), new ISealConfigToggles.SealToggle(true, "pnbt", "golem.prop.nbt"), new ISealConfigToggles.SealToggle(false, "pore", "golem.prop.ore"), new ISealConfigToggles.SealToggle(false, "pmod", "golem.prop.mod"), new ISealConfigToggles.SealToggle(false, "psing", "golem.prop.single"), new ISealConfigToggles.SealToggle(false, "pleave", "golem.prop.leave")};

    @Override
    public String getKey() {
        return "thaumcraft:provider";
    }

    @Override
    public int getFilterSize() {
        return 9;
    }

    @Override
    public void tickSeal(World world, ISealEntity seal) {
        if (this.delay % 100 == 0) {
            Iterator<Integer> it = this.cache.keySet().iterator();
            while (it.hasNext()) {
                Task t = TaskHandler.getTask(world.field_73011_w.getDimension(), it.next());
                if (t != null) continue;
                it.remove();
            }
        }
        if (this.delay++ % 20 != 0) {
            return;
        }
        TileEntity te = world.func_175625_s(seal.getSealPos().pos);
        if (te != null && te instanceof IInventory && GolemHelper.provisionRequests.containsKey(world.field_73011_w.getDimension())) {
            ListIterator<ProvisionRequest> it = GolemHelper.provisionRequests.get(world.field_73011_w.getDimension()).listIterator();
            while (it.hasNext()) {
                ProvisionRequest pr = it.next();
                if (!(pr.getSeal().getSealPos().pos.func_177951_i((Vec3i)seal.getSealPos().pos) < 4096.0) || InventoryUtils.findFirstMatchFromFilter(this.getInv(), this.blacklist, new ItemStack[]{pr.getStack()}, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value) == null || InventoryUtils.inventoryContainsAmount((IInventory)te, pr.getStack(), seal.getSealPos().face, false, false, false, false) <= (this.props[5].value ? 1 : 0)) continue;
                Task task = new Task(seal.getSealPos(), seal.getSealPos().pos);
                task.setPriority(pr.getSeal().getPriority());
                task.setLifespan((short)5);
                TaskHandler.addTask(world.field_73011_w.getDimension(), task);
                this.cache.put(task.getId(), pr);
                it.remove();
                break;
            }
        }
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        TileEntity te = world.func_175625_s(task.getSealPos().pos);
        if (te != null && te instanceof IInventory) {
            ItemStack stack = null;
            try {
                stack = this.cache.get(task.getId()).getStack().func_77946_l();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stack != null && this.props[4].value) {
                stack.field_77994_a = 1;
            }
            int sa = 0;
            if (stack != null && this.props[5].value && (sa = InventoryUtils.inventoryContainsAmount((IInventory)te, stack, task.getSealPos().face, false, false, false, false)) <= stack.field_77994_a) {
                stack.field_77994_a = sa - 1;
            }
            if (stack != null && golem.canCarry(stack, true)) {
                ItemStack q;
                ItemStack s = golem.holdItem(InventoryUtils.extractStack((IInventory)te, stack.func_77946_l(), task.getSealPos().face, false, false, false, false, true));
                if (s != null && (q = InventoryUtils.placeItemStackIntoInventory(s, (IInventory)te, task.getSealPos().face, true)) != null) {
                    ((Entity)golem).func_70099_a(q, 0.25f);
                }
                ((Entity)golem).func_184185_a(SoundEvents.field_187638_cR, 0.125f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                golem.addRankXp(1);
                golem.swingArm();
            }
            this.cache.remove(task.getId());
        }
        task.setSuspended(true);
        return true;
    }

    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        ProvisionRequest pr = this.cache.get(task.getId());
        return pr != null && ((EntityThaumcraftGolem)golem).func_180485_d(pr.getSeal().getSealPos().pos) && this.areGolemTagsValidForTask(pr.getSeal(), golem) && pr.getStack() != null && !golem.isCarrying(pr.getStack()) && golem.canCarry(pr.getStack(), true);
    }

    private boolean areGolemTagsValidForTask(ISealEntity se, IGolemAPI golem) {
        if (se != null) {
            if (se.isLocked() && !((IEntityOwnable)golem).func_184753_b().equals(se.getOwner())) {
                return false;
            }
            if (se.getSeal().getRequiredTags() != null && !golem.getProperties().getTraits().containsAll(Arrays.asList(se.getSeal().getRequiredTags()))) {
                return false;
            }
            if (se.getSeal().getForbiddenTags() != null) {
                for (EnumGolemTrait tag : se.getSeal().getForbiddenTags()) {
                    if (!golem.getProperties().getTraits().contains((Object)tag)) continue;
                    return false;
                }
            }
        } else {
            return true;
        }
        return true;
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
        this.cache.remove(task.getId());
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te instanceof IInventory;
    }

    @Override
    public ResourceLocation getSealIcon() {
        return this.icon;
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{1, 3, 0, 4};
    }

    @Override
    public EnumGolemTrait[] getRequiredTags() {
        return new EnumGolemTrait[]{EnumGolemTrait.SMART};
    }

    @Override
    public EnumGolemTrait[] getForbiddenTags() {
        return new EnumGolemTrait[]{EnumGolemTrait.CLUMSY};
    }

    @Override
    public void onTaskStarted(World world, IGolemAPI golem, Task task) {
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }

    @Override
    public ISealConfigToggles.SealToggle[] getToggles() {
        return this.props;
    }

    @Override
    public void setToggle(int indx, boolean value) {
        this.props[indx].setValue(value);
    }
}

