/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.projectile;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.lib.utils.Utils;

public class EntityGenericProjectile
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    FocusCore core;
    ItemStack casterStack;
    float charge = 1.0f;

    public EntityGenericProjectile(World par1World) {
        super(par1World);
    }

    public EntityGenericProjectile(World par1World, EntityLivingBase p, ItemStack s, float speed, float scatter, FocusCore core, float charge, boolean mainhand) {
        super(par1World, p);
        this.core = core;
        this.func_184538_a((Entity)p, p.field_70125_A, p.field_70177_z, -1.0f, speed, scatter);
        this.field_70165_t += (double)(-MathHelper.func_76134_b((float)((p.field_70177_z - 0.5f) / 180.0f * 3.141593f)) * 0.2f * (float)(mainhand ? 1 : -1));
        this.field_70163_u += (double)-0.4f;
        this.field_70161_v += (double)(-MathHelper.func_76126_a((float)((p.field_70177_z - 0.5f) / 180.0f * 3.141593f)) * 0.3f * (float)(mainhand ? 1 : -1));
        this.casterStack = s;
        this.charge = charge;
    }

    protected float func_70185_h() {
        return 0.01f;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeFloat(this.charge);
        Utils.writeNBTTagCompoundToBuffer(data, this.core.serialize());
        if (this.casterStack != null) {
            Utils.writeNBTTagCompoundToBuffer(data, this.casterStack.serializeNBT());
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.charge = data.readFloat();
        this.core = new FocusCore();
        this.core.deserialize(Utils.readNBTTagCompoundFromBuffer(data));
        try {
            this.casterStack = ItemStack.func_77949_a((NBTTagCompound)Utils.readNBTTagCompoundFromBuffer(data));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74782_a("core", (NBTBase)this.core.serialize());
        if (this.casterStack != null) {
            nbt.func_74782_a("casterstack", (NBTBase)this.casterStack.serializeNBT());
        }
        nbt.func_74776_a("charge", this.charge);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.charge = nbt.func_74760_g("charge");
        this.core = new FocusCore();
        this.core.deserialize(nbt.func_74775_l("core"));
        this.casterStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("casterstack"));
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (mop != null) {
            boolean unhurt = mop.field_72308_g == null || mop.field_72308_g.field_70172_ad <= 0;
            int resetHurt = 0;
            for (FocusCore.FocusEffect ef : this.core.effects) {
                if (mop.field_72308_g != null && unhurt && mop.field_72308_g.field_70172_ad > 0) {
                    resetHurt = mop.field_72308_g.field_70172_ad;
                    mop.field_72308_g.field_70172_ad = 0;
                }
                ef.effect.onEffectTrigger(this.field_70170_p, mop, (Entity)this.func_85052_h(), this.casterStack, (Entity)this, ef, this.charge);
            }
            if (!this.field_70170_p.field_72995_K) {
                CasterManager.sendImpact(this.field_70170_p, mop.field_72307_f.field_72450_a, Math.max(mop.field_72307_f.field_72448_b, this.field_70163_u), mop.field_72307_f.field_72449_c, this.core);
            }
            if (resetHurt > 0) {
                mop.field_72308_g.field_70172_ad = resetHurt;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 1200) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            for (double i = 0.0; i < 3.0; i += 1.0) {
                FocusCore.FocusEffect eff = this.core.effects[this.field_70146_Z.nextInt(this.core.effects.length)];
                float scale = 1.0f * eff.effectMultipler * this.charge;
                Color c1 = new Color(eff.effect.getGemColor());
                Color c2 = new Color(eff.effect.getIconColor());
                double coeff = i / 3.0;
                FXDispatcher.INSTANCE.drawFireMote((float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * coeff), (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * coeff) + this.field_70131_O / 2.0f, (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * coeff), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f) * scale, 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f) * scale, 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f) * scale, (float)c1.getRed() / 255.0f, (float)c1.getGreen() / 255.0f, (float)c1.getBlue() / 255.0f, 0.5f, 4.0f * scale);
                if (i != 0.0) continue;
                ArrayList<String> hp = new ArrayList<String>();
                for (String p : this.core.partsRaw.keySet()) {
                    if (!this.core.partsRaw.get(p).hasCustomParticle()) continue;
                    hp.add(p);
                }
                if (hp.isEmpty()) {
                    FXDispatcher.INSTANCE.drawGenericParticles(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * coeff + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70167_r + (this.field_70163_u - this.field_70167_r) * coeff + (double)(this.field_70131_O / 2.0f) + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70166_s + (this.field_70161_v - this.field_70166_s) * coeff + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f, (float)c2.getRed() / 255.0f, (float)c2.getGreen() / 255.0f, (float)c2.getBlue() / 255.0f, 0.8f, false, 448, 8, 1, 20 + this.field_70146_Z.nextInt(10), 0, 0.3f * scale, 0.0f, 0);
                    continue;
                }
                IFocusPart p = this.core.partsRaw.get(hp.get(this.field_70146_Z.nextInt(hp.size())));
                if (p == null) continue;
                p.drawCustomParticle(this.field_70170_p, this.field_70169_q + (this.field_70165_t - this.field_70169_q) * coeff + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70167_r + (this.field_70163_u - this.field_70167_r) * coeff + (double)(this.field_70131_O / 2.0f) + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70166_s + (this.field_70161_v - this.field_70166_s) * coeff + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f);
            }
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
    }
}

