/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters;

import baubles.api.BaublesApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.api.potions.PotionVisExhaust;
import thaumcraft.common.items.casters.ICaster;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.items.casters.ItemFocusPouch;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXFocusPartImpact;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;

public class CasterManager {
    static HashMap<Integer, Long> cooldownServer = new HashMap();
    static HashMap<Integer, Long> cooldownClient = new HashMap();

    public static int getBaseChargeRate(EntityPlayer player, boolean currentItem, int slot) {
        return ThaumcraftCapabilities.getKnowledge(player).isResearchKnown("NODETAPPER2") && slot < 9 ? 3 : (ThaumcraftCapabilities.getKnowledge(player).isResearchKnown("NODETAPPER1") && slot < 9 ? 2 : (currentItem ? 1 : 0));
    }

    public static float getTotalVisDiscount(EntityPlayer player) {
        int a;
        int total = 0;
        if (player == null) {
            return 0.0f;
        }
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (a = 0; a < 4; ++a) {
            if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof IVisDiscountGear)) continue;
            total += ((IVisDiscountGear)baubles.func_70301_a(a).func_77973_b()).getVisDiscount(baubles.func_70301_a(a), player);
        }
        for (a = 0; a < 4; ++a) {
            if (player.field_71071_by.field_70460_b[a] == null || !(player.field_71071_by.field_70460_b[a].func_77973_b() instanceof IVisDiscountGear)) continue;
            total += ((IVisDiscountGear)player.field_71071_by.field_70460_b[a].func_77973_b()).getVisDiscount(player.field_71071_by.field_70460_b[a], player);
        }
        if (player.func_70644_a((Potion)PotionVisExhaust.instance) || player.func_70644_a((Potion)PotionInfectiousVisExhaust.instance)) {
            int level1 = 0;
            int level2 = 0;
            if (player.func_70644_a((Potion)PotionVisExhaust.instance)) {
                level1 = player.func_70660_b((Potion)PotionVisExhaust.instance).func_76458_c();
            }
            if (player.func_70644_a((Potion)PotionInfectiousVisExhaust.instance)) {
                level2 = player.func_70660_b((Potion)PotionInfectiousVisExhaust.instance).func_76458_c();
            }
            total -= (Math.max(level1, level2) + 1) * 10;
        }
        return (float)total / 100.0f;
    }

    public static boolean consumeVisFromInventory(EntityPlayer player, float cost) {
        for (int a = player.field_71071_by.field_70462_a.length - 1; a >= 0; --a) {
            boolean done;
            ItemStack item = player.field_71071_by.field_70462_a[a];
            if (item == null || !(item.func_77973_b() instanceof ICaster) || !(done = ((ICaster)item.func_77973_b()).consumeVis(item, player, cost, true))) continue;
            return true;
        }
        return false;
    }

    public static void changeFocus(ItemStack is, World w, EntityPlayer player, String focus) {
        int q;
        ItemStack[] inv;
        int a;
        ICaster wand = (ICaster)is.func_77973_b();
        TreeMap<String, Integer> foci = new TreeMap<String, Integer>();
        HashMap<Integer, Integer> pouches = new HashMap<Integer, Integer>();
        int pouchcount = 0;
        ItemStack item = null;
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (a = 0; a < baubles.func_70302_i_(); ++a) {
            if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof ItemFocusPouch)) continue;
            item = baubles.func_70301_a(a);
            pouches.put(++pouchcount, a - 4);
            inv = ((ItemFocusPouch)item.func_77973_b()).getInventory(item);
            for (q = 0; q < inv.length; ++q) {
                item = inv[q];
                if (item == null || !(item.func_77973_b() instanceof ItemFocus)) continue;
                foci.put(((ItemFocus)item.func_77973_b()).getSortingHelper(item), q + pouchcount * 1000);
            }
        }
        for (a = 0; a < 36; ++a) {
            item = player.field_71071_by.field_70462_a[a];
            if (item != null && item.func_77973_b() instanceof ItemFocus) {
                foci.put(((ItemFocus)item.func_77973_b()).getSortingHelper(item), a);
            }
            if (item == null || !(item.func_77973_b() instanceof ItemFocusPouch)) continue;
            pouches.put(++pouchcount, a);
            inv = ((ItemFocusPouch)item.func_77973_b()).getInventory(item);
            for (q = 0; q < inv.length; ++q) {
                item = inv[q];
                if (item == null || !(item.func_77973_b() instanceof ItemFocus)) continue;
                foci.put(((ItemFocus)item.func_77973_b()).getSortingHelper(item), q + pouchcount * 1000);
            }
        }
        if (focus.equals("REMOVE") || foci.size() == 0) {
            if (wand.getFocus(is) != null && (CasterManager.addFocusToPouch(player, wand.getFocusStack(is).func_77946_l(), pouches) || player.field_71071_by.func_70441_a(wand.getFocusStack(is).func_77946_l()))) {
                wand.setFocus(is, null);
                player.func_184185_a(SoundsTC.ticks, 0.3f, 0.9f);
            }
            return;
        }
        if (foci != null && foci.size() > 0 && focus != null) {
            String newkey = focus;
            if (foci.get(newkey) == null) {
                newkey = foci.higherKey(newkey);
            }
            if (newkey == null || foci.get(newkey) == null) {
                newkey = (String)foci.firstKey();
            }
            if ((Integer)foci.get(newkey) < 1000 && (Integer)foci.get(newkey) >= 0) {
                item = player.field_71071_by.field_70462_a[(Integer)foci.get(newkey)].func_77946_l();
            } else {
                int pid = (Integer)foci.get(newkey) / 1000;
                if (pouches.containsKey(pid)) {
                    int pouchslot = pouches.get(pid);
                    int focusslot = (Integer)foci.get(newkey) - pid * 1000;
                    ItemStack tmp = null;
                    tmp = pouchslot >= 0 ? player.field_71071_by.field_70462_a[pouchslot].func_77946_l() : baubles.func_70301_a(pouchslot + 4).func_77946_l();
                    item = CasterManager.fetchFocusFromPouch(player, focusslot, tmp, pouchslot);
                }
            }
            if (item != null) {
                if ((Integer)foci.get(newkey) < 1000 && (Integer)foci.get(newkey) >= 0) {
                    player.field_71071_by.func_70299_a(((Integer)foci.get(newkey)).intValue(), null);
                }
            } else {
                return;
            }
            player.func_184185_a(SoundsTC.ticks, 0.3f, 1.0f);
            if (wand.getFocus(is) != null && (CasterManager.addFocusToPouch(player, wand.getFocusStack(is).func_77946_l(), pouches) || player.field_71071_by.func_70441_a(wand.getFocusStack(is).func_77946_l()))) {
                wand.setFocus(is, null);
            }
            if (wand.getFocus(is) == null) {
                wand.setFocus(is, item);
            } else if (!CasterManager.addFocusToPouch(player, item, pouches)) {
                player.field_71071_by.func_70441_a(item);
            }
        }
    }

    private static ItemStack fetchFocusFromPouch(EntityPlayer player, int focusid, ItemStack pouch, int pouchslot) {
        ItemStack focus = null;
        ItemStack[] inv = ((ItemFocusPouch)pouch.func_77973_b()).getInventory(pouch);
        ItemStack contents = inv[focusid];
        if (contents != null && contents.func_77973_b() instanceof ItemFocus) {
            focus = contents.func_77946_l();
            inv[focusid] = null;
            ((ItemFocusPouch)pouch.func_77973_b()).setInventory(pouch, inv);
            if (pouchslot >= 0) {
                player.field_71071_by.func_70299_a(pouchslot, pouch);
                player.field_71071_by.func_70296_d();
            } else {
                IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
                baubles.func_70299_a(pouchslot + 4, pouch);
                baubles.func_70296_d();
            }
        }
        return focus;
    }

    private static boolean addFocusToPouch(EntityPlayer player, ItemStack focus, HashMap<Integer, Integer> pouches) {
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (Integer pouchslot : pouches.values()) {
            ItemStack pouch = pouchslot >= 0 ? player.field_71071_by.field_70462_a[pouchslot] : baubles.func_70301_a(pouchslot + 4);
            ItemStack[] inv = ((ItemFocusPouch)pouch.func_77973_b()).getInventory(pouch);
            for (int q = 0; q < inv.length; ++q) {
                ItemStack contents = inv[q];
                if (contents != null) continue;
                inv[q] = focus.func_77946_l();
                ((ItemFocusPouch)pouch.func_77973_b()).setInventory(pouch, inv);
                if (pouchslot >= 0) {
                    player.field_71071_by.func_70299_a(pouchslot.intValue(), pouch);
                    player.field_71071_by.func_70296_d();
                } else {
                    baubles.func_70299_a(pouchslot + 4, pouch);
                    baubles.func_70296_d();
                }
                return true;
            }
        }
        return false;
    }

    public static void toggleMisc(ItemStack itemstack, World world, EntityPlayer player) {
    }

    private static int getAreaSize(ItemStack stack) {
        return 3;
    }

    public static int getAreaDim(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("aread")) {
            return stack.func_77978_p().func_74762_e("aread");
        }
        return 0;
    }

    public static int getAreaX(ItemStack stack) {
        ICaster wand = (ICaster)stack.func_77973_b();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("areax")) {
            int a = stack.func_77978_p().func_74762_e("areax");
            if (a > CasterManager.getAreaSize(wand.getFocusStack(stack))) {
                a = CasterManager.getAreaSize(wand.getFocusStack(stack));
            }
            return a;
        }
        return CasterManager.getAreaSize(wand.getFocusStack(stack));
    }

    public static int getAreaY(ItemStack stack) {
        ICaster wand = (ICaster)stack.func_77973_b();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("areay")) {
            int a = stack.func_77978_p().func_74762_e("areay");
            if (a > CasterManager.getAreaSize(wand.getFocusStack(stack))) {
                a = CasterManager.getAreaSize(wand.getFocusStack(stack));
            }
            return a;
        }
        return CasterManager.getAreaSize(wand.getFocusStack(stack));
    }

    public static int getAreaZ(ItemStack stack) {
        ICaster wand = (ICaster)stack.func_77973_b();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("areaz")) {
            int a = stack.func_77978_p().func_74762_e("areaz");
            if (a > CasterManager.getAreaSize(wand.getFocusStack(stack))) {
                a = CasterManager.getAreaSize(wand.getFocusStack(stack));
            }
            return a;
        }
        return CasterManager.getAreaSize(wand.getFocusStack(stack));
    }

    public static void setAreaX(ItemStack stack, int area) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("areax", area);
        }
    }

    public static void setAreaY(ItemStack stack, int area) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("areay", area);
        }
    }

    public static void setAreaZ(ItemStack stack, int area) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("areaz", area);
        }
    }

    public static void setAreaDim(ItemStack stack, int dim) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("aread", dim);
        }
    }

    public static void sendImpact(World world, double x, double y, double z, FocusCore core) {
        ArrayList<String> pParts = new ArrayList<String>();
        for (String k : core.partsRaw.keySet()) {
            IFocusPart p = core.partsRaw.get(k);
            if (p == null || !p.hasCustomParticle()) continue;
            pParts.add(k);
        }
        if (!pParts.isEmpty()) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXFocusPartImpact(x, y, z, pParts.toArray(new String[0])), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 32.0));
        }
    }

    static boolean isOnCooldown(EntityLivingBase entityLiving) {
        if (entityLiving.field_70170_p.field_72995_K && cooldownClient.containsKey(entityLiving.func_145782_y())) {
            return cooldownClient.get(entityLiving.func_145782_y()) > System.currentTimeMillis();
        }
        if (!entityLiving.field_70170_p.field_72995_K && cooldownServer.containsKey(entityLiving.func_145782_y())) {
            return cooldownServer.get(entityLiving.func_145782_y()) > System.currentTimeMillis();
        }
        return false;
    }

    public static float getCooldown(EntityLivingBase entityLiving) {
        if (entityLiving.field_70170_p.field_72995_K && cooldownClient.containsKey(entityLiving.func_145782_y())) {
            return (float)(cooldownClient.get(entityLiving.func_145782_y()) - System.currentTimeMillis()) / 1000.0f;
        }
        return 0.0f;
    }

    public static void setCooldown(EntityLivingBase entityLiving, int cd) {
        if (cd == 0) {
            cooldownClient.remove(entityLiving.func_145782_y());
            cooldownServer.remove(entityLiving.func_145782_y());
        } else if (entityLiving.field_70170_p.field_72995_K) {
            cooldownClient.put(entityLiving.func_145782_y(), System.currentTimeMillis() + (long)(cd * 50));
        } else {
            cooldownServer.put(entityLiving.func_145782_y(), System.currentTimeMillis() + (long)(cd * 50));
        }
    }
}

