/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import thaumcraft.Thaumcraft;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.common.items.ItemTCBase;

public class ItemFocus
extends ItemTCBase {
    public ItemFocus() {
        super("focus", new String[0]);
        this.field_77777_bU = 1;
        this.func_77656_e(0);
        this.func_77637_a(null);
    }

    public int[] getFocusColors(ItemStack focusstack) {
        int[] colors = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
        FocusCore core = ItemFocus.getCore(focusstack);
        int r = 0;
        int g = 0;
        int b = 0;
        for (FocusCore.FocusEffect ef : core.effects) {
            Color c = new Color(ef.effect.getGemColor());
            r += c.getRed();
            g += c.getGreen();
            b += c.getBlue();
        }
        Color c = new Color(r /= core.effects.length, g /= core.effects.length, b /= core.effects.length);
        colors[0] = c.getRGB();
        int i = 1;
        for (IFocusPart p : core.partsRaw.values()) {
            colors[i] = p.getIconColor();
            ++i;
        }
        return colors;
    }

    public String getSortingHelper(ItemStack focusstack) {
        return ItemFocus.getCore(focusstack).getSortingHelper();
    }

    public static void setCore(ItemStack focusstack, FocusCore core) {
        NBTTagCompound tag = core.serialize();
        focusstack.func_77983_a("core", (NBTBase)tag);
    }

    public static FocusCore getCore(ItemStack focusstack) {
        NBTTagCompound tag = focusstack.func_179543_a("core", true);
        FocusCore core = new FocusCore();
        core.deserialize(tag);
        return core;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        float al = this.getVisCost(stack);
        DecimalFormat myFormatter = new DecimalFormat("#####.##");
        String amount = myFormatter.format(al);
        list.add(amount + " " + I18n.func_74838_a((String)"item.Focus.cost1"));
        this.addFocusInformation(stack, player, list, par4);
    }

    public void addFocusInformation(ItemStack focusstack, EntityPlayer player, List list, boolean par4) {
        FocusCore core = ItemFocus.getCore(focusstack);
        String t = TextFormatting.GOLD + core.medium.getName();
        if (Thaumcraft.proxy.isShiftKeyDown() && core.mediumModifiers != null && core.mediumModifiers.length > 0) {
            t = t + TextFormatting.DARK_GRAY + " [";
            for (IFocusPart p : core.mediumModifiers) {
                if (p.getType() == IFocusPart.EnumFocusPartType.EFFECT) continue;
                t = t + p.getName() + " ";
            }
            t = t + "]";
        }
        list.add(t);
        for (FocusCore.FocusEffect fe : core.effects) {
            String t0 = TextFormatting.DARK_PURPLE + fe.effect.getName();
            if (Thaumcraft.proxy.isShiftKeyDown() && fe.modifiers != null && fe.modifiers.length > 0) {
                t0 = t0 + TextFormatting.DARK_GRAY + " [";
                for (IFocusPart p : fe.modifiers) {
                    if (p.getType() == IFocusPart.EnumFocusPartType.MEDIUM) continue;
                    t0 = t0 + p.getName() + " ";
                }
                t0 = t0 + "]";
            }
            list.add(t0);
        }
    }

    public EnumRarity func_77613_e(ItemStack focusstack) {
        return EnumRarity.RARE;
    }

    public float getVisCost(ItemStack focusstack) {
        return ItemFocus.getCore((ItemStack)focusstack).cost;
    }

    public int getActivationTime(ItemStack focusstack) {
        return ItemFocus.getCore(focusstack).getFinalChargeTime();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }
}

