/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.items.casters.foci.FModFortune;
import thaumcraft.common.items.casters.foci.FModSilkTouch;
import thaumcraft.common.lib.utils.BlockUtils;

public class FEffectBreak
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/break.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.BREAK";
    }

    @Override
    public String getResearch() {
        return "FOCUSBREAK@2";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.ENTROPY;
    }

    @Override
    public int getGemColor() {
        return 9063176;
    }

    @Override
    public int getIconColor() {
        return 16249568;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 0.5f;
    }

    @Override
    public boolean onEffectTrigger(World world, RayTraceResult ray, Entity caster, ItemStack casterStack, Entity mediumEntity, FocusCore.FocusEffect effect, float charge) {
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK && caster instanceof EntityPlayer && !world.field_72995_K) {
            boolean silk = false;
            int fortune = 0;
            if (effect.modifiers != null) {
                for (IFocusPart mod : effect.modifiers) {
                    if (mod instanceof FModSilkTouch) {
                        silk = true;
                    }
                    if (!(mod instanceof FModFortune)) continue;
                    fortune = 2;
                }
            }
            return BlockUtils.harvestBlock(world, (EntityPlayer)caster, ray.func_178782_a(), true, silk, fortune, false);
        }
        return false;
    }

    @Override
    public boolean hasCustomParticle() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawCustomParticle(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, motionX, motionY, motionZ);
        fb.func_187114_a(6 + world.field_73012_v.nextInt(6));
        int q = world.field_73012_v.nextInt(4);
        fb.setParticles(704 + q * 3, 3, 1);
        fb.setSlowDown(0.8);
        fb.setScale((float)((double)0.7f + world.field_73012_v.nextGaussian() * (double)0.3f));
        ParticleEngine.INSTANCE.addEffectWithDelay(world, fb, 0);
    }
}

