/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.common.items.casters.foci.FModLingering;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockBamf;

public class FEffectCurse
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/curse.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.CURSE";
    }

    @Override
    public String getResearch() {
        return "FOCUSCURSE";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.DEATH;
    }

    @Override
    public int getGemColor() {
        return 2815273;
    }

    @Override
    public int getIconColor() {
        return 0x805080;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 5.0f;
    }

    @Override
    public boolean onEffectTrigger(World world, RayTraceResult ray, Entity caster, ItemStack casterStack, Entity mediumEntity, FocusCore.FocusEffect effect, float charge) {
        if (!world.field_72995_K) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockBamf(ray.field_72307_f.field_72450_a, Math.max(ray.field_72307_f.field_72448_b, mediumEntity.field_70163_u), ray.field_72307_f.field_72449_c, this.getGemColor(), true, true, null), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), mediumEntity.field_70165_t, mediumEntity.field_70163_u, mediumEntity.field_70161_v, 32.0));
        }
        if (ray.field_72313_a == RayTraceResult.Type.ENTITY && ray.field_72308_g != null) {
            if (world.field_72995_K) {
                return true;
            }
            int duration = 80;
            float eff = 1.0f * effect.effectMultipler * charge - 1.0f;
            if (eff < 0.0f) {
                eff = 0.0f;
            }
            if (effect.modifiers != null) {
                for (IFocusPart mod : effect.modifiers) {
                    if (!(mod instanceof FModLingering)) continue;
                    duration *= 2;
                }
            }
            if (ray.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)ray.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration / 2, Math.round(eff)));
                ((EntityLivingBase)ray.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, Math.round(eff)));
                ((EntityLivingBase)ray.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 2, Math.round(eff)));
                ((EntityLivingBase)ray.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_189112_A, duration * 3, Math.round(eff)));
            }
            return true;
        }
        return false;
    }
}

