/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusBlockPicker;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.common.items.casters.ItemCaster;
import thaumcraft.common.items.casters.foci.FModFortune;
import thaumcraft.common.items.casters.foci.FModSilkTouch;
import thaumcraft.common.lib.events.ServerEvents;

public class FEffectExchange
implements IFocusPartEffect,
IFocusBlockPicker {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/exchange.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.EXCHANGE";
    }

    @Override
    public String getResearch() {
        return "FOCUSEXCHANGE";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.EXCHANGE;
    }

    @Override
    public int getGemColor() {
        return 13927953;
    }

    @Override
    public int getIconColor() {
        return 16775142;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 0.25f;
    }

    @Override
    public boolean onEffectTrigger(World world, RayTraceResult ray, Entity caster, ItemStack casterStack, Entity mediumEntity, FocusCore.FocusEffect effect, float charge) {
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK && !world.field_72995_K && caster instanceof EntityPlayer && casterStack != null) {
            ItemCaster c;
            boolean silk = false;
            int fortune = 0;
            if (effect.modifiers != null) {
                for (IFocusPart mod : effect.modifiers) {
                    if (mod instanceof FModSilkTouch) {
                        silk = true;
                    }
                    if (!(mod instanceof FModFortune)) continue;
                    fortune = 2;
                }
            }
            if ((c = (ItemCaster)casterStack.func_77973_b()).getPickedBlock(casterStack) == null) {
                return false;
            }
            ServerEvents.addSwapper(world, ray.func_178782_a(), world.func_180495_p(ray.func_178782_a()), c.getPickedBlock(casterStack), true, 0, (EntityPlayer)caster, true, false, this.getGemColor(), true, silk, fortune, ServerEvents.DEFAULT_PREDICATE, effect.effect.getBaseCost() * effect.costMultipler);
            return true;
        }
        return false;
    }
}

