/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.items.casters.foci.FModLingering;

public class FEffectFire
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/fire.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.FIRE";
    }

    @Override
    public String getResearch() {
        return "BASEAUROMANCY@3";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.FIRE;
    }

    @Override
    public int getGemColor() {
        return 16519424;
    }

    @Override
    public int getIconColor() {
        return 16366673;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 2.0f;
    }

    @Override
    public boolean onEffectTrigger(World world, RayTraceResult ray, Entity caster, ItemStack casterStack, Entity mediumEntity, FocusCore.FocusEffect effect, float charge) {
        if (ray.field_72313_a == RayTraceResult.Type.ENTITY && ray.field_72308_g != null) {
            if (ray.field_72308_g.func_70045_F()) {
                return false;
            }
            if (world.field_72995_K) {
                return true;
            }
            float fire = 2.0f;
            float damage = 3.0f * effect.effectMultipler * charge;
            if (effect.modifiers != null) {
                for (IFocusPart mod : effect.modifiers) {
                    if (!(mod instanceof FModLingering)) continue;
                    fire *= 3.0f;
                }
            }
            ray.field_72308_g.func_70097_a(new EntityDamageSourceIndirect("fireball", mediumEntity, caster).func_76361_j(), damage);
            ray.field_72308_g.func_70015_d(Math.round(fire));
            return true;
        }
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (world.field_72995_K) {
                return true;
            }
            BlockPos pos = ray.func_178782_a();
            if (world.func_175623_d(pos = pos.func_177972_a(ray.field_178784_b))) {
                world.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasCustomParticle() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawCustomParticle(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXDispatcher.INSTANCE.drawGenericParticles(posX, posY, posZ, motionX, motionY, motionZ, 1.0f, 1.0f, 1.0f, 0.7f, false, 640, 10, 1, 10, 0, (float)(1.0 + world.field_73012_v.nextGaussian() * (double)0.2f), 0.0f, 0);
    }
}

