/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import java.util.Random;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.items.casters.foci.FModLingering;

public class FEffectFrost
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/frost.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.FROST";
    }

    @Override
    public String getResearch() {
        return "FOCUSFROST";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.COLD;
    }

    @Override
    public int getGemColor() {
        return 3836158;
    }

    @Override
    public int getIconColor() {
        return 13299966;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 2.0f;
    }

    @Override
    public boolean onEffectTrigger(World world, RayTraceResult ray, Entity caster, ItemStack casterStack, Entity mediumEntity, FocusCore.FocusEffect effect, float charge) {
        if (ray.field_72313_a == RayTraceResult.Type.ENTITY && ray.field_72308_g != null) {
            if (world.field_72995_K) {
                return true;
            }
            float damage = 3.0f * effect.effectMultipler * charge;
            int cold = 40;
            int frost = 1;
            if (effect.modifiers != null) {
                for (IFocusPart mod : effect.modifiers) {
                    if (!(mod instanceof FModLingering)) continue;
                    cold *= 3;
                    frost *= 2;
                }
            }
            ray.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)mediumEntity, (Entity)caster), damage);
            if (ray.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)ray.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76421_d, cold, frost));
            }
            return true;
        }
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (world.field_72995_K) {
                return true;
            }
            float f = Math.min(16.0f, 2.0f * effect.effectMultipler);
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.func_177975_b((BlockPos)ray.func_178782_a().func_177963_a((double)(-f), (double)(-f), (double)(-f)), (BlockPos)ray.func_178782_a().func_177963_a((double)f, (double)f, (double)f))) {
                IBlockState iblockstate1;
                if (!(blockpos$mutableblockpos1.func_177957_d(mediumEntity.field_70165_t, mediumEntity.field_70163_u, mediumEntity.field_70161_v) <= (double)(f * f)) || (iblockstate1 = world.func_180495_p((BlockPos)blockpos$mutableblockpos1)).func_185904_a() != Material.field_151586_h || (Integer)iblockstate1.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !world.func_175716_a(Blocks.field_185778_de, (BlockPos)blockpos$mutableblockpos1, false, EnumFacing.DOWN, (Entity)null, (ItemStack)null)) continue;
                world.func_175656_a((BlockPos)blockpos$mutableblockpos1, Blocks.field_185778_de.func_176223_P());
                world.func_175684_a(blockpos$mutableblockpos1.func_185334_h(), Blocks.field_185778_de, MathHelper.func_76136_a((Random)world.field_73012_v, (int)60, (int)120));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomParticle() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawCustomParticle(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, motionX, motionY, motionZ);
        fb.func_187114_a(40 + world.field_73012_v.nextInt(40));
        fb.setAlphaF(1.0f, 0.0f);
        fb.setParticles(8, 1, 1);
        fb.setGravity(0.033f);
        fb.setSlowDown(0.8);
        fb.setRandomMovementScale(0.0025f, 1.0E-4f, 0.0025f);
        fb.setScale((float)((double)0.7f + world.field_73012_v.nextGaussian() * (double)0.3f));
        fb.setRotationSpeed(world.field_73012_v.nextFloat() * 3.0f, (float)world.field_73012_v.nextGaussian() / 4.0f);
        ParticleEngine.INSTANCE.addEffectWithDelay(world, fb, 0);
    }
}

