/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockBamf;

public class FEffectMagic
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/magic.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.MAGIC";
    }

    @Override
    public String getResearch() {
        return "FOCUSMAGIC";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.MAGIC;
    }

    @Override
    public int getGemColor() {
        return 0xCF00FF;
    }

    @Override
    public int getIconColor() {
        return 0xFFC0FF;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 2.0f;
    }

    @Override
    public boolean onEffectTrigger(World world, RayTraceResult ray, Entity caster, ItemStack casterStack, Entity mediumEntity, FocusCore.FocusEffect effect, float charge) {
        if (!world.field_72995_K) {
            double hm = 0.0;
            if (ray.field_72308_g != null) {
                hm = ray.field_72308_g.field_70131_O / 2.0f;
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockBamf(ray.field_72307_f.field_72450_a, ray.field_72307_f.field_72448_b + hm, ray.field_72307_f.field_72449_c, this.getGemColor(), true, true, null), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), mediumEntity.field_70165_t, mediumEntity.field_70163_u, mediumEntity.field_70161_v, 32.0));
        }
        if (ray.field_72313_a == RayTraceResult.Type.ENTITY && ray.field_72308_g != null) {
            if (world.field_72995_K) {
                return true;
            }
            float damage = 2.0f * effect.effectMultipler * charge;
            ray.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)mediumEntity, (Entity)caster), damage);
        }
        return false;
    }
}

