/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.casters.foci.FModLingering;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.tiles.misc.TileHole;

public class FEffectRift
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/rift.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.RIFT";
    }

    @Override
    public String getResearch() {
        return "FOCUSBREAK@2";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.VOID;
    }

    @Override
    public int getGemColor() {
        return 3084645;
    }

    @Override
    public int getIconColor() {
        return 6863354;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 10.0f;
    }

    @Override
    public boolean onEffectTrigger(World world, RayTraceResult ray, Entity caster, ItemStack casterStack, Entity mediumEntity, FocusCore.FocusEffect effect, float charge) {
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState bi;
            if (world.field_73011_w.getDimension() == Config.dimensionOuterId) {
                if (!world.field_72995_K) {
                    world.func_184148_a(null, (double)ray.func_178782_a().func_177958_n() + 0.5, (double)ray.func_178782_a().func_177956_o() + 0.5, (double)ray.func_178782_a().func_177952_p() + 0.5, SoundsTC.wandfail, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                return false;
            }
            float maxdis = 8.0f * effect.effectMultipler * charge;
            int dur = 120;
            if (effect.modifiers != null) {
                for (IFocusPart mod : effect.modifiers) {
                    if (!(mod instanceof FModLingering)) continue;
                    dur *= 2;
                }
            }
            int distance = 0;
            BlockPos pos = new BlockPos((Vec3i)ray.func_178782_a());
            distance = 0;
            while ((float)distance < maxdis && !BlockUtils.isPortableHoleBlackListed(bi = world.func_180495_p(pos)) && bi.func_177230_c() != Blocks.field_150357_h && bi.func_177230_c() != BlocksTC.hole && !bi.func_177230_c().isAir(bi, (IBlockAccess)world, pos) && bi.func_185887_b(world, pos) != -1.0f) {
                pos = pos.func_177972_a(ray.field_178784_b.func_176734_d());
                ++distance;
            }
            if (!world.field_72995_K) {
                world.func_184133_a(null, ray.func_178782_a(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return FEffectRift.createHole(world, ray.func_178782_a(), ray.field_178784_b, (byte)Math.round(distance + 1), dur);
        }
        return false;
    }

    public static boolean createHole(World world, BlockPos pos, EnumFacing side, byte count, int max) {
        IBlockState bs = world.func_180495_p(pos);
        if (!(world.field_72995_K || world.func_175625_s(pos) != null || BlockUtils.isPortableHoleBlackListed(bs) || bs.func_177230_c() == Blocks.field_150357_h || bs.func_177230_c() == BlocksTC.hole || !bs.func_177230_c().isAir(bs, (IBlockAccess)world, pos) && bs.func_177230_c().func_176196_c(world, pos) || bs.func_185887_b(world, pos) == -1.0f)) {
            if (world.func_175656_a(pos, BlocksTC.hole.func_176223_P())) {
                TileHole ts = (TileHole)world.func_175625_s(pos);
                ts.oldblock = bs;
                ts.countdownmax = (short)max;
                ts.count = count;
                ts.direction = side;
                ts.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomParticle() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawCustomParticle(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, motionX, motionY, motionZ);
        fb.func_187114_a(16 + world.field_73012_v.nextInt(16));
        fb.setParticles(384 + world.field_73012_v.nextInt(16), 1, 1);
        fb.setSlowDown(0.75);
        fb.setAlphaF(1.0f, 0.0f);
        fb.setScale((float)((double)0.7f + world.field_73012_v.nextGaussian() * (double)0.3f));
        fb.func_70538_b(0.25f, 0.25f, 1.0f);
        fb.setRandomMovementScale(0.01f, 0.01f, 0.01f);
        ParticleEngine.INSTANCE.addEffectWithDelay(world, fb, 0);
    }
}

