/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.FocusHelper;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.items.casters.ICaster;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;

public class FMediumBolt
implements IFocusPartMedium {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/bolt.png");
    private ArrayList<Long> exList = new ArrayList();

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MEDIUM;
    }

    @Override
    public String getKey() {
        return "thaumcraft.BOLT";
    }

    @Override
    public String getResearch() {
        return "FOCUSBOLT@2";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.FIRE;
    }

    @Override
    public int getGemColor() {
        return 5821431;
    }

    @Override
    public int getIconColor() {
        return 0xC0FFFF;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getCostMultiplier() {
        return 1.25f;
    }

    @Override
    public boolean onMediumTrigger(World world, Entity caster, ItemStack casterStack, FocusCore focus, float charge) {
        Entity pointedEntity;
        RayTraceResult mop;
        boolean mainhand = true;
        if (caster instanceof EntityPlayer) {
            if (((EntityPlayer)caster).func_184614_ca() != null && ((EntityPlayer)caster).func_184614_ca().func_77973_b() instanceof ICaster) {
                mainhand = true;
            } else if (((EntityPlayer)caster).func_184592_cb() != null && ((EntityPlayer)caster).func_184592_cb().func_77973_b() instanceof ICaster) {
                mainhand = false;
            }
        }
        float range = 16.0f;
        boolean chaining = false;
        int links = 2;
        if (focus.mediumModifiers != null) {
            for (IFocusPart mod : focus.mediumModifiers) {
                if (mod != FocusHelper.CHAIN) continue;
                chaining = true;
            }
        }
        if ((mop = (pointedEntity = EntityUtils.getPointedEntity(world, caster, 0.0, range, 0.1f)) != null ? new RayTraceResult(pointedEntity) : Utils.rayTrace(world, caster, false, range)) != null) {
            Vec3d v = caster.func_70676_i(1.0f);
            double px = caster.field_70165_t + v.field_72450_a * (double)range;
            double py = caster.func_174813_aQ().field_72338_b + 0.25 + (double)(caster.field_70131_O / 2.0f) + v.field_72448_b * (double)range;
            double pz = caster.field_70161_v + v.field_72449_c * (double)range;
            boolean b = false;
            boolean unhurt = mop.field_72308_g == null || mop.field_72308_g.field_70172_ad <= 0;
            int resetHurt = 0;
            ArrayList<Vec3d> impacts = new ArrayList<Vec3d>();
            block1: for (FocusCore.FocusEffect effect : focus.effects) {
                if (mop.field_72308_g != null && unhurt && mop.field_72308_g.field_70172_ad > 0) {
                    resetHurt = mop.field_72308_g.field_70172_ad;
                    mop.field_72308_g.field_70172_ad = 0;
                }
                if (world.field_72995_K) {
                    this.shootLightning(caster, px, py, pz, effect.effect.getGemColor(), effect.effectMultipler * charge, mainhand);
                }
                IBlockState oldState = null;
                if (mop.func_178782_a() != null) {
                    oldState = world.func_180495_p(mop.func_178782_a());
                }
                if (!effect.effect.onEffectTrigger(world, mop, caster, casterStack, caster, effect, charge)) continue;
                double hmod = 0.0;
                if (mop.field_72308_g != null) {
                    hmod = mop.field_72308_g.field_70131_O / 2.0f;
                }
                impacts.add(new Vec3d(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b + hmod, mop.field_72307_f.field_72449_c));
                b = true;
                if (!chaining) continue;
                Entity sourceE = mop.field_72308_g;
                BlockPos sourceB = mop.func_178782_a();
                this.exList.clear();
                long l = mop.field_72308_g != null ? (long)sourceE.func_145782_y() : (mop.func_178782_a() != null ? sourceB.func_177986_g() : 0L);
                this.exList.add(l);
                Random rand = new Random(l);
                for (int a = 0; a < links; ++a) {
                    BlockPos pos;
                    double pz3;
                    double py3;
                    double px3;
                    double pz2;
                    double py2;
                    double px2;
                    Color c;
                    RayTraceResult rt;
                    if (sourceE != null) {
                        Entity nt = this.getClosestEntityOfType(sourceE, range);
                        if (nt == null) continue;
                        rt = new RayTraceResult(nt);
                        if (!effect.effect.onEffectTrigger(world, rt, caster, casterStack, caster, effect, charge)) continue block1;
                        impacts.add(new Vec3d(rt.field_72307_f.field_72450_a, rt.field_72307_f.field_72448_b + hmod, rt.field_72307_f.field_72449_c));
                        if (world.field_72995_K) {
                            c = new Color(effect.effect.getGemColor());
                            px2 = sourceE.field_70165_t;
                            py2 = sourceE.func_174813_aQ().field_72338_b + (double)(sourceE.field_70131_O / 2.0f);
                            pz2 = sourceE.field_70161_v;
                            px3 = nt.field_70165_t;
                            py3 = nt.func_174813_aQ().field_72338_b + (double)(sourceE.field_70131_O / 2.0f);
                            pz3 = nt.field_70161_v;
                            FXDispatcher.INSTANCE.arcBolt(px2, py2, pz2, px3, py3, pz3, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, charge * effect.effectMultipler);
                        }
                        sourceE = nt;
                        continue;
                    }
                    if (sourceB == null || (pos = this.getClosestBlockOfType(world, mop.func_178782_a(), range, oldState, rand)) == null) continue;
                    rt = new RayTraceResult(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), EnumFacing.UP, pos);
                    if (!effect.effect.onEffectTrigger(world, rt, caster, casterStack, caster, effect, charge)) continue block1;
                    impacts.add(new Vec3d(rt.field_72307_f.field_72450_a, rt.field_72307_f.field_72448_b + hmod, rt.field_72307_f.field_72449_c));
                    if (world.field_72995_K) {
                        c = new Color(effect.effect.getGemColor());
                        px2 = (double)sourceB.func_177958_n() + 0.25 + (double)(world.field_73012_v.nextFloat() * 0.5f);
                        py2 = (double)sourceB.func_177956_o() + 0.25 + (double)(world.field_73012_v.nextFloat() * 0.5f);
                        pz2 = (double)sourceB.func_177952_p() + 0.25 + (double)(world.field_73012_v.nextFloat() * 0.5f);
                        px3 = (double)pos.func_177958_n() + 0.25 + (double)(world.field_73012_v.nextFloat() * 0.5f);
                        py3 = (double)pos.func_177956_o() + 0.25 + (double)(world.field_73012_v.nextFloat() * 0.5f);
                        pz3 = (double)pos.func_177952_p() + 0.25 + (double)(world.field_73012_v.nextFloat() * 0.5f);
                        FXDispatcher.INSTANCE.arcBolt(px2, py2, pz2, px3, py3, pz3, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, charge * effect.effectMultipler);
                    }
                    sourceB = pos;
                }
            }
            if (!world.field_72995_K && !impacts.isEmpty()) {
                for (Vec3d ve : impacts) {
                    CasterManager.sendImpact(world, ve.field_72450_a, ve.field_72448_b, ve.field_72449_c, focus);
                }
            }
            if (resetHurt > 0) {
                mop.field_72308_g.field_70172_ad = resetHurt;
            }
            return b;
        }
        return false;
    }

    private Entity getClosestEntityOfType(Entity source, double range) {
        List<Entity> l = EntityUtils.getEntitiesInRange(source.field_70170_p, source.field_70165_t, source.field_70163_u, source.field_70161_v, source, source.getClass(), range);
        Entity out = null;
        double d = Double.MAX_VALUE;
        for (Entity e : l) {
            double r;
            if (this.exList.contains(e.func_145782_y()) || !((r = source.func_70068_e(e)) < d)) continue;
            d = r;
            out = e;
        }
        if (out != null) {
            this.exList.add(Long.valueOf(out.func_145782_y()));
        }
        return out;
    }

    private BlockPos getClosestBlockOfType(World world, BlockPos source, double range, IBlockState state, Random rand) {
        range = Math.max(2.0, Math.min(8.0, range / 2.0));
        double md = Double.MAX_VALUE;
        BlockPos mp = null;
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.func_177975_b((BlockPos)source.func_177963_a(-range, -range, -range), (BlockPos)source.func_177963_a(range, range, range))) {
            Double d;
            if (this.exList.contains(blockpos$mutableblockpos1.func_177986_g()) || !((d = Double.valueOf(blockpos$mutableblockpos1.func_177951_i((Vec3i)source) + (double)rand.nextInt((int)range))) <= range * range) || !(d <= md)) continue;
            IBlockState iblockstate1 = world.func_180495_p((BlockPos)blockpos$mutableblockpos1);
            if (state.func_177230_c() != iblockstate1.func_177230_c()) continue;
            md = d;
            mp = blockpos$mutableblockpos1.func_185334_h();
        }
        if (mp != null) {
            this.exList.add(mp.func_177986_g());
            return mp;
        }
        return null;
    }

    private void shootLightning(Entity caster, double xx, double yy, double zz, int color, float width, boolean mainhand) {
        Color c = new Color(color);
        double px = caster.field_70165_t;
        double py = caster.func_174813_aQ().field_72338_b + (double)(caster.field_70131_O / 2.0f) + 0.25;
        double pz = caster.field_70161_v;
        px += (double)(-MathHelper.func_76134_b((float)(caster.field_70177_z / 180.0f * 3.141593f)) * (Minecraft.func_71410_x().field_71474_y.field_74320_O > 0 ? 0.3f : 1.0f) * (float)(mainhand ? 1 : -1));
        py += -0.25;
        pz += (double)(-MathHelper.func_76126_a((float)(caster.field_70177_z / 180.0f * 3.141593f)) * 0.3f * (float)(mainhand ? 1 : -1));
        Vec3d vec3d = caster.func_70676_i(1.0f);
        FXDispatcher.INSTANCE.arcBolt(px += vec3d.field_72450_a * 0.5, py += vec3d.field_72448_b * 0.5, pz += vec3d.field_72449_c * 0.5, xx, yy, zz, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, width);
    }
}

