/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.common.entities.projectile.EntityGenericProjectile;
import thaumcraft.common.items.casters.ICaster;
import thaumcraft.common.items.casters.foci.FModScatter;

public class FMediumProjectile
implements IFocusPartMedium {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/projectile.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MEDIUM;
    }

    @Override
    public String getKey() {
        return "thaumcraft.PROJECTILE";
    }

    @Override
    public String getResearch() {
        return "FOCUSPROJECTILE@2";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.FLIGHT;
    }

    @Override
    public int getGemColor() {
        return 5800698;
    }

    @Override
    public int getIconColor() {
        return 16765440;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public boolean onMediumTrigger(World world, Entity caster, ItemStack casterStack, FocusCore focus, float charge) {
        boolean mainhand = true;
        if (caster instanceof EntityPlayer) {
            if (((EntityPlayer)caster).func_184614_ca() != null && ((EntityPlayer)caster).func_184614_ca().func_77973_b() instanceof ICaster) {
                mainhand = true;
            } else if (((EntityPlayer)caster).func_184592_cb() != null && ((EntityPlayer)caster).func_184592_cb().func_77973_b() instanceof ICaster) {
                mainhand = false;
            }
        }
        float speed = 1.5f;
        float spread = 2.0f;
        int projectiles = 1;
        if (focus.mediumModifiers != null) {
            for (IFocusPart mod : focus.mediumModifiers) {
                if (!(mod instanceof FModScatter)) continue;
                spread *= 6.0f;
                projectiles = 5;
            }
        }
        if (!world.field_72995_K && caster instanceof EntityLivingBase) {
            for (int a = 0; a < projectiles; ++a) {
                EntityGenericProjectile projectile = new EntityGenericProjectile(world, (EntityLivingBase)caster, casterStack, speed, spread, focus, charge, mainhand);
                projectile.func_184538_a(caster, caster.field_70125_A, caster.field_70177_z + (mainhand ? -0.5f : 0.5f), -2.0f, speed, spread);
                world.func_72838_d((Entity)projectile);
            }
        }
        return true;
    }
}

