/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;

public class FMediumTouch
implements IFocusPartMedium {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/touch.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MEDIUM;
    }

    @Override
    public IFocusPartMedium.EnumFocusCastMethod getCastMethod() {
        return IFocusPartMedium.EnumFocusCastMethod.INSTANT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.TOUCH";
    }

    @Override
    public String getResearch() {
        return "BASEAUROMANCY@3";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.EARTH;
    }

    @Override
    public int getGemColor() {
        return 5811450;
    }

    @Override
    public int getIconColor() {
        return 12706559;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getCostMultiplier() {
        return 0.5f;
    }

    @Override
    public float getEffectMultiplier() {
        return 1.1f;
    }

    @Override
    public boolean onMediumTrigger(World world, Entity caster, ItemStack casterStack, FocusCore focus, float charge) {
        Entity pointedEntity = EntityUtils.getPointedEntity(world, caster, 0.0, 2.0, 0.1f);
        RayTraceResult mop = pointedEntity != null ? new RayTraceResult(pointedEntity) : Utils.rayTrace(world, caster, true);
        if (mop != null) {
            boolean b = false;
            boolean unhurt = mop.field_72308_g == null || mop.field_72308_g.field_70172_ad <= 0;
            int resetHurt = 0;
            for (FocusCore.FocusEffect effect : focus.effects) {
                if (mop.field_72308_g != null && unhurt && mop.field_72308_g.field_70172_ad > 0) {
                    resetHurt = mop.field_72308_g.field_70172_ad;
                    mop.field_72308_g.field_70172_ad = 0;
                }
                if (!effect.effect.onEffectTrigger(world, mop, caster, casterStack, caster, effect, charge)) continue;
                b = true;
            }
            if (!world.field_72995_K) {
                CasterManager.sendImpact(world, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, focus);
            }
            if (resetHurt > 0) {
                mop.field_72308_g.field_70172_ad = resetHurt;
            }
            return b;
        }
        return false;
    }
}

