/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;

public class FModSilkTouch
implements IFocusPart {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/silk.png");

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MODIFIER;
    }

    @Override
    public String getKey() {
        return "thaumcraft.SILKTOUCH";
    }

    @Override
    public String getResearch() {
        return "FOCUSBREAK@3";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.EXCHANGE;
    }

    @Override
    public int getGemColor() {
        return 9046120;
    }

    @Override
    public int getIconColor() {
        return 16099809;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getCostMultiplier() {
        return 1.5f;
    }

    @Override
    public boolean hasCustomParticle() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawCustomParticle(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, motionX, motionY, motionZ);
        fb.func_187114_a(10 + world.field_73012_v.nextInt(5));
        fb.setParticles(16, 5, 1);
        fb.setSlowDown(0.85);
        fb.setScale((float)((double)0.6f + world.field_73012_v.nextGaussian() * (double)0.2f));
        fb.setGravity(0.2f);
        fb.func_70538_b(0.96f, 0.66f, 0.98f);
        fb.setRotationSpeed(world.field_73012_v.nextFloat() * 3.0f, (float)world.field_73012_v.nextGaussian());
        ParticleEngine.INSTANCE.addEffectWithDelay(world, fb, world.field_73012_v.nextInt(10));
    }
}

