/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.common.lib.utils.Utils;

public class ThaumcraftCraftingManager {
    static final int ASPECTCAP = 500;

    public static ShapedRecipes createFakeRecipe(ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        int var9;
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (par2ArrayOfObj[var4] instanceof String[]) {
            String[] var7;
            String[] var8 = var7 = (String[])par2ArrayOfObj[var4++];
            var9 = var7.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                String var11 = var8[var10];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        } else {
            while (par2ArrayOfObj[var4] instanceof String) {
                String var13 = (String)par2ArrayOfObj[var4++];
                ++var6;
                var5 = var13.length();
                var3 = var3 + var13;
            }
        }
        HashMap<Character, ItemStack> var14 = new HashMap<Character, ItemStack>();
        while (var4 < par2ArrayOfObj.length) {
            Character var16 = (Character)par2ArrayOfObj[var4];
            ItemStack var17 = null;
            if (par2ArrayOfObj[var4 + 1] instanceof Item) {
                var17 = new ItemStack((Item)par2ArrayOfObj[var4 + 1]);
            } else if (par2ArrayOfObj[var4 + 1] instanceof Block) {
                var17 = new ItemStack((Block)par2ArrayOfObj[var4 + 1]);
            } else if (par2ArrayOfObj[var4 + 1] instanceof ItemStack) {
                var17 = (ItemStack)par2ArrayOfObj[var4 + 1];
            }
            var14.put(var16, var17);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[var5 * var6];
        for (var9 = 0; var9 < var5 * var6; ++var9) {
            char var18 = var3.charAt(var9);
            var15[var9] = var14.containsKey(Character.valueOf(var18)) ? ((ItemStack)var14.get(Character.valueOf(var18))).func_77946_l() : null;
        }
        return new ShapedRecipes(var5, var6, var15, par1ItemStack);
    }

    public static CrucibleRecipe findMatchingCrucibleRecipe(EntityPlayer player, AspectList aspects, ItemStack lastDrop) {
        int highest = 0;
        CrucibleRecipe out = null;
        for (Object re : ThaumcraftApi.getCraftingRecipes().values()) {
            if (re == null || !(re instanceof CrucibleRecipe[])) continue;
            for (CrucibleRecipe recipe : (CrucibleRecipe[])re) {
                int result;
                ItemStack temp = lastDrop.func_77946_l();
                temp.field_77994_a = 1;
                if (player == null || !ThaumcraftCapabilities.knowsResearchStrict(player, recipe.research) || !recipe.matches(aspects, temp) || (result = recipe.aspects.visSize()) <= highest) continue;
                highest = result;
                out = recipe;
            }
        }
        return out;
    }

    public static IArcaneRecipe findMatchingArcaneRecipe(InventoryCrafting awb, EntityPlayer player) {
        int var2 = 0;
        ItemStack var3 = null;
        ItemStack var4 = null;
        for (int var5 = 0; var5 < 15; ++var5) {
            ItemStack var6 = awb.func_70301_a(var5);
            if (var6 == null) continue;
            if (var2 == 0) {
                var3 = var6;
            }
            if (var2 == 1) {
                var4 = var6;
            }
            ++var2;
        }
        for (Object recipes : ThaumcraftApi.getCraftingRecipes().values()) {
            if (recipes == null || !(recipes instanceof IArcaneRecipe[])) continue;
            for (IArcaneRecipe recipe : (IArcaneRecipe[])recipes) {
                if (!recipe.matches(awb, player.field_70170_p, player)) continue;
                return recipe;
            }
        }
        return null;
    }

    public static ItemStack findMatchingArcaneRecipeResult(InventoryCrafting awb, EntityPlayer player) {
        IArcaneRecipe var13 = ThaumcraftCraftingManager.findMatchingArcaneRecipe(awb, player);
        return var13 == null ? null : var13.func_77572_b(awb);
    }

    public static ItemStack[] findMatchingArcaneRecipeCrystals(InventoryCrafting awb, EntityPlayer player) {
        IArcaneRecipe var13 = ThaumcraftCraftingManager.findMatchingArcaneRecipe(awb, player);
        return var13 == null ? null : var13.getCrystals();
    }

    public static int findMatchingArcaneRecipeVis(InventoryCrafting awb, EntityPlayer player) {
        IArcaneRecipe var13 = ThaumcraftCraftingManager.findMatchingArcaneRecipe(awb, player);
        return var13 == null ? 0 : (var13.getVis() > 0 ? var13.getVis() : var13.getVis(awb));
    }

    public static InfusionRecipe findMatchingInfusionRecipe(ArrayList<ItemStack> items, ItemStack input, EntityPlayer player) {
        for (Object recipes : ThaumcraftApi.getCraftingRecipes().values()) {
            if (recipes == null || !(recipes instanceof InfusionRecipe[])) continue;
            for (InfusionRecipe recipe : (InfusionRecipe[])recipes) {
                if (!recipe.matches(items, input, player.field_70170_p, player)) continue;
                return recipe;
            }
        }
        return null;
    }

    public static AspectList getObjectTags(ItemStack itemstack) {
        return ThaumcraftCraftingManager.getObjectTags(itemstack, null);
    }

    public static AspectList getObjectTags(ItemStack itemstack, ArrayList<String> history) {
        String ss = null;
        ItemStack sc = null;
        try {
            sc = itemstack.func_77946_l();
            sc.field_77994_a = 1;
            ss = sc.serializeNBT().toString();
        }
        catch (Exception e) {
            return null;
        }
        if (ss == null) {
            return null;
        }
        AspectList tmp = CommonInternals.objectTags.get(ss);
        if (tmp == null) {
            try {
                sc.func_77964_b(Short.MAX_VALUE);
                ss = sc.serializeNBT().toString();
                tmp = CommonInternals.objectTags.get(ss);
                if (tmp == null) {
                    if (itemstack.func_77952_i() == Short.MAX_VALUE && tmp == null) {
                        int index = 0;
                        do {
                            sc.func_77964_b(index);
                            ss = sc.serializeNBT().toString();
                            tmp = CommonInternals.objectTags.get(ss);
                        } while (++index < 16 && tmp == null);
                    }
                    if (tmp == null) {
                        tmp = ThaumcraftCraftingManager.generateTags(itemstack, history);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ThaumcraftCraftingManager.capAspects(ThaumcraftCraftingManager.getBonusTags(itemstack, tmp), 500);
    }

    private static AspectList capAspects(AspectList sourcetags, int amount) {
        if (sourcetags == null) {
            return sourcetags;
        }
        AspectList out = new AspectList();
        for (Aspect aspect : sourcetags.getAspects()) {
            if (aspect == null) continue;
            out.merge(aspect, Math.min(amount, sourcetags.getAmount(aspect)));
        }
        return out;
    }

    private static AspectList getBonusTags(ItemStack itemstack, AspectList sourcetags) {
        AspectList tmp = new AspectList();
        Item item = itemstack.func_77973_b();
        if (item != null && item instanceof IEssentiaContainerItem && !((IEssentiaContainerItem)item).ignoreContainedAspects()) {
            if (sourcetags != null) {
                sourcetags.aspects.clear();
            }
            if ((tmp = ((IEssentiaContainerItem)item).getAspects(itemstack)) != null && tmp.size() > 0) {
                for (Aspect tag : tmp.copy().getAspects()) {
                    if (tmp.getAmount(tag) > 0) continue;
                    tmp.remove(tag);
                }
            }
        }
        if (tmp == null) {
            tmp = new AspectList();
        }
        if (sourcetags != null) {
            for (Aspect tag : sourcetags.getAspects()) {
                if (tag == null) continue;
                tmp.add(tag, sourcetags.getAmount(tag));
            }
        }
        if (item != null && (tmp != null || item == Items.field_151068_bn)) {
            if (item instanceof ItemArmor) {
                tmp.merge(Aspect.PROTECT, ((ItemArmor)item).field_77879_b * 4);
            } else if (item instanceof ItemSword && ((ItemSword)item).func_150931_i() + 1.0f > 0.0f) {
                tmp.merge(Aspect.AVERSION, (int)(((ItemSword)item).func_150931_i() + 1.0f) * 4);
            } else if (item instanceof ItemBow) {
                tmp.merge(Aspect.AVERSION, 10).merge(Aspect.FLIGHT, 5);
            } else if (item instanceof ItemTool) {
                String mat = ((ItemTool)item).func_77861_e();
                for (Item.ToolMaterial tm : Item.ToolMaterial.values()) {
                    if (!tm.toString().equals(mat)) continue;
                    tmp.merge(Aspect.TOOL, (tm.func_77996_d() + 1) * 4);
                }
            } else if (item instanceof ItemShears || item instanceof ItemHoe) {
                if (item.func_77612_l() <= Item.ToolMaterial.WOOD.func_77997_a()) {
                    tmp.merge(Aspect.TOOL, 4);
                } else if (item.func_77612_l() <= Item.ToolMaterial.STONE.func_77997_a() || item.func_77612_l() <= Item.ToolMaterial.GOLD.func_77997_a()) {
                    tmp.merge(Aspect.TOOL, 8);
                } else if (item.func_77612_l() <= Item.ToolMaterial.IRON.func_77997_a()) {
                    tmp.merge(Aspect.TOOL, 12);
                } else {
                    tmp.merge(Aspect.TOOL, 16);
                }
            }
            Object[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
            int[] ores = OreDictionary.getOreIDs((ItemStack)itemstack);
            if (ores != null && ores.length > 0) {
                Arrays.sort(dyes);
                for (int od : ores) {
                    String s = OreDictionary.getOreName((int)od);
                    if (s == null || Arrays.binarySearch(dyes, s) < 0) continue;
                    tmp.merge(Aspect.SENSES, 5);
                    break;
                }
            }
            NBTTagList ench = itemstack.func_77986_q();
            if (item instanceof ItemEnchantedBook) {
                ench = ((ItemEnchantedBook)item).func_92110_g(itemstack);
            }
            if (ench != null) {
                int var5 = 0;
                for (int var3 = 0; var3 < ench.func_74745_c(); ++var3) {
                    short eid = ench.func_150305_b(var3).func_74765_d("id");
                    short lvl = (short)(ench.func_150305_b(var3).func_74765_d("lvl") * 3);
                    Enchantment e = Enchantment.func_185262_c((int)eid);
                    if (e != null) {
                        if (e == Enchantments.field_185299_g) {
                            tmp.merge(Aspect.WATER, lvl);
                        } else if (e == Enchantments.field_180312_n) {
                            tmp.merge(Aspect.BEAST, lvl / 2).merge(Aspect.AVERSION, lvl / 2);
                        } else if (e == Enchantments.field_185297_d) {
                            tmp.merge(Aspect.PROTECT, lvl / 2).merge(Aspect.ENTROPY, lvl / 2);
                        } else if (e == Enchantments.field_185305_q) {
                            tmp.merge(Aspect.TOOL, lvl);
                        } else if (e == Enchantments.field_180309_e) {
                            tmp.merge(Aspect.FLIGHT, lvl);
                        } else if (e == Enchantments.field_77334_n) {
                            tmp.merge(Aspect.FIRE, lvl / 2).merge(Aspect.AVERSION, lvl / 2);
                        } else if (e == Enchantments.field_77329_d) {
                            tmp.merge(Aspect.PROTECT, lvl / 2).merge(Aspect.FIRE, lvl / 2);
                        } else if (e == Enchantments.field_185311_w) {
                            tmp.merge(Aspect.FIRE, lvl);
                        } else if (e == Enchantments.field_185308_t) {
                            tmp.merge(Aspect.DESIRE, lvl);
                        } else if (e == Enchantments.field_185312_x) {
                            tmp.merge(Aspect.CRAFT, lvl);
                        } else if (e == Enchantments.field_180313_o) {
                            tmp.merge(Aspect.AIR, lvl);
                        } else if (e == Enchantments.field_185304_p) {
                            tmp.merge(Aspect.DESIRE, lvl);
                        } else if (e == Enchantments.field_185309_u) {
                            tmp.merge(Aspect.AVERSION, lvl);
                        } else if (e == Enchantments.field_180308_g) {
                            tmp.merge(Aspect.PROTECT, lvl);
                        } else if (e == Enchantments.field_180310_c) {
                            tmp.merge(Aspect.PROTECT, lvl);
                        } else if (e == Enchantments.field_185310_v) {
                            tmp.merge(Aspect.AIR, lvl);
                        } else if (e == Enchantments.field_185298_f) {
                            tmp.merge(Aspect.AIR, lvl);
                        } else if (e == Enchantments.field_185302_k) {
                            tmp.merge(Aspect.AVERSION, lvl);
                        } else if (e == Enchantments.field_185306_r) {
                            tmp.merge(Aspect.EXCHANGE, lvl);
                        } else if (e == Enchantments.field_92091_k) {
                            tmp.merge(Aspect.AVERSION, lvl);
                        } else if (e == Enchantments.field_185303_l) {
                            tmp.merge(Aspect.UNDEAD, lvl / 2).merge(Aspect.AVERSION, lvl / 2);
                        } else if (e == Enchantments.field_185307_s) {
                            tmp.merge(Aspect.EARTH, lvl);
                        } else if (e == Enchantments.field_185300_i) {
                            tmp.merge(Aspect.WATER, lvl);
                        } else if (e == Enchantments.field_151370_z) {
                            tmp.merge(Aspect.DESIRE, lvl);
                        } else if (e == Enchantments.field_151369_A) {
                            tmp.merge(Aspect.BEAST, lvl);
                        } else if (e == Enchantments.field_185301_j) {
                            tmp.merge(Aspect.COLD, lvl);
                        } else if (e == Enchantments.field_185296_A) {
                            tmp.merge(Aspect.CRAFT, lvl);
                        }
                        if (e.func_77324_c() == Enchantment.Rarity.UNCOMMON) {
                            var5 += 2;
                        }
                        if (e.func_77324_c() == Enchantment.Rarity.RARE) {
                            var5 += 4;
                        }
                        if (e.func_77324_c() == Enchantment.Rarity.VERY_RARE) {
                            var5 += 6;
                        }
                    }
                    var5 += lvl;
                }
                if (var5 > 0) {
                    tmp.merge(Aspect.MAGIC, var5);
                }
            }
        }
        return AspectHelper.cullTags(tmp);
    }

    public static AspectList generateTags(ItemStack is) {
        AspectList temp = ThaumcraftCraftingManager.generateTags(is, new ArrayList<String>());
        return temp;
    }

    public static AspectList generateTags(ItemStack is, ArrayList<String> history) {
        if (history == null) {
            history = new ArrayList();
        }
        ItemStack stack = is.func_77946_l();
        stack.field_77994_a = 1;
        try {
            if (stack.func_77973_b().func_77645_m() || !stack.func_77973_b().func_77614_k()) {
                stack.func_77964_b(Short.MAX_VALUE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ThaumcraftApi.exists(stack)) {
            return ThaumcraftCraftingManager.getObjectTags(stack, history);
        }
        String ss = stack.serializeNBT().toString();
        if (history.contains(ss)) {
            return null;
        }
        history.add(ss);
        if (history.size() < 100) {
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
        } else {
            return null;
        }
        AspectList ret = ThaumcraftCraftingManager.generateTagsFromRecipes(stack, history);
        ret = ThaumcraftCraftingManager.capAspects(ret, 500);
        ThaumcraftApi.registerObjectTag(is, ret);
        return ret;
    }

    private static AspectList generateTagsFromCrucibleRecipes(ItemStack stack, ArrayList<String> history) {
        CrucibleRecipe cr = ThaumcraftApi.getCrucibleRecipe(stack);
        if (cr != null && !CommonInternals.craftingRecipesCatalogFake.contains(cr.getRecipeName())) {
            AspectList ot = cr.aspects.copy();
            int ss = cr.getRecipeOutput().field_77994_a;
            ItemStack cat = null;
            if (cr.catalyst instanceof ItemStack) {
                cat = (ItemStack)cr.catalyst;
            } else if (cr.catalyst instanceof List && ((List)cr.catalyst).size() > 0) {
                cat = (ItemStack)((List)cr.catalyst).get(0);
            }
            if (cat == null) {
                return null;
            }
            AspectList ot2 = ThaumcraftCraftingManager.getObjectTags(cat, history);
            AspectList out = new AspectList();
            if (ot2 != null && ot2.size() > 0) {
                for (Aspect tt : ot2.getAspects()) {
                    out.add(tt, ot2.getAmount(tt));
                }
            }
            for (Aspect tt : ot.getAspects()) {
                int amt = (int)(Math.sqrt(ot.getAmount(tt)) / (double)ss);
                out.add(tt, amt);
            }
            for (Aspect as : out.getAspects()) {
                if (out.getAmount(as) > 0) continue;
                out.remove(as);
            }
            return out;
        }
        return null;
    }

    private static AspectList generateTagsFromArcaneRecipes(ItemStack stack, ArrayList<String> history) {
        AspectList ret = null;
        boolean value = false;
        HashMap<String, Object> recipeList = ThaumcraftApi.getCraftingRecipes();
        block2: for (String q : recipeList.keySet()) {
            if (CommonInternals.craftingRecipesCatalogFake.contains(q) || !(recipeList.get(q) instanceof IArcaneRecipe[])) continue;
            for (IArcaneRecipe recipe : (IArcaneRecipe[])recipeList.get(q)) {
                int idS;
                if (recipe.func_77571_b() == null || recipe.func_77571_b().func_77973_b() == null) continue;
                int idR = recipe.func_77571_b().func_77952_i() == Short.MAX_VALUE ? 0 : recipe.func_77571_b().func_77952_i();
                int n = idS = stack.func_77952_i() < 0 ? 0 : stack.func_77952_i();
                if (recipe.func_77571_b().func_77973_b() != stack.func_77973_b() || idR != idS) continue;
                ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
                AspectList ph = new AspectList();
                boolean cval = false;
                try {
                    if (recipe instanceof ShapedArcaneRecipe) {
                        int width = ((ShapedArcaneRecipe)recipe).width;
                        int height = ((ShapedArcaneRecipe)recipe).height;
                        Object[] items = ((ShapedArcaneRecipe)recipe).getInput();
                        for (int i = 0; i < width && i < 3; ++i) {
                            block5: for (int j = 0; j < height && j < 3; ++j) {
                                if (items[i + j * width] == null) continue;
                                if (items[i + j * width] instanceof List) {
                                    for (ItemStack it : (List)items[i + j * width]) {
                                        if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                                        AspectList obj = ThaumcraftCraftingManager.getObjectTags(it, history);
                                        if (obj == null || obj.size() <= 0) continue;
                                        ItemStack is = it.func_77946_l();
                                        is.field_77994_a = 1;
                                        ingredients.add(is);
                                        continue block5;
                                    }
                                    continue;
                                }
                                ItemStack it = (ItemStack)items[i + j * width];
                                if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                                ItemStack is = it.func_77946_l();
                                is.field_77994_a = 1;
                                ingredients.add(is);
                            }
                        }
                    } else if (recipe instanceof ShapelessArcaneRecipe) {
                        ArrayList items = ((ShapelessArcaneRecipe)recipe).getInput();
                        block7: for (int i = 0; i < items.size() && i < 9; ++i) {
                            if (items.get(i) == null) continue;
                            if (items.get(i) instanceof List) {
                                for (ItemStack it : (List)items.get(i)) {
                                    if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                                    AspectList obj = ThaumcraftCraftingManager.getObjectTags(it, history);
                                    if (obj == null || obj.size() <= 0) continue;
                                    ItemStack is = it.func_77946_l();
                                    is.field_77994_a = 1;
                                    ingredients.add(is);
                                    continue block7;
                                }
                                continue;
                            }
                            ItemStack it = (ItemStack)items.get(i);
                            if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                            ItemStack is = it.func_77946_l();
                            is.field_77994_a = 1;
                            ingredients.add(is);
                        }
                    }
                    ph = ThaumcraftCraftingManager.getAspectsFromIngredients(ingredients, recipe.func_77571_b(), history);
                    if (recipe.getVis() > 0) {
                        ph.add(Aspect.MAGIC, (int)(Math.sqrt(1 + recipe.getVis() / 2) / (double)recipe.func_77571_b().field_77994_a));
                    }
                    for (Aspect as : ph.copy().getAspects()) {
                        if (ph.getAmount(as) > 0) continue;
                        ph.remove(as);
                    }
                    if (cval < value) continue;
                    ret = ph;
                    value = cval;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private static ItemStack stackFromRecipeObject(Object obj) {
        ItemStack out = null;
        if (obj instanceof ItemStack) {
            return (ItemStack)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            int l = Integer.MAX_VALUE;
            for (ItemStack stack : OreDictionary.getOres((String)s, (boolean)false)) {
                AspectList al;
                int q;
                if (out == null) {
                    out = stack.func_77946_l();
                }
                if ((q = (al = AspectHelper.getObjectAspects(stack)).visSize()) <= 0 || q >= l) continue;
                l = q;
                out = stack.func_77946_l();
            }
        }
        return out;
    }

    private static AspectList generateTagsFromInfusionRecipes(ItemStack stack, ArrayList<String> history) {
        InfusionRecipe cr = ThaumcraftApi.getInfusionRecipe(stack);
        if (cr != null && !CommonInternals.craftingRecipesCatalogFake.contains(cr.getRecipeName())) {
            AspectList ot = cr.getAspects().copy();
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            ItemStack is = ThaumcraftCraftingManager.stackFromRecipeObject(cr.getRecipeInput());
            is.field_77994_a = 1;
            ingredients.add(is);
            for (Object cat : cr.getComponents()) {
                ItemStack is2 = ThaumcraftCraftingManager.stackFromRecipeObject(cat);
                is2.field_77994_a = 1;
                ingredients.add(is2);
            }
            AspectList out = new AspectList();
            AspectList ot2 = ThaumcraftCraftingManager.getAspectsFromIngredients(ingredients, (ItemStack)cr.getRecipeOutput(), history);
            for (Aspect tt : ot2.getAspects()) {
                out.add(tt, ot2.getAmount(tt));
            }
            for (Aspect tt : ot.getAspects()) {
                int amt = (int)(Math.sqrt(ot.getAmount(tt)) / (double)((ItemStack)cr.getRecipeOutput()).field_77994_a);
                out.add(tt, amt);
            }
            for (Aspect as : out.getAspects()) {
                if (out.getAmount(as) > 0) continue;
                out.remove(as);
            }
            return out;
        }
        return null;
    }

    private static AspectList generateTagsFromCraftingRecipes(ItemStack stack, ArrayList<String> history) {
        AspectList ret = null;
        int value = Integer.MAX_VALUE;
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        block2: for (int q = 0; q < recipeList.size(); ++q) {
            int idS;
            IRecipe recipe;
            if (CommonInternals.craftingRecipesCatalogFake.contains(recipeList.get(q)) || (recipe = (IRecipe)recipeList.get(q)) == null || recipe.func_77571_b() == null || Item.func_150891_b((Item)recipe.func_77571_b().func_77973_b()) <= 0 || recipe.func_77571_b().func_77973_b() == null) continue;
            int idR = recipe.func_77571_b().func_77952_i() == Short.MAX_VALUE ? 0 : recipe.func_77571_b().func_77952_i();
            int n = idS = stack.func_77952_i() == Short.MAX_VALUE ? 0 : stack.func_77952_i();
            if (recipe.func_77571_b().func_77973_b() != stack.func_77973_b() || idR != idS) continue;
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            AspectList ph = new AspectList();
            boolean cval = false;
            try {
                ItemStack is;
                if (recipeList.get(q) instanceof ShapedRecipes) {
                    int width = ((ShapedRecipes)recipeList.get((int)q)).field_77576_b;
                    int height = ((ShapedRecipes)recipeList.get((int)q)).field_77577_c;
                    ItemStack[] items = ((ShapedRecipes)recipeList.get((int)q)).field_77574_d;
                    for (int i = 0; i < width && i < 3; ++i) {
                        for (int j = 0; j < height && j < 3; ++j) {
                            if (items[i + j * width] == null) continue;
                            if (Utils.isEETransmutionItem(items[i + j * width].func_77973_b())) continue block2;
                            is = items[i + j * width].func_77946_l();
                            is.field_77994_a = 1;
                            ingredients.add(is);
                        }
                    }
                } else if (recipeList.get(q) instanceof ShapelessRecipes) {
                    List items = ((ShapelessRecipes)recipeList.get((int)q)).field_77579_b;
                    for (int i = 0; i < items.size() && i < 9; ++i) {
                        if (items.get(i) == null) continue;
                        if (Utils.isEETransmutionItem(((ItemStack)items.get(i)).func_77973_b())) continue block2;
                        ItemStack is2 = ((ItemStack)items.get(i)).func_77946_l();
                        is2.field_77994_a = 1;
                        ingredients.add(is2);
                    }
                } else if (recipeList.get(q) instanceof ShapedOreRecipe) {
                    int size = ((ShapedOreRecipe)recipeList.get(q)).func_77570_a();
                    Object[] items = ((ShapedOreRecipe)recipeList.get(q)).getInput();
                    block6: for (int i = 0; i < size && i < 9; ++i) {
                        if (items[i] == null) continue;
                        if (items[i] instanceof List) {
                            for (ItemStack it : (List)items[i]) {
                                if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                                AspectList obj = ThaumcraftCraftingManager.getObjectTags(it, history);
                                if (obj == null || obj.size() <= 0) continue;
                                ItemStack is3 = it.func_77946_l();
                                is3.field_77994_a = 1;
                                ingredients.add(is3);
                                continue block6;
                            }
                            continue;
                        }
                        ItemStack it = (ItemStack)items[i];
                        if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                        ItemStack is4 = it.func_77946_l();
                        is4.field_77994_a = 1;
                        ingredients.add(is4);
                    }
                } else if (recipeList.get(q) instanceof ShapelessOreRecipe) {
                    ArrayList items = ((ShapelessOreRecipe)recipeList.get(q)).getInput();
                    block8: for (int i = 0; i < items.size() && i < 9; ++i) {
                        if (items.get(i) == null) continue;
                        if (items.get(i) instanceof List) {
                            for (ItemStack it : (List)items.get(i)) {
                                if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                                AspectList obj = ThaumcraftCraftingManager.getObjectTags(it, history);
                                if (obj == null || obj.size() <= 0) continue;
                                is = it.func_77946_l();
                                is.field_77994_a = 1;
                                ingredients.add(is);
                                continue block8;
                            }
                            continue;
                        }
                        ItemStack it = (ItemStack)items.get(i);
                        if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                        ItemStack is5 = it.func_77946_l();
                        is5.field_77994_a = 1;
                        ingredients.add(is5);
                    }
                }
                ph = ThaumcraftCraftingManager.getAspectsFromIngredients(ingredients, recipe.func_77571_b(), history);
                for (Aspect as : ph.copy().getAspects()) {
                    if (ph.getAmount(as) > 0) continue;
                    ph.remove(as);
                }
                if (ph.visSize() >= value || ph.visSize() <= 0) continue;
                ret = ph;
                value = ph.visSize();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private static AspectList getAspectsFromIngredients(ArrayList<ItemStack> ingredients, ItemStack recipeOut, ArrayList<String> history) {
        AspectList out = new AspectList();
        AspectList mid = new AspectList();
        for (ItemStack is : ingredients) {
            AspectList obj = ThaumcraftCraftingManager.getObjectTags(is, history);
            if (is.func_77973_b().func_77668_q() != null) {
                if (is.func_77973_b().func_77668_q() == is.func_77973_b()) continue;
                AspectList objC = ThaumcraftCraftingManager.getObjectTags(new ItemStack(is.func_77973_b(), 1, Short.MAX_VALUE), history);
                Aspect[] aspectArray = objC.getAspects();
                int n = aspectArray.length;
                for (int i = 0; i < n; ++i) {
                    Aspect as = aspectArray[i];
                    out.reduce(as, objC.getAmount(as));
                }
            }
            if (obj == null) continue;
            for (Aspect as : obj.getAspects()) {
                if (as == null) continue;
                mid.add(as, obj.getAmount(as));
            }
        }
        for (Aspect as : mid.getAspects()) {
            if (as == null) continue;
            float v = (float)mid.getAmount(as) * 0.75f / (float)recipeOut.field_77994_a;
            if (v < 1.0f && (double)v > 0.75) {
                v = 1.0f;
            }
            out.add(as, (int)v);
        }
        for (Aspect as : out.getAspects()) {
            if (out.getAmount(as) > 0) continue;
            out.remove(as);
        }
        return out;
    }

    private static AspectList generateTagsFromRecipes(ItemStack stack, ArrayList<String> history) {
        AspectList ret = null;
        boolean value = false;
        ret = ThaumcraftCraftingManager.generateTagsFromCrucibleRecipes(stack, history);
        if (ret != null) {
            return ret;
        }
        ret = ThaumcraftCraftingManager.generateTagsFromArcaneRecipes(stack, history);
        if (ret != null) {
            return ret;
        }
        ret = ThaumcraftCraftingManager.generateTagsFromInfusionRecipes(stack, history);
        if (ret != null) {
            return ret;
        }
        ret = ThaumcraftCraftingManager.generateTagsFromCraftingRecipes(stack, history);
        return ret;
    }
}

