/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.enchantment;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public enum EnumInfusionEnchantment {
    COLLECTOR((Set<String>)ImmutableSet.of((Object)"axe", (Object)"pickaxe", (Object)"shovel", (Object)"weapon"), 1, "INFUSIONENCHANTMENT"),
    DESTRUCTIVE((Set<String>)ImmutableSet.of((Object)"axe", (Object)"pickaxe", (Object)"shovel"), 1, "INFUSIONENCHANTMENT"),
    BURROWING((Set<String>)ImmutableSet.of((Object)"axe", (Object)"pickaxe"), 1, "INFUSIONENCHANTMENT"),
    SOUNDING((Set<String>)ImmutableSet.of((Object)"pickaxe"), 4, "INFUSIONENCHANTMENT"),
    REFINING((Set<String>)ImmutableSet.of((Object)"pickaxe"), 4, "INFUSIONENCHANTMENT"),
    ARCING((Set<String>)ImmutableSet.of((Object)"weapon"), 4, "INFUSIONENCHANTMENT"),
    ESSENCE((Set<String>)ImmutableSet.of((Object)"weapon"), 5, "INFUSIONENCHANTMENT"),
    VISBATTERY((Set<String>)ImmutableSet.of((Object)"chargable"), 3, "?"),
    VISCHARGE((Set<String>)ImmutableSet.of((Object)"chargable"), 1, "?"),
    SWIFT((Set<String>)ImmutableSet.of((Object)"boots"), 4, "IEARMOR"),
    AGILE((Set<String>)ImmutableSet.of((Object)"legs"), 1, "IEARMOR"),
    INFESTED((Set<String>)ImmutableSet.of((Object)"chest"), 1, "IETAINT");

    public Set<String> toolClasses;
    public int maxLevel;
    public String research;

    private EnumInfusionEnchantment(Set<String> toolClasses, int ml, String research) {
        this.toolClasses = toolClasses;
        this.maxLevel = ml;
        this.research = research;
    }

    public static NBTTagList getInfusionEnchantmentTagList(ItemStack stack) {
        return stack == null || stack.func_77978_p() == null ? null : stack.func_77978_p().func_150295_c("infench", 10);
    }

    public static List<EnumInfusionEnchantment> getInfusionEnchantments(ItemStack stack) {
        NBTTagList nbttaglist = EnumInfusionEnchantment.getInfusionEnchantmentTagList(stack);
        ArrayList<EnumInfusionEnchantment> list = new ArrayList<EnumInfusionEnchantment>();
        if (nbttaglist != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                if (k < 0 || k >= EnumInfusionEnchantment.values().length) continue;
                list.add(EnumInfusionEnchantment.values()[k]);
            }
        }
        return list;
    }

    public static int getInfusionEnchantmentLevel(ItemStack stack, EnumInfusionEnchantment enchantment) {
        NBTTagList nbttaglist = EnumInfusionEnchantment.getInfusionEnchantmentTagList(stack);
        ArrayList list = new ArrayList();
        if (nbttaglist != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                if (k < 0 || k >= EnumInfusionEnchantment.values().length || EnumInfusionEnchantment.values()[k] != enchantment) continue;
                return l;
            }
        }
        return 0;
    }

    public static void addInfusionEnchantment(ItemStack stack, EnumInfusionEnchantment ie, int level) {
        if (stack == null || level > ie.maxLevel) {
            return;
        }
        NBTTagList nbttaglist = EnumInfusionEnchantment.getInfusionEnchantmentTagList(stack);
        if (nbttaglist != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                if (k != ie.ordinal()) continue;
                if (level <= l) {
                    return;
                }
                nbttaglist.func_150305_b(j).func_74777_a("lvl", (short)level);
                stack.func_77983_a("infench", (NBTBase)nbttaglist);
                return;
            }
        } else {
            nbttaglist = new NBTTagList();
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74777_a("id", (short)ie.ordinal());
        nbttagcompound.func_74777_a("lvl", (short)level);
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        if (nbttaglist.func_74745_c() > 0) {
            stack.func_77983_a("infench", (NBTBase)nbttaglist);
        }
    }
}

