/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.essentia;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.codechicken.lib.raytracer.IndexedCuboid6;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.codechicken.lib.vec.Cuboid6;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.tiles.TileThaumcraft;
import thaumcraft.common.tiles.essentia.TileTubeFilter;

public class TileTube
extends TileThaumcraft
implements IEssentiaTransport,
IInteractWithCaster,
ITickable {
    public static final int freq = 5;
    public EnumFacing facing = EnumFacing.NORTH;
    public boolean[] openSides = new boolean[]{true, true, true, true, true, true};
    Aspect essentiaType = null;
    int essentiaAmount = 0;
    Aspect suctionType = null;
    int suction = 0;
    int venting = 0;
    int count = 0;
    int ventColor = 0;

    @Override
    public void readSyncNBT(NBTTagCompound nbttagcompound) {
        this.essentiaType = Aspect.getAspect(nbttagcompound.func_74779_i("type"));
        this.essentiaAmount = nbttagcompound.func_74762_e("amount");
        this.facing = EnumFacing.field_82609_l[nbttagcompound.func_74762_e("side")];
        byte[] sides = nbttagcompound.func_74770_j("open");
        if (sides != null && sides.length == 6) {
            for (int a = 0; a < 6; ++a) {
                this.openSides[a] = sides[a] == 1;
            }
        }
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbttagcompound) {
        if (this.essentiaType != null) {
            nbttagcompound.func_74778_a("type", this.essentiaType.getTag());
        }
        nbttagcompound.func_74768_a("amount", this.essentiaAmount);
        byte[] sides = new byte[6];
        for (int a = 0; a < 6; ++a) {
            sides[a] = this.openSides[a] ? (byte)1 : 0;
        }
        nbttagcompound.func_74768_a("side", this.facing.ordinal());
        nbttagcompound.func_74773_a("open", sides);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.suctionType = Aspect.getAspect(nbttagcompound.func_74779_i("stype"));
        this.suction = nbttagcompound.func_74762_e("samount");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        if (this.suctionType != null) {
            nbttagcompound.func_74778_a("stype", this.suctionType.getTag());
        }
        nbttagcompound.func_74768_a("samount", this.suction);
        return nbttagcompound;
    }

    public void func_73660_a() {
        if (this.venting > 0) {
            --this.venting;
        }
        if (this.count == 0) {
            this.count = this.field_145850_b.field_73012_v.nextInt(10);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.venting <= 0) {
                if (++this.count % 2 == 0) {
                    this.calculateSuction(null, false, false);
                    this.checkVenting();
                    if (this.essentiaType != null && this.essentiaAmount == 0) {
                        this.essentiaType = null;
                    }
                }
                if (this.count % 5 == 0 && this.suction > 0) {
                    this.equalizeWithNeighbours(false);
                }
            }
        } else if (this.venting > 0) {
            Random r = new Random(this.hashCode() * 4);
            float rp = r.nextFloat() * 360.0f;
            float ry = r.nextFloat() * 360.0f;
            double fx = -MathHelper.func_76126_a((float)(ry / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rp / 180.0f * (float)Math.PI));
            double fz = MathHelper.func_76134_b((float)(ry / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rp / 180.0f * (float)Math.PI));
            double fy = -MathHelper.func_76126_a((float)(rp / 180.0f * (float)Math.PI));
            FXDispatcher.INSTANCE.drawVentParticles((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, fx / 5.0, fy / 5.0, fz / 5.0, this.ventColor);
        }
    }

    void calculateSuction(Aspect filter, boolean restrict, boolean directional) {
        this.suction = 0;
        this.suctionType = null;
        EnumFacing loc = null;
        for (int dir = 0; dir < 6; ++dir) {
            try {
                int suck;
                TileEntity te;
                loc = EnumFacing.field_82609_l[dir];
                if (directional && this.facing != loc.func_176734_d() || !this.isConnectable(loc) || (te = ThaumcraftApiHelper.getConnectableTile(this.field_145850_b, this.field_174879_c, loc)) == null) continue;
                IEssentiaTransport ic = (IEssentiaTransport)te;
                if (filter != null && ic.getSuctionType(loc.func_176734_d()) != null && ic.getSuctionType(loc.func_176734_d()) != filter || filter == null && this.getEssentiaAmount(loc) > 0 && ic.getSuctionType(loc.func_176734_d()) != null && this.getEssentiaType(loc) != ic.getSuctionType(loc.func_176734_d()) || filter != null && this.getEssentiaAmount(loc) > 0 && this.getEssentiaType(loc) != null && ic.getSuctionType(loc.func_176734_d()) != null && this.getEssentiaType(loc) != ic.getSuctionType(loc.func_176734_d()) || (suck = ic.getSuctionAmount(loc.func_176734_d())) <= 0 || suck <= this.suction + 1) continue;
                Aspect st = ic.getSuctionType(loc.func_176734_d());
                if (st == null) {
                    st = filter;
                }
                this.setSuction(st, restrict ? suck / 2 : suck - 1);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void checkVenting() {
        EnumFacing loc = null;
        for (int dir = 0; dir < 6; ++dir) {
            try {
                TileEntity te;
                loc = EnumFacing.field_82609_l[dir];
                if (!this.isConnectable(loc) || (te = ThaumcraftApiHelper.getConnectableTile(this.field_145850_b, this.field_174879_c, loc)) == null) continue;
                IEssentiaTransport ic = (IEssentiaTransport)te;
                int suck = ic.getSuctionAmount(loc.func_176734_d());
                if (this.suction <= 0 || suck != this.suction && suck != this.suction - 1 || this.suctionType == ic.getSuctionType(loc.func_176734_d()) || te instanceof TileTubeFilter) continue;
                int c = -1;
                if (this.suctionType != null) {
                    c = Config.aspectOrder.indexOf(this.suctionType);
                }
                this.field_145850_b.func_175641_c(this.field_174879_c, BlocksTC.tube, 1, c);
                this.venting = 40;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void equalizeWithNeighbours(boolean directional) {
        EnumFacing loc = null;
        if (this.essentiaAmount > 0) {
            return;
        }
        for (int dir = 0; dir < 6; ++dir) {
            try {
                int am;
                IEssentiaTransport ic;
                TileEntity te;
                loc = EnumFacing.field_82609_l[dir];
                if (directional && this.facing == loc.func_176734_d() || !this.isConnectable(loc) || (te = ThaumcraftApiHelper.getConnectableTile(this.field_145850_b, this.field_174879_c, loc)) == null || !(ic = (IEssentiaTransport)te).canOutputTo(loc.func_176734_d()) || this.getSuctionType(null) != null && this.getSuctionType(null) != ic.getEssentiaType(loc.func_176734_d()) && ic.getEssentiaType(loc.func_176734_d()) != null || this.getSuctionAmount(null) <= ic.getSuctionAmount(loc.func_176734_d()) || this.getSuctionAmount(null) < ic.getMinimumSuction()) continue;
                Aspect a = this.getSuctionType(null);
                if (a == null && (a = ic.getEssentiaType(loc.func_176734_d())) == null) {
                    a = ic.getEssentiaType(null);
                }
                if ((am = this.addEssentia(a, ic.takeEssentia(a, 1, loc.func_176734_d()), loc)) <= 0) continue;
                if (this.field_145850_b.field_73012_v.nextInt(100) == 0) {
                    this.field_145850_b.func_175641_c(this.field_174879_c, BlocksTC.tube, 0, 0);
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isConnectable(EnumFacing face) {
        if (face == null) {
            return false;
        }
        return this.openSides[face.ordinal()];
    }

    @Override
    public boolean canInputFrom(EnumFacing face) {
        if (face == null) {
            return false;
        }
        return this.openSides[face.ordinal()];
    }

    @Override
    public boolean canOutputTo(EnumFacing face) {
        if (face == null) {
            return false;
        }
        return this.openSides[face.ordinal()];
    }

    @Override
    public void setSuction(Aspect aspect, int amount) {
        this.suctionType = aspect;
        this.suction = amount;
    }

    @Override
    public Aspect getSuctionType(EnumFacing loc) {
        return this.suctionType;
    }

    @Override
    public int getSuctionAmount(EnumFacing loc) {
        return this.suction;
    }

    @Override
    public Aspect getEssentiaType(EnumFacing loc) {
        return this.essentiaType;
    }

    @Override
    public int getEssentiaAmount(EnumFacing loc) {
        return this.essentiaAmount;
    }

    @Override
    public int takeEssentia(Aspect aspect, int amount, EnumFacing face) {
        if (this.canOutputTo(face) && this.essentiaType == aspect && this.essentiaAmount > 0 && amount > 0) {
            --this.essentiaAmount;
            if (this.essentiaAmount <= 0) {
                this.essentiaType = null;
            }
            this.func_70296_d();
            return 1;
        }
        return 0;
    }

    @Override
    public int addEssentia(Aspect aspect, int amount, EnumFacing face) {
        if (this.canInputFrom(face) && this.essentiaAmount == 0 && amount > 0) {
            this.essentiaType = aspect;
            ++this.essentiaAmount;
            this.func_70296_d();
            return 1;
        }
        return 0;
    }

    @Override
    public int getMinimumSuction() {
        return 0;
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 0) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundsTC.creak, SoundCategory.AMBIENT, 1.0f, 1.3f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, false);
            }
            return true;
        }
        if (i == 1) {
            if (this.field_145850_b.field_72995_K) {
                if (this.venting <= 0) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.1f, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, false);
                }
                this.venting = 50;
                this.ventColor = j == -1 || j >= Config.aspectOrder.size() ? 0xAAAAAA : Config.aspectOrder.get(j).getColor();
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    @Override
    public boolean onCasterRightClick(World world, ItemStack wandstack, EntityPlayer player, BlockPos bp, EnumFacing side, EnumHand hand) {
        RayTraceResult hit = RayTracer.retraceBlock(world, player, this.field_174879_c);
        if (hit == null) {
            return false;
        }
        if (hit.subHit >= 0 && hit.subHit < 6) {
            player.field_70170_p.func_184134_a((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5, SoundsTC.tool, SoundCategory.BLOCKS, 0.5f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, false);
            player.func_184609_a(hand);
            this.func_70296_d();
            this.syncTile(true);
            this.openSides[hit.subHit] = !this.openSides[hit.subHit];
            EnumFacing dir = EnumFacing.field_82609_l[hit.subHit];
            TileEntity tile = world.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (tile != null && tile instanceof TileTube) {
                ((TileTube)tile).openSides[dir.func_176734_d().ordinal()] = this.openSides[hit.subHit];
                this.syncTile(true);
                tile.func_70296_d();
            }
        }
        if (hit.subHit == 6) {
            player.field_70170_p.func_184134_a((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5, SoundsTC.tool, SoundCategory.BLOCKS, 0.5f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, false);
            player.func_184609_a(hand);
            int a = this.facing.ordinal();
            this.func_70296_d();
            while (++a < 20) {
                if (!this.canConnectSide(EnumFacing.field_82609_l[a % 6].func_176734_d()) || !this.isConnectable(EnumFacing.field_82609_l[a % 6].func_176734_d())) continue;
                this.facing = EnumFacing.field_82609_l[a %= 6];
                this.syncTile(true);
                this.func_70296_d();
                break;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    public RayTraceResult rayTrace(World world, Vec3d vec3d, Vec3d vec3d1, RayTraceResult fullblock) {
        return fullblock;
    }

    public boolean canConnectSide(EnumFacing side) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        return tile != null && tile instanceof IEssentiaTransport;
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        float min = 0.375f;
        float max = 0.625f;
        if (this.canConnectSide(EnumFacing.DOWN)) {
            cuboids.add(new IndexedCuboid6(0, new Cuboid6((float)this.field_174879_c.func_177958_n() + min, this.field_174879_c.func_177956_o(), (float)this.field_174879_c.func_177952_p() + min, (float)this.field_174879_c.func_177958_n() + max, (double)this.field_174879_c.func_177956_o() + 0.375, (float)this.field_174879_c.func_177952_p() + max)));
        }
        if (this.canConnectSide(EnumFacing.UP)) {
            cuboids.add(new IndexedCuboid6(1, new Cuboid6((float)this.field_174879_c.func_177958_n() + min, (double)this.field_174879_c.func_177956_o() + 0.625, (float)this.field_174879_c.func_177952_p() + min, (float)this.field_174879_c.func_177958_n() + max, this.field_174879_c.func_177956_o() + 1, (float)this.field_174879_c.func_177952_p() + max)));
        }
        if (this.canConnectSide(EnumFacing.NORTH)) {
            cuboids.add(new IndexedCuboid6(2, new Cuboid6((float)this.field_174879_c.func_177958_n() + min, (float)this.field_174879_c.func_177956_o() + min, this.field_174879_c.func_177952_p(), (float)this.field_174879_c.func_177958_n() + max, (float)this.field_174879_c.func_177956_o() + max, (double)this.field_174879_c.func_177952_p() + 0.375)));
        }
        if (this.canConnectSide(EnumFacing.SOUTH)) {
            cuboids.add(new IndexedCuboid6(3, new Cuboid6((float)this.field_174879_c.func_177958_n() + min, (float)this.field_174879_c.func_177956_o() + min, (double)this.field_174879_c.func_177952_p() + 0.625, (float)this.field_174879_c.func_177958_n() + max, (float)this.field_174879_c.func_177956_o() + max, this.field_174879_c.func_177952_p() + 1)));
        }
        if (this.canConnectSide(EnumFacing.WEST)) {
            cuboids.add(new IndexedCuboid6(4, new Cuboid6(this.field_174879_c.func_177958_n(), (float)this.field_174879_c.func_177956_o() + min, (float)this.field_174879_c.func_177952_p() + min, (double)this.field_174879_c.func_177958_n() + 0.375, (float)this.field_174879_c.func_177956_o() + max, (float)this.field_174879_c.func_177952_p() + max)));
        }
        if (this.canConnectSide(EnumFacing.EAST)) {
            cuboids.add(new IndexedCuboid6(5, new Cuboid6((double)this.field_174879_c.func_177958_n() + 0.625, (float)this.field_174879_c.func_177956_o() + min, (float)this.field_174879_c.func_177952_p() + min, this.field_174879_c.func_177958_n() + 1, (float)this.field_174879_c.func_177956_o() + max, (float)this.field_174879_c.func_177952_p() + max)));
        }
        cuboids.add(new IndexedCuboid6(6, new Cuboid6((double)this.field_174879_c.func_177958_n() + 0.375, (double)this.field_174879_c.func_177956_o() + 0.375, (double)this.field_174879_c.func_177952_p() + 0.375, (double)this.field_174879_c.func_177958_n() + 0.625, (double)this.field_174879_c.func_177956_o() + 0.625, (double)this.field_174879_c.func_177952_p() + 0.625)));
    }
}

