/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityCreeperTitanFireball;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EntityWitherTurret;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAICreeperTitanSwell;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titan.animation.creepertitan.AnimationCreeperTitanAntiTitanAttack;
import net.minecraft.entity.titan.animation.creepertitan.AnimationCreeperTitanAttack;
import net.minecraft.entity.titan.animation.creepertitan.AnimationCreeperTitanDeath;
import net.minecraft.entity.titan.animation.creepertitan.AnimationCreeperTitanHeadSlam;
import net.minecraft.entity.titan.animation.creepertitan.AnimationCreeperTitanKick;
import net.minecraft.entity.titan.animation.creepertitan.AnimationCreeperTitanSpit;
import net.minecraft.entity.titan.animation.creepertitan.AnimationCreeperTitanStomp;
import net.minecraft.entity.titan.animation.creepertitan.AnimationCreeperTitanStunned;
import net.minecraft.entity.titan.animation.creepertitan.AnimationCreeperTitanThunderClap;
import net.minecraft.entity.titanminion.EntityCreeperLoyalist;
import net.minecraft.entity.titanminion.EntityCreeperPriest;
import net.minecraft.entity.titanminion.EntityCreeperTemplar;
import net.minecraft.entity.titanminion.EntityCreeperZealot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.ClientProxy;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import thehippomaster.AnimationAPI.AnimationAPI;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntityCreeperTitan
extends EntityTitan
implements IAnimatedEntity,
IEntityMultiPart {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 200;
    private int field_175494_bm = 0;
    public boolean isAttacking;
    public boolean isStunned;
    public EntityDragonPart[] partArray;
    public EntityDragonPart head;
    public EntityDragonPart body;

    public EntityCreeperTitan(World worldIn) {
        super(worldIn);
        this.setTitanHealth(this.func_110138_aP());
        this.head = new EntityDragonPart((IEntityMultiPart)this, "head", 8.0f, 8.0f);
        this.body = new EntityDragonPart((IEntityMultiPart)this, "body", 8.0f, 12.0f);
        this.partArray = new EntityDragonPart[]{this.head, this.body};
        this.func_70105_a(8.0f, 26.0f);
        this.field_70138_W = 6.0f;
        this.field_70728_aV = 50000;
        this.field_70178_ae = true;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
    }

    @Override
    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAICreeperTitanSwell(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationCreeperTitanDeath(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationCreeperTitanStunned(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationCreeperTitanThunderClap(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationCreeperTitanSpit(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationCreeperTitanKick(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationCreeperTitanAntiTitanAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationCreeperTitanAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationCreeperTitanStomp(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationCreeperTitanHeadSlam(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.CreeperTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityCreeperLoyalist.class && p_70686_1_ != EntityCreeperTitan.class;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(250) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.CreeperTitanMinionSpawnrate;
    }

    @Override
    public int getMinionCap() {
        return 120;
    }

    @Override
    public int getPriestCap() {
        return 60;
    }

    @Override
    public int getZealotCap() {
        return 30;
    }

    @Override
    public int getTemplarCap() {
        return 8;
    }

    @Override
    public int getParticleCount() {
        if (this.getPowered()) {
            return 28;
        }
        return super.getParticleCount();
    }

    @Override
    public int getRegenTime() {
        return 15;
    }

    @Override
    public float getRegen() {
        if (this.getPowered()) {
            return 60.0f;
        }
        return super.getRegen();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(70.0);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return this.isStunned && !this.func_85032_ar();
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.AVERAGE;
    }

    protected void func_70069_a(float p_70069_1_) {
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:groundSmash", 20.0f, 1.0f);
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.func_85030_a("thetitans:titanStrike", 10.0f, 1.0f);
            this.func_85030_a("thetitans:titanSlam", 10.0f, 1.0f);
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(16.0, 2.0, 16.0));
            this.collideWithEntities(this.body, this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || !this.func_70686_a(entity.getClass()) || entity instanceof EntityTitan) continue;
                    float smash = 50.0f - this.func_70032_d(entity);
                    if (smash <= 1.0f) {
                        smash = 1.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), smash);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                    if (this.field_70170_p.field_72995_K || !this.func_70089_S() || this.isStunned) continue;
                    this.collideWithEntities(this.body, this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
        if (this.getCreeperState() > 0) {
            this.timeSinceIgnited += 20;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            tagCompound.func_74757_a("Charged", true);
        }
        tagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        tagCompound.func_74757_a("ignited", this.func_146078_ca());
        tagCompound.func_74757_a("Stunned", this.isStunned);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(tagCompund.func_74767_n("Charged") ? 1 : 0)));
        this.isStunned = tagCompund.func_74767_n("Stunned");
        if (tagCompund.func_150297_b("Fuse", 99)) {
            this.fuseTime = tagCompund.func_74765_d("Fuse");
        }
        if (tagCompund.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    public void func_70071_h_() {
        if (this.animID != 0) {
            ++this.animTick;
        }
        super.func_70071_h_();
    }

    @Override
    public double getSpeed() {
        return this.getPowered() ? 0.6 : 0.3;
    }

    @Override
    public void setAnimID(int id) {
        this.animID = id;
    }

    @Override
    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    @Override
    public int getAnimID() {
        return this.animID;
    }

    @Override
    public int getAnimTick() {
        return this.animTick;
    }

    public void collideWithEntities(EntityDragonPart part, List p_70970_1_) {
        double d0 = (part.field_70121_D.field_72340_a + part.field_70121_D.field_72336_d) / 2.0;
        double d1 = (part.field_70121_D.field_72339_c + part.field_70121_D.field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityTitan || entity instanceof EntityTitanSpirit || !this.func_70686_a(entity.getClass()) || !entity.func_70067_L()) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 0.5, 0.25, d3 / d4 * 0.5);
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 2.0f);
        }
    }

    @Override
    public void attackChoosenEntity(Entity damagedEntity, float damage, int knockbackAmount) {
        super.attackChoosenEntity(damagedEntity, damage, knockbackAmount);
        if (this.getPowered() && damagedEntity instanceof EntityLivingBase) {
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_72885_a((Entity)this, damagedEntity.field_70165_t, damagedEntity.field_70163_u, damagedEntity.field_70161_v, 6.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.head.field_70163_u, this.field_70161_v, 2.0f, false, false);
            damagedEntity.func_70097_a(DamageSourceExtra.lightningBolt, 49.0f);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, damagedEntity.field_70165_t, damagedEntity.field_70163_u, damagedEntity.field_70161_v));
        }
    }

    @Override
    public boolean shouldMove() {
        return this.animID == 0 && !this.isStunned && this.func_70638_az() != null ? super.shouldMove() : false;
    }

    public void doLightningAttackToEntity(Entity p_70652_1_) {
        if (this.getPowered()) {
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_72885_a((Entity)this, p_70652_1_.field_70165_t, p_70652_1_.field_70163_u, p_70652_1_.field_70161_v, 6.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, p_70652_1_.field_70165_t, p_70652_1_.field_70163_u + 12.0, p_70652_1_.field_70161_v, 6.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, p_70652_1_.field_70165_t, p_70652_1_.field_70163_u + 20.0, p_70652_1_.field_70161_v, 6.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.head.field_70163_u, this.field_70161_v, 2.0f, false, false);
            p_70652_1_.func_70097_a(DamageSourceExtra.lightningBolt, 49.0f);
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i = this.getKnockbackAmount();
            this.attackChoosenEntity(p_70652_1_, f, i);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, p_70652_1_.field_70165_t, p_70652_1_.field_70163_u, p_70652_1_.field_70161_v));
            if (p_70652_1_ instanceof EntityWitherzilla) {
                p_70652_1_.func_70097_a(DamageSource.field_76377_j, 400.0f);
            }
        } else if (!this.getPowered()) {
            this.field_70170_p.func_72885_a((Entity)this, p_70652_1_.field_70165_t, p_70652_1_.field_70163_u, p_70652_1_.field_70161_v, 3.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, p_70652_1_.field_70165_t, p_70652_1_.field_70163_u + 12.0, p_70652_1_.field_70161_v, 3.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, p_70652_1_.field_70165_t, p_70652_1_.field_70163_u + 20.0, p_70652_1_.field_70161_v, 3.0f, false, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.head.field_70163_u, this.field_70161_v, 2.0f, false, false);
            p_70652_1_.func_70097_a(DamageSourceExtra.lightningBolt, 49.0f);
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i = this.getKnockbackAmount();
            this.attackChoosenEntity(p_70652_1_, f, i);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, p_70652_1_.field_70165_t, p_70652_1_.field_70163_u, p_70652_1_.field_70161_v));
            if (p_70652_1_ instanceof EntityWitherzilla) {
                p_70652_1_.func_70097_a(DamageSource.field_76377_j, 400.0f);
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        return false;
    }

    @Override
    public void func_70636_d() {
        Block block;
        EntityCreeperLoyalist entitychicken;
        int in;
        List list;
        if (this.isStunned) {
            this.func_70624_b(null);
            AnimationAPI.sendAnimPacket(this, 8);
        }
        if (this.animID == 10) {
            if (this.animTick == 30 || this.animTick == 70 || this.animTick == 80) {
                this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
            }
            if (this.animTick == 100) {
                this.func_85030_a("thetitans:titanFall", 20.0f, 1.0f);
                this.func_85030_a("thetitans:groundSmash", 20.0f, 1.0f);
            }
            if (this.animTick == 140) {
                this.func_85030_a("thetitans:titanFall", 20.0f, 1.0f);
            }
        }
        if (this.animID == 8) {
            if (this.animTick == 120) {
                this.func_85030_a("thetitans:groundSmash", 8.0f, 0.9f);
                this.func_85030_a("thetitans:titanFall", 10.0f, 1.0f);
            }
            if (this.animTick == 180) {
                this.func_85030_a("thetitans:groundSmash", 8.0f, 0.9f);
                this.func_85030_a("thetitans:titanFall", 10.0f, 1.0f);
                this.func_85030_a("thetitans:titanLand", 10000.0f, 1.0f);
            }
            if (this.animTick == 20) {
                this.func_85030_a("thetitans:titanCreeperStun", this.func_70599_aP(), this.func_70647_i());
            }
            if (this.animTick >= 500 && this.isStunned) {
                this.isStunned = false;
                this.setAnimID(0);
                this.setAnimTick(0);
            }
            this.func_70624_b(null);
        }
        if (this.getPowered() && !this.isStunned) {
            WorldServer worldserver = MinecraftServer.func_71276_C().field_71305_c[0];
            WorldInfo worldinfo = worldserver.func_72912_H();
            worldinfo.func_76080_g(9999999);
            worldinfo.func_76090_f(1000000);
            worldinfo.func_76084_b(true);
            worldinfo.func_76069_a(true);
            if (this.field_70146_Z.nextInt(100) == 0) {
                EntityLightningBolt entitylightning = new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.head.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72942_c((Entity)entitylightning);
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                for (int l = 0; l < 50; ++l) {
                    int i = MathHelper.func_76128_c((double)this.field_70165_t);
                    int j = MathHelper.func_76128_c((double)this.field_70163_u);
                    int k = MathHelper.func_76128_c((double)this.field_70161_v);
                    int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)10, (int)100) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    int j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)10, (int)100) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    int k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)10, (int)100) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    EntityLightningBolt entitylightning = new EntityLightningBolt(this.field_70170_p, (double)i1, (double)j1, (double)k1);
                    if (!World.func_147466_a((IBlockAccess)this.field_70170_p, (int)i1, (int)(j1 - 1), (int)k1) || !this.field_70170_p.func_72855_b(entitylightning.field_70121_D) || !this.field_70170_p.func_72945_a((Entity)entitylightning, entitylightning.field_70121_D).isEmpty() || this.field_70170_p.func_72953_d(entitylightning.field_70121_D)) continue;
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, (double)i1, (double)j1, (double)k1));
                }
            }
        }
        if (this.isStunned) {
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t, this.field_70163_u + 12.0, this.field_70161_v, 0.0f, 0.0f);
            this.body.func_70071_h_();
            this.body.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        } else {
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t, this.field_70163_u + 18.0, this.field_70161_v, 0.0f, 0.0f);
            this.body.func_70071_h_();
            this.body.func_70012_b(this.field_70165_t, this.field_70163_u + 6.0, this.field_70161_v, 0.0f, 0.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.isStunned) {
            this.collideWithEntities(this.head, this.field_70170_p.func_72839_b((Entity)this, this.head.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.body, this.field_70170_p.func_72839_b((Entity)this, this.body.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.head, this.field_70170_p.func_72839_b((Entity)this, this.head.field_70121_D.func_72314_b(3.0, 1.0, 3.0).func_72317_d(0.0, -20.0, 0.0)));
        }
        if (this.field_70173_aa % 20 == 0 && this.animID == 0) {
            this.isAttacking = false;
        }
        this.meleeTitan = true;
        if (this.animID != 0 || this.isStunned || this.isAttacking) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (!AnimationAPI.isEffectiveClient() && this.func_70638_az() != null && !this.isStunned && this.getAnimID() == 0) {
            double d0 = this.func_70068_e((Entity)this.func_70638_az());
            if (d0 < (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 800.0) {
                if (this.func_70638_az() instanceof EntityTitan || this.func_70638_az().field_70131_O >= 6.0f || this.func_70638_az().field_70163_u > this.field_70163_u + 6.0) {
                    this.isAttacking = true;
                    AnimationAPI.sendAnimPacket(this, 4);
                    this.setAnimID(4);
                } else {
                    this.isAttacking = true;
                    switch (this.field_70146_Z.nextInt(4)) {
                        case 0: {
                            AnimationAPI.sendAnimPacket(this, 3);
                            this.setAnimID(3);
                            this.setAnimTick(0);
                            break;
                        }
                        case 1: {
                            AnimationAPI.sendAnimPacket(this, 2);
                            this.setAnimID(2);
                            this.setAnimTick(0);
                            break;
                        }
                        case 2: {
                            AnimationAPI.sendAnimPacket(this, 5);
                            this.setAnimID(5);
                            this.setAnimTick(0);
                            break;
                        }
                        case 3: {
                            AnimationAPI.sendAnimPacket(this, 1);
                            this.setAnimID(1);
                            this.setAnimTick(0);
                        }
                    }
                }
            } else if (this.getAnimID() == 0 && this.func_70681_au().nextInt(100) == 0) {
                this.isAttacking = true;
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        AnimationAPI.sendAnimPacket(this, 6);
                        this.setAnimID(6);
                        this.setAnimTick(0);
                        break;
                    }
                    case 1: {
                        AnimationAPI.sendAnimPacket(this, 7);
                        this.setAnimID(7);
                        this.setAnimTick(0);
                    }
                }
            }
        }
        if (this.getAnimID() == 6 && this.getAnimTick() == 40 && this.func_70638_az() != null) {
            int it = this.getPowered() ? 2000 + this.field_70146_Z.nextInt(2000) : 500 + this.field_70146_Z.nextInt(500);
            block22: for (int i = 0; i < it; ++i) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        double d5 = this.func_70638_az().field_70165_t + this.field_70146_Z.nextDouble() - this.head.field_70165_t;
                        double d6 = this.func_70638_az().field_70121_D.field_72338_b + (double)(this.func_70638_az().field_70131_O / 4.0f) - this.head.field_70163_u;
                        double d7 = this.func_70638_az().field_70161_v + this.field_70146_Z.nextDouble() - this.head.field_70161_v;
                        EntityCreeperTitanFireball entitylargefireball = new EntityCreeperTitanFireball(this.field_70170_p, (EntityLivingBase)this, d5, d6, d7);
                        Vec3 vec3 = this.func_70676_i(0.25f);
                        entitylargefireball.field_70165_t = this.head.field_70165_t + vec3.field_72450_a + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 32.0f);
                        entitylargefireball.field_70163_u = this.head.field_70163_u + 16.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 32.0f);
                        entitylargefireball.field_70161_v = this.head.field_70161_v + vec3.field_72449_c + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 32.0f);
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                        continue block22;
                    }
                    case 1: {
                        if (this.field_70170_p.field_72995_K) continue block22;
                        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(this.field_70170_p, this.func_70638_az().field_70165_t + 0.5 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 32.0f), this.func_70638_az().field_70163_u + 32.0 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 32.0f), this.func_70638_az().field_70161_v + 0.5 + (double)((this.func_70681_au().nextFloat() * 2.0f - 1.0f) * 32.0f), (EntityLivingBase)this);
                        this.field_70170_p.func_72838_d((Entity)entitytntprimed);
                        this.func_85030_a("game.tnt.primed", 1.0f, 1.0f);
                        entitytntprimed.field_70516_a = 100 + this.field_70146_Z.nextInt(60);
                    }
                }
            }
        }
        if ((list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0))) != null && !list.isEmpty() && this.field_70173_aa % 20 == 0) {
            for (int i1 = 0; i1 < list.size(); ++i1) {
                Entity entity = (Entity)list.get(i1);
                if (entity != null && this.getPowered() && entity instanceof EntityCreeperLoyalist) {
                    if (!((EntityCreeperLoyalist)entity).getPowered()) {
                        this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                        continue;
                    }
                    ((EntityCreeperLoyalist)entity).func_70691_i(5.0f);
                    continue;
                }
                if (entity == null || this.func_70638_az() == null || !this.getPowered() || !(entity instanceof EntityLivingBase) || entity instanceof EntityCreeperLoyalist || entity instanceof EntityCreeperTitan || this.field_70146_Z.nextInt(60) != 0) continue;
                this.doLightningAttackToEntity(entity);
            }
        }
        if (this.func_70638_az() != null) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 180.0f, 30.0f);
        }
        if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).getDisplayName().equals("Boom337317")) {
            this.func_70624_b(null);
        }
        if (this.getPowered()) {
            switch (this.field_70146_Z.nextInt(5)) {
                case 0: {
                    this.func_94058_c("\u00a72Charged Creeper Titan");
                    break;
                }
                case 1: {
                    this.func_94058_c("\u00a74Charged Creeper Titan");
                    break;
                }
                case 2: {
                    this.func_94058_c("\u00a76Charged Creeper Titan");
                    break;
                }
                case 3: {
                    this.func_94058_c("\u00a7aCharged Creeper Titan");
                    break;
                }
                case 4: {
                    this.func_94058_c("\u00a7eCharged Creeper Titan");
                }
            }
        } else {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.CreeperTitan.name"));
        }
        if (this.func_70638_az() != null && this.field_70122_E && !this.isStunned && this.func_70068_e((Entity)this.func_70638_az()) > 300.0 && this.animID != 3 && this.animID != 4 && this.animID != 5 && this.animID != 6 && this.animID != 7 && this.animID != 8 && this.animID != 9 && this.animID != 10 && this.field_70146_Z.nextInt(in = this.getPowered() ? 50 : 300) == 0) {
            this.func_70664_aZ();
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.func_70638_az() != null && this.field_70122_E && !this.isStunned && this.animID == 0 && this.field_70146_Z.nextInt(in = this.getPowered() ? 50 : 600) == 0) {
            double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
            double hor = f21 / 16.0f;
            double ver = 2.5;
            this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
            this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
            this.field_70181_x = ver;
        }
        if ((this.field_70146_Z.nextInt(20) == 0 && this.getPowered() || this.field_70146_Z.nextInt(80) == 0 && !this.getPowered()) && !this.isStunned && this.animID != 4 && this.animID != 6 && this.func_70638_az() != null) {
            this.doLightningAttackToEntity((Entity)this.func_70638_az());
        }
        if (this.numMinions < this.getMinionCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            entitychicken = new EntityCreeperLoyalist(this.field_70170_p);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            entitychicken.master = this;
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.9, 0.0);
            entitychicken.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numMinions;
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
            }
            if (this.field_70146_Z.nextInt(100) == 0 || this.getPowered()) {
                entitychicken.func_70096_w().func_75692_b(17, (Object)1);
            }
        }
        if (this.numPriests < this.getPriestCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 2) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            entitychicken = new EntityCreeperPriest(this.field_70170_p);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            ((EntityCreeperPriest)entitychicken).master = this;
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.9, 0.0);
            entitychicken.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numPriests;
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            block = this.field_70170_p.func_147439_a((int)((EntityCreeperPriest)entitychicken).field_70165_t, (int)(((EntityCreeperPriest)entitychicken).field_70163_u + 1.0), (int)((EntityCreeperPriest)entitychicken).field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)((EntityCreeperPriest)entitychicken).field_70165_t, (int)(((EntityCreeperPriest)entitychicken).field_70163_u + 1.0), (int)((EntityCreeperPriest)entitychicken).field_70161_v, Block.func_149682_b((Block)block));
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)((EntityCreeperPriest)entitychicken).field_70165_t, (int)(((EntityCreeperPriest)entitychicken).field_70163_u + 1.0), (int)((EntityCreeperPriest)entitychicken).field_70161_v, Blocks.field_150346_d);
            }
            if (this.field_70146_Z.nextInt(100) == 0 || this.getPowered()) {
                entitychicken.func_70096_w().func_75692_b(17, (Object)1);
            }
        }
        if (this.numZealots < this.getZealotCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 5) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            entitychicken = new EntityCreeperZealot(this.field_70170_p);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            ((EntityCreeperZealot)entitychicken).master = this;
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.9, 0.0);
            ((EntityCreeperZealot)entitychicken).func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numZealots;
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            block = this.field_70170_p.func_147439_a((int)((EntityCreeperZealot)entitychicken).field_70165_t, (int)(((EntityCreeperZealot)entitychicken).field_70163_u + 1.0), (int)((EntityCreeperZealot)entitychicken).field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)((EntityCreeperZealot)entitychicken).field_70165_t, (int)(((EntityCreeperZealot)entitychicken).field_70163_u + 1.0), (int)((EntityCreeperZealot)entitychicken).field_70161_v, Block.func_149682_b((Block)block));
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)((EntityCreeperZealot)entitychicken).field_70165_t, (int)(((EntityCreeperZealot)entitychicken).field_70163_u + 1.0), (int)((EntityCreeperZealot)entitychicken).field_70161_v, Blocks.field_150346_d);
            }
            if (this.field_70146_Z.nextInt(100) == 0 || this.getPowered()) {
                entitychicken.func_70096_w().func_75692_b(17, (Object)1);
            }
        }
        if (this.numTemplar < this.getTemplarCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 10) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            entitychicken = new EntityCreeperTemplar(this.field_70170_p);
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            ((EntityCreeperTemplar)entitychicken).master = this;
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.9, 0.0);
            entitychicken.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            ++this.numTemplar;
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            block = this.field_70170_p.func_147439_a((int)((EntityCreeperTemplar)entitychicken).field_70165_t, (int)(((EntityCreeperTemplar)entitychicken).field_70163_u + 1.0), (int)((EntityCreeperTemplar)entitychicken).field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)((EntityCreeperTemplar)entitychicken).field_70165_t, (int)(((EntityCreeperTemplar)entitychicken).field_70163_u + 1.0), (int)((EntityCreeperTemplar)entitychicken).field_70161_v, Block.func_149682_b((Block)block));
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)((EntityCreeperTemplar)entitychicken).field_70165_t, (int)(((EntityCreeperTemplar)entitychicken).field_70163_u + 1.0), (int)((EntityCreeperTemplar)entitychicken).field_70161_v, Blocks.field_150346_d);
            }
            if (this.field_70146_Z.nextInt(100) == 0 || this.getPowered()) {
                entitychicken.func_70096_w().func_75692_b(17, (Object)1);
            }
        }
        if (TheTitans.NightmareMode) {
            if (this.getPowered()) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1620.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(540.0);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50000.0);
        } else {
            if (this.getPowered()) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(540.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(180.0);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25000.0);
        }
        super.func_70636_d();
    }

    protected String func_70639_aQ() {
        return this.isStunned ? null : "thetitans:titanCreeperLiving";
    }

    @Override
    protected String func_70621_aR() {
        return "thetitans:titanCreeperGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return "thetitans:titanCreeperDeath";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.1f);
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.1f);
    }

    @Override
    public StatBase getAchievement() {
        return TitansAchievments.creepertitan;
    }

    public void setPowered(int i) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)i));
    }

    public boolean getPowered() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            EntityItem entityitem;
            int l;
            for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151016_H));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 64 + this.field_70146_Z.nextInt(64 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150335_W));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_) + p_70628_2_; ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_) + p_70628_2_; ++l) {
                int t = Item.func_150891_b((Item)Items.field_151096_cd);
                int v = Item.func_150891_b((Item)Items.field_151084_co);
                int q = t + this.field_70146_Z.nextInt(v - t + 1);
                EntityItem entityitem2 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Item.func_150899_d((int)q)));
                entityitem2.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem2);
            }
            for (l = 0; l < 8 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                EntityItem entityitem3 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151166_bC));
                entityitem3.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem3);
            }
            for (l = 0; l < 8 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                EntityItem entityitem4 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                entityitem4.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem4);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(4 + p_70628_2_); ++l) {
                EntityItem entityitem5 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadium));
                entityitem5.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem5);
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                EntityItem entityitem6 = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150357_h));
                entityitem6.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem6);
            }
        }
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int p_70829_1_) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)p_70829_1_));
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (this.field_70146_Z.nextInt(1000) == 0) {
            this.setPowered(1);
        }
    }

    @Override
    public int getThreashHold() {
        return this.fuseTime;
    }

    private void explode() {
        for (int i = 0; i < 1000; ++i) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 16.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 48.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 16.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + (double)f1, this.field_70161_v + (double)f2, this.field_70146_Z.nextDouble() - 0.5, 0.0, this.field_70146_Z.nextDouble() - 0.5);
        }
        this.func_85030_a("thetitans:titanCreeperExplosion", Float.MAX_VALUE, 1.0f);
        this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        double d1 = this.getPowered() ? 256.0 : 128.0;
        double d2 = this.getPowered() ? 2048.0 : 1024.0;
        this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(d1, d1, d1));
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + 24.0, this.field_70161_v, 12.0f, flag);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + 18.0, this.field_70161_v, 12.0f, flag);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + 12.0, this.field_70161_v, 12.0f, flag);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + 6.0, this.field_70161_v, 12.0f, flag);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0f, flag);
        this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
        for (int da = 0; da <= 500; ++da) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(d1, d1, d1));
            if (list == null || list.isEmpty()) continue;
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity == null || !(entity instanceof EntityLivingBase)) continue;
                this.attackChoosenEntity(entity, this.getPowered() ? 200.0f : 100.0f, 0);
                entity.func_70097_a(DamageSourceExtra.causeCreeperTitanExplosionDamage((Entity)this), this.getPowered() ? 200.0f : 100.0f);
                entity.field_70172_ad = 0;
            }
        }
        List list111 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(d2, d2, d2));
        if (list111 != null && !list111.isEmpty()) {
            for (int i = 0; i < list111.size(); ++i) {
                Entity entity = (Entity)list111.get(i);
                if (!(entity instanceof EntityLivingBase)) continue;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(ClientProxy.creeperTitanRadiation.field_76415_H, 30000, 1));
            }
        }
    }

    public boolean func_146078_ca() {
        return this.field_70180_af.func_75683_a(18) != 0;
    }

    public void func_146079_cb() {
        this.field_70180_af.func_75692_b(18, (Object)1);
    }

    public void func_175493_co() {
        ++this.field_175494_bm;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                if (!(entity instanceof EntityLivingBase) || !entity.field_70122_E || entity instanceof EntityTitan) continue;
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                entity.func_70097_a(DamageSourceExtra.causeSquishingDamage((Entity)this), f / 2.0f);
            }
        }
    }

    public boolean attackCreeperFrom(DamageSource source, float amount) {
        if (this.getPowered()) {
            amount *= 0.25f;
        }
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (source == DamageSourceExtra.lightningBolt || source.func_76346_g() instanceof EntityCreeperLoyalist || source.func_76346_g() instanceof EntityCreeperTitan || source.func_94541_c() && !(source.func_76346_g() instanceof EntityWitherTurret)) {
            this.func_70691_i(amount);
            return false;
        }
        if (!this.isStunned && source.func_76346_g() instanceof EntityPlayer) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.attackCreeperFrom(source, amount);
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public boolean func_70965_a(EntityDragonPart p_70965_1_, DamageSource source, float amount) {
        if (p_70965_1_ != this.head) {
            amount /= 3.0f;
        }
        this.func_82195_e(source, amount);
        if (source.func_76346_g() instanceof EntityPlayer && !AnimationAPI.isEffectiveClient() && source.func_76357_e() && (this.getAnimID() == 3 && this.getAnimTick() > 40 && this.getAnimTick() < 80 || this.getAnimID() == 7 && this.getAnimTick() > 40 && this.getAnimTick() < 140) && !this.isStunned) {
            AnimationAPI.sendAnimPacket(this, 8);
            this.setAnimID(8);
            this.setAnimTick(0);
            this.isStunned = true;
        }
        if (source == DamageSourceExtra.lightningBolt || source.func_76346_g() instanceof EntityCreeperLoyalist || source.func_76346_g() instanceof EntityCreeperTitan || source.func_94541_c() && !(source.func_76346_g() instanceof EntityWitherTurret)) {
            this.func_70691_i(amount);
            return false;
        }
        return true;
    }

    protected boolean func_82195_e(DamageSource p_82195_1_, float p_82195_2_) {
        return this.attackCreeperFrom(p_82195_1_, p_82195_2_);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
            entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitytitan);
            entitytitan.setVesselHunting(false);
            entitytitan.setSpiritType(7);
            this.explode();
        }
    }

    @Override
    protected void onTitanDeathUpdate() {
        if (this.timeSinceIgnited >= this.getThreashHold()) {
            this.deathTicks = 200;
            this.func_70106_y();
        } else {
            this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
            if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
                ++this.deathTicks;
                AnimationAPI.sendAnimPacket(this, 10);
                this.setAnimID(10);
                this.setTitanHealth(0.0f);
            } else {
                this.func_70097_a(DamageSource.field_76380_i, 25.0f);
                this.setTitanHealth(this.field_70180_af.func_111145_d(5));
                this.func_70606_j(this.field_70180_af.func_111145_d(5));
                this.deathTicks = 0;
                if (this.animID == 10) {
                    this.animID = 0;
                }
            }
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
            this.func_70624_b(null);
            if (this.deathTicks == 1 && !this.field_70170_p.field_72995_K) {
                this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
                ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
                if (listp != null && !listp.isEmpty()) {
                    for (int i1 = 0; i1 < listp.size(); ++i1) {
                        Entity entity = (Entity)listp.get(i1);
                        if (entity == null || !(entity instanceof EntityPlayer)) continue;
                        ((EntityPlayer)entity).func_71029_a(this.getAchievement());
                    }
                }
            }
            if (this.deathTicks == 1) {
                this.setAnimTick(1);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.deathTicks >= 300 && this.deathTicks % 10 == 0) {
                int j;
                for (int i = this.func_70693_a(this.field_70717_bb) / 10; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 32.0, this.field_70161_v, j));
                }
            }
            if (this.deathTicks < 300) {
                this.timeSinceIgnited = 0;
            }
            if (this.deathTicks >= 300) {
                if (this.timeSinceIgnited == 1) {
                    this.func_85030_a("thetitans:titanCreeperWarning", Float.MAX_VALUE, 1.0f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    ++this.timeSinceIgnited;
                }
                --this.animTick;
                this.setCreeperState(1);
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 16.0f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 16.0f;
                this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
            }
            if (this.timeSinceIgnited >= this.getThreashHold()) {
                this.deathTicks = 200;
                this.func_70106_y();
            }
        }
    }
}

