/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityWitherTurret;
import net.minecraft.entity.titan.EntityWitherTurretGround;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityIronGolemTitan
extends EntityTitan
implements IBossDisplayData {
    private int homeCheckTimer;
    Village villageObj;
    private int attackTimer;
    private int holdRoseTick;
    private static final IEntitySelector attackEntitySelector = new IEntitySelector(){

        public boolean func_82704_a(Entity p_180027_1_) {
            return !(p_180027_1_ instanceof EntityIronGolemTitan) && !(p_180027_1_ instanceof EntitySnowGolemTitan) && !(p_180027_1_ instanceof EntityWitherTurret) && !(p_180027_1_ instanceof EntityWitherTurretGround);
        }
    };

    @Override
    public int getMinionCap() {
        return 30;
    }

    public EntityIronGolemTitan(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.func_70105_a(12.0f, 44.0f);
        this.field_70138_W = 12.0f;
        this.func_70661_as().func_75491_a(true);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, IMob.field_82192_a));
        EntityIronGolemTitan.addTitanTargetingTaskToEntity(this);
        this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
        this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
        this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
        this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
    }

    public static void addTitanTargetingTaskToEntity(EntityCreature entity) {
        entity.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(entity, EntityTitan.class, 0, false, false, attackEntitySelector));
    }

    public float func_70047_e() {
        return 37.0f;
    }

    @Override
    public void onKillCommand() {
        this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
        this.func_70106_y();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2000.0);
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.GREATER;
    }

    @Override
    protected int func_70682_h(int p_70682_1_) {
        return p_70682_1_;
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.UltimaIronGolemMinionSpawnrate;
    }

    @Override
    public int func_70658_aO() {
        return 24;
    }

    protected void func_70069_a(float p_70069_1_) {
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        super.func_70069_a(p_70069_1_);
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:groundSmash", 20.0f, 0.9f);
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || !this.func_70686_a(entity.getClass()) || entity instanceof EntityTitan) continue;
                    float smash = 50.0f - this.func_70032_d(entity);
                    if (smash <= 1.0f) {
                        smash = 1.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), smash * 4.0f);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.func_70606_j(this.func_110138_aP() / 10.0f);
    }

    @Override
    public boolean shouldMove() {
        double d0 = this.func_70068_e((Entity)this.func_70638_az());
        return d0 < (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 2000.0;
    }

    @Override
    public void func_70636_d() {
        double d0;
        super.func_70636_d();
        if (this.func_70638_az() != null && (d0 = this.func_70068_e((Entity)this.func_70638_az())) < (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 2000.0) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (this.func_70638_az() != null && this.canAttack() && this.func_70638_az() instanceof EntityWitherzilla && (d0 = this.func_70068_e((Entity)this.func_70638_az())) < (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 2000.0) {
            this.func_71038_i();
            this.func_70652_k((Entity)this.func_70638_az());
        }
        if (this.field_70181_x > 1.0) {
            this.field_70181_x = 1.0;
        }
        this.meleeTitan = true;
        this.func_94058_c("\u00a77\u00a7lUltima Iron Golem Titan");
        List list1 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0));
        if (list1 != null && !list1.isEmpty() && this.field_70146_Z.nextInt(60) == 0) {
            for (int i1 = 0; i1 < list1.size(); ++i1) {
                Entity entity = (Entity)list1.get(i1);
                if (entity == null || !(entity instanceof EntityIronGolem) || this.func_70638_az() == null || !(this.func_70638_az().field_70131_O <= 6.0f)) continue;
                ((EntityIronGolem)entity).func_70624_b(this.func_70638_az());
                ((EntityIronGolem)entity).func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                ((EntityIronGolem)entity).func_70605_aq().func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 1.0);
                ((EntityIronGolem)entity).func_70661_as().func_75492_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 1.0);
            }
        }
        if (this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K) {
            EntityIronGolem entitychicken = new EntityIronGolem(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70177_z, 0.0f);
            if (this.isPlayerCreated()) {
                entitychicken.func_70849_f(true);
            }
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2000.0);
            entitychicken.func_70606_j(2000.0f);
            entitychicken.func_94058_c("Reinforced Iron Golem");
            EntityIronGolemTitan.addTitanTargetingTaskToEntity((EntityCreature)entitychicken);
            entitychicken.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
            entitychicken.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.holdRoseTick > 0) {
            --this.holdRoseTick;
        }
    }

    @Override
    protected void func_70619_bc() {
        List list11;
        if (--this.homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
            this.villageObj = this.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 32);
            if (this.villageObj == null) {
                this.func_110177_bN();
            } else {
                ChunkCoordinates chunkcoordinates = this.villageObj.func_75577_a();
                this.func_110171_b(chunkcoordinates.field_71574_a, chunkcoordinates.field_71572_b, chunkcoordinates.field_71573_c, (int)((float)this.villageObj.func_75568_b() * 0.6f));
            }
        }
        if ((list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D)) != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                if (!(entity instanceof EntityLivingBase) || !entity.field_70122_E || entity instanceof EntityTitan || entity instanceof EntityIronGolem) continue;
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                entity.func_70097_a(DamageSourceExtra.causeSquishingDamage((Entity)this), f / 2.0f);
            }
        }
        super.func_70619_bc();
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ == EntityIronGolem.class || p_70686_1_ == EntityIronGolemTitan.class ? false : (this.isPlayerCreated() && EntityPlayer.class.isAssignableFrom(p_70686_1_) ? false : super.func_70686_a(p_70686_1_));
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("PlayerCreated", this.isPlayerCreated());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setPlayerCreated(tagCompund.func_74767_n("PlayerCreated"));
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.func_85030_a("mob.irongolem.throw", 100.0f, 0.5f);
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (p_70652_1_ instanceof EntityWitherzilla) {
            f *= 5.0f;
        }
        for (int i = 0; i < 7 + this.field_70146_Z.nextInt(15); ++i) {
            if (i > 10) {
                this.func_85030_a("thetitans:titanStrike", 20.0f, 1.0f);
                continue;
            }
            this.func_85030_a("thetitans:titanSlam", 20.0f, 1.0f);
        }
        this.attackChoosenEntity(p_70652_1_, f, p_70652_1_ instanceof EntityTitan ? 0 : 1);
        this.func_70671_ap().func_75651_a(p_70652_1_, 180.0f, 30.0f);
        return true;
    }

    @Override
    public float getRegen() {
        return 10.0f;
    }

    @Override
    public int getRegenTime() {
        return 20;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityDragon) {
            this.func_85030_a("thetitans:titanpunch", 10.0f, 1.0f);
            amount *= 30.0f;
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_94541_c()) {
            return false;
        }
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && this.isPlayerCreated()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.attackTimer = 10;
            this.func_85030_a("mob.irongolem.throw", 100.0f, 0.5f);
        } else if (p_70103_1_ == 11) {
            this.holdRoseTick = 800;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public Village getVillage() {
        return this.villageObj;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public void setHoldingRose(boolean p_70851_1_) {
        this.holdRoseTick = p_70851_1_ ? 800 : 0;
        this.field_70170_p.func_72960_a((Entity)this, (byte)11);
    }

    @Override
    protected String func_70621_aR() {
        return "mob.irongolem.hit";
    }

    @Override
    protected String func_70673_aS() {
        return "mob.irongolem.death";
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f;
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("mob.irongolem.walk", 10.0f, 0.5f);
        this.func_85030_a("mob.irongolem.walk", 10.0f, 0.5f);
        this.func_85030_a("mob.irongolem.walk", 10.0f, 0.5f);
        this.func_85030_a("mob.irongolem.walk", 10.0f, 0.5f);
        this.func_85030_a("mob.irongolem.walk", 10.0f, 0.5f);
        this.func_85030_a("mob.irongolem.walk", 10.0f, 0.5f);
        this.func_85030_a("mob.irongolem.walk", 10.0f, 0.5f);
        this.func_85030_a("mob.irongolem.walk", 10.0f, 0.5f);
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
    }

    @Override
    protected float func_70599_aP() {
        return 100.0f;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int l;
        for (l = 64; l < 64 + this.field_70146_Z.nextInt(512 + p_70628_2_); ++l) {
            this.func_70099_a(new ItemStack(Items.field_151042_j), 12.0f);
        }
        for (l = 32; l < 32 + this.field_70146_Z.nextInt(64 + p_70628_2_); ++l) {
            this.func_70099_a(new ItemStack((Block)Blocks.field_150328_O), 12.0f);
        }
        for (l = 0; l < 0 + this.field_70146_Z.nextInt(64 + p_70628_2_); ++l) {
            this.func_70099_a(new ItemStack(Items.field_151166_bC), 12.0f);
        }
        for (l = 0; l < 0 + this.field_70146_Z.nextInt(128 + p_70628_2_); ++l) {
            this.func_70099_a(new ItemStack(Items.field_151045_i), 12.0f);
        }
        for (l = 0; l < 0 + this.field_70146_Z.nextInt(16 + p_70628_2_); ++l) {
            this.func_70099_a(new ItemStack(TitanItems.harcadium), 12.0f);
        }
        for (l = 0; l < 0 + this.field_70146_Z.nextInt(8); ++l) {
            this.func_70099_a(new ItemStack(Blocks.field_150357_h), 12.0f);
        }
    }

    public int getHoldRoseTick() {
        return this.holdRoseTick;
    }

    public boolean isPlayerCreated() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setPlayerCreated(boolean p_70849_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (p_70849_1_) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.isPlayerCreated() && this.field_70717_bb != null && this.villageObj != null) {
            this.villageObj.func_82688_a(this.field_70717_bb.getDisplayName(), -50000);
        }
        super.func_70645_a(cause);
    }
}

