/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.titan.EntitySlimeTitan;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityMagmaCubeTitan
extends EntitySlimeTitan {
    public EntityMagmaCubeTitan(World worldIn) {
        super(worldIn);
        this.shouldParticlesBeUpward = true;
        this.field_70178_ae = true;
    }

    @Override
    protected void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.MagmaCubeTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    @Override
    protected String getSlimeParticle() {
        return "flame";
    }

    @Override
    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityMagmaCube.class && p_70686_1_ != EntityMagmaCubeTitan.class;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(50) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.MagmaCubeTitanMinionSpawnrate;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    @Override
    protected boolean isValidLightLevel() {
        return true;
    }

    @Override
    public boolean func_70058_J() {
        return false;
    }

    @Override
    protected boolean makesSoundOnLand() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    @Override
    protected String func_180487_n() {
        return "flame";
    }

    @Override
    protected EntitySlime createProtoInstance() {
        return new EntityMagmaCube(this.field_70170_p);
    }

    @Override
    protected EntitySlimeTitan createInstance() {
        return new EntityMagmaCubeTitan(this.field_70170_p);
    }

    @Override
    protected Item func_146068_u() {
        return Items.field_151064_bs;
    }

    public boolean func_70027_ad() {
        return false;
    }

    @Override
    protected int getJumpDelay() {
        return super.getJumpDelay() * 4;
    }

    @Override
    protected String func_70673_aS() {
        return "mob.magmacube.jump";
    }

    @Override
    protected void alterSquishAmount() {
        this.squishAmount *= 0.9f;
    }

    @Override
    protected void func_70664_aZ() {
        this.field_70181_x = 4.0 + (double)((float)this.getSlimeSize() * 0.33f);
        this.field_70160_al = true;
        if (this.func_70638_az() != null) {
            double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
            double hor = 1.0 + (double)((float)this.getSlimeSize() * 0.25f);
            this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
            this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
        }
    }

    protected void func_180466_bG() {
        this.field_70181_x = 2.5f + (float)this.getSlimeSize() * 0.05f;
        this.field_70160_al = true;
        if (this.func_70638_az() != null) {
            double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
            double hor = 1.0 + (double)((float)this.getSlimeSize() * 0.25f);
            this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
            this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
        }
    }

    @Override
    protected boolean canDamagePlayer() {
        return true;
    }

    @Override
    protected int getAttackStrength() {
        if (TheTitans.NightmareMode) {
            return this.getSlimeSize() * 150;
        }
        return this.getSlimeSize() * 50;
    }

    @Override
    protected String getJumpSound() {
        return "mob.magmacube.big";
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityMagmaCube || source.func_76346_g() instanceof EntityMagmaCubeTitan) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }
}

