/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityBlazeTitan;
import net.minecraft.entity.titan.EntityCreeperTitan;
import net.minecraft.entity.titan.EntityEnderColossus;
import net.minecraft.entity.titan.EntityGiantSnowball;
import net.minecraft.entity.titan.EntitySilverfishTitan;
import net.minecraft.entity.titan.EntitySkeletonTitan;
import net.minecraft.entity.titan.EntitySlimeTitan;
import net.minecraft.entity.titan.EntitySpiderTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.EntityZombieTitan;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntitySnowGolemTitan
extends EntityTitan
implements IRangedAttackMob {
    public EntitySnowGolemTitan(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.func_70105_a(10.0f, 30.0f);
        this.field_70138_W = 12.0f;
        this.func_70661_as().func_75491_a(true);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityBlazeTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityCreeperTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityEnderColossus.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySilverfishTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySkeletonTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySlimeTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySpiderTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityWitherzilla.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityZombieTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, IMob.field_82192_a));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(60.0);
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.AVERAGE;
    }

    @Override
    public void onKillCommand() {
        this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
        this.func_70106_y();
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        double doub = this.func_70068_e(p_70652_1_);
        if (doub < 600.0) {
            return super.func_70652_k(p_70652_1_);
        }
        return false;
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.SnowGolemMinionSpawnrate;
    }

    @Override
    public float getRegen() {
        return 4.0f;
    }

    @Override
    public int getRegenTime() {
        return 20;
    }

    protected void func_70069_a(float p_70069_1_) {
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        super.func_70069_a(p_70069_1_);
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:groundSmash", 20.0f, 1.0f);
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || entity instanceof EntitySnowman || entity instanceof EntityPlayer || entity instanceof EntityTitan) continue;
                    float smash = 50.0f - this.func_70032_d(entity);
                    if (smash <= 1.0f) {
                        smash = 1.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), smash);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.func_70606_j(this.func_110138_aP() / 10.0f);
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityPlayer.class && p_70686_1_ != EntitySnowman.class && p_70686_1_ != EntitySnowGolemTitan.class;
    }

    @Override
    public void func_70636_d() {
        double d0;
        if (this.func_70638_az() != null && this.field_70173_aa % 30 == 0 && (d0 = this.func_70068_e((Entity)this.func_70638_az())) < 600.0) {
            this.func_71038_i();
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 180.0f, 30.0f);
            this.func_70652_k((Entity)this.func_70638_az());
        }
        if (this.func_70638_az() != null) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 10.0f, 30.0f);
        }
        this.field_70761_aq = this.field_70177_z;
        this.func_94058_c(StatCollector.func_74838_a((String)"entity.SnowManTitan.name"));
        List list1 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(256.0, 256.0, 256.0));
        if (list1 != null && !list1.isEmpty()) {
            for (int i1 = 0; i1 < list1.size(); ++i1) {
                Entity entity = (Entity)list1.get(i1);
                if (entity == null || !(entity instanceof EntitySnowman) || this.func_70638_az() == null) continue;
                ((EntitySnowman)entity).func_70624_b(this.func_70638_az());
                ((EntitySnowman)entity).func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            }
        }
        if (this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && this.field_70173_aa % 20 == 0 && !this.field_70170_p.field_72995_K) {
            this.func_82196_d(this.func_70638_az(), 0.0f);
        }
        if (this.numMinions < this.getMinionCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K) {
            EntitySnowman entitychicken = new EntitySnowman(this.field_70170_p);
            entitychicken.func_70012_b(this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70177_z, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            entitychicken.func_70606_j(20.0f);
            entitychicken.func_94058_c("Reinforced Snow Golem");
            ++this.numMinions;
        }
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.func_70026_G() && this.field_70173_aa % 40 == 0) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
            if (this.field_70170_p.func_72807_a(i, k).func_150564_a(i, j, k) > 1.5f) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
            for (int l = 0; l < 128; ++l) {
                i = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N));
                if (this.field_70170_p.func_147439_a(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N))).func_149688_o() != Material.field_151579_a || !(this.field_70170_p.func_72807_a(i, k).func_150564_a(i, j, k) < 0.8f) || !Blocks.field_150431_aC.func_149742_c(this.field_70170_p, i, j, k)) continue;
                this.field_70170_p.func_147449_b(i, j, k, Blocks.field_150431_aC);
            }
        }
        super.func_70636_d();
    }

    protected Item func_146068_u() {
        return Items.field_151126_ay;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int l;
        this.func_70099_a(new ItemStack(Blocks.field_150428_aP), 12.0f);
        Item item = this.func_146068_u();
        for (l = 48; l < 48 + this.field_70146_Z.nextInt(256 + p_70628_2_); ++l) {
            this.func_70099_a(new ItemStack(item), 12.0f);
        }
        for (l = 0; l < 0 + this.field_70146_Z.nextInt(4 + p_70628_2_); ++l) {
            this.func_70099_a(new ItemStack(Items.field_151166_bC), 12.0f);
        }
        for (l = 0; l < 0 + this.field_70146_Z.nextInt(4 + p_70628_2_); ++l) {
            this.func_70099_a(new ItemStack(Items.field_151045_i), 12.0f);
        }
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.func_70625_a((Entity)p_82196_1_, 180.0f, 30.0f);
        double doub = this.func_70068_e((Entity)p_82196_1_);
        if (doub > 600.0) {
            double d8 = 16.0;
            Vec3 vec3 = this.func_70676_i(1.0f);
            double dx = vec3.field_72450_a * d8;
            double dz = vec3.field_72449_c * d8;
            EntityGiantSnowball entitysnowball = new EntityGiantSnowball(this.field_70170_p, (EntityLivingBase)this);
            double d0 = p_82196_1_.field_70165_t - this.field_70165_t;
            double d1 = p_82196_1_.field_70163_u - this.field_70163_u;
            double d2 = p_82196_1_.field_70161_v - this.field_70161_v;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entitysnowball.func_70186_c(d0, d1 + (double)f1, d2, f1 / 57.295776f * 1.5f, 1.0f);
            this.func_85030_a("random.bow", 10.0f, this.func_70647_i() - 0.5f);
            this.field_70170_p.func_72838_d((Entity)entitysnowball);
            entitysnowball.field_70165_t = this.field_70165_t + vec3.field_72450_a * d8;
            entitysnowball.field_70163_u = this.field_70163_u + d8;
            entitysnowball.field_70161_v = this.field_70161_v + vec3.field_72449_c * d8;
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            if (p_82196_1_ instanceof EntityTitan) {
                this.attackChoosenEntity((Entity)p_82196_1_, 25.0f, 1);
            }
        }
    }

    @Override
    public int func_70658_aO() {
        return 15;
    }

    public float func_70047_e() {
        return 27.2f;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                if (!(entity instanceof EntityLivingBase) || !entity.field_70122_E || entity instanceof EntityTitan || entity instanceof EntitySnowman) continue;
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                entity.func_70097_a(DamageSourceExtra.causeSquishingDamage((Entity)this), f / 2.0f);
            }
        }
    }
}

