/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityCaveSpiderTitan;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntitySkeletonTitan;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanAntiTitanAttack;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanAttack;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanAttack2;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanAttack3;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanDeath;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanIdle;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanShootLightning;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanShootWeb;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanStunned;
import net.minecraft.entity.titan.animation.spidertitan.AnimationSpiderTitanWalk;
import net.minecraft.entity.titanminion.EntityCaveSpiderLoyalist;
import net.minecraft.entity.titanminion.EntitySkeletonLoyalist;
import net.minecraft.entity.titanminion.EntitySkeletonPriest;
import net.minecraft.entity.titanminion.EntitySkeletonTemplar;
import net.minecraft.entity.titanminion.EntitySkeletonZealot;
import net.minecraft.entity.titanminion.EntitySpiderLoyalist;
import net.minecraft.entity.titanminion.EntitySpiderPriest;
import net.minecraft.entity.titanminion.EntitySpiderTemplar;
import net.minecraft.entity.titanminion.EntitySpiderZealot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.theTitans.TitansAchievments;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import thehippomaster.AnimationAPI.AnimationAPI;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntitySpiderTitan
extends EntityTitan
implements IAnimatedEntity,
IEntityMultiPart {
    public int damageToLegs;
    public boolean isAttacking;
    public boolean isStunned;
    public EntityDragonPart[] partArray;
    public EntityDragonPart head = new EntityDragonPart((IEntityMultiPart)this, "head", 8.0f, 8.0f);
    public EntityDragonPart thorax = new EntityDragonPart((IEntityMultiPart)this, "thorax", 6.0f, 6.0f);
    public EntityDragonPart abdomen = new EntityDragonPart((IEntityMultiPart)this, "abdomen", 12.0f, 8.0f);
    public EntityDragonPart rightlegs = new EntityDragonPart((IEntityMultiPart)this, "rightlegs", 12.0f, 8.0f);
    public EntityDragonPart leftlegs = new EntityDragonPart((IEntityMultiPart)this, "leftlegs", 12.0f, 8.0f);

    public EntitySpiderTitan(World worldIn) {
        super(worldIn);
        this.partArray = new EntityDragonPart[]{this.head, this.thorax, this.abdomen, this.rightlegs, this.leftlegs};
        this.setTitanHealth(this.func_110138_aP());
        this.field_70138_W = 8.0f;
        this.func_70105_a(28.0f, 14.0f);
        this.field_70728_aV = 12000 + this.getExtraPower() * 500;
        this.field_70178_ae = true;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityIronGolemTitan.class, 0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntitySnowGolemTitan.class, 0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanDeath(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanAttack3(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanStunned(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanShootWeb(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanShootLightning(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanAntiTitanAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanAttack2(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanWalk(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationSpiderTitanIdle(this));
    }

    @Override
    protected void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SpiderTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan(this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntitySpiderLoyalist.class && (p_70686_1_ == EntityCaveSpiderTitan.class || p_70686_1_ != EntitySpiderTitan.class);
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(25) == 0 && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }

    @Override
    public int getMinionSpawnRate() {
        return TheTitans.SpiderTitanMinionSpawnrate;
    }

    @Override
    public int getMinionCap() {
        return 160;
    }

    @Override
    public int getPriestCap() {
        return 80;
    }

    @Override
    public int getZealotCap() {
        return 40;
    }

    @Override
    public int getTemplarCap() {
        return 7;
    }

    @Override
    public int getRegenTime() {
        return 30;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("DamageToLegs", 99)) {
            this.damageToLegs = tagCompund.func_74762_e("DamageToLegs");
        }
        this.isStunned = tagCompund.func_74767_n("Stunned");
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("DamageToLegs", this.damageToLegs);
        tagCompound.func_74757_a("Stunned", this.isStunned);
    }

    public void func_82206_m() {
        this.setInvulTime(860);
        this.setTitanHealth(this.func_110138_aP() / 10.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
        if (this.animID != 0) {
            ++this.animTick;
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(60.0);
    }

    @Override
    public boolean canBeHurtByPlayer() {
        return this.isStunned && !this.func_85032_ar();
    }

    @Override
    public boolean canAttack() {
        return false;
    }

    protected String func_70639_aQ() {
        return this.isStunned ? null : "thetitans:titanSpiderLiving";
    }

    @Override
    protected String func_70621_aR() {
        return "thetitans:titanSpiderGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return "thetitans:titanSpiderDeath";
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        return false;
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.5f);
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.5f);
    }

    public void collideWithEntities(EntityDragonPart part, List p_70970_1_) {
        double d0 = (part.field_70121_D.field_72340_a + part.field_70121_D.field_72336_d) / 2.0;
        double d1 = (part.field_70121_D.field_72339_c + part.field_70121_D.field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityTitan || entity instanceof EntityTitanSpirit || !this.func_70686_a(entity.getClass()) || !entity.func_70067_L()) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 3.0, 0.5, d3 / d4 * 3.0);
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 10.0f);
        }
    }

    @Override
    public boolean shouldMove() {
        return this.animID != 3 && this.animID != 4 && this.animID != 5 && this.animID != 6 && this.animID != 7 && this.animID != 8 && this.animID != 9 && !this.isStunned && this.func_70638_az() != null ? super.shouldMove() : false;
    }

    @Override
    public double getSpeed() {
        return 0.6 + (double)this.getExtraPower() * 0.005;
    }

    @Override
    public void func_70636_d() {
        if (this.animID == 0) {
            this.isAttacking = false;
        }
        this.meleeTitan = true;
        if (this.animID == 10) {
            if (this.animTick == 80 || this.animTick == 220) {
                this.func_85030_a("thetitans:titanFall", 20.0f, 1.0f);
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
                this.collideWithEntities(this.leftlegs, this.field_70170_p.func_72839_b((Entity)this, this.leftlegs.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
                this.collideWithEntities(this.rightlegs, this.field_70170_p.func_72839_b((Entity)this, this.rightlegs.field_70121_D.func_72314_b(16.0, 1.0, 16.0)));
            }
            if (this.animTick == 420) {
                this.isStunned = false;
            } else {
                this.func_70624_b(null);
            }
        }
        if (this.animID == 8) {
            if (this.animTick == 58) {
                this.func_85030_a("thetitans:largeFall", 8.0f, 0.9f);
                this.func_85030_a("thetitans:titanFall", 10.0f, 1.0f);
            }
            if (this.animTick == 60) {
                this.func_85030_a("thetitans:distantLargeFall", 10000.0f, 1.0f);
            }
            if (this.animTick == 420) {
                this.isStunned = false;
            } else {
                this.func_70624_b(null);
            }
        }
        if (this.isStunned) {
            this.func_70624_b(null);
            AnimationAPI.sendAnimPacket(this, 8);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.isStunned) {
            this.collideWithEntities(this.rightlegs, this.field_70170_p.func_72839_b((Entity)this, this.rightlegs.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.leftlegs, this.field_70170_p.func_72839_b((Entity)this, this.leftlegs.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
            this.collideWithEntities(this.head, this.field_70170_p.func_72839_b((Entity)this, this.head.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
        }
        this.destroyBlocksInAABB(this.head.field_70121_D);
        this.destroyBlocksInAABB(this.thorax.field_70121_D);
        this.destroyBlocksInAABB(this.abdomen.field_70121_D);
        this.destroyBlocksInAABB(this.rightlegs.field_70121_D);
        this.destroyBlocksInAABB(this.leftlegs.field_70121_D);
        if (this.animID == 3 || this.animID == 4 || this.animID == 5 || this.animID == 6 || this.animID == 7 || this.animID == 8 || this.animID == 9 || this.isStunned || this.isAttacking) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (this.field_70173_aa % 20 == 0 && this.animID != 3 && this.animID != 4 && this.animID != 5 && this.animID != 6 && this.animID != 7 && this.animID != 8 && this.animID != 9 && this.animID != 10) {
            this.isAttacking = false;
        }
        if (this.animID == 2 && this.field_70122_E && (this.animTick == 7 || this.animTick == 12 || this.animTick == 17 || this.animTick == 22)) {
            this.func_85030_a("thetitans:titanStep", 10.0f, 1.5f);
            this.func_85030_a("thetitans:titanStep", 10.0f, 1.5f);
        }
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        if (!AnimationAPI.isEffectiveClient() && this.func_70638_az() != null && !this.isStunned && this.getAnimID() == 0) {
            double d0 = this.func_70068_e((Entity)this.func_70638_az());
            if (d0 < (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 25.0) {
                if (this.getAnimID() == 0) {
                    this.isAttacking = true;
                    if (this.func_70638_az() instanceof EntityTitan || this.func_70638_az().field_70131_O >= 6.0f || this.field_70163_u + (double)this.func_70047_e() < this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e()) {
                        AnimationAPI.sendAnimPacket(this, 4);
                        this.setAnimID(4);
                    } else {
                        switch (this.field_70146_Z.nextInt(3)) {
                            case 0: {
                                if (this.func_70681_au().nextInt(3) == 0) {
                                    AnimationAPI.sendAnimPacket(this, 3);
                                    this.setAnimID(3);
                                    break;
                                }
                                AnimationAPI.sendAnimPacket(this, 5);
                                this.setAnimID(5);
                                break;
                            }
                            case 1: {
                                AnimationAPI.sendAnimPacket(this, 9);
                                this.setAnimID(9);
                                break;
                            }
                            case 2: {
                                AnimationAPI.sendAnimPacket(this, 5);
                                this.setAnimID(5);
                            }
                        }
                    }
                }
            } else if (this.getAnimID() == 0 && this.func_70681_au().nextInt(120) == 0) {
                this.isAttacking = true;
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        AnimationAPI.sendAnimPacket(this, 6);
                        this.setAnimID(6);
                        break;
                    }
                    case 1: {
                        AnimationAPI.sendAnimPacket(this, 7);
                        this.setAnimID(7);
                    }
                }
            }
        }
        if (this.field_70146_Z.nextInt(100) == 0 && this.func_70638_az() != null && !this.isStunned && this.field_70122_E && this.animID != 3 && this.animID != 4 && this.animID != 5 && this.animID != 6 && this.animID != 7 && this.animID != 8 && this.animID != 9) {
            this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 180.0f);
            double d01 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d11 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f21 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11));
            double hor = 3.0;
            double ver = 1.5;
            this.field_70159_w = d01 / (double)f21 * hor * hor + this.field_70159_w * hor;
            this.field_70179_y = d11 / (double)f21 * hor * hor + this.field_70179_y * hor;
            this.field_70181_x = ver;
            if (this.func_70068_e((Entity)this.func_70638_az()) < 1024.0) {
                float f11 = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                int i = this.getKnockbackAmount() * 2;
                this.attackChoosenEntity((Entity)this.func_70638_az(), f11, i);
            }
        }
        if (this.func_70638_az() != null) {
            this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 40.0f);
            if (this.field_70146_Z.nextInt(60) == 0 && this.func_70685_l((Entity)this.func_70638_az())) {
                int k;
                int j;
                int i = MathHelper.func_76128_c((double)(this.func_70638_az().field_70165_t + this.field_70146_Z.nextDouble() * 2.0));
                Block block1 = this.field_70170_p.func_147439_a(i, j = MathHelper.func_76128_c((double)(this.func_70638_az().field_70163_u + this.field_70146_Z.nextDouble() * 2.0)), k = MathHelper.func_76128_c((double)(this.func_70638_az().field_70161_v + this.field_70146_Z.nextDouble() * 2.0)));
                if (block1.func_149688_o() == Material.field_151579_a && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    this.field_70170_p.func_147449_b(i, j, k, Blocks.field_150321_G);
                } else {
                    this.func_70638_az().func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 2));
                }
            }
        }
        if (this.numMinions < this.getMinionCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate()) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntitySpider entitychicken = this.createInstance();
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.75, 0.0);
            entitychicken.func_110161_a((IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
            ++this.numMinions;
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
            }
            if (!(this.createInstance() instanceof EntityCaveSpiderLoyalist) && this.field_70153_n != null && this.field_70153_n instanceof EntitySkeletonTitan && this.field_70146_Z.nextInt(2) == 0) {
                EntitySkeletonLoyalist entitychicken1 = new EntitySkeletonLoyalist(this.field_70170_p);
                entitychicken1.func_70012_b(entitychicken.field_70165_t, entitychicken.field_70163_u, entitychicken.field_70161_v, entitychicken.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entitychicken1);
                entitychicken1.func_110161_a(null);
                entitychicken1.func_70078_a((Entity)entitychicken);
                if (((EntitySkeletonTitan)this.field_70153_n).getSkeletonType() == 1) {
                    entitychicken1.func_82201_a(1);
                    entitychicken1.func_70062_b(0, new ItemStack(Items.field_151052_q));
                    entitychicken1.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                }
            }
        }
        if (this.numPriests < this.getPriestCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 2) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntitySpider entitychicken = this.createBetterInstance();
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.75, 0.0);
            entitychicken.func_110161_a((IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
            ++this.numPriests;
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
            }
            if (!(this.createInstance() instanceof EntityCaveSpiderLoyalist) && this.field_70153_n != null && this.field_70153_n instanceof EntitySkeletonTitan && this.field_70146_Z.nextInt(2) == 0) {
                EntitySkeletonPriest entitychicken1 = new EntitySkeletonPriest(this.field_70170_p);
                entitychicken1.func_70012_b(entitychicken.field_70165_t, entitychicken.field_70163_u, entitychicken.field_70161_v, entitychicken.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entitychicken1);
                entitychicken1.func_110161_a(null);
                entitychicken1.func_70078_a((Entity)entitychicken);
                if (((EntitySkeletonTitan)this.field_70153_n).getSkeletonType() == 1) {
                    entitychicken1.func_82201_a(1);
                    entitychicken1.func_70062_b(0, new ItemStack(Items.field_151052_q));
                    entitychicken1.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                }
            }
        }
        if (this.numZealots < this.getZealotCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 5) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntitySpider entitychicken = this.createEvenBetterInstance();
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.75, 0.0);
            entitychicken.func_110161_a((IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_110161_a((IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
            ++this.numZealots;
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
            }
            if (!(this.createInstance() instanceof EntityCaveSpiderLoyalist) && this.field_70153_n != null && this.field_70153_n instanceof EntitySkeletonTitan && this.field_70146_Z.nextInt(2) == 0) {
                EntitySkeletonZealot entitychicken1 = new EntitySkeletonZealot(this.field_70170_p);
                entitychicken1.func_70012_b(entitychicken.field_70165_t, entitychicken.field_70163_u, entitychicken.field_70161_v, entitychicken.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entitychicken1);
                entitychicken1.func_110161_a(null);
                entitychicken1.func_70078_a((Entity)entitychicken);
                if (((EntitySkeletonTitan)this.field_70153_n).getSkeletonType() == 1) {
                    entitychicken1.func_82201_a(1);
                    entitychicken1.func_70062_b(0, new ItemStack(Items.field_151052_q));
                    entitychicken1.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                }
            }
        }
        if (this.numTemplar < this.getTemplarCap() && this.field_70146_Z.nextInt(this.getMinionSpawnRate() * 10) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            EntitySpider entitychicken = this.createSuperInstance();
            this.teleportEntityRandomly((EntityLivingBase)entitychicken);
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.75, 0.0);
            entitychicken.func_110161_a((IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 4, false));
            Block block = this.field_70170_p.func_147439_a((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v);
            this.field_70170_p.func_72926_e(2001, (int)entitychicken.field_70165_t, (int)entitychicken.field_70163_u, (int)entitychicken.field_70161_v, Block.func_149682_b((Block)block));
            ++this.numTemplar;
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b((int)entitychicken.field_70165_t, (int)(entitychicken.field_70163_u + 1.0), (int)entitychicken.field_70161_v, Blocks.field_150346_d);
            }
            if (!(this.createInstance() instanceof EntityCaveSpiderLoyalist) && this.field_70153_n != null && this.field_70153_n instanceof EntitySkeletonTitan && this.field_70146_Z.nextInt(2) == 0) {
                EntitySkeletonTemplar entitychicken1 = new EntitySkeletonTemplar(this.field_70170_p);
                entitychicken1.func_70012_b(entitychicken.field_70165_t, entitychicken.field_70163_u, entitychicken.field_70161_v, entitychicken.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entitychicken1);
                entitychicken1.func_110161_a(null);
                entitychicken1.func_70078_a((Entity)entitychicken);
                if (((EntitySkeletonTitan)this.field_70153_n).getSkeletonType() == 1) {
                    entitychicken1.func_82201_a(1);
                    entitychicken1.func_70062_b(0, new ItemStack(Items.field_151052_q));
                    entitychicken1.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                }
            }
        }
        super.func_70636_d();
        if (this.createInstance() instanceof EntityCaveSpiderLoyalist) {
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.CaveSpiderTitan.name"));
            if (TheTitans.NightmareMode) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(225.0 + (double)(this.getExtraPower() * 30));
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16000.0 + (double)(this.getExtraPower() * 1600));
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(75.0 + (double)(this.getExtraPower() * 10));
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8000.0 + (double)(this.getExtraPower() * 800));
            }
            float f = this.field_70177_z * (float)Math.PI / 180.0f;
            float f1 = MathHelper.func_76126_a((float)f);
            float f2 = MathHelper.func_76134_b((float)f);
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t - (double)(f1 * 6.3f), this.field_70163_u + 2.8, this.field_70161_v + (double)(f2 * 6.3f), 0.0f, 0.0f);
            this.thorax.func_70071_h_();
            this.thorax.func_70012_b(this.field_70165_t, this.field_70163_u + 3.5, this.field_70161_v, 0.0f, 0.0f);
            this.abdomen.func_70071_h_();
            this.abdomen.func_70012_b(this.field_70165_t + (double)(f1 * 7.0f), this.field_70163_u + 2.8, this.field_70161_v - (double)(f2 * 7.0f), 0.0f, 0.0f);
            this.rightlegs.func_70071_h_();
            this.rightlegs.func_70012_b(this.field_70165_t + (double)(f2 * 7.0f), this.field_70163_u + 0.7, this.field_70161_v + (double)(f1 * 7.0f), 0.0f, 0.0f);
            this.leftlegs.func_70071_h_();
            this.leftlegs.func_70012_b(this.field_70165_t - (double)(f2 * 7.0f), this.field_70163_u + 0.7, this.field_70161_v - (double)(f1 * 7.0f), 0.0f, 0.0f);
            this.func_70105_a(16.0f, 10.0f);
        } else {
            this.head = new EntityDragonPart((IEntityMultiPart)this, "head", 8.0f, 8.0f);
            this.thorax = new EntityDragonPart((IEntityMultiPart)this, "thorax", 6.0f, 6.0f);
            this.abdomen = new EntityDragonPart((IEntityMultiPart)this, "abdomen", 12.0f, 8.0f);
            this.rightlegs = new EntityDragonPart((IEntityMultiPart)this, "rightlegs", 12.0f, 8.0f);
            this.leftlegs = new EntityDragonPart((IEntityMultiPart)this, "leftlegs", 12.0f, 8.0f);
            this.partArray = new EntityDragonPart[]{this.head, this.thorax, this.abdomen, this.rightlegs, this.leftlegs};
            this.func_94058_c(StatCollector.func_74838_a((String)"entity.SpiderTitan.name"));
            if (TheTitans.NightmareMode) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(270.0 + (double)(this.getExtraPower() * 30));
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20000.0 + (double)(this.getExtraPower() * 2000));
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(90.0 + (double)(this.getExtraPower() * 10));
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10000.0 + (double)(this.getExtraPower() * 1000));
            }
            float f = this.field_70177_z * (float)Math.PI / 180.0f;
            float f1 = MathHelper.func_76126_a((float)f);
            float f2 = MathHelper.func_76134_b((float)f);
            this.head.func_70071_h_();
            this.head.func_70012_b(this.field_70165_t - (double)(f1 * 9.0f), this.field_70163_u + 4.0, this.field_70161_v + (double)(f2 * 9.0f), 0.0f, 0.0f);
            this.thorax.func_70071_h_();
            this.thorax.func_70012_b(this.field_70165_t, this.field_70163_u + 5.0, this.field_70161_v, 0.0f, 0.0f);
            this.abdomen.func_70071_h_();
            this.abdomen.func_70012_b(this.field_70165_t + (double)(f1 * 10.0f), this.field_70163_u + 4.0, this.field_70161_v - (double)(f2 * 10.0f), 0.0f, 0.0f);
            this.rightlegs.func_70071_h_();
            this.rightlegs.func_70012_b(this.field_70165_t + (double)(f2 * 10.0f), this.field_70163_u + 1.0, this.field_70161_v + (double)(f1 * 10.0f), 0.0f, 0.0f);
            this.leftlegs.func_70071_h_();
            this.leftlegs.func_70012_b(this.field_70165_t - (double)(f2 * 10.0f), this.field_70163_u + 1.0, this.field_70161_v - (double)(f1 * 10.0f), 0.0f, 0.0f);
            this.func_70105_a(28.0f, 14.0f);
        }
    }

    public EntitySpider createInstance() {
        return new EntitySpiderLoyalist(this.field_70170_p);
    }

    protected EntitySpider createBetterInstance() {
        return new EntitySpiderPriest(this.field_70170_p);
    }

    protected EntitySpider createEvenBetterInstance() {
        return new EntitySpiderZealot(this.field_70170_p);
    }

    protected EntitySpider createSuperInstance() {
        return new EntitySpiderTemplar(this.field_70170_p);
    }

    protected Item func_146068_u() {
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.deathTicks > 0) {
            EntityItem entityitem;
            int l;
            for (l = 0; l < 256 + this.field_70146_Z.nextInt(256 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151007_F));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 32 + this.field_70146_Z.nextInt(32 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151044_h));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 8 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151166_bC));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 8 + this.field_70146_Z.nextInt(8 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151045_i));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 48 + this.field_70146_Z.nextInt(48 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151042_j));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 24 + this.field_70146_Z.nextInt(24 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150321_G));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 24 + this.field_70146_Z.nextInt(24 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Blocks.field_150341_Y));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 36 + this.field_70146_Z.nextInt(36 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151116_aA));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 64 + this.field_70146_Z.nextInt(64 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151070_bp));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 24 + this.field_70146_Z.nextInt(24 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(Items.field_151071_bq));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (l = 0; l < 0 + this.field_70146_Z.nextInt(4 + p_70628_2_); ++l) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), this.field_70163_u + 10.0 + (double)(this.field_70146_Z.nextFloat() * 10.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 12.0f - 6.0f), new ItemStack(TitanItems.harcadiumNugget));
                entityitem.field_145804_b = 40;
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    @Override
    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public boolean func_70687_e(PotionEffect p_70687_1_) {
        return p_70687_1_.func_76456_a() == Potion.field_76436_u.field_76415_H ? false : super.func_70687_e(p_70687_1_);
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean p_70839_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b0);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData p_180482_2_) {
        int i;
        IEntityLivingData p_180482_2_1 = super.func_110161_a(p_180482_2_);
        if (p_180482_2_1 == null) {
            p_180482_2_1 = new GroupData();
            if (this.field_70170_p.field_73012_v.nextFloat() < 0.1f) {
                ((GroupData)p_180482_2_1).func_111104_a(this.field_70170_p.field_73012_v);
            }
        }
        if (p_180482_2_1 instanceof GroupData && (i = ((GroupData)p_180482_2_1).field_111105_a) > 0 && Potion.field_76425_a[i] != null) {
            this.func_70690_d(new PotionEffect(i, Integer.MAX_VALUE));
        }
        return p_180482_2_1;
    }

    public float func_70047_e() {
        return 10.4f;
    }

    protected void func_70069_a(float p_70069_1_) {
        if ((p_70069_1_ = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)p_70069_1_)) <= 0.0f) {
            return;
        }
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f1 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)(p_70069_1_ - 12.0f - f1));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:groundSmash", 20.0f, 1.0f);
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.field_70121_D.func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || !this.func_70686_a(entity.getClass()) || entity instanceof EntityTitan) continue;
                    float smash = 50.0f - this.func_70032_d(entity);
                    if (smash <= 1.0f) {
                        smash = 1.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), smash);
                    double d0 = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
                    double d1 = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_147439_a(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                if (!(entity instanceof EntityLivingBase) || !entity.field_70122_E || entity instanceof EntityTitan) continue;
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                entity.func_70097_a(DamageSourceExtra.causeSquishingDamage((Entity)this), f / 2.0f);
            }
        }
        super.func_70619_bc();
    }

    @Override
    public StatBase getAchievement() {
        if (this.createInstance() instanceof EntityCaveSpider) {
            return TitansAchievments.cavespidertitan;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntitySkeletonTitan) {
            return TitansAchievments.spiderjockeytitan;
        }
        return TitansAchievments.spidertitan;
    }

    @Override
    public void setAnimID(int id) {
        this.animID = id;
    }

    @Override
    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    @Override
    public int getAnimID() {
        return this.animID;
    }

    @Override
    public int getAnimTick() {
        return this.animTick;
    }

    @Override
    protected void onTitanDeathUpdate() {
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
        if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
            ++this.deathTicks;
            AnimationAPI.sendAnimPacket(this, 10);
            this.setAnimID(10);
            this.setTitanHealth(0.0f);
        } else {
            this.func_70097_a(DamageSource.field_76380_i, 25.0f);
            this.setTitanHealth(this.field_70180_af.func_111145_d(5));
            this.func_70606_j(this.field_70180_af.func_111145_d(5));
            this.deathTicks = 0;
            if (this.animID == 10) {
                this.animID = 0;
            }
        }
        this.field_70159_w *= 0.0;
        this.field_70179_y *= 0.0;
        this.func_70624_b(null);
        this.setTitanHealth(0.0f);
        this.func_70606_j(0.0f);
        if (this.deathTicks == 1 && !this.field_70170_p.field_72995_K) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
            if (listp != null && !listp.isEmpty()) {
                for (int i1 = 0; i1 < listp.size(); ++i1) {
                    Entity entity = (Entity)listp.get(i1);
                    if (entity == null || !(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a(this.getAchievement());
                }
            }
        }
        if (this.deathTicks == 1) {
            this.setAnimTick(1);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.deathTicks >= 500 && this.deathTicks % 10 == 0) {
            int j;
            for (int i = this.func_70693_a(this.field_70717_bb) / 10; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 32.0, this.field_70161_v, j));
            }
        }
        if (this.deathTicks >= 500) {
            this.setInvulTime(this.getInvulTime() + 8);
            --this.animTick;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 24.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 12.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 24.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.func_70106_y();
        }
    }

    @Override
    protected void inactDeathAction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                this.func_70628_a(true, 0);
                this.func_82160_b(true, 0);
                this.func_70600_l(1);
            }
            if (this.createInstance() instanceof EntityCaveSpiderLoyalist) {
                EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
                entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entitytitan);
                entitytitan.setVesselHunting(false);
                entitytitan.setSpiritType(2);
            } else {
                EntityTitanSpirit entitytitan = new EntityTitanSpirit(this.field_70170_p);
                entitytitan.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entitytitan);
                entitytitan.setVesselHunting(false);
                entitytitan.setSpiritType(3);
            }
        }
    }

    public boolean attackSpiderFrom(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.isStunned && source.func_76346_g() instanceof EntityPlayer) {
            return false;
        }
        if (this.createInstance() instanceof EntitySpiderLoyalist && (source.func_76346_g() instanceof EntitySpiderLoyalist || this.field_70153_n != null && source.func_76346_g() == this.field_70153_n && this.field_70153_n instanceof EntitySkeletonTitan || source.func_76346_g() instanceof EntitySpiderTitan && !(source.func_76346_g() instanceof EntityCaveSpiderTitan))) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase && !this.func_85032_ar() && amount > 25.0f) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntitySpiderTitan && !(entity1 instanceof EntityCaveSpiderTitan)) {
                    EntitySpiderTitan entitypigzombie = (EntitySpiderTitan)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.attackSpiderFrom(source, amount);
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public boolean func_70965_a(EntityDragonPart p_70965_1_, DamageSource source, float amount) {
        if (p_70965_1_ != this.head) {
            amount /= 3.0f;
        }
        this.func_82195_e(source, amount);
        if (source.func_76346_g() instanceof EntityPlayer && source.func_76357_e() && this.damageToLegs < 8 && !this.isStunned && (p_70965_1_ == this.leftlegs || p_70965_1_ == this.rightlegs)) {
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i());
            ++this.damageToLegs;
            this.func_70057_ab();
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            this.func_70604_c((EntityLivingBase)source.func_76346_g());
            if (this.damageToLegs >= 8) {
                this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
                this.isStunned = true;
                this.damageToLegs = 0;
            }
        }
        return true;
    }

    protected boolean func_82195_e(DamageSource p_82195_1_, float p_82195_2_) {
        return this.attackSpiderFrom(p_82195_1_, p_82195_2_);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public static class GroupData
    implements IEntityLivingData {
        public int field_111105_a;

        public void func_111104_a(Random p_111104_1_) {
            int i = p_111104_1_.nextInt(5);
            if (i <= 1) {
                this.field_111105_a = Potion.field_76424_c.field_76415_H;
            } else if (i <= 2) {
                this.field_111105_a = Potion.field_76420_g.field_76415_H;
            } else if (i <= 3) {
                this.field_111105_a = Potion.field_76428_l.field_76415_H;
            } else if (i <= 4) {
                this.field_111105_a = Potion.field_76441_p.field_76415_H;
            }
        }
    }
}

