/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityGhastTitan;
import net.minecraft.entity.titan.EntityIronGolemTitan;
import net.minecraft.entity.titan.EntitySlimeTitan;
import net.minecraft.entity.titan.EntitySnowGolemTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.EntityUltimaBlade;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.EnumTitanStatus;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAITitanLookIdle;
import net.minecraft.entity.titan.ai.EntityAITitanWatchClosest;
import net.minecraft.entity.titanminion.EntityDragonMinion;
import net.minecraft.entity.titanminion.EntityWitherMinion;
import net.minecraft.entity.titanminion.EnumMinionType;
import net.minecraft.entity.titanminion.IMinion;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.DamageSourceExtra;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.theTitans.items.ItemHarcadiumArmor;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public abstract class EntityTitan
extends EntityCreature
implements ITitan,
IBossDisplayData {
    public boolean shouldParticlesBeUpward;
    public int deathTicks;
    public boolean isRejuvinating;
    public int animID;
    public int animTick;
    public boolean meleeTitan;
    protected int nextStepDistanceTitan;
    protected int numMinions;
    protected int numPriests;
    protected int numZealots;
    protected int numTemplar;
    protected int numSpecialMinions;
    public static final String[] randomlyGeneratedTitanNames = new String[]{"Gaaos", "Giqdar", "Vofdon", "Qoysus", "Nidbum", "Grimtori", "Gargaros", "Malerappa", "Thorguma", "Rozaldir", "Elzotl", "Lettarr", "Agdall", "Masgami", "Spirirugon", "Leviaragon", "Priros", "Hiplios", "Cacdos", "Udite", "Ycldir", "Koxdis", "Anarju", "Brutavern", "Crysis", "Grieros", "Onyju", "Savagaru", "Elephagora", "Cataclyranda", "Primerax", "Jaxeyr", "Ulbus", "Jihther", "Zixzotl"};

    public EntityTitan(World worldIn) {
        super(worldIn);
        this.setTitanHealth(this.func_110138_aP());
        this.applyEntityAI();
        this.field_70158_ak = true;
        this.nextStepDistanceTitan = 2;
        this.field_70771_an = 30;
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAITitanWatchClosest((EntityLiving)this, EntityTitanSpirit.class, 128.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAITitanWatchClosest((EntityLiving)this, EntityTitan.class, 128.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAITitanWatchClosest((EntityLiving)this, EntityPlayer.class, 128.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAITitanLookIdle((EntityLiving)this));
        this.field_70155_l = 100.0;
        switch (this.getTitanStatus()) {
            case LESSER: {
                this.func_85030_a("thetitans:titanBirth", 100.0f, 1.25f);
                this.func_85030_a("thetitans:titanBirth", 100.0f, 1.25f);
                this.func_85030_a("thetitans:titanBirth", 100.0f, 1.25f);
                this.func_85030_a("thetitans:titanBirth", 100.0f, 1.25f);
                break;
            }
            case AVERAGE: {
                this.func_85030_a("thetitans:titanBirth", 1000.0f, 1.0f);
                this.func_85030_a("thetitans:titanBirth", 1000.0f, 1.0f);
                this.func_85030_a("thetitans:titanBirth", 1000.0f, 1.0f);
                this.func_85030_a("thetitans:titanBirth", 1000.0f, 1.0f);
                break;
            }
            case GREATER: {
                this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
                this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
                this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
                this.func_85030_a("thetitans:titanBirth", 10000.0f, 0.875f);
                break;
            }
            case GOD: {
                this.func_85030_a("thetitans:titanBirth", Float.MAX_VALUE, 0.75f);
                this.func_85030_a("thetitans:titanBirth", Float.MAX_VALUE, 0.75f);
                this.func_85030_a("thetitans:titanBirth", Float.MAX_VALUE, 0.75f);
                this.func_85030_a("thetitans:titanBirth", Float.MAX_VALUE, 0.75f);
            }
        }
    }

    public boolean alreadyHasAName() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Double.MAX_VALUE);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(512.0);
    }

    public void func_70091_d(double p_70091_1_, double p_70091_3_, double p_70091_5_) {
        if (this.field_70145_X) {
            this.field_70121_D.func_72317_d(p_70091_1_, p_70091_3_, p_70091_5_);
            this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
            this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
        } else {
            int k;
            double d11;
            double d10;
            double d12;
            int j;
            this.field_70170_p.field_72984_F.func_76320_a("move");
            this.field_70139_V *= 0.4f;
            double d3 = this.field_70165_t;
            double d4 = this.field_70163_u;
            double d5 = this.field_70161_v;
            double d6 = p_70091_1_;
            double d7 = p_70091_3_;
            double d8 = p_70091_5_;
            AxisAlignedBB axisalignedbb = this.field_70121_D.func_72329_c();
            List list = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D.func_72321_a(p_70091_1_, p_70091_3_, p_70091_5_));
            for (int i = 0; i < list.size(); ++i) {
                p_70091_3_ = ((AxisAlignedBB)list.get(i)).func_72323_b(this.field_70121_D, p_70091_3_);
            }
            this.field_70121_D.func_72317_d(0.0, p_70091_3_, 0.0);
            if (!this.field_70135_K && d7 != p_70091_3_) {
                p_70091_5_ = 0.0;
                p_70091_3_ = 0.0;
                p_70091_1_ = 0.0;
            }
            boolean flag1 = this.field_70122_E || d7 != p_70091_3_ && d7 < 0.0;
            for (j = 0; j < list.size(); ++j) {
                p_70091_1_ = ((AxisAlignedBB)list.get(j)).func_72316_a(this.field_70121_D, p_70091_1_);
            }
            this.field_70121_D.func_72317_d(p_70091_1_, 0.0, 0.0);
            if (!this.field_70135_K && d6 != p_70091_1_) {
                p_70091_5_ = 0.0;
                p_70091_3_ = 0.0;
                p_70091_1_ = 0.0;
            }
            for (j = 0; j < list.size(); ++j) {
                p_70091_5_ = ((AxisAlignedBB)list.get(j)).func_72322_c(this.field_70121_D, p_70091_5_);
            }
            this.field_70121_D.func_72317_d(0.0, 0.0, p_70091_5_);
            if (!this.field_70135_K && d8 != p_70091_5_) {
                p_70091_5_ = 0.0;
                p_70091_3_ = 0.0;
                p_70091_1_ = 0.0;
            }
            if (this.field_70138_W > 0.0f && flag1 && this.field_70139_V < 0.05f && (d6 != p_70091_1_ || d8 != p_70091_5_)) {
                d12 = p_70091_1_;
                d10 = p_70091_3_;
                d11 = p_70091_5_;
                p_70091_1_ = d6;
                p_70091_3_ = this.field_70138_W;
                p_70091_5_ = d8;
                AxisAlignedBB axisalignedbb1 = this.field_70121_D.func_72329_c();
                this.field_70121_D.func_72328_c(axisalignedbb);
                list = this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D.func_72321_a(d6, p_70091_3_, d8));
                for (k = 0; k < list.size(); ++k) {
                    p_70091_3_ = ((AxisAlignedBB)list.get(k)).func_72323_b(this.field_70121_D, p_70091_3_);
                }
                this.field_70121_D.func_72317_d(0.0, p_70091_3_, 0.0);
                if (!this.field_70135_K && d7 != p_70091_3_) {
                    p_70091_5_ = 0.0;
                    p_70091_3_ = 0.0;
                    p_70091_1_ = 0.0;
                }
                for (k = 0; k < list.size(); ++k) {
                    p_70091_1_ = ((AxisAlignedBB)list.get(k)).func_72316_a(this.field_70121_D, p_70091_1_);
                }
                this.field_70121_D.func_72317_d(p_70091_1_, 0.0, 0.0);
                if (!this.field_70135_K && d6 != p_70091_1_) {
                    p_70091_5_ = 0.0;
                    p_70091_3_ = 0.0;
                    p_70091_1_ = 0.0;
                }
                for (k = 0; k < list.size(); ++k) {
                    p_70091_5_ = ((AxisAlignedBB)list.get(k)).func_72322_c(this.field_70121_D, p_70091_5_);
                }
                this.field_70121_D.func_72317_d(0.0, 0.0, p_70091_5_);
                if (!this.field_70135_K && d8 != p_70091_5_) {
                    p_70091_5_ = 0.0;
                    p_70091_3_ = 0.0;
                    p_70091_1_ = 0.0;
                }
                if (!this.field_70135_K && d7 != p_70091_3_) {
                    p_70091_5_ = 0.0;
                    p_70091_3_ = 0.0;
                    p_70091_1_ = 0.0;
                } else {
                    p_70091_3_ = -this.field_70138_W;
                    for (k = 0; k < list.size(); ++k) {
                        p_70091_3_ = ((AxisAlignedBB)list.get(k)).func_72323_b(this.field_70121_D, p_70091_3_);
                    }
                    this.field_70121_D.func_72317_d(0.0, p_70091_3_, 0.0);
                }
                if (d12 * d12 + d11 * d11 >= p_70091_1_ * p_70091_1_ + p_70091_5_ * p_70091_5_) {
                    p_70091_1_ = d12;
                    p_70091_3_ = d10;
                    p_70091_5_ = d11;
                    this.field_70121_D.func_72328_c(axisalignedbb1);
                }
            }
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70170_p.field_72984_F.func_76320_a("rest");
            this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
            this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
            this.field_70123_F = d6 != p_70091_1_ || d8 != p_70091_5_;
            this.field_70124_G = d7 != p_70091_3_;
            this.field_70122_E = d7 != p_70091_3_ && d7 < 0.0;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            this.func_70064_a(p_70091_3_, this.field_70122_E);
            if (d6 != p_70091_1_) {
                this.field_70159_w = 0.0;
            }
            if (d7 != p_70091_3_) {
                this.field_70181_x = 0.0;
            }
            if (d8 != p_70091_5_) {
                this.field_70179_y = 0.0;
            }
            d12 = this.field_70165_t - d3;
            d10 = this.field_70163_u - d4;
            d11 = this.field_70161_v - d5;
            if (this.func_70041_e_() && this.field_70154_o == null) {
                int j1 = MathHelper.func_76128_c((double)this.field_70165_t);
                k = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5 - (double)this.field_70129_M));
                int l = MathHelper.func_76128_c((double)this.field_70161_v);
                Block block = this.field_70170_p.func_147439_a(j1, k, l);
                int i1 = this.field_70170_p.func_147439_a(j1, k - 1, l).func_149645_b();
                if (i1 == 11 || i1 == 32 || i1 == 21) {
                    block = this.field_70170_p.func_147439_a(j1, k - 1, l);
                }
                if (block != Blocks.field_150468_ap) {
                    d10 = 0.0;
                }
                this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a((double)(d12 * d12 + d11 * d11)) * 0.6);
                this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(d12 * d12 + d10 * d10 + d11 * d11)) * 0.6);
                if (this.field_82151_R > (float)this.nextStepDistanceTitan && block.func_149688_o() != Material.field_151579_a) {
                    this.nextStepDistanceTitan = (int)this.field_82151_R + 2;
                    this.func_145780_a(j1, k, l, block);
                    block.func_149724_b(this.field_70170_p, j1, k, l, (Entity)this);
                }
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    public double func_70068_e(Entity p_70068_1_) {
        double d0 = this.field_70165_t - p_70068_1_.field_70165_t;
        double d1 = this.field_70163_u + (double)(this.field_70131_O * 0.5f) - p_70068_1_.field_70163_u;
        double d2 = this.field_70161_v - p_70068_1_.field_70161_v;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void func_70108_f(Entity p_70108_1_) {
        double d1;
        double d0;
        double d2;
        if (p_70108_1_.field_70153_n != this && p_70108_1_.field_70154_o != this && (d2 = MathHelper.func_76132_a((double)(d0 = p_70108_1_.field_70165_t - this.field_70165_t), (double)(d1 = p_70108_1_.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (p_70108_1_ instanceof EntityTitan) {
                this.func_70024_g(-d0, 0.0, -d1);
            }
        }
    }

    public void setTitanHealth(float p_70606_1_) {
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)p_70606_1_, (float)0.0f, (float)this.func_110138_aP())));
        this.field_70180_af.func_75692_b(5, (Object)Float.valueOf(MathHelper.func_76131_a((float)p_70606_1_, (float)0.0f, (float)this.func_110138_aP())));
    }

    public boolean func_70089_S() {
        return !this.field_70128_L && this.field_70180_af.func_111145_d(5) > 0.0f;
    }

    public void func_70606_j(float p_70606_1_) {
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
    }

    public void func_70691_i(float p_70691_1_) {
        if ((p_70691_1_ = ForgeEventFactory.onLivingHeal((EntityLivingBase)this, (float)p_70691_1_)) <= 0.0f) {
            return;
        }
        float f1 = this.func_110143_aJ();
        if (f1 > 0.0f && this.field_70180_af.func_111145_d(5) > 0.0f) {
            this.setTitanHealth(f1 + p_70691_1_);
        }
    }

    protected void func_70665_d(DamageSource p_70665_1_, float p_70665_2_) {
        if (!this.func_85032_ar()) {
            if ((p_70665_2_ = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)p_70665_1_, (float)p_70665_2_)) <= 0.0f) {
                return;
            }
            p_70665_2_ = this.func_70655_b(p_70665_1_, p_70665_2_);
            float f1 = p_70665_2_ = this.func_70672_c(p_70665_1_, p_70665_2_);
            p_70665_2_ = Math.max(p_70665_2_ - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (f1 - p_70665_2_));
            if (p_70665_2_ != 0.0f) {
                float f2 = this.func_110143_aJ();
                this.setTitanHealth(f2 - p_70665_2_);
                this.func_110142_aN().func_94547_a(p_70665_1_, f2, p_70665_2_);
                this.func_110149_m(this.func_110139_bj() - p_70665_2_);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 2) {
            this.field_70721_aZ = 1.5f;
            this.field_70172_ad = this.field_70771_an;
            this.field_70738_aO = 10;
            this.field_70737_aN = 10;
            this.field_70739_aP = 0.0f;
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_70097_a(DamageSource.field_76377_j, 0.0f);
        } else if (p_70103_1_ == 3) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.setTitanHealth(0.0f);
            this.func_70645_a(DamageSource.field_76377_j);
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public void func_70106_y() {
        if (this.deathTicks > 0 && this.field_70180_af.func_111145_d(5) <= 0.0f) {
            this.inactDeathAction();
            ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
            if (!(listp == null || listp.isEmpty() || this.field_70170_p.field_72995_K || this instanceof EntitySlimeTitan || this instanceof EntityIronGolemTitan || this instanceof EntitySnowGolemTitan)) {
                for (int i1 = 0; i1 < listp.size(); ++i1) {
                    Entity entity = (Entity)listp.get(i1);
                    if (entity == null || !(entity instanceof EntityPlayer)) continue;
                    this.func_70642_aH();
                    ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(this.func_70005_c_() + ": I will return, " + entity.func_70005_c_()));
                }
            }
            super.func_70106_y();
        }
    }

    protected void inactDeathAction() {
        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v, 0.0f, false, false);
    }

    protected void applyEntityAI() {
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70624_b(EntityLivingBase p_70624_1_) {
        if (!this.func_85032_ar() && p_70624_1_ != null && p_70624_1_.func_70089_S() && this.func_70686_a(p_70624_1_.getClass()) && p_70624_1_ != this.field_70154_o) {
            super.func_70624_b(p_70624_1_);
        } else {
            super.func_70624_b(null);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(5, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(21, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(22, (Object)new Integer(0));
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
        this.setExtraPower(tagCompund.func_74762_e("ExtraPower"));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
        tagCompound.func_74768_a("ExtraPower", this.getExtraPower());
    }

    public int getMinionCap() {
        return 100;
    }

    public int getPriestCap() {
        return 40;
    }

    public int getZealotCap() {
        return 15;
    }

    public int getTemplarCap() {
        return 6;
    }

    public int getSpecialMinionCap() {
        return 6;
    }

    public int getExtraPower() {
        return this.field_70180_af.func_75679_c(21);
    }

    public void setExtraPower(int p_82215_1_) {
        this.field_70180_af.func_75692_b(21, (Object)p_82215_1_);
    }

    public int getRandomName() {
        return this.field_70180_af.func_75679_c(21);
    }

    public void setRandomName(int p_82215_1_) {
        this.field_70180_af.func_75692_b(21, (Object)p_82215_1_);
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        if (!this.field_70170_p.field_72995_K) {
            if (p_82215_1_ < 0) {
                this.field_70180_af.func_75692_b(20, (Object)0);
            } else {
                this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
                this.field_70125_A = 0.0f + (float)p_82215_1_ / 4.8f + (0.01f + 0.01f * MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.25f))) * (float)Math.PI;
                this.field_70721_aZ += 1.0f;
            }
        }
    }

    public boolean destroyBlocksInAABBGriefingBypass(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = this.field_70170_p.func_147439_a(k1, l1, i2);
                    Block blockextra = this.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block.isAir((IBlockAccess)this.field_70170_p, k1, l1, i2) || this.field_70170_p.field_72995_K || !this.func_70089_S()) continue;
                    if (block.func_149712_f(this.field_70170_p, k1, l1, i2) != -1.0f) {
                        flag1 = this.field_70170_p.func_147468_f(k1, l1, i2) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        return flag;
    }

    public boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = this.field_70170_p.func_147439_a(k1, l1, i2);
                    Block blockextra = this.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block.isAir((IBlockAccess)this.field_70170_p, k1, l1, i2) || this.field_70170_p.field_72995_K || !this.func_70089_S()) continue;
                    if (block.func_149712_f(this.field_70170_p, k1, l1, i2) != -1.0f && !block.func_149688_o().func_76224_d() && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") || block.func_149712_f(this.field_70170_p, k1, l1, i2) != -1.0f && TheTitans.NightmareMode) {
                        flag1 = (!(block.func_149712_f(this.field_70170_p, k1, l1, i2) > -1.0f) || !(block.func_149712_f(this.field_70170_p, k1, l1, i2) <= 1.0f) ? this.field_70170_p.func_147480_a(k1, l1, i2, true) : this.field_70170_p.func_147468_f(k1, l1, i2)) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        return flag;
    }

    public boolean func_70104_M() {
        return false;
    }

    public int func_70658_aO() {
        if (this.getTitanStatus() == EnumTitanStatus.GOD) {
            return 24;
        }
        if (this.getTitanStatus() == EnumTitanStatus.GREATER) {
            return 22;
        }
        if (this.getTitanStatus() == EnumTitanStatus.AVERAGE) {
            return 21;
        }
        return 20;
    }

    public int func_70641_bl() {
        return 1;
    }

    public float func_70603_bj() {
        return 16.0f;
    }

    public void func_70690_d(PotionEffect p_70690_1_) {
    }

    protected float func_70599_aP() {
        return 100.0f;
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    public int func_70627_aG() {
        return 200;
    }

    public int getMaxFallHeight() {
        return 20;
    }

    public void func_70110_aj() {
    }

    public int getMinionSpawnRate() {
        return 0;
    }

    public boolean func_70072_I() {
        return !(this instanceof EntityWitherzilla) ? false : super.func_70072_I();
    }

    public boolean func_70058_J() {
        return !(this instanceof EntityWitherzilla) ? false : super.func_70058_J();
    }

    protected int func_70682_h(int p_70682_1_) {
        int j = EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        return j > 0 && this.field_70146_Z.nextInt(j + 10) > 0 ? p_70682_1_ : p_70682_1_ - 1;
    }

    public double getSpeed() {
        return 0.35;
    }

    public void func_70636_d() {
        double d0;
        if (TheTitans.TitansFFAMode && this.field_70154_o != null) {
            this.field_70154_o = null;
        }
        if (this.animID < 0) {
            this.animID = 0;
        }
        if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
            this.onTitanDeathUpdate();
        } else {
            this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
            this.deathTicks = 0;
            if (this.animID == 10) {
                this.animID = 0;
            }
        }
        if (this.field_70163_u > 300.0) {
            this.field_70181_x = 0.0;
            this.func_70107_b(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 32.0f - 16.0f), 60.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 32.0f - 16.0f));
        }
        if (this.field_70146_Z.nextInt(60) == 0) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        }
        if (this.field_70163_u <= 0.0) {
            this.func_70107_b(this.field_70165_t, 0.0, this.field_70161_v);
            this.field_70122_E = true;
            this.field_70160_al = false;
            this.field_70143_R = 0.0f;
            if (this.field_70181_x < 0.0) {
                this.field_70181_x = 0.0;
            }
        }
        if (this.numMinions < 0) {
            this.numMinions = 0;
        }
        if (this.numPriests < 0) {
            this.numPriests = 0;
        }
        if (this.numZealots < 0) {
            this.numZealots = 0;
        }
        if (this.numTemplar < 0) {
            this.numTemplar = 0;
        }
        if (this.numSpecialMinions < 0) {
            this.numSpecialMinions = 0;
        }
        if (this.func_110143_aJ() <= 0.0f && this.field_70181_x > 0.0) {
            this.field_70181_x = 0.0;
        }
        if (this.animTick < 0) {
            this.animTick = 0;
        }
        this.field_70134_J = false;
        this.field_110153_bc = 2.1474836E9f;
        this.field_70138_W = this.field_70131_O / 2.0f;
        this.func_82168_bl();
        this.field_70158_ak = true;
        if (this.meleeTitan && this.func_70638_az() != null && this.shouldMove() && this.field_70122_E && !this.field_70170_p.field_72995_K) {
            d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.field_70159_w = d0 / (double)f2 * this.getSpeed() * this.getSpeed() + this.field_70159_w;
            this.field_70179_y = d1 / (double)f2 * this.getSpeed() * this.getSpeed() + this.field_70179_y;
        }
        if (this.meleeTitan && this.func_70638_az() != null && this.animID == 0) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 5.0f, (float)this.func_70646_bf());
        }
        if (this.field_70159_w != 0.0 && this.field_70179_y != 0.0 && this.field_70122_E) {
            EntityPlayer entity;
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)(this.field_70165_t + (this.field_70146_Z.nextDouble() * (double)this.field_70130_N - (double)(this.field_70130_N / 2.0f))));
            Block block = this.field_70170_p.func_147439_a(i, j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), k = MathHelper.func_76128_c((double)(this.field_70161_v + (this.field_70146_Z.nextDouble() * (double)this.field_70130_N - (double)(this.field_70130_N / 2.0f)))));
            if (block.func_149688_o() != Material.field_151579_a) {
                this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(i, j, k), this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70121_D.field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
            }
            if ((entity = this.field_70170_p.func_72890_a((Entity)this, 64.0)) != null) {
                entity.field_70159_w += (double)((float)(Math.random() * 0.025 - 0.0125));
                entity.field_70181_x += (double)((float)(Math.random() * 0.025 - 0.0125));
                entity.field_70179_y += (double)((float)(Math.random() * 0.025 - 0.0125));
                EntityPlayer tmp697_695 = entity;
                tmp697_695.field_70125_A += (float)(Math.random() * 1.0 - 0.5);
                EntityPlayer tmp720_718 = entity;
                tmp720_718.field_70177_z += (float)(Math.random() * 1.0 - 0.5);
            }
        }
        super.func_70606_j(this.func_110143_aJ());
        super.func_70636_d();
        if (this.func_70638_az() != null && this.canAttack()) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 180.0f, (float)this.func_70646_bf());
        }
        if (this.func_70638_az() != null && this.field_70173_aa % 30 == 0 && this.canAttack() && (d0 = this.func_70068_e((Entity)this.func_70638_az())) < (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 800.0) {
            this.func_71038_i();
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 180.0f, (float)this.func_70646_bf());
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.func_70652_k((Entity)this.func_70638_az());
        }
        if (this.field_70173_aa % this.getRegenTime() == 0) {
            this.func_70691_i(this.getRegen());
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.func_70691_i(this.getRegen());
            }
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.func_70691_i(this.getRegen());
            }
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.func_70691_i(this.getRegen());
            }
            if (this.field_70146_Z.nextInt(6) == 0) {
                this.func_70691_i(this.getRegen());
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az() == this.field_70154_o || this.func_70638_az() != null && this.func_70638_az() == this.field_70153_n) {
            this.func_70624_b(null);
        }
        if (this.field_70170_p.field_72995_K && this.deathTicks < this.getThreashHold() && !(this instanceof EntityWitherzilla)) {
            int i;
            for (i = 0; i < this.getParticleCount(); ++i) {
                if (this.shouldParticlesBeUpward) {
                    this.field_70170_p.func_72869_a(this.getParticles(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.25, 0.0);
                    continue;
                }
                this.field_70170_p.func_72869_a(this.getParticles(), this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
            }
            if (TheTitans.NightmareMode && this.field_70146_Z.nextInt(20) == 0) {
                for (i = 0; i < 5; ++i) {
                    this.field_70170_p.func_72869_a("largeexplode", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_72869_a("lava", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_72869_a("smoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean canAttack() {
        return this.meleeTitan;
    }

    public boolean shouldMove() {
        double d0 = this.func_70068_e((Entity)this.func_70638_az());
        return this.func_70638_az() != null && !this.meleeTitan && d0 > (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N) + 5000.0 || this.func_70638_az() != null && this.meleeTitan && d0 > (double)(this.field_70130_N * this.field_70130_N + this.func_70638_az().field_70130_N * this.func_70638_az().field_70130_N);
    }

    protected void func_70619_bc() {
        List list11 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        if (list11 != null && !list11.isEmpty()) {
            for (int i1 = 0; i1 < list11.size(); ++i1) {
                Entity entity = (Entity)list11.get(i1);
                this.func_70108_f(entity);
            }
        }
        if (this.field_70146_Z.nextInt(1000) == 0 && this.func_110143_aJ() < this.func_110138_aP() / 20.0f && this.deathTicks <= 0) {
            this.isRejuvinating = true;
            this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
            this.setExtraPower(this.getExtraPower() + 1);
            this.func_70664_aZ();
        }
        if (this.isRejuvinating) {
            this.setInvulTime(this.getInvulTime() + 5);
            this.func_70057_ab();
            if (this.getInvulTime() > 875) {
                this.isRejuvinating = false;
            }
        }
        if (this.getInvulTime() > 0) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, this.field_70131_O, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_82739_e(1013, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                this.destroyBlocksInAABB(this.field_70121_D);
            }
            this.setInvulTime(i);
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(2.0, 2.0, 2.0));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (!(entity instanceof EntityUltimaBlade)) continue;
                    entity.func_70106_y();
                }
            }
            if (this.field_70173_aa % 1 == 0) {
                this.func_70691_i(this.func_110138_aP() / 800.0f);
            }
        } else {
            super.func_70619_bc();
            if (this.func_70638_az() != null && (this.func_70638_az() instanceof EntityAmbientCreature || this.func_70638_az() instanceof EntityAnimal || this.func_70638_az() instanceof EntityWaterMob)) {
                this.func_70638_az().func_70106_y();
            }
        }
    }

    protected EntityLivingBase getMinion() {
        return null;
    }

    protected EntityLivingBase getSecondMinion() {
        return null;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData p_110161_1_) {
        this.setTitanHealth(this.func_110138_aP());
        return p_110161_1_;
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        Entity entity = p_70645_1_.func_76346_g();
        ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
        if (listp != null && !listp.isEmpty() && !this.field_70170_p.field_72995_K) {
            for (int i1 = 0; i1 < listp.size(); ++i1) {
                Entity entityplayer = (Entity)listp.get(i1);
                if (entityplayer == null || !(entityplayer instanceof EntityPlayer) || !(entity instanceof EntityPlayer)) continue;
                ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(this.func_94057_bL() + " has been defeated by " + entity.func_70005_c_()));
            }
        }
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 2.0;
    }

    protected float func_175134_bD() {
        return 1.5f;
    }

    public int getParticleCount() {
        return 3;
    }

    public String getParticles() {
        if (this.getTitanStatus() == EnumTitanStatus.GOD) {
            return "fireworksSpark";
        }
        if (this.getTitanStatus() == EnumTitanStatus.GREATER) {
            return "magicCrit";
        }
        if (this.getTitanStatus() == EnumTitanStatus.AVERAGE) {
            return "crit";
        }
        return "enchantmenttable";
    }

    public int getThreashHold() {
        return 880;
    }

    public float getRegen() {
        return 10.0f;
    }

    public int getRegenTime() {
        return 20;
    }

    public int getKnockbackAmount() {
        if (this.getTitanStatus() == EnumTitanStatus.GOD) {
            return 10;
        }
        if (this.getTitanStatus() == EnumTitanStatus.GREATER) {
            return 4;
        }
        if (this.getTitanStatus() == EnumTitanStatus.AVERAGE) {
            return 2;
        }
        return 1;
    }

    @Override
    public EnumTitanStatus getTitanStatus() {
        return EnumTitanStatus.LESSER;
    }

    protected String func_145776_H() {
        return "game.hostile.swim";
    }

    protected String func_145777_O() {
        return "game.hostile.swim.splash";
    }

    public boolean func_70687_e(PotionEffect p_70687_1_) {
        return p_70687_1_.func_76456_a() == Potion.field_76436_u.field_76415_H || p_70687_1_.func_76456_a() == Potion.field_82731_v.field_76415_H ? false : super.func_70687_e(p_70687_1_);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (amount > 500.0f) {
            amount = 500.0f;
        }
        if (source.func_76346_g() instanceof EntityDragon || source.func_76346_g() instanceof EntityWither || source.func_76346_g() instanceof EntityDragonMinion || source.func_76346_g() instanceof EntityWitherMinion) {
            this.func_85030_a("thetitans:titanpunch", 10.0f, this.func_70631_g_() ? 1.5f : 1.0f);
            amount *= 3.0f;
        }
        if (this.func_85032_ar() || amount <= 20.0f) {
            return false;
        }
        if (entity != null && entity instanceof EntityLivingBase && entity.field_70131_O >= 6.0f && entity.field_70130_N != 9.9f && entity.field_70130_N != 22.0f && !(entity instanceof EntityTitan) && !(entity instanceof EntityDragon) && !(entity instanceof EntityDragonMinion) && !(entity instanceof EntityTameable)) {
            return false;
        }
        if (source == DamageSource.field_76380_i || source == DamageSource.field_76377_j || source == DamageSource.field_82728_o || source == DamageSource.field_76367_g || source == DamageSource.field_76379_h || source == DamageSource.field_82729_p || source == DamageSource.field_76368_d || source == DamageSource.field_82727_n || source == DamageSource.field_76366_f || source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source == DamageSource.field_76371_c || source == DamageSource.field_76369_e || source == DamageSource.field_76376_m) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            this.func_70624_b((EntityLivingBase)entity);
            this.func_70604_c((EntityLivingBase)entity);
            return true;
        }
        return false;
    }

    protected String func_70621_aR() {
        return "game.hostile.hurt";
    }

    protected String func_70673_aS() {
        return "game.hostile.die";
    }

    protected String getFallSoundString(int damageValue) {
        return damageValue > 4 ? "game.hostile.hurt.fall.big" : "game.hostile.hurt.fall.small";
    }

    public void attackChoosenEntity(Entity damagedEntity, float damage, int knockbackAmount) {
        int j;
        if (!this.func_70089_S() || !damagedEntity.func_70089_S()) {
            return;
        }
        if (damagedEntity instanceof EntityPlayer && ((EntityPlayer)damagedEntity).getDisplayName().equals("Umberlla_Ghast") || !this.func_70686_a(damagedEntity.getClass())) {
            return;
        }
        if (damagedEntity instanceof EntityTitanSpirit) {
            this.func_70097_a(DamageSource.field_76380_i, 10.0f);
        }
        if (damagedEntity instanceof EntityDragon) {
            this.field_70170_p.func_72885_a(null, damagedEntity.field_70165_t, damagedEntity.field_70163_u, damagedEntity.field_70161_v, 3.0f, false, false);
        }
        if (!this.field_70170_p.field_72995_K) {
            damagedEntity.field_70172_ad = 0;
        }
        this.field_70761_aq = this.field_70177_z = this.field_70759_as;
        if (damagedEntity.field_70131_O >= 6.0f) {
            damage *= 5.0f;
            damagedEntity.func_85030_a("thetitans:titanpunch", 10.0f, this.func_70631_g_() ? 1.5f : 1.0f);
            damagedEntity.func_85030_a("thetitans:titanpunch", 10.0f, this.func_70631_g_() ? 1.5f : 1.0f);
            damagedEntity.func_85030_a("thetitans:titanpunch", 10.0f, this.func_70631_g_() ? 1.5f : 1.0f);
            damagedEntity.func_85030_a("thetitans:titanpunch", 10.0f, this.func_70631_g_() ? 1.5f : 1.0f);
        }
        if (damagedEntity instanceof EntityPlayer && ((EntityPlayer)damagedEntity).getDisplayName() == "SuperGirlyGamer") {
            damage *= 100.0f;
            damagedEntity.func_85030_a("thetitans:titanpunch", 10.0f, 1.0f);
        }
        if (damagedEntity instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_70694_bm(), (EnumCreatureAttribute)((EntityLivingBase)damagedEntity).func_70668_bt());
            knockbackAmount += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)damagedEntity));
        }
        if (damagedEntity instanceof EntityPlayer) {
            if (!(this.getTitanStatus() != EnumTitanStatus.GREATER && this.getTitanStatus() != EnumTitanStatus.GOD || !((EntityPlayer)damagedEntity).field_71075_bZ.field_75102_a && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL)) {
                damagedEntity.func_70097_a(DamageSource.field_76380_i, damage);
            }
            ItemStack itemstack1 = ((EntityPlayer)damagedEntity).func_82169_q(3);
            ItemStack itemstack2 = ((EntityPlayer)damagedEntity).func_82169_q(2);
            ItemStack itemstack3 = ((EntityPlayer)damagedEntity).func_82169_q(1);
            ItemStack itemstack4 = ((EntityPlayer)damagedEntity).func_82169_q(0);
            if (itemstack4 != null) {
                if (itemstack4.func_77984_f()) {
                    if (itemstack4.func_77973_b() instanceof ItemHarcadiumArmor) {
                        itemstack4.func_77964_b((int)((float)itemstack4.func_77960_j() + damage));
                    } else {
                        itemstack4.func_77964_b((int)((float)itemstack4.func_77960_j() + damage * 500.0f));
                    }
                    if (itemstack4.func_77960_j() >= itemstack4.func_77958_k() || damage >= (float)(itemstack4.func_77958_k() - itemstack4.func_77960_j())) {
                        ((EntityPlayer)damagedEntity).func_70669_a(itemstack4);
                        --itemstack4.field_77994_a;
                        ((EntityPlayer)damagedEntity).func_70062_b(4, (ItemStack)null);
                    }
                } else {
                    ((EntityPlayer)damagedEntity).func_70669_a(itemstack4);
                    --itemstack4.field_77994_a;
                    ((EntityPlayer)damagedEntity).func_70062_b(4, (ItemStack)null);
                }
            }
            if (itemstack3 != null) {
                if (itemstack3.func_77984_f()) {
                    if (itemstack3.func_77973_b() instanceof ItemHarcadiumArmor) {
                        itemstack3.func_77964_b((int)((float)itemstack3.func_77960_j() + damage));
                    } else {
                        itemstack3.func_77964_b((int)((float)itemstack3.func_77960_j() + damage * 500.0f));
                    }
                    if (itemstack3.func_77960_j() >= itemstack3.func_77958_k() || damage >= (float)(itemstack3.func_77958_k() - itemstack3.func_77960_j())) {
                        ((EntityPlayer)damagedEntity).func_70669_a(itemstack3);
                        --itemstack3.field_77994_a;
                        ((EntityPlayer)damagedEntity).func_70062_b(3, (ItemStack)null);
                    }
                } else {
                    ((EntityPlayer)damagedEntity).func_70669_a(itemstack3);
                    --itemstack3.field_77994_a;
                    ((EntityPlayer)damagedEntity).func_70062_b(3, (ItemStack)null);
                }
            }
            if (itemstack1 != null) {
                if (itemstack1.func_77984_f()) {
                    if (itemstack1.func_77973_b() instanceof ItemHarcadiumArmor) {
                        itemstack1.func_77964_b((int)((float)itemstack1.func_77960_j() + damage));
                    } else {
                        itemstack1.func_77964_b((int)((float)itemstack1.func_77960_j() + damage * 500.0f));
                    }
                    if (itemstack1.func_77960_j() >= itemstack1.func_77958_k() || damage >= (float)(itemstack1.func_77958_k() - itemstack1.func_77960_j())) {
                        ((EntityPlayer)damagedEntity).func_70669_a(itemstack1);
                        --itemstack1.field_77994_a;
                        ((EntityPlayer)damagedEntity).func_70062_b(1, (ItemStack)null);
                    }
                } else {
                    ((EntityPlayer)damagedEntity).func_70669_a(itemstack1);
                    --itemstack1.field_77994_a;
                    ((EntityPlayer)damagedEntity).func_70062_b(1, (ItemStack)null);
                }
            }
            if (itemstack2 != null) {
                if (itemstack2.func_77984_f()) {
                    if (itemstack2.func_77973_b() instanceof ItemHarcadiumArmor) {
                        itemstack2.func_77964_b((int)((float)itemstack2.func_77960_j() + damage));
                    } else {
                        itemstack2.func_77964_b((int)((float)itemstack2.func_77960_j() + damage * 500.0f));
                    }
                    if (itemstack2.func_77960_j() >= itemstack2.func_77958_k() || damage >= (float)(itemstack2.func_77958_k() - itemstack2.func_77960_j())) {
                        ((EntityPlayer)damagedEntity).func_70669_a(itemstack2);
                        --itemstack2.field_77994_a;
                        ((EntityPlayer)damagedEntity).func_70062_b(2, (ItemStack)null);
                    }
                } else {
                    ((EntityPlayer)damagedEntity).func_70669_a(itemstack2);
                    --itemstack2.field_77994_a;
                    ((EntityPlayer)damagedEntity).func_70062_b(2, (ItemStack)null);
                }
            }
        }
        if (knockbackAmount > 0 && !(damagedEntity instanceof EntityTitan) && (this.func_70686_a(damagedEntity.getClass()) && !this.field_70170_p.field_72995_K || damagedEntity instanceof EntityPlayer)) {
            this.field_70721_aZ = 3.0f;
            damagedEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70759_as * (float)Math.PI / 180.0f)) * (float)knockbackAmount * 0.25f), (double)knockbackAmount * 0.25, (double)(MathHelper.func_76134_b((float)(this.field_70759_as * (float)Math.PI / 180.0f)) * (float)knockbackAmount * 0.25f));
        }
        if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
            damagedEntity.func_70015_d(j * 4);
        }
        float at = this.getTitanStatus() == EnumTitanStatus.AVERAGE ? 10.0f : (this.getTitanStatus() == EnumTitanStatus.GREATER ? 20.0f : (this.getTitanStatus() == EnumTitanStatus.GOD ? 60.0f : 6.0f));
        if ((((EntityLivingBase)damagedEntity).func_85032_ar() && !(damagedEntity instanceof EntityTitan) || ((EntityLivingBase)damagedEntity).func_70658_aO() > 19 || ((EntityLivingBase)damagedEntity).func_70658_aO() > 19 || (EntityLivingBase)damagedEntity instanceof EntityPlayer && ((EntityPlayer)damagedEntity).field_71075_bZ.field_75102_a || ((EntityLivingBase)damagedEntity).func_70644_a(Potion.field_76429_m)) && !(damagedEntity instanceof EntityTitan) && !(damagedEntity instanceof IMinion) && !(damagedEntity instanceof EntityTameable)) {
            if ((EntityLivingBase)damagedEntity instanceof EntityPlayer) {
                if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
                    this.field_70170_p.field_73013_u = EnumDifficulty.HARD;
                }
                damagedEntity.func_70097_a(DamageSourceExtra.destroy, at);
            } else {
                this.damageBypassEntity((EntityLivingBase)damagedEntity, DamageSourceExtra.destroy, damage);
                if (((EntityLivingBase)damagedEntity).func_110143_aJ() <= damage) {
                    ((EntityLivingBase)damagedEntity).func_70606_j(0.0f);
                }
            }
        } else if (this.func_70668_bt() == EnumCreatureAttribute.UNDEAD && ((EntityLivingBase)damagedEntity).func_70668_bt() == EnumCreatureAttribute.UNDEAD && !(damagedEntity instanceof EntityTitan)) {
            if (damagedEntity instanceof EntityTameable || damagedEntity instanceof EntityPlayer || damagedEntity instanceof IMinion) {
                damagedEntity.func_70097_a(DamageSourceExtra.lightningBolt, damage);
            } else {
                this.damageBypassEntity((EntityLivingBase)damagedEntity, DamageSourceExtra.lightningBolt, damage);
            }
        } else if (damagedEntity.field_70131_O >= 6.0f && !(damagedEntity instanceof EntityTameable) && !(damagedEntity instanceof EntityTitan) && !(damagedEntity instanceof EntityDragon) && !(damagedEntity instanceof EntityDragonMinion) || ((EntityLivingBase)damagedEntity).func_70658_aO() > 9 && !(damagedEntity instanceof EntityPlayer) && !(damagedEntity instanceof EntityTitan) && !(damagedEntity instanceof EntityDragon) && !(damagedEntity instanceof IMinion)) {
            this.damageBypassEntity((EntityLivingBase)damagedEntity, DamageSourceExtra.causeArmorPiercingMobDamage((Entity)this), damage);
            ((EntityLivingBase)damagedEntity).func_70606_j(((EntityLivingBase)damagedEntity).func_110143_aJ() - damage);
            if (((EntityLivingBase)damagedEntity).func_110143_aJ() <= damage) {
                ((EntityLivingBase)damagedEntity).func_70606_j(0.0f);
            }
        } else {
            damagedEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        }
    }

    private void damageBypassEntity(EntityLivingBase entity, DamageSource p_70665_1_, float p_70665_2_) {
        if ((p_70665_2_ = ForgeHooks.onLivingHurt((EntityLivingBase)entity, (DamageSource)p_70665_1_, (float)p_70665_2_)) <= 0.0f) {
            return;
        }
        float f1 = p_70665_2_;
        p_70665_2_ = Math.max(p_70665_2_ - entity.func_110139_bj(), 0.0f);
        this.func_110149_m(entity.func_110139_bj() - (f1 - p_70665_2_));
        if (p_70665_2_ != 0.0f) {
            float f2 = entity.func_110143_aJ();
            entity.func_70606_j(f2 - p_70665_2_);
            entity.func_110142_aN().func_94547_a(p_70665_1_, f2, p_70665_2_);
            entity.func_110149_m(entity.func_110139_bj() - p_70665_2_);
        }
        if (entity.field_70130_N == 22.0f && entity.field_70131_O == 24.0f && entity.func_110143_aJ() <= 2040.0f) {
            entity.func_70645_a(p_70665_1_);
            entity.func_70106_y();
        }
    }

    public boolean canBeHurtByPlayer() {
        return !this.func_85032_ar();
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        this.func_71038_i();
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = this.getKnockbackAmount();
        this.attackChoosenEntity(p_70652_1_, f, i);
        if (p_70652_1_ instanceof EntityMob) {
            ((EntityMob)p_70652_1_).func_70604_c((EntityLivingBase)this);
        }
        this.func_70671_ap().func_75651_a(p_70652_1_, 180.0f, this instanceof EntityGhastTitan ? 180.0f : 30.0f);
        return true;
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, i, j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_72957_l(i, j, k);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            l = this.field_70170_p.func_72957_l(i, j, k);
            this.field_70170_p.field_73008_k = i1;
        }
        return l <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && super.func_70601_bi();
    }

    public void onKillCommand() {
        if (this.getTitanStatus() != EnumTitanStatus.GOD) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            this.func_70106_y();
        }
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public StatBase getAchievement() {
        return null;
    }

    protected void func_70609_aI() {
    }

    protected void onTitanDeathUpdate() {
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)this.field_70180_af.func_111145_d(5), (float)0.0f, (float)this.func_110138_aP())));
        if (this.field_70180_af.func_111145_d(5) <= 0.0f) {
            ++this.deathTicks;
            this.setTitanHealth(0.0f);
        } else {
            this.func_70097_a(DamageSource.field_76380_i, 25.0f);
            this.setTitanHealth(this.field_70180_af.func_111145_d(5));
            this.func_70606_j(this.field_70180_af.func_111145_d(5));
            this.deathTicks = 0;
            if (this.animID == 10) {
                this.animID = 0;
            }
        }
        if (this.deathTicks == 1 && !this.field_70170_p.field_72995_K) {
            this.func_85030_a(this.func_70673_aS(), this.func_70599_aP(), this.func_70647_i());
            ArrayList listp = Lists.newArrayList((Iterable)this.field_70170_p.field_73010_i);
            if (listp != null && !listp.isEmpty()) {
                for (int i1 = 0; i1 < listp.size(); ++i1) {
                    Entity entity = (Entity)listp.get(i1);
                    if (entity == null || !(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a(this.getAchievement());
                }
            }
        }
        if (this.deathTicks == 1 && !this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            int j;
            for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O + 16.0, this.field_70161_v, j));
            }
        }
        this.field_70159_w *= 0.0;
        this.field_70179_y *= 0.0;
        this.field_70177_z = this.field_70759_as = this.field_70146_Z.nextFloat() * 360.0f;
        this.field_70761_aq = this.field_70759_as;
        this.field_70125_A = this.field_70146_Z.nextFloat() * 180.0f - 90.0f;
        this.func_70624_b(null);
        this.func_70057_ab();
        this.func_70656_aK();
        if (this.deathTicks > 400 && !this.field_70170_p.field_72995_K) {
            this.setInvulTime(this.getInvulTime() + 10);
        }
        if (this.getInvulTime() >= this.getThreashHold()) {
            this.func_70106_y();
        }
    }

    public boolean func_85032_ar() {
        return this.getInvulTime() >= 1 || this.deathTicks > 0 ? true : super.func_85032_ar();
    }

    protected boolean teleportEntityRandomly(EntityLivingBase entity) {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 72.0;
        double d1 = this.field_70163_u + (double)this.field_70131_O;
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 72.0;
        return this.teleportEntityTo(entity, d0, d1, d2);
    }

    protected boolean teleportEntityTo(EntityLivingBase entity, double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent(entity, p_70825_1_, p_70825_3_, p_70825_5_, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        entity.field_70165_t = event.targetX;
        entity.field_70163_u = event.targetY;
        entity.field_70161_v = event.targetZ;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)entity.field_70163_u), k = MathHelper.func_76128_c((double)entity.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76220_a()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(entity.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70107_b(d3, d4, d5);
            return false;
        }
        return true;
    }

    public void retractMinionNumFromType(EnumMinionType minionType) {
        if (minionType == EnumMinionType.SPECIAL) {
            --this.numSpecialMinions;
        } else if (minionType == EnumMinionType.PRIEST) {
            --this.numPriests;
        } else if (minionType == EnumMinionType.ZEALOT) {
            --this.numZealots;
        } else if (minionType == EnumMinionType.TEMPLAR) {
            --this.numTemplar;
        } else if (minionType == EnumMinionType.LOYALIST) {
            --this.numMinions;
        }
    }
}

