/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titanminion;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.entity.titan.EntityBlazeTitan;
import net.minecraft.entity.titan.EntityTitan;
import net.minecraft.entity.titan.EntityTitanSpirit;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAIBreakDoorMinion;
import net.minecraft.entity.titan.ai.EntityAINearestTargetTitan;
import net.minecraft.entity.titanminion.EnumMinionType;
import net.minecraft.entity.titanminion.IMinion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.theTitans.TheTitans;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBlazeLoyalist
extends EntityBlaze
implements IMinion {
    public int randomSoundDelay;
    public EntityLiving master;
    private int shootTimer;

    public EntityBlazeLoyalist(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 1.625f);
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75490_c(true);
        this.func_70661_as().func_75495_e(false);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWitherSkull.class, 2.0f, 1.2, 1.75));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTitanSpirit.class, 48.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIBreakDoorMinion((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (TheTitans.TitansFFAMode) {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)this, EntityLivingBase.class, 0, false, false, ITitan.BlazeTitanSorter));
        } else {
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestTargetTitan((EntityCreature)this, EntityLivingBase.class, 0, false, false, ITitan.SearchForAThingToKill));
        }
    }

    protected void func_70069_a(float p_70069_1_) {
        this.field_70701_bs = 0.0f;
        this.field_70702_br = 0.0f;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.master != null && this.master instanceof EntityTitan) {
            ((EntityTitan)this.master).retractMinionNumFromType(this.getMinionType());
        }
    }

    @Override
    public EnumMinionType getMinionType() {
        return EnumMinionType.LOYALIST;
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(26.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean func_70686_a(Class p_70686_1_) {
        return p_70686_1_ != EntityBlazeLoyalist.class && p_70686_1_ != EntityBlazeTitan.class;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityBlazeLoyalist || source.func_76346_g() instanceof EntityBlazeTitan) {
            return false;
        }
        if (source.func_76346_g() != null && this.field_70702_br == 0.0f && this.getMinionType() == EnumMinionType.ZEALOT) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.func_85030_a("thetitans:titanSwing", 1.0f, 2.0f);
            switch (this.field_70146_Z.nextInt(3)) {
                case 0: {
                    this.field_70701_bs = -2.0f;
                    this.func_70060_a(0.0f, -2.0f, 0.99f);
                    this.field_70702_br = 0.01f;
                    break;
                }
                case 1: {
                    this.field_70702_br = 1.0f;
                    this.func_70060_a(1.0f, 0.0f, 0.25f);
                    break;
                }
                case 2: {
                    this.field_70702_br = -1.0f;
                    this.func_70060_a(-1.0f, 0.0f, 0.25f);
                }
            }
            this.func_70664_aZ();
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(32.0, 32.0, 32.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntityBlazeLoyalist) {
                    EntityBlazeLoyalist entitypigzombie = (EntityBlazeLoyalist)entity1;
                    entitypigzombie.func_70624_b((EntityLivingBase)entity);
                    entitypigzombie.func_70604_c((EntityLivingBase)entity);
                    entitypigzombie.randomSoundDelay = this.field_70146_Z.nextInt(40);
                }
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
                this.randomSoundDelay = this.field_70146_Z.nextInt(40);
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        int j = this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151072_bj, 1);
        }
        j = this.field_70146_Z.nextInt(3 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151114_aO, 1);
        }
        if (this.func_70027_ad()) {
            j = this.field_70146_Z.nextInt(2 + p_70628_2_);
            for (k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151072_bj, 1);
            }
        }
        if (this.field_70146_Z.nextInt(60) == 0 || this.func_70027_ad() && this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0) {
            this.func_70099_a(new ItemStack((Block)Blocks.field_150480_ab), 0.0f);
        }
    }

    protected void func_70619_bc() {
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_85030_a(this.func_70621_aR(), this.func_70599_aP(), this.func_70647_i() + 0.25f);
        }
        if (this.field_70123_F && this.master != null) {
            this.field_70181_x = 0.2;
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 256.0) {
            this.func_70605_aq().func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 1.0);
        }
        if (this.func_70638_az() != null) {
            float f = this.func_70638_az().func_70032_d((Entity)this);
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70121_D.field_72338_b + (double)(this.func_70638_az().field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
            if ((double)f < 64.0) {
                if (this.field_70724_aR == 0) {
                    ++this.shootTimer;
                    if (this.shootTimer == 1) {
                        this.field_70724_aR = 60;
                        this.func_70844_e(true);
                    } else if (this.shootTimer <= 4) {
                        this.field_70724_aR = 6;
                    } else {
                        this.field_70724_aR = 100;
                        this.shootTimer = 0;
                        this.func_70844_e(false);
                    }
                    if (this.shootTimer > 1) {
                        float f1 = MathHelper.func_76129_c((float)f) * 0.5f;
                        this.field_70170_p.func_72889_a((EntityPlayer)null, 1009, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                        for (int i = 0; i < 1; ++i) {
                            EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                            entitysmallfireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
                            this.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                        }
                    }
                }
            } else {
                this.func_70605_aq().func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 5.0);
            }
            this.field_70177_z = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
        }
        if (this.master != null) {
            if (this.func_70068_e((Entity)this.master) > 2304.0) {
                this.func_70605_aq().func_75642_a(this.master.field_70165_t, this.master.field_70163_u, this.master.field_70161_v, 2.0);
            }
            if (this.master.func_70638_az() != null && this.master.func_70638_az().field_70131_O < 4.0f) {
                this.func_70624_b(this.master.func_70638_az());
            }
        } else {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0));
            if (list != null && !list.isEmpty()) {
                for (int i1 = 0; i1 < list.size(); ++i1) {
                    Entity entity = (Entity)list.get(i1);
                    if (entity == null || !(entity instanceof EntityBlazeTitan)) continue;
                    this.master = (EntityBlazeTitan)entity;
                }
            }
        }
        super.func_70619_bc();
    }
}

