/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateStateHelper;
import forestry.core.climate.AbsentClimateState;
import forestry.core.climate.ImmutableClimateState;
import forestry.core.climate.MutableClimateState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public final class ClimateStateHelper
implements IClimateStateHelper {
    private static final String TEMPERATURE_NBT_KEY = "TEMP";
    private static final String HUMIDITY_NBT_KEY = "HUMID";
    private static final String ABSENT_NBT_KEY = "ABSENT";
    private static final String MUTABLE_NBT_KEY = "MUTABLE";
    public static final ClimateStateHelper INSTANCE = new ClimateStateHelper();
    public static final IClimateState ZERO_STATE = ImmutableClimateState.MIN;
    public static final float CLIMATE_CHANGE = 0.01f;

    private ClimateStateHelper() {
    }

    public static IClimateState of(float temperature, float humidity, boolean mutable) {
        return INSTANCE.create(temperature, humidity, mutable);
    }

    public static IClimateState of(float temperature, float humidity) {
        return INSTANCE.create(temperature, humidity, false);
    }

    public static IClimateState mutableOf(float temperature, float humidity) {
        return INSTANCE.create(temperature, humidity, true);
    }

    public static boolean isNearTarget(IClimateState state, IClimateState target) {
        return ClimateStateHelper.isNearTarget(ClimateType.HUMIDITY, state, target) && ClimateStateHelper.isNearTarget(ClimateType.TEMPERATURE, state, target);
    }

    public static boolean isNearTarget(ClimateType type, IClimateState state, IClimateState target) {
        float value;
        float targetedValue = target.getClimate(type);
        return targetedValue - 0.01f < (value = state.getClimate(type)) && targetedValue + 0.01f > value;
    }

    public static boolean isZero(IClimateState state) {
        return state.getHumidity() == ZERO_STATE.getHumidity() && state.getTemperature() == ZERO_STATE.getTemperature();
    }

    public static boolean isNearZero(ClimateType type, IClimateState state) {
        return ClimateStateHelper.isNearTarget(type, state, ZERO_STATE);
    }

    public static boolean isZero(ClimateType type, IClimateState state) {
        return state.getClimate(type) == ZERO_STATE.getClimate(type);
    }

    public static boolean isNearZero(IClimateState state) {
        return ClimateStateHelper.isNearTarget(state, ZERO_STATE);
    }

    @Override
    public IClimateState create(float temperature, float humidity) {
        return this.create(temperature, humidity, false);
    }

    @Override
    public IClimateState create(ClimateType type, float value) {
        return this.create(type == ClimateType.TEMPERATURE ? value : 0.0f, type == ClimateType.HUMIDITY ? value : 0.0f);
    }

    @Override
    public IClimateState create(IClimateState climateState) {
        return this.create(climateState, false);
    }

    @Override
    public IClimateState create(IClimateState climateState, boolean mutable) {
        return this.create(climateState.getTemperature(), climateState.getHumidity(), mutable);
    }

    @Override
    public IClimateState create(float temperature, float humidity, boolean mutable) {
        IClimateState state = mutable ? new MutableClimateState(temperature, humidity) : new ImmutableClimateState(temperature, humidity);
        return this.checkState(state);
    }

    @Override
    public IClimateState create(NBTTagCompound compound, boolean mutable) {
        if (compound.func_74767_n(ABSENT_NBT_KEY)) {
            return AbsentClimateState.INSTANCE;
        }
        return this.checkState(this.create(compound.func_74760_g(TEMPERATURE_NBT_KEY), compound.func_74760_g(HUMIDITY_NBT_KEY), mutable));
    }

    @Override
    public IClimateState create(NBTTagCompound compound) {
        return this.create(compound, compound.func_74767_n(MUTABLE_NBT_KEY));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound, IClimateState state) {
        if (state.isPresent()) {
            compound.func_74757_a(ABSENT_NBT_KEY, false);
            compound.func_74776_a(TEMPERATURE_NBT_KEY, state.getTemperature());
            compound.func_74776_a(HUMIDITY_NBT_KEY, state.getHumidity());
            compound.func_74757_a(MUTABLE_NBT_KEY, state instanceof MutableClimateState);
        } else {
            compound.func_74757_a(ABSENT_NBT_KEY, true);
        }
        return compound;
    }

    @Override
    public IClimateState checkState(IClimateState climateState) {
        return !climateState.isPresent() ? this.absent() : climateState;
    }

    @Override
    public IClimateState clamp(IClimateState climateState) {
        if (!climateState.isPresent()) {
            return this.absent();
        }
        float temp = climateState.getTemperature();
        float humid = climateState.getHumidity();
        if (temp > 2.0f || temp < 0.0f || humid > 2.0f || humid < 0.0f) {
            temp = MathHelper.func_76131_a((float)temp, (float)0.0f, (float)2.0f);
            return climateState.setClimate(MathHelper.func_76131_a((float)temp, (float)0.0f, (float)2.0f), MathHelper.func_76131_a((float)humid, (float)0.0f, (float)2.0f));
        }
        return climateState;
    }

    @Override
    public IClimateState absent() {
        return AbsentClimateState.INSTANCE;
    }

    @Override
    public IClimateState min() {
        return ImmutableClimateState.MIN;
    }

    @Override
    public IClimateState max() {
        return ImmutableClimateState.MAX;
    }

    @Override
    public IClimateState zero() {
        return ZERO_STATE;
    }

    @Override
    public IClimateState mutableZero() {
        return this.create(0.0f, 0.0f, true);
    }
}

