/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionImpl;
import com.mathworks.install.InstallOptionProvider;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Product;
import java.util.ArrayList;

public abstract class AbstractInstallOptionProvider
implements InstallOptionProvider {
    private static final int MDCS = 94;
    private static final int MATLAB = 1;
    private static final int MATLAB_COMPILER = 28;
    private static final int LICENSE_MANAGER = 0;
    private static final int MPS = 126;
    private static final int POLYSPACE_BUG_FINDER = 138;

    @Override
    public InstallOption[] getDefaultInstallOptions(Product[] productArray) {
        ArrayList<InstallOption> arrayList = new ArrayList<InstallOption>();
        if (AbstractInstallOptionProvider.containsLicenseManager(productArray)) {
            arrayList.add(new InstallOptionImpl(System.getProperty("user.name"), true, InstallOptionType.LICENSE_SERVICE));
            if (AbstractInstallOptionProvider.containsAnythingOtherThanLicenseManager(productArray)) {
                arrayList.add(new InstallOptionImpl(null, true, InstallOptionType.SERVER_AND_CLIENT_LICENSE_FILE));
            } else {
                arrayList.add(new InstallOptionImpl(null, true, InstallOptionType.SERVER_LICENSE_FILE));
            }
        } else {
            arrayList.add(new InstallOptionImpl(null, true, InstallOptionType.CLIENT_LICENSE_FILE));
        }
        if (!AbstractInstallOptionProvider.containsProduct(productArray, 94) && !AbstractInstallOptionProvider.containsProduct(productArray, 126)) {
            if (AbstractInstallOptionProvider.containsAnythingOtherThanLicenseManager(productArray)) {
                arrayList.add(new InstallOptionImpl("", false, InstallOptionType.DESKTOP_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", this.startMenuShortcutDefaultStatus(productArray), InstallOptionType.START_MENU_SHORTCUT));
            }
            if (AbstractInstallOptionProvider.containsProduct(productArray, 1) || AbstractInstallOptionProvider.containsProduct(productArray, 28)) {
                arrayList.add(AbstractInstallOptionProvider.createSymbolicLinkOption(InstallOptionType.SYMBOLIC_LINK, this.getSymLinkDefault()));
            }
        }
        if (AbstractInstallOptionProvider.containsProduct(productArray, 138)) {
            arrayList.add(new InstallOptionImpl("", false, InstallOptionType.POLYSPACE_BF_SHORTCUT));
            arrayList.add(new InstallOptionImpl("", false, InstallOptionType.POLYSPACE_BF_START_MENU_SHORTCUT));
            arrayList.add(new InstallOptionImpl("", false, InstallOptionType.POLYSPACE_CP_SHORTCUT));
            arrayList.add(new InstallOptionImpl("", false, InstallOptionType.POLYSPACE_CP_START_MENU_SHORTCUT));
        }
        return arrayList.toArray(new InstallOption[arrayList.size()]);
    }

    private boolean startMenuShortcutDefaultStatus(Product[] productArray) {
        return AbstractInstallOptionProvider.containsProduct(productArray, 1) || AbstractInstallOptionProvider.containsProduct(productArray, 138);
    }

    @Override
    public InstallOption getDefaultPreferencesOption() {
        return new InstallOptionImpl(null, false, InstallOptionType.DELETE_PREFERENCES);
    }

    @Override
    public InstallOption[] getUninstallOptions(Product[] productArray) {
        ArrayList<InstallOption> arrayList = new ArrayList<InstallOption>();
        if (AbstractInstallOptionProvider.containsLicenseManager(productArray)) {
            arrayList.add(new InstallOptionImpl(System.getProperty("user.name"), true, InstallOptionType.LICENSE_SERVICE));
        }
        if (!AbstractInstallOptionProvider.containsProduct(productArray, 94) && !AbstractInstallOptionProvider.containsProduct(productArray, 126) && AbstractInstallOptionProvider.containsAnythingOtherThanLicenseManager(productArray)) {
            if (AbstractInstallOptionProvider.containsProduct(productArray, 1)) {
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.DESKTOP_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.START_MENU_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.DELETE_MARKER_FILE));
            }
            if (AbstractInstallOptionProvider.containsProduct(productArray, 1) || AbstractInstallOptionProvider.containsProduct(productArray, 28)) {
                arrayList.add(AbstractInstallOptionProvider.createSymbolicLinkOption(InstallOptionType.SYMBOLIC_LINK, true));
            }
            if (AbstractInstallOptionProvider.containsProduct(productArray, 138)) {
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.POLYSPACE_BF_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.POLYSPACE_BF_START_MENU_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.POLYSPACE_CP_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.POLYSPACE_CP_START_MENU_SHORTCUT));
            }
        }
        return arrayList.toArray(new InstallOption[arrayList.size()]);
    }

    private static InstallOption createSymbolicLinkOption(InstallOptionType installOptionType, boolean bl) {
        InstallOptionImpl installOptionImpl = new InstallOptionImpl(null, bl, installOptionType);
        installOptionImpl.setContext("/usr/local/bin");
        return installOptionImpl;
    }

    private static boolean containsAnythingOtherThanLicenseManager(Product[] productArray) {
        return !AbstractInstallOptionProvider.containsLicenseManager(productArray) || productArray.length > 1;
    }

    private static boolean containsLicenseManager(Product[] productArray) {
        return AbstractInstallOptionProvider.containsProduct(productArray, 0);
    }

    private static boolean containsProduct(Product[] productArray, int n) {
        for (Product product : productArray) {
            if (product.getProductNumber() != n) continue;
            return true;
        }
        return false;
    }

    abstract boolean getSymLinkDefault();
}

