/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.DotNetFramework;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.filefilter.FileFilterUtils;

final class AssemblyFileRegisterer
implements FileProcessor {
    private final DotNetFramework dotNetFramework;
    private final String groupName;
    private final AppLogger appLogger;

    AssemblyFileRegisterer(DotNetFramework dotNetFramework, String string, AppLogger appLogger) {
        this.dotNetFramework = dotNetFramework;
        this.groupName = string;
        this.appLogger = appLogger;
    }

    @Override
    public void processFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("registering assembly " + file.getName() + " in group " + this.groupName);
        if (!this.dotNetFramework.registerAssembly(this.groupName, file)) {
            this.appLogger.logMsg(InstallResourceKeys.REG_ASSEMBLY_ERROR_MESSAGE.getString(file.getAbsolutePath(), this.groupName));
        }
    }

    @Override
    public void undoProcessFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return FileFilterUtils.falseFileFilter();
    }
}

