/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.command.AbstractRegisterUninstaller;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;

final class RegisterUninstallerCommand
extends AbstractRegisterUninstaller {
    private static final String URLINFO_ABOUT_VALUE = "www.mathworks.com";
    private static final String PUBLISHER_VALUE = "The MathWorks, Inc.";
    private static final String HELP_LINK_VALUE = "www.mathworks.com/support";
    private static final String UNINSTALL_VERSION_SUB_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
    private final String appName;
    private final String appVersion;
    private final String appRelease;
    private final String displayName;
    private final String pathToUninstallExe;
    private final String pathToIconFile;

    RegisterUninstallerCommand(Registry registry, String string, String string2, String string3, String string4, String string5, String string6, AppLogger appLogger) {
        super(registry, appLogger);
        this.appName = string;
        this.appVersion = string2;
        this.appRelease = string3;
        this.displayName = string4;
        this.pathToUninstallExe = string5;
        this.pathToIconFile = string6;
    }

    @Override
    protected String getUninstallVersionSubKey() {
        return UNINSTALL_VERSION_SUB_KEY + this.appName + ' ' + this.appRelease;
    }

    @Override
    String getUninstallString(File file) {
        File file2 = RegisterUninstallerCommand.getAbsoluteFile(file, this.getPathToUninstallExe());
        return file2.getAbsolutePath() + " " + file.getAbsolutePath();
    }

    @Override
    String getInstallLocation(File file) {
        return file.getAbsolutePath();
    }

    @Override
    protected String getHelpLink() {
        return HELP_LINK_VALUE;
    }

    @Override
    protected String getPublisher() {
        return PUBLISHER_VALUE;
    }

    @Override
    protected String getURLInfoAbout() {
        return URLINFO_ABOUT_VALUE;
    }

    @Override
    protected String getDisplayVersion() {
        return this.appVersion;
    }

    @Override
    protected String getPathToIconFile() {
        return this.pathToIconFile;
    }

    @Override
    protected String getPathToUninstallExe() {
        return this.pathToUninstallExe;
    }

    @Override
    protected String getDisplayName() {
        return this.displayName;
    }
}

