/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.mathworks.install.ComponentData;
import com.mathworks.install.InputStreamProvider;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.archive.MissingEntryException;
import com.mathworks.install.input.ComponentSource;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.Contents;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.XMLInstallationFileParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.IOUtils;

abstract class AbstractInstallationInputFile
implements InstallationInputFile,
ComponentSourceProvider {
    private final File file;
    private final XMLInstallationFileParser xmlInstallationFileParser;
    private final ComponentSourceFactory componentSourceFactory;
    private Collection<String> componentFiles = new ArrayList<String>();
    private Collection<String> manifests = new ArrayList<String>();

    AbstractInstallationInputFile(File file, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory) {
        this.file = file;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.componentSourceFactory = componentSourceFactory;
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    @Override
    public final ComponentSource getComponentSource(File file, String string, ComponentData componentData) throws IOException {
        if (this.componentFiles.contains(string)) {
            return this.componentSourceFactory.createArchiveComponentSource(this.getInputStream(string));
        }
        if (this.manifests.contains(string)) {
            return this.componentSourceFactory.createManifestComponentSource(this.getInputStream(string));
        }
        throw new MissingEntryException(string);
    }

    protected abstract InputStream getInputStream(String var1) throws IOException;

    @Override
    public long getDownloadSize(long l) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void parse() throws IOException, XMLParseException {
        this.open();
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(this.getContentsEntry());
            Contents contents = this.xmlInstallationFileParser.parseContents(inputStream);
            this.componentFiles.addAll(Arrays.asList(contents.getComponentFiles()));
            this.manifests.addAll(Arrays.asList(contents.getManifests()));
            this.readInDefinitions(contents.getDefinitions());
        }
        catch (MissingEntryException missingEntryException) {
            IOUtils.closeQuietly((InputStream)inputStream);
            this.close();
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                this.close();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        this.close();
    }

    private void readInDefinitions(String[] stringArray) throws IOException, XMLParseException {
        XMLParseException xMLParseException = null;
        for (String string : stringArray) {
            try {
                this.xmlInstallationFileParser.readInDefinition(this.getInputStreamProvider(string), this);
            }
            catch (XMLParseException xMLParseException2) {
                xMLParseException = xMLParseException2;
            }
        }
        if (xMLParseException != null) {
            throw xMLParseException;
        }
    }

    protected abstract InputStreamProvider getInputStreamProvider(String var1);

    protected abstract String getContentsEntry();
}

