/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.CommandContainer;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.Product;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.condition.ArchConditions;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Platform;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

final class CommandContainerImpl
implements CommandContainer {
    private final String sourcePath;
    private final CommandFactory commandFactory;
    private final ServiceFactory serviceFactory;
    private final InstallConfiguration installConfiguration;
    private final IO io;
    private final InstallConfigurationPersistence installConfigurationPersistence;
    private final InstallerRequirements installerRequirements;
    private final Properties properties;
    private final Platform platform;

    CommandContainerImpl(String string, CommandFactory commandFactory, ServiceFactory serviceFactory, InstallConfiguration installConfiguration, IO iO, InstallConfigurationPersistence installConfigurationPersistence, InstallerRequirements installerRequirements, Properties properties, Platform platform) {
        this.sourcePath = string;
        this.commandFactory = commandFactory;
        this.serviceFactory = serviceFactory;
        this.installConfiguration = installConfiguration;
        this.io = iO;
        this.installConfigurationPersistence = installConfigurationPersistence;
        this.installerRequirements = installerRequirements;
        this.properties = properties;
        this.platform = platform;
    }

    @Override
    public Command[] getPreInstallCommands(InstallableProduct ... installableProductArray) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addPreInstallCommandsForConfiguration(arrayList, installableProductArray);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    @Override
    public Command[] getPostInstallCommands(InstallOption[] installOptionArray, InstallableProduct ... installableProductArray) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addRegisterApplicationCommands(arrayList, installableProductArray);
        this.addPostInstallCommandsForConfiguration(arrayList, installableProductArray);
        this.addInstallUninstallerCommands(arrayList, installableProductArray);
        this.addRegisterUninstallerCommands(arrayList, installableProductArray);
        this.addPostInstallPreUninstallCommandsForOptions(installOptionArray, installableProductArray, arrayList);
        this.addPostInstallPostUninstallCommandsForOptions(installOptionArray, installableProductArray, arrayList);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    @Override
    public Command[] getPreUninstallCommands(InstallOption[] installOptionArray, InstallableProduct ... installableProductArray) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addRegisterApplicationCommands(arrayList, installableProductArray);
        this.addPreInstallCommandsForConfiguration(arrayList, installableProductArray);
        this.addPostInstallCommandsForConfiguration(arrayList, installableProductArray);
        this.addPostInstallPreUninstallCommandsForOptions(installOptionArray, installableProductArray, arrayList);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    @Override
    public Command[] getPostUninstallCommands(InstallOption[] installOptionArray, InstallableProduct ... installableProductArray) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addRegisterUninstallerCommands(arrayList, installableProductArray);
        this.addPostUninstallCommandsForConfiguration(arrayList, installableProductArray);
        this.addPostInstallPostUninstallCommandsForOptions(installOptionArray, installableProductArray, arrayList);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    private void addInstallUninstallerCommands(Collection<Command> collection, InstallableProduct[] installableProductArray) {
        Collection<Product> collection2 = CommandContainerImpl.getProductCollection(installableProductArray);
        if (ArchConditions.WINDOWS.isSatisfied(this.platform.getArchString(), collection2)) {
            this.addInstallUninstaller(this.platform.getArchString(), this.sourcePath, collection, this.commandFactory);
        }
    }

    private void addPostInstallCommandsForConfiguration(Collection<Command> collection, InstallableProduct[] installableProductArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.getPostInstallCommands(this.platform.getArchString(), CommandContainerImpl.getProducts(installableProductArray), this.commandFactory, this.serviceFactory, this.io, this.properties)));
    }

    private void addPostUninstallCommandsForConfiguration(Collection<Command> collection, InstallableProduct[] installableProductArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.getPostUninstallCommands(this.platform.getArchString(), CommandContainerImpl.getProducts(installableProductArray), this.commandFactory, this.io)));
    }

    private void addRegisterApplicationCommands(Collection<Command> collection, InstallableProduct[] installableProductArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.createRegisterApplicationCommands(this.platform.getArchString(), CommandContainerImpl.getProducts(installableProductArray), this.commandFactory)));
    }

    private void addPreInstallCommandsForConfiguration(Collection<Command> collection, InstallableProduct[] installableProductArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.getPreInstallCommands(this.platform.getArchString(), CommandContainerImpl.getProducts(installableProductArray), this.commandFactory, this.serviceFactory)));
    }

    private void addRegisterUninstallerCommands(Collection<Command> collection, InstallableProduct[] installableProductArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.createRegisterUninstallerCommands(this.platform.getArchString(), CommandContainerImpl.getProducts(installableProductArray), this.commandFactory, this.installerRequirements)));
    }

    private void addInstallUninstaller(String string, String string2, Collection<Command> collection, CommandFactory commandFactory) {
        IOFileFilter iOFileFilter = FileFilterUtils.fileFileFilter();
        collection.add(commandFactory.createCopyFilesToInstallationCommand(CommandContainerImpl.buildPath(string2, "utils", "uninstall"), CommandContainerImpl.buildPath("uninstall"), (FilenameFilter)iOFileFilter));
        collection.add(commandFactory.createCopyFilesToInstallationCommand(CommandContainerImpl.buildPath(string2, "bin", string), CommandContainerImpl.buildPath("uninstall", "bin", string), (FilenameFilter)FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".ocx"), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".dll"))));
        collection.add(commandFactory.createCopyFilesToInstallationCommand(CommandContainerImpl.buildPath(string2, "utils", "uninstall", "bin", string), CommandContainerImpl.buildPath("uninstall", "bin", string), (FilenameFilter)iOFileFilter));
        collection.add(commandFactory.createCopyFilesToInstallationCommand(CommandContainerImpl.buildPath(string2, "java"), CommandContainerImpl.buildPath("uninstall", "java"), (FilenameFilter)FileFilterUtils.trueFileFilter()));
        collection.add(commandFactory.createWriteInstallConfigurationCommand(this.installConfigurationPersistence, this.installConfiguration));
    }

    private static String buildPath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(File.separator);
        }
        return stringBuilder.toString();
    }

    private static Product[] getProducts(InstallableProduct[] installableProductArray) {
        return CommandContainerImpl.getProductCollection(installableProductArray).toArray(new Product[installableProductArray.length]);
    }

    private static Collection<Product> getProductCollection(InstallableProduct[] installableProductArray) {
        HashSet<Product> hashSet = new HashSet<Product>();
        for (InstallableProduct installableProduct : installableProductArray) {
            hashSet.add(installableProduct.getProductData());
        }
        return hashSet;
    }

    private void addPostInstallPostUninstallCommandsForOptions(InstallOption[] installOptionArray, InstallableProduct[] installableProductArray, Collection<Command> collection) {
        if (installableProductArray.length > 0) {
            for (InstallOption installOption : installOptionArray) {
                this.addPostUninstallCommandsForOption(collection, installableProductArray, installOption);
            }
        }
    }

    private void addPostUninstallCommandsForOption(Collection<Command> collection, InstallableProduct[] installableProductArray, InstallOption installOption) {
        if (installOption.isSelected()) {
            switch (installOption.getType()) {
                case DESKTOP_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createDesktopShortcutCommands(this.platform.getArchString(), this.commandFactory, this.installerRequirements)));
                    break;
                }
                case POLYSPACE_BF_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createDesktopShortcutForPolyspaceBFCommands(this.platform.getArchString(), this.commandFactory, this.installerRequirements)));
                    break;
                }
                case POLYSPACE_BF_START_MENU_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createStartMenuShortcutForPolyspaceBFCommands(this.commandFactory, this.installerRequirements, this.platform)));
                    break;
                }
                case POLYSPACE_CP_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createDesktopShortcutForPolyspaceCPCommands(this.platform.getArchString(), this.commandFactory, this.installerRequirements)));
                    break;
                }
                case POLYSPACE_CP_START_MENU_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createStartMenuShortcutForPolyspaceCPCommands(this.commandFactory, this.installerRequirements, this.platform)));
                    break;
                }
                case START_MENU_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createStartMenuShortcutCommands(this.commandFactory, this.installerRequirements, this.platform)));
                    break;
                }
                case SERVER_LICENSE_FILE: 
                case CLIENT_LICENSE_FILE: 
                case SERVER_AND_CLIENT_LICENSE_FILE: {
                    collection.add(this.commandFactory.createWriteLicenseFileCommand(installOption));
                    break;
                }
                case SYMBOLIC_LINK: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createSymbolicLinkCommands(CommandContainerImpl.getProducts(installableProductArray), this.platform.getArchString(), installOption, this.commandFactory)));
                    break;
                }
                case DELETE_PREFERENCES: {
                    collection.add(this.commandFactory.createDeletePreferencesCommand(installOption));
                    break;
                }
                case DELETE_MARKER_FILE: {
                    collection.add(this.commandFactory.createDeleteMarkerFileCommand());
                    break;
                }
            }
        }
    }

    private void addPostInstallPreUninstallCommandsForOptions(InstallOption[] installOptionArray, InstallableProduct[] installableProductArray, Collection<Command> collection) {
        if (installableProductArray.length > 0) {
            for (InstallOption installOption : installOptionArray) {
                this.addPreUninstallCommandsForOption(collection, installOption);
            }
        }
    }

    private void addPreUninstallCommandsForOption(Collection<Command> collection, InstallOption installOption) {
        if (installOption.isSelected()) {
            switch (installOption.getType()) {
                case LICENSE_SERVICE: {
                    collection.add(this.commandFactory.createInstallLicenseManagerServiceCommand(installOption, this.serviceFactory.createLicenseManagerService()));
                    break;
                }
                case CUSTOM: {
                    collection.addAll(Arrays.asList(installOption.getCommands(this.commandFactory, this.serviceFactory)));
                    break;
                }
            }
        }
    }
}

