/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.mathworks.install.ComponentInstaller;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install.status.InstallStatusObserverAdapter;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.ParentFolderOperation;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class ComponentInstallerImpl
implements ComponentInstaller {
    private final InstalledProductData fileList;
    private final IO ioUtil;
    private final AppLogger logger;
    private final long statusFactor;

    @Inject
    ComponentInstallerImpl(@Named(value="uninstallStatusFactor") Long l, InstalledProductData installedProductData, IO iO, AppLogger appLogger) {
        this.statusFactor = l;
        this.fileList = installedProductData;
        this.ioUtil = iO;
        this.logger = appLogger;
    }

    @Override
    public void installComponents(File file, File file2, InstallableComponent[] installableComponentArray, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        MyInstallStatusObserver myInstallStatusObserver = new MyInstallStatusObserver(file, (FolderUtils)this.ioUtil);
        ArrayList<InstallStatusObserver> arrayList = new ArrayList<InstallStatusObserver>();
        arrayList.addAll(Arrays.asList(installStatusObserverArray));
        arrayList.add(myInstallStatusObserver);
        for (InstallableComponent installableComponent : installableComponentArray) {
            this.installComponent(installableComponent, file, file2, installFlowControlHandler, arrayList.toArray(new InstallStatusObserver[arrayList.size()]));
        }
        myInstallStatusObserver.writeToFileList(installableComponentArray, this.fileList);
    }

    @Override
    public void uninstallComponents(File file, InstallableComponent[] installableComponentArray, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException, IOException {
        for (InstallableComponent installableComponent : installableComponentArray) {
            int n;
            String string = installableComponent.getComponentData().getComponentNameAndVersion();
            Object[] objectArray = installStatusObserverArray;
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                InstallStatusObserver installStatusObserver = objectArray[n];
                installStatusObserver.removeComponent(string);
            }
            Object[] objectArray2 = objectArray = this.fileList.getNonSharedFiles(installableComponent.getComponentData().getComponentNameAndVersion(), file.getAbsolutePath());
            n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray2[i];
                installFlowControlHandler.checkTaskState();
                File file2 = new File((String)object);
                this.ioUtil.deleteFile(file2);
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.removeFile(file2);
                    installStatusObserver.updateUnits(this.statusFactor);
                }
            }
            this.fileList.removeComponent(string, file.getAbsolutePath());
        }
    }

    private void installComponent(InstallableComponent installableComponent, File file, File file2, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException, IOException {
        try {
            installableComponent.install(file, file2, installFlowControlHandler, installStatusObserverArray);
        }
        catch (IOException iOException) {
            String string = InstallResourceKeys.EXTRACT_TITLE.getString(new Object[0]);
            String string2 = InstallResourceKeys.INSTALL_RETRY_MESSAGE.getString(installableComponent.getComponentData().getName(), iOException.getMessage(), this.logger.getPath());
            if (installFlowControlHandler.shouldRetry(string, string2, iOException)) {
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.reset();
                }
                this.installComponent(installableComponent, file, file2, installFlowControlHandler, installStatusObserverArray);
            }
            throw iOException;
        }
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.confirm();
        }
    }

    private static class MyInstallStatusObserver
    extends InstallStatusObserverAdapter {
        private final Map<String, Set<String>> fileListByComponentMap = new HashMap<String, Set<String>>();
        private Set<String> currentComponentFiles;
        private final File destinationFolder;
        private final FolderUtils folderUtils;

        MyInstallStatusObserver(File file, FolderUtils folderUtils) {
            this.destinationFolder = file;
            this.folderUtils = folderUtils;
        }

        @Override
        public void addComponent(String string) {
            this.currentComponentFiles = new LinkedHashSet<String>();
            this.fileListByComponentMap.put(string, this.currentComponentFiles);
        }

        @Override
        public void addFile(File file) {
            final ArrayList arrayList = new ArrayList();
            this.folderUtils.recursivelyOperateOnFileAndParents(file, this.destinationFolder, new ParentFolderOperation(){

                public void execute(File file) {
                    arrayList.add(MyInstallStatusObserver.this.trimOffMatlabRootToConserveMemory(file));
                }
            });
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.currentComponentFiles.add((String)arrayList.get(i));
            }
            String string = this.trimOffMatlabRootToConserveMemory(file);
            this.currentComponentFiles.add(string);
        }

        private String trimOffMatlabRootToConserveMemory(File file) {
            String string;
            String string2 = file.getAbsolutePath();
            String string3 = string2.startsWith(string = this.destinationFolder.getAbsolutePath() + File.separator) ? string2.substring(string.length(), string2.length()) : string2;
            return string3;
        }

        public void writeToFileList(InstallableComponent[] installableComponentArray, InstalledProductData installedProductData) throws IOException {
            for (InstallableComponent installableComponent : installableComponentArray) {
                String string = installableComponent.getComponentData().getName();
                if (!this.fileListByComponentMap.containsKey(string)) continue;
                String string2 = installableComponent.getComponentData().getComponentNameAndVersion();
                installedProductData.installComponentFileData(string2, this.destinationFolder.getAbsolutePath(), installableComponent.getXML());
                Set<String> set = MyInstallStatusObserver.reverseOrder(this.fileListByComponentMap.get(string));
                installedProductData.installFileListData(set, string2, this.destinationFolder.getAbsolutePath());
            }
        }

        private static Set<String> reverseOrder(Set<String> set) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object : set) {
                arrayList.add(object);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Collections.reverse(arrayList);
            for (String string : arrayList) {
                linkedHashSet.add(string);
            }
            return linkedHashSet;
        }
    }
}

