/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.Product;
import com.mathworks.install.ValidatedFik;
import java.util.Collection;
import java.util.HashSet;

final class ValidatedFikImpl
implements ValidatedFik {
    private final String fik;
    private final boolean isDemo;
    private final boolean isNetwork;
    private final Collection<Integer> productNumberCollection = new HashSet<Integer>();
    private static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];

    ValidatedFikImpl(String string, boolean bl, boolean bl2, int[] nArray) {
        this.fik = string;
        this.isDemo = false;
        this.isNetwork = string.startsWith("2");
        this.getProductNumbersOnFik(nArray);
    }

    @Override
    public String get() {
        return this.fik;
    }

    private void getProductNumbersOnFik(int[] nArray) {
        int n = 0;
        while (n < 250) {
            if (n > 0 && n != 94 && n != 126 || this.isNetwork) {
                this.productNumberCollection.add(n);
            }
            ++n;
        }
    }

    public Integer[] getUpdatableProducts() {
        if (this.isDemo) {
            return EMPTY_INTEGER_ARRAY;
        }
        return this.productNumberCollection.toArray(new Integer[this.productNumberCollection.size()]);
    }

    @Override
    public boolean canActivate() {
        return !this.isNetwork && !this.containsMDCS();
    }

    @Override
    public boolean canInstall(Product product, long l) {
        return this.productNumberCollection.contains(product.getProductNumber());
    }

    @Override
    public boolean requiresLicenseFile() {
        return this.isNetwork;
    }

    private boolean containsMDCS() {
        return this.productNumberCollection.contains(94);
    }
}

