/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

final class SystemFileInstaller
implements FileProcessor {
    private static final int COPY_TO_SYSTEM_DIRECTORY = 1;
    private static final int DONT_REGISTER = 0;
    private final AppLogger appLogger;

    SystemFileInstaller(AppLogger appLogger) {
        this.appLogger = appLogger;
    }

    @Override
    public void processFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        this.logMessage("Installing", file);
        int n = SystemFileInstaller.installSystemFiles(file.getAbsolutePath(), 1, 0, 1, stringBuffer);
        SystemFileInstaller.handleStatus(installFlowControlHandler, stringBuffer, n);
    }

    private static void handleStatus(InstallFlowControlHandler installFlowControlHandler, StringBuffer stringBuffer, int n) {
        if (n == 0) {
            String string = stringBuffer.toString();
            installFlowControlHandler.alert(string);
        }
    }

    private void logMessage(String string, File file) {
        this.appLogger.logMsg(string + " system file: " + file.getAbsolutePath());
        this.debugMsg(file);
    }

    private void debugMsg(File file) {
        this.appLogger.debugMsg("File: " + file.getName() + " copy to system directory: " + Integer.toString(1) + " register: " + Integer.toString(0));
    }

    @Override
    public void undoProcessFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        this.logMessage("Uninstalling", file);
        int n = SystemFileInstaller.uninstallSystemFiles(file.getAbsolutePath(), 1, 0, 1, stringBuffer);
        SystemFileInstaller.handleStatus(installFlowControlHandler, stringBuffer, n);
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".ocx"), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".dll"));
    }

    private static native int installSystemFiles(String var0, int var1, int var2, int var3, StringBuffer var4);

    private static native int uninstallSystemFiles(String var0, int var1, int var2, int var3, StringBuffer var4);
}

