/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocProductList;
import com.mathworks.install.command.doc.InstalledDocProduct;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.instutil.IO;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

class SearchIndexCommand
implements SharedDocSubCommand {
    static final FilenameFilter SEARCH_INDEX_FILTER = new SearchIndexFilter();
    private final DirectoryBuilder dirBuilder;
    private final IO io;

    SearchIndexCommand(IO iO) {
        this(iO, new FileSystemDirectoryBuilder());
    }

    SearchIndexCommand(IO iO, DirectoryBuilder directoryBuilder) {
        this.io = iO;
        this.dirBuilder = directoryBuilder;
    }

    @Override
    public void handleProductsFound(File file, DocProductList docProductList) throws IOException, InterruptedException {
        this.buildSearchIndex(file, docProductList, "");
        for (String string : docProductList.getLocaleSuffixes()) {
            this.buildSearchIndex(file, docProductList, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSearchIndex(File file, DocProductList docProductList, String string) throws IOException {
        File file2 = new File(file, SearchIndexCommand.getIndexDirName(string));
        this.io.deleteDirectory(file2);
        Directory[] directoryArray = this.getSearchIndexesToMerge(file, docProductList.getInstalledProducts(), string);
        if (directoryArray == null || directoryArray.length == 0) {
            return;
        }
        Directory directory = this.dirBuilder.getDirectory(file2, true);
        try (IndexWriter indexWriter = new IndexWriter(directory, (Analyzer)new SimpleAnalyzer(), true);){
            indexWriter.addIndexes(directoryArray);
            indexWriter.optimize();
        }
    }

    @Override
    public void handleNoProducts(File file) throws IOException, InterruptedException {
        File[] fileArray;
        for (File file2 : fileArray = this.io.listFiles(file, SEARCH_INDEX_FILTER)) {
            if (!this.io.isDirectory(file2)) continue;
            this.io.deleteDirectory(file2);
        }
    }

    private Directory[] getSearchIndexesToMerge(File file, List<InstalledDocProduct> list, String string) throws IOException {
        LinkedList<Directory> linkedList = new LinkedList<Directory>();
        for (InstalledDocProduct installedDocProduct : list) {
            Directory directory;
            File file2 = new File(file, installedDocProduct.getHelpLoc());
            File file3 = this.findProductIndex(file2, string);
            if (file3 == null || !IndexReader.indexExists((Directory)(directory = this.dirBuilder.getDirectory(file3, false)))) continue;
            linkedList.add(directory);
        }
        Directory[] directoryArray = linkedList.toArray(new Directory[linkedList.size()]);
        return directoryArray;
    }

    private static String getIndexDirName(String string) {
        return string == null || string.trim().length() == 0 ? "helpsearch" : "helpsearch_" + string;
    }

    private File findProductIndex(File file, String string) {
        File file2;
        File file3 = new File(file, SearchIndexCommand.getIndexDirName(string));
        if (this.io.isDirectory(file3)) {
            return file3;
        }
        if (string != null && string.trim().length() > 0 && this.io.isDirectory(file2 = new File(file, SearchIndexCommand.getIndexDirName("")))) {
            return file2;
        }
        return null;
    }

    private static class FileSystemDirectoryBuilder
    implements DirectoryBuilder {
        private FileSystemDirectoryBuilder() {
        }

        @Override
        public Directory getDirectory(File file, boolean bl) throws IOException {
            return FSDirectory.getDirectory((File)file, (boolean)bl);
        }
    }

    static interface DirectoryBuilder {
        public Directory getDirectory(File var1, boolean var2) throws IOException;
    }

    private static class SearchIndexFilter
    implements FilenameFilter {
        private SearchIndexFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("helpsearch");
        }
    }
}

