// preview.js

function preview(obj) {
    const {type, content} = obj
    var article_content = document.querySelector(".articleContent");
    var snap_content = document.querySelector(".snapContent");
    var selection_content = document.querySelector(".selectContent");
    for (const elem of [article_content, snap_content, selection_content]) {
      elem.style.display = 'none';
    }
    if(type == 'web-content') {
        article_content.style.display = "block";
        var page_content = article_content.querySelector(".page_content");
        if(page_content){
            page_content.innerHTML = content;
            var article_header = page_content.querySelector("#articleHeader__separator");
            if (article_header)
              article_header.classList.add("separator");
        }
    } else if(type == 'snap') {
        snap_content.style.display = "block";
        document.querySelector("#snap-image").src = content;
    } else if (type == 'select-content') {
        selection_content.style.display = "block";
        selection_content.querySelector(".selectionContent").innerHTML = content;
    }
}

// prevent default
function recoverDefault(e){e.preventDefault(); return false;}
// window.oncontextmenu = recoverDefault;
window.ondrag = recoverDefault;
window.ondragstart = recoverDefault;
window.ondragend = recoverDefault;
