/**
 *  页面初始化
 *  @author  guotingjie@maxthon.net
 */
$(function () {
    var DEFAULT_MY_SITE = null;

    var lang = navigator.language.toLocaleLowerCase();

    Api.Maxthon.updateServiceAddress(function () {
        Api.Maxthon.getProfile(function (data) {
            if (data.profile == 'Guest Profile') {
                $('.guest-profile').show();
            } else {
                $('.profile').show();
                Promise.all([getPageTpl(lang), getPageData(lang)])
                    .then(function (data) {
                        // $('#page_data').append(data[1]);
                        let default_data = JSON.parse(data[1])
                        window.SITE_LIST = default_data.SITE_LIST;
                        window.DEFAULT_MY_SITE = default_data.DEFAULT_MY_SITE;
                        window.DEFAULT_DATA = default_data;
                        pageinit(data[0]);
                    }).catch(function (err) {
                        console.error(err)
                    });
            }
        });
    });

    function getPageData(lang) {
        var max_version = Api.Maxthon.max_version,
            _pn = Api.Maxthon.pn;

        var subfix = lang === 'zh-cn' ? lang : 'en-us';
        return getStore('page_data', 'local_page_data', lang, '/static/res/i18n/data_' + subfix + '.js');
    }

    function getPageTpl(lang) {
        return getStore('page_tpl', 'local_page_template', lang, '/static/res/tpl/page.tpl');
    }

    function getStore(id, key, lang, url) {
        return new Promise(function (resolve, reject) {
            var dom = document.getElementById(id)
            var version = dom.getAttribute('version');
            var local = localStorage.getItem(key);
            // if (local &&
            //     (local = JSON.parse(local)) &&
            //     local.lang === lang &&
            //     local.version === version &&
            //     !$.isEmptyObject(local.data)) {
            //     resolve(local.data);
            // } else {
                $('#' + id).load(url + '?v=' + version, function (data) {
                    resolve(data);
                    localStorage.setItem(key, JSON.stringify({ 'version': version, 'lang': lang, 'data': data }));
                });
            // }
        });
    }

    function pageinit(tpl) {
        var mapList = __PRELOAD__['map_list.json'] || JSON.parse(localStorage.getItem('MAP_LIST_JSON'));
        var activity;
        var maxthon = window.Api.Maxthon;

        if (lang === 'zh-cn' && mapList && mapList['activity'] && mapList['activity'].length > 0) {
            var now = Date.now();
            mapList['activity'].forEach(function (_activity) {
                _activity.stime = _activity['stime'];
                _activity.etime = _activity['etime'];
                if (_activity.stime < now && now < _activity.etime) { // 处理活动开始结束之间
                    activity = _activity;
                }
            });
        }

        // var pageHtml = template(tpl, { lang: lang, activity: activity });
        // document.getElementById('wrapper').innerHTML = pageHtml;

        window.Api.Grid.getGridDataList(mapList);

        activity && loadActivity(activity);

        var firstInit = false && true; // 先强制false
        var hoverTimer = null;
        $('.nav-header-menu li').on('mouseover mouseout', function (e) {
            e.stopPropagation();
            var $this = $(this);
            var _index = $this.index();
            var menuName = $this.data('menu-name');
            if (hoverTimer) clearTimeout(hoverTimer);
            hoverTimer = setTimeout(function (type) {
                if (type == "mouseover") {
                    $this.siblings().removeClass('active');
                    $this.addClass('active');
                    if (menuName === "feed" && firstInit) { window.infoService.init(); firstInit = false };
                    $('.nav-body > div').hide().eq(_index).show();
                    maxthon.useApi("config.set", {key: 'newtab.nav_menu', value: menuName}, function () {});
                }
            }, 300, e.type);
        });

        if (activity && activity.is_view === 'true') {
            var cur_nav_tab = $('.nav-header-menu [data-menu-name="activity"]').trigger("mouseover");
        } else {
            maxthon.useApi("config.get", {key: 'newtab.nav_menu'}, function (result) {
                var cur_nav_menu = (result && typeof result == "string") ? result : 'favor';
                var cur_nav_tab = $('.nav-header-menu [data-menu-name=' + cur_nav_menu + ']');
                if (cur_nav_tab.length) {
                    cur_nav_tab.trigger('mouseover');
                } else {
                    $('.nav-header-menu li').eq(0).trigger('mouseover');
                    maxthon.useApi("config.set", {key: 'newtab.nav_menu', value: 'favor'}, function () {});
                }
            });
        }
    }

    /**
     *  加载活动
     * @param {活动信息} activity
     */
    function loadActivity(activity) {
        getStore('activity_tpl',
            'local_act_template',
            lang,
            '/static/res/tpl/activity.tpl').then(function (tpl) {
                var actHtml = template(tpl, { activity: activity });
                document.getElementById('activity').innerHTML = actHtml;
            }).catch(function (err) {
                console.error(err)
            });
    }

    // 屏蔽页面右键
    $(document).on('contextmenu', function (e) {
        if (!$(e.target).is('input')) {
            e.preventDefault();
        }
    }).on('dragstart', function (e) { // 取消拖拽
        if (!$(e.target).closest('.allow-drag').length) {
            e.preventDefault();
            return false;
        }
    });

    // 关闭右键菜单
    window.addEventListener('blur', function () {
        Menu.hideAndRemovePopupMenu();
    });

    $('.header-action').on('click', 'a', function (ev) {
        ev.preventDefault();
        Api.Maxthon.setData('mxOpenUrl', $(this).attr('href'));
    });

    function initStatistic () {
        var state = false;
        if (templateData.isChinaPosition || navigator.language.toLowerCase() == 'zh-cn') {
            state = true;
        }
        Api.Maxthon.initStatistic(state);
    }
    initStatistic();
});