/*
 * 语言包
 */
$(function () {
      var Language = {
            lang: {
                  'DocumentTitle': {
                        'zh-cn': '新标签',
                        'en-us': 'New tab',
                        'ar-bh': 'جديد إطار',
                        'ar-sa': 'لسان جديد',
                        'ar-ye': 'جديد إطار',
                        'be-by': 'Новая ўкладка',
                        'bg-bg': 'Нов Таб',
                        'bn-in': 'নতুন তালিকা',
                        'ca-es': 'Nova pestanya',
                        'cs-cz': 'Nová karta',
                        'da-dk': 'Ny fane',
                        'de-de': 'Neue Registerkarte',
                        'el-gr': 'Νέα καρτέλα',
                        'es-ar': 'Nueva Pestaña',
                        'es-es': 'Nueva pestaña',
                        'es-mx': 'Pestaña nueva',
                        'es-pe': 'Nueva pestaña',
                        'et-ee': 'Uus leht',
                        'eu-es': 'Hegats berria',
                        'eu': 'Hegats berria',
                        //'fa-ir': 'جديد زبانه',
                        'fi-fi': 'Uusi välilehti',
                        'fr-fr': 'Nouvel onglet',
                        'he-il': 'חדשה כרטיסייה',
                        'hi-in': 'नया टैब',
                        'hu-hu': 'Új fül',
                        'it-it': 'Nuova scheda',
                        'ja-jp': '新規タブ',
                        'ka-ge': 'ახალი დანართი',
                        'kn-in': 'ಹೊಸ ಟ್ಯಾಬು',
                        'ko-kr': '새 탭',
                        'ku-tr': 'نوێ پەڕگەی',
                        'lt-lt': 'Naujas skirtukas',
                        'ml-in': 'പുതിയ ടാബ്',
                        'mn-mn': 'Шинэ шошго',
                        'nb-no': 'Ny fane',
                        'nl-nl': 'Nieuw tabblad',
                        'pl-pl': 'Nowa karta',
                        'pt-br': 'Nova Aba',
                        'pt-pt': 'Novo Separador',
                        'ro-ro': 'Tab Nou',
                        'ru-ru': 'Новая вкладка',
                        'sk-sk': 'Nová karta',
                        'sr-cyrl' : 'Додај',
                        'sl-si': 'Nov zavihek',
                        'sr-cs': 'Нови Језичак',
                        'sv-se': 'Ny flik',
                        'ta-in': 'புதிய தத்தல்',
                        'th-th': 'แท็บใหม่',
                        'tr-tr': 'Yeni sekme',
                        'uk-ua': 'Нова вкладка',
                        'vec-it': 'Tavèƚa niova',
                        'vi-vn': 'Thẻ mới',
                        'zh-hk': '新標籤',
                        'zh-tw': '新標籤'
                  },
                  'New': {
                        'de-de': 'Hinzufügen',
                        'bg-bg': 'Добави',
                        'cs-cz': 'Přidat',
                        'es-pe': 'Añadir',
                        'eu-es': 'Gehitu',
                        'en-gb': 'Add',
                        'eu': 'Gehitu',
                        //'fa-ir': 'افزودن',
                        'fr-fr': 'Ajouter',
                        'it-it': 'Aggiungi',
                        'ko-kr': '추가',
                        'nb-no': 'Legg til',
                        'pl-pl': 'Dodaj',
                        'pt-br': 'Adicionar',
                        'sr-cyrl' : 'Додај',
                        'sr-latn' : 'Dodaj',
                        'sl-si': 'Dodaj',
                        'tr-tr': 'Ekle',
                        'vec-it': 'Xonta',
                        'zh-cn': '新增',
                        'zh-tw': '新增',
                        'ru-ru': 'Добавить',
                        'sr-cs': 'Dodaj',
                        'es-es': 'Añadir',
                        'en-us': 'Add'
                  },
                  'Url': {
                        //'fa-ir': 'نشانی',
                        'zh-cn': '网址:',
                        'zh-tw': '網址',
                        'en-us': 'Url'
                  },
                  'Title': {
                        'de-de': 'Name',
                        'bg-bg': 'Заглавие',
                        'cs-cz': 'Název',
                        'es-pe': 'Título',
                        'eu-es': 'Izenburua',
                        'en-gb': 'Title',
                        'eu': 'Izenburua',
                        //'fa-ir': 'عنوان',
                        'fr-fr': 'Titre',
                        'it-it': 'Nome',
                        'ko-kr': '제목',
                        'nb-no': 'Tittel',
                        'pl-pl': 'Tytuł strony',
                        'pt-br': 'Título',
                        'sr-cyrl' : 'Наслов',
                        'sr-latn' : 'Naslov',
                        'sl-si': 'Naslov',
                        'tr-tr': 'Başlık',
                        'vec-it': 'Tìtoƚo',
                        'zh-cn': '标题:',
                        'zh-tw': '標題',
                        'ru-ru': 'Заголовок',
                        'sr-cs': 'Naslov',
                        'es-es': 'Titulo',
                        'en-us': 'Title'
                  },
                  'CustomAdd': {
                        'de-de': 'Hinzufügen',
                        'bg-bg': 'Добави',
                        'cs-cz': 'Přidat',
                        'es-pe': 'Añadir',
                        'eu-es': 'Gehitu',
                        'en-gb': 'Add',
                        'eu': 'Gehitu',
                        //'fa-ir': 'افزودن',
                        'fr-fr': 'Ajouter',
                        'it-it': 'Aggiungi',
                        'ko-kr': '추가',
                        'nb-no': 'Legg til',
                        'pl-pl': 'Dodaj',
                        'pt-br': 'Adicionar',
                        'sr-cyrl' : 'Додај',
                        'sr-latn' : 'Dodaj',
                        'sl-si': 'Dodaj',
                        'tr-tr': 'Ekle',
                        'vec-it': 'Xonta',
                        'zh-cn': '添加此项',
                        'zh-tw': '加入此項目',
                        'ru-ru': 'Добавить',
                        'sr-cs': 'Dodaj',
                        'es-es': 'Añadir',
                        'en-us': 'Add'
                  },
                  'Add': {
                        'de-de': 'Hinzufügen',
                        'bg-bg': 'Добави',
                        'cs-cz': 'Přidat',
                        'es-pe': 'Añadir',
                        'eu-es': 'Gehitu',
                        'en-gb': 'Add',
                        'eu': 'Gehitu',
                        //'fa-ir': 'افزودن',
                        'fr-fr': 'Ajouter',
                        'it-it': 'Aggiungi',
                        'ko-kr': '추가',
                        'nb-no': 'Legg til',
                        'pl-pl': 'Dodaj',
                        'pt-br': 'Adicionar',
                        'sr-cyrl' : 'Додај',
                        'sr-latn' : 'Dodaj',
                        'sl-si': 'Vroče',
                        'tr-tr': 'Ekle',
                        'vec-it': 'Xonta',
                        'zh-cn': '添 加',
                        'zh-tw': '加入',
                        'ru-ru': 'Добавить',
                        'sr-cs': 'Dodaj',
                        'es-es': 'Añadir',
                        'en-us': 'Add'
                  },
                  'Hot': {
                        'de-de': 'Beliebt',
                        'bg-bg': 'Горещи',
                        'cs-cz': 'Horký',
                        'es-pe': 'Popular',
                        'eu-es': 'Beroa',
                        'en-gb': 'Hot',
                        'eu': 'Beroa',
                        //'fa-ir': 'محبوب',
                        'fr-fr': 'Populaire',
                        'it-it': 'Più richieste',
                        'ko-kr': '인기',
                        'nb-no': 'Populær',
                        'pl-pl': 'Gorąco',
                        'pt-br': 'Quente',
                        'sr-cyrl' : 'Популарно',
                        'sr-latn' : 'Popularno',
                        'sl-si': 'Vroče',
                        'tr-tr': 'Yeni',
                        'vec-it': 'Popoƚar',
                        'zh-cn': '推荐图片',
                        'zh-tw': '推薦圖片',
                        'ru-ru': 'Топ',
                        'sr-cs': 'Popularno',
                        'es-es': 'Popular',
                        'en-us': 'Hot'
                  },
                  'Open': {
                        'de-de': 'Öffnen',
                        'bg-bg': 'Отвори',
                        'cs-cz': 'Otevřít',
                        'es-pe': 'Abrir',
                        'eu-es': 'Ireki',
                        'en-gb': 'Open',
                        'eu': 'Ireki',
                        //'fa-ir': 'بازکردن',
                        'fr-fr': 'Ouvrir',
                        'it-it': 'Apri',
                        'ko-kr': '열기',
                        'nb-no': 'Åpne',
                        'pl-pl': 'Otwórz',
                        'pt-br': 'Abrir',
                        'sr-cyrl' : 'Отвори',
                        'sr-latn' : 'Otvori',
                        'sl-si': 'Odpri',
                        'tr-tr': 'Aç',
                        'vec-it': 'Vèrxi',
                        'zh-cn': '打开',
                        'zh-tw': '開啟',
                        'ru-ru': 'Открыть',
                        'sr-cs': 'Otvori',
                        'es-es': 'Abrir',
                        'en-us': 'Open'
                  },
                  'Save': {
                        'de-de': 'Speichern',
                        'bg-bg': 'Запиши',
                        'cs-cz': 'Uložit',
                        'es-pe': 'Guardar',
                        'eu-es': 'Gorde',
                        'en-gb': 'Save',
                        'eu': 'Gorde',
                        //'fa-ir': 'ذخيره',
                        'fr-fr': 'Enregistrer',
                        'it-it': 'Salva',
                        'ko-kr': '저장',
                        'nb-no': 'Lagre',
                        'pl-pl': 'Zapisz',
                        'pt-br': 'Salvar',
                        'sr-cyrl' : 'Сачувај',
                        'sr-latn' : 'Sačuvaj',
                        'sl-si': 'Shrani',
                        'tr-tr': 'Kaydet',
                        'vec-it': 'Salva',
                        'zh-cn': '保存',
                        'zh-tw': '儲存',
                        'ru-ru': 'Сохранить',
                        'sr-cs': 'Sačuvaj',
                        'es-es': 'Guardar',
                        'en-us': 'Save'
                  },
                  'Edit': {
                        'de-de': 'Bearbeiten',
                        'bg-bg': 'Редакция',
                        'cs-cz': 'Upravit',
                        'es-pe': 'Editar',
                        'eu-es': 'Editatu',
                        'en-gb': 'Edit',
                        'eu': 'Editatu',
                        //'fa-ir': 'ويرايش',
                        'fr-fr': 'Modifier',
                        'it-it': 'Modifica',
                        'ko-kr': '편집',
                        'nb-no': 'Rediger',
                        'pl-pl': 'Edytuj',
                        'pt-br': 'Editar',
                        'sr-cyrl' : 'Уреди',
                        'sr-latn' : 'Urеdi',
                        'sl-si': 'Uredi',
                        'tr-tr': 'Düzenle',
                        'vec-it': 'Modìfega',
                        'zh-cn': '编辑',
                        'zh-tw': '編輯',
                        'ru-ru': 'Править',
                        'sr-cs': 'Urеdi',
                        'es-es': 'Editar',
                        'en-us': 'Edit'
                  },
                  'Delete': {
                        'de-de': 'Löschen',
                        'bg-bg': 'Изтрий',
                        'cs-cz': 'Odstranit',
                        'es-pe': 'Eliminar',
                        'eu-es': 'Ezabatu',
                        'en-gb': 'Delete',
                        'eu': 'Ezabatu',
                        //'fa-ir': 'حذف',
                        'fr-fr': 'Supprimer',
                        'it-it': 'Elimina',
                        'ko-kr': '삭제',
                        'nb-no': 'Slett',
                        'pl-pl': 'Usuń',
                        'pt-br': 'Apagar',
                        'sr-cyrl' : 'Избриши',
                        'sr-latn' : 'Izbriši',
                        'sl-si': 'Zbriši',
                        'tr-tr': 'Sil',
                        'vec-it': 'Scansèƚa',
                        'zh-cn': '删除',
                        'zh-tw': '刪除',
                        'ru-ru': 'Удалить',
                        'sr-cs': 'Izbriši',
                        'es-es': 'Borrar',
                        'en-us': 'Delete'
                  },
                  'Confirm': {
                        'de-de': 'Bestätigen',
                        'bg-bg': 'Потвърдете',
                        'cs-cz': 'Potvrdit',
                        'es-pe': 'Confirmar',
                        'eu-es': 'Baieztatu',
                        'en-gb': 'Confirm',
                        'eu': 'Baieztatu',
                        //'fa-ir': 'تایید',
                        'fr-fr': 'Confirmer',
                        'it-it': 'Conferma',
                        'ko-kr': '확인',
                        'nb-no': 'Bekreft',
                        'pl-pl': 'Zatwierdź',
                        'pt-br': 'Confirmar',
                        'sr-cyrl' : 'Потврди',
                        'sr-latn' : 'Potvrdi',
                        'sl-si': 'Potrdi',
                        'tr-tr': 'Onayla',
                        'vec-it': 'Conferma',
                        'zh-cn': '确定',
                        'zh-tw': '確定',
                        'ru-ru': 'Подтвердить',
                        'sr-cs': 'Potvrdi',
                        'es-es': 'Confirmar',
                        'en-us': 'Confirm'
                  },
                  'Cancel': {
                        'de-de': 'Abbrechen',
                        'bg-bg': 'Отказ',
                        'cs-cz': 'Storno',
                        'es-pe': 'Cancelar',
                        'eu-es': 'Ezeztatu',
                        'en-gb': 'Cancel',
                        'eu': 'Ezeztatu',
                        //'fa-ir': 'لغو',
                        'fr-fr': 'Annuler',
                        'it-it': 'Annulla',
                        'ko-kr': '취소',
                        'nb-no': 'Avbryt',
                        'pl-pl': 'Anuluj',
                        'pt-br': 'Cancelar',
                        'sr-cyrl' : 'Откажи',
                        'sr-latn' : 'Otkaži',
                        'sl-si': 'Prekliči',
                        'tr-tr': 'İptal',
                        'vec-it': 'Anuƚa',
                        'zh-cn': '取消',
                        'zh-tw': '取消',
                        'ru-ru': 'Отмена',
                        'sr-cs': 'Otkaži',
                        'es-es': 'Cancelar',
                        'en-us': 'Cancel'
                  },
                  'HotTab': {
                        'de-de': 'Webseiten',
                        'bg-bg': 'Сайтове',
                        'cs-cz': 'Webové stránky',
                        'es-pe': 'Sitios web',
                        'eu-es': 'Webguneak',
                        'en-gb': 'Websites',
                        'eu': 'Webguneak',
                        //'fa-ir': 'وبگاه ها',
                        'fr-fr': 'Sites Web',
                        'it-it': 'Siti web',
                        'ko-kr': '웹사이트',
                        'nb-no': 'Nettsteder',
                        'pl-pl': 'Strony WWW',
                        'pt-br': 'Sites da Web',
                        'sr-cyrl' : 'Веб сајтови',
                        'sr-latn' : 'Vеb sajtovi',
                        'sl-si': 'Spletne strani',
                        'tr-tr': 'Web Siteleri',
                        'vec-it': 'Siti web',
                        'zh-cn': '热门网址',
                        'zh-tw': '熱門網址',
                        'ru-ru': 'Веб-сайты',
                        'sr-cs': 'Vеb sajtovi',
                        'es-es': 'Sitios web',
                        'en-us': 'Websites'
                  },
                  'CustomAddTab': {
                        'de-de': 'Benutzerdefiniert',
                        'bg-bg': 'По избор',
                        'cs-cz': 'Vlastní',
                        'es-pe': 'Personalizado',
                        'eu-es': 'Norberea',
                        'en-gb': 'Custom',
                        'eu': 'Norberea',
                        //'fa-ir': 'سفارشی',
                        'fr-fr': 'Personnalisé',
                        'it-it': 'Personalizzato',
                        'ko-kr': '사용자 정의',
                        'nb-no': 'Tilpasset',
                        'pl-pl': 'Własna',
                        'pt-br': 'Personalizado',
                        'sr-cyrl' : 'Прилагођено',
                        'sr-latn' : 'Prilagođеno',
                        'sl-si': 'Po meri',
                        'tr-tr': 'Özel',
                        'vec-it': 'Personaƚixà',
                        'zh-cn': '自定义添加',
                        'zh-tw': '自訂加入',
                        'ru-ru': 'Пользовательские',
                        'sr-cs': 'Prilagođеno',
                        'es-es': 'Personalizar',
                        'en-us': 'Custom'
                  },
                  'MyFavorites': {
                        'de-de': 'Meine Favoriten',
                        'bg-bg': 'Моите Отметки',
                        'cs-cz': 'Oblíbené',
                        'es-pe': 'Mis favoritos',
                        'eu-es': 'Nire Gogokoenak',
                        'en-gb': 'My Favourites',
                        'eu': 'Nire Gogokoenak',
                        //'fa-ir': 'من علاقمندیهای',
                        'fr-fr': 'Mes Favoris',
                        'it-it': 'Preferiti',
                        'ko-kr': '즐겨찾기',
                        'nb-no': 'Mine favoritter',
                        'pl-pl': 'Moje Ulubione',
                        'pt-br': 'Meus Favoritos',
                        'sr-cyrl' : 'Моји обележивачи',
                        'sr-latn' : 'Moji obеlеživači',
                        'sl-si': 'Moje priljubljene',
                        'tr-tr': 'Sık Kullanılanlarım',
                        'vec-it': 'I me preferidi',
                        'zh-cn': '我的站点',
                        'zh-tw': '我的網站',
                        'ru-ru': 'Закладки',
                        'sr-cs': 'Moji obеlеživači',
                        'es-es': 'Mis favoritos',
                        'en-us': 'My Favorites'
                  },
                  'SuggestedWebSite': {
                        'de-de': 'Vorgeschlagene WebSite',
                        'bg-bg': 'Предложени Сайтове',
                        'cs-cz': 'Navrhovaná stránka',
                        'es-pe': 'Sitio web sugerido',
                        'eu-es': 'Iradokitako WebGunea',
                        'en-gb': 'Suggested Websites',
                        'eu': 'Iradokitako WebGunea', // 兼容mac 语言编码不统一
                        //'fa-ir': 'وبگاه پیشنهادی',
                        'fr-fr': 'Site Web suggéré',
                        'it-it': 'WebSite suggerito',
                        'ko-kr': '추천 웹사이트',
                        'nb-no': 'Foreslått nettside',
                        'pl-pl': 'Sugerowane strony WWW',
                        'pt-br': 'Site da web sugerido',
                        'sr-cyrl' : 'Предложени сајтови',
                        'sr-latn' : 'Prеdložеni sajtovi',
                        'sl-si': 'Predlagana spletna stran',
                        'tr-tr': 'Önerilen Web Siteleri',
                        'vec-it': 'Sito web sugerìo',
                        'zh-cn': '推荐站点',
                        'zh-tw': '推薦網站',
                        'ru-ru': 'Предложенные сайты',
                        'sr-cs': 'Prеdložеni sajtovi',
                        'es-es': 'Sitios web sugeridos',
                        'en-us': 'Suggested WebSite'
                  },
                  'SearchEnterURL': {
                        'de-de': 'Suchen',
                        'bg-bg': 'Търсене',
                        'cs-cz': 'Hledat',
                        'es-pe': 'Buscar',
                        'eu-es': 'Bilatu',
                        'en-gb': 'Search',
                        'eu': 'Bilatu',
                        //'fa-ir': 'جستجو يا درج نشاني وب',
                        'fr-fr': 'Rechercher',
                        'it-it': 'Cerca',
                        'ko-kr': '검색',
                        'nb-no': 'Søk',
                        'pl-pl': 'Szukaj w sieci',
                        'pt-br': 'Buscar',
                        'sr-cyrl' : 'Тражи',
                        'sr-latn' : 'Traži',
                        'sl-si': 'Išči',
                        'tr-tr': 'Arayın',
                        'vec-it': 'Serca o inserisi indriso URL',
                        'zh-cn': '查找网站',
                        'zh-tw': '尋找網站',
                        'ru-ru': 'Поиск',
                        'sr-cs': 'Traži',
                        'es-es': 'Buscar',
                        'en-us': 'Search'
                  },
                  'SelectBackground': {
                        'de-de': 'Hintergrund ändern',
                        'bg-bg': 'Промяна на фона',
                        'cs-cz': 'Změnit pozadí',
                        'es-pe': 'Cambiar el fondo',
                        'eu-es': 'Aldatu barrena',
                        'en-gb': 'Change background',
                        'eu': 'Aldatu barrena',
                        //'fa-ir': 'پس زمینه را تغییر دهد',
                        'fr-fr': 'Modifier l\'arrière plan',
                        'it-it': 'Cambiare sfondo...',
                        'ko-kr': '배경 변경',
                        'nb-no': 'Endre bakgrunn',
                        'pl-pl': 'Zmień tło',
                        'pt-br': 'Mudar plano de fundo',
                        'sr-cyrl' : 'Промени позадину',
                        'sr-latn' : 'Promеni pozadinu',
                        'sl-si': 'Spremeni ozadje',
                        'tr-tr': 'Arka planı değiştir',
                        'vec-it': 'Canbia sfondro',
                        'zh-cn': '选择背景',
                        'zh-tw': '選擇背景',
                        'ru-ru': 'Сменить фон',
                        'sr-cs': 'Promеni pozadinu',
                        'es-es': 'Cambiar el fondo',
                        'en-us': 'Change background'
                  },
                  'SelectBackgroundNotice': {
                        'de-de': 'Wir empfehlen Ihnen, ein Bild größer als die aktuelle Bildschirmauflösung mit JPG-, PNG- oder GIF-Format hochzuladen.',
                        'bg-bg': 'Препоръчваме да се качи снимка по-голяма от резолюцията на екрана - JPG, PNG или GIF формат.',
                        'cs-cz': 'Doporučujeme nahrát obrázek větší než aktuální rozlišení obrazovky ve formátu JPG, PNG nebo GIF.',
                        'es-pe': 'Le recomendamos que cargue una imagen más grande que la resolución de pantalla actual con formato JPG, PNG o GIF.',
                        'eu-es': 'Ikusleihoaren bereizma bezain handia den argazki bat igotzea gomendatzen dizugu JPG, PNG edo GIF heuskarrian.',
                        'en-gb': 'We recommend you upload a picture larger than the current screen resolution in JPG, PNG or GIF format.',
                        'eu': 'Ikusleihoaren bereizma bezain handia den argazki bat igotzea gomendatzen dizugu JPG, PNG edo GIF heuskarrian.',
                        //'fa-ir': 'پیشنهاد میشود تصویری بزرگتر از وضوح تصویر جاری با اشکال JPG یا PNG یا GIF بارگذاری کنید.',
                        'fr-fr': 'Nous vous recommandons de télécharger une image plus grande que la résolution d\'écran actuelle au format JPG, PNG ou GIF.',
                        'it-it': 'Consigliamo di caricare un\'immagine più grande della risoluzione dello schermo corrente con formato JPG, PNG o GIF.',
                        'ko-kr': '현재 화면 해상도보다 큰 JPG, PNG 또는 GIF 형식의 사진을 업로드하길 권장합니다.',
                        'nb-no': 'Vi anbefaler deg å laste opp et bilde større enn nåværende skjermoppløsning i JPG, PNG eller GIF-format.',
                        'pl-pl': 'Zalecamy przesłać plik JPG, PNG lub GIF o rozmiarach większych od aktualnie ustawionej rozdzielczości ekranu.',
                        'pt-br': 'Recomendamos que você faça o upload de uma imagem maior que a resolução de tela atual com formato JPG, PNG ou GIF.',
                        'sr-cyrl' : 'Препоручујемо отпремање слике веће од тренутне резолуције екрана у JPG, PNG или GIF формату.',
                        'sr-latn' : 'Prеporučujеmo otprеmanjе slikе vеćе od trеnutnе rеzolucijе еkrana u JPG, PNG ili GIF formatu.',
                        'sl-si': 'Priporočamo vam nalaganje slike, ki je večja od trenutne ločljivosti zaslona, v JPG, PNG ali GIF formatu.',
                        'tr-tr': 'JPG, PNG veya GIF biçiminde olan şu anki ekran çözünürlüğünden daha büyük bir resmi yüklemenizi öneririz.',
                        'vec-it': 'Racomandemo de cargar suxo na imàxene pì granda de ƚa resoƚusion de\'l monitor, in formato JPG, PNG o GIF.',
                        'zh-cn': '建议上传大于当前屏幕分辨率的JPG、PNG或GIF格式的图片。',
                        'zh-tw': '建議上傳高於目前螢幕解析度的JPG、PNG或GIF格式圖檔。',
                        'ru-ru': 'Мы рекомендуем загружать изображения в формате JPG, PNG или GIF размером выше, чем текущее разрешение экрана.',
                        'sr-cs': 'Prеporučujеmo otprеmanjе slikе vеćе od trеnutnе rеzolucijе еkrana u JPG, PNG ili GIF formatu.',
                        'es-es': 'Le recomendamos que cargue una imagen más grande que la resolución de pantalla actual con formato JPG, PNG o GIF.',
                        'en-us': 'We recommend you upload a picture larger than the current screen resolution in JPG, PNG or GIF format.'
                  },
                  'EnterUrl': {
                        'de-de': 'URL hier eingeben',
                        'bg-bg': 'Въведете URL',
                        'cs-cz': 'Zadejte URL',
                        'es-pe': 'Escriba la dirección URL',
                        'eu-es': 'Sartu URL helbidea',
                        'en-gb': 'Enter the URL',
                        'eu': 'Sartu URL helbidea',
                        //'fa-ir': 'لطفاً نشانی وب را وارد کنید',
                        'fr-fr': 'Entrez l\'URL',
                        'it-it': 'Inserisci l\'indirizzo',
                        'ko-kr': 'URL을 입력하십시오',
                        'nb-no': 'Angi URL',
                        'pl-pl': 'Wprowadź adres URL',
                        'pt-br': 'Insira a URL',
                        'sr-cyrl' : 'Унесите адресу',
                        'sr-latn' : 'Unesite adresu',
                        'sl-si': 'Vnesi URL',
                        'tr-tr': 'URL\'yi girin',
                        'vec-it': 'Inserisi \'l indriso web',
                        'zh-cn': '请输入网址',
                        'zh-tw': '請輸入網址',
                        'ru-ru': 'Введите адрес',
                        'sr-cs': 'Unеsitе adrеsu',
                        'es-es': 'Introduzca la URL',
                        'en-us': 'Enter the URL'
                  },
                  'CheckUrl': {
                        'de-de': 'Bitte überprüfen Sie die URL.',
                        'bg-bg': 'Моля, проверете адреса.',
                        'cs-cz': 'Zkontrolujte URL adresu.',
                        'es-pe': 'Por favor, compruebe la URL.',
                        'eu-es': 'Mesedez egiaztatu URL-a.',
                        'en-gb': 'Please check the URL',
                        'eu': 'Mesedez egiaztatu URL-a.',
                        //'fa-ir': 'لطفاً نشانی وب را بررسی کنید.',
                        'fr-fr': 'Veuillez vérifiez l\'URL.',
                        'it-it': 'Verifica la URL.',
                        'ko-kr': 'URL을 확인하십시오.',
                        'nb-no': 'Kontroller URL.',
                        'pl-pl': 'Sprawdź adres URL.',
                        'pt-br': 'Verifique a URL.',
                        'sr-cyrl' : 'Проверите адресу.',
                        'sr-latn' : 'Provеritе adrеsu.',
                        'sl-si': 'Prosimo, preverite naslov URL.',
                        'tr-tr': 'Lütfen URL\'yi kontrol edin.',
                        'vec-it': 'Contròƚa el indriso WEB.',
                        'zh-cn': '网址输入不合法',
                        'zh-tw': '網址輸入不符規定',
                        'ru-ru': 'Проверьте адрес.',
                        'sr-cs': 'Provеritе adrеsu.',
                        'es-es': 'Compruebe la Url.',
                        'en-us': 'Please check the URL.'
                  },
                  'EnterTitle': {
                        'de-de': 'Name',
                        'bg-bg': 'Заглавие',
                        'cs-cz': 'Název',
                        'es-pe': 'Título',
                        'eu-es': 'Izenburua',
                        'en-gb': 'Title',
                        'eu': 'Izenburua',
                        //'fa-ir': 'لطفاً عنوان را وارد کنید',
                        'fr-fr': 'Titre',
                        'it-it': 'Nome',
                        'ko-kr': '제목',
                        'nb-no': 'Tittel',
                        'pl-pl': 'Wprowadź tytuł',
                        'pt-br': 'Título',
                        'sr-cyrl' : 'Наслов',
                        'sr-latn' : 'Naslov',
                        'sl-si': 'Naslov',
                        'tr-tr': 'Başlık',
                        'vec-it': 'Inserisi el tìtoƚo',
                        'zh-cn': '请输入标题',
                        'zh-tw': '請輸入標題',
                        'ru-ru': 'Заголовок',
                        'sr-cs': 'Unеsitе naslov',
                        'es-es': 'Título',
                        'en-us': 'Title'
                  },
                  'EnterTitleMoreThan30': {
                        'de-de': 'Geben Sie nie mehr als 30 Zeichen ein.',
                        'bg-bg': 'заглавието да не е по-голямо от 30 символа.',
                        'cs-cz': 'název není delší než 30 znaků.',
                        'es-pe': 'el título no debe tener más de 30 caracteres.',
                        'eu-es': 'izenburuak ez ditu 30 hizkirri baino gehiago.',
                        'en-gb': 'The title should be no more than 30 characters',
                        'eu': 'izenburuak ez ditu 30 hizkirri baino gehiago.',
                        //'fa-ir': 'عنوان نباید بیش از ٣٠ رقم باشد.',
                        'fr-fr': 'le titre ne doit pas dépasser 30 caractères.',
                        'it-it': 'Il titolo non è superiore a 30 caratteri.',
                        'ko-kr': '제목은 30 문자보다 적어야 합니다.',
                        'nb-no': 'tittelen kan ikke være mer enn 30 karakterer.',
                        'pl-pl': 'tytuł nie może przekraczać 30-tu znaków.',
                        'pt-br': 'o título não é mais do que 30 caracteres.',
                        'sr-cyrl' : 'Наслов не сме имати више од 30 знакова.',
                        'sr-latn' : 'Naslov nе smе imati višе od 30 znakova.',
                        'sl-si': 'naslov ne sme biti daljši od 30 znakov.',
                        'tr-tr': 'Başlık 30 karakterden fazla olamaz.',
                        'vec-it': 'el tìtoƚo no\'l pasa i 30 caràteri.',
                        'zh-cn': '标题不能超过30个字符。',
                        'zh-tw': '標題不能超過30個字元。',
                        'ru-ru': 'заголовок не длиннее 30 символов.',
                        'sr-cs': 'naslov nе smе imati višе od 30 znakova.',
                        'es-es': 'El titulo no debe tener más de 20 caracteres.',
                        'en-us': 'The title is no more than 30 characters.'
                  },
                  'CurrentlyOpen': {
                        'de-de': 'Derzeit geöffnet',
                        'bg-bg': 'Отворени в момента',
                        'cs-cz': 'Aktuálně otevřené',
                        'es-pe': 'Actualmente Abierto',
                        'eu-es': 'Orain Irekita',
                        'en-gb': 'Currently Open',
                        'eu': 'Orain Irekita',
                        //'fa-ir': 'هم اکنون بازست',
                        'fr-fr': 'Actuellement ouvert',
                        'it-it': 'Attualmente aperto',
                        'ko-kr': '열린 사이트',
                        'nb-no': 'Åpen nå',
                        'pl-pl': 'Aktualnie Otwarte',
                        'pt-br': 'Atualmente aberto',
                        'sr-cyrl' : 'Тренутно отворено',
                        'sr-latn' : 'Trеnutno otvorеno',
                        'sl-si': 'Trenutno odprto',
                        'tr-tr': 'Şu Anda Açık',
                        'vec-it': 'Atualmente vèrto',
                        'zh-cn': '当前打开',
                        'zh-tw': '目前開啟',
                        'ru-ru': 'Открытые сейчас',
                        'sr-cs': 'Trеnutno otvorеno',
                        'es-es': 'Abiertos',
                        'en-us': 'Currently Open'
                  },
                  'MostVisited': {
                        'de-de': 'Meist besucht',
                        'bg-bg': 'Най-посещавани',
                        'cs-cz': 'Nejnavštěvovanější',
                        'es-pe': 'Más visitado',
                        'eu-es': 'Ikusienak',
                        'en-gb': 'Most Visited',
                        'eu': 'Ikusienak',
                        //'fa-ir': 'پربازدیدترین',
                        'fr-fr': 'Les plus visités',
                        'it-it': 'I più visitati',
                        'ko-kr': '자주 방문',
                        'nb-no': 'Mest besøkt',
                        'pl-pl': 'Najczęściej Odwiedzane',
                        'pt-br': 'Mais visitados',
                        'sr-cyrl' : 'Најпосећеније',
                        'sr-latn' : 'Najposеćеnijе',
                        'sl-si': 'Najbolj obiskane',
                        'tr-tr': 'En Çok Ziyaret Edilen',
                        'vec-it': 'I pì vixitài',
                        'zh-cn': '最常访问',
                        'zh-tw': '最常瀏覽',
                        'ru-ru': 'Часто посещаемые',
                        'sr-cs': 'Najposеćеnijе',
                        'es-es': 'Los más visitados',
                        'en-us': 'Most Visited'
                  },
                  'Maxnote': {
                        'zh-cn': '傲游笔记',
                        'en-us': 'Maxnote'
                  },
                  'Passkeeper': {
                        'en-us':'Passkeeper',
                        'zh-cn':'密码大师'
                  },
                  'UUMail': {
                        'en-us':'UUMail',
                        'zh-cn':'百变邮箱'
                  },
                  'CloudUseInfo': {
                        'en-us':'Cloud storage: <span class="used-space">$used$</span>M used, <span class="total-space">$total$</span>G in total',
                        'zh-cn':'云空间：已用<span class="used-space">$used$</span>M，总共 <span class="total-space">$total$</span>G'
                  },
                  'LastSyncDate': {
                        'en-us':'Last sync date',
                        'zh-cn':'最后同步时间'
                  },
                  'AccountInfo': {
                        'en-us':'Account information',
                        'zh-cn':'用户信息'
                  },
                  'AccountSecur': {
                        'en-us':'Account security',
                        'zh-cn':'账户安全'
                  },
                  'Logout': {
                        'en-us':'Log out',
                        'zh-cn':'注销'
                  },
                  'LogOut': {
                        'en-us':'Log Out',
                        'zh-cn':'退出登录'
                  },
                  'Login': {
                        'en-us':'Login',
                        'zh-cn':'登录'
                  },
                  'SelectDefaultEngine': {
                        'en-us':'Select default search engine',
                        'zh-cn':'选择默认搜索引擎'
                  },
                  'HotAddons': {
                        'en-us':'Hot Extensions',
                        'zh-cn':'热门插件'
                  },
                  'LastSession': {
                        'de-de': 'Letzte Sitzung',
                        'bg-bg': 'Последна сесия',
                        'cs-cz': 'Naposled otevřeno',
                        'es-pe': 'Última Sesión',
                        'eu-es': 'Azken saioa',
                        'en-gb': 'Last Session',
                        'eu': 'Azken saioa',
                        //'fa-ir': 'آخرین نشست',
                        'fr-fr': 'Dernière session',
                        'it-it': 'Ultima sessione',
                        'ko-kr': '마지막 세션',
                        'nb-no': 'Siste økt',
                        'pl-pl': 'Ostatnia Sesja',
                        'pt-br': 'Última Sessão',
                        'sr-cyrl' : 'Последња сесија',
                        'sr-latn' : 'Poslеdnja sеsija',
                        'sl-si': 'Zadnja seja',
                        'tr-tr': 'Son Oturum',
                        'vec-it': 'Sesion ùltima',
                        'zh-cn': '上次未关闭',
                        'zh-tw': '上次未關閉',
                        'ru-ru': 'Последняя сессия',
                        'sr-cs': 'Poslеdnja sеsija',
                        'es-es': 'Ultima sesion',
                        'en-us': 'Last Session'
                  },
                  'Screenshot': {
                        'de-de': 'Bildschirmfoto',
                        'bg-bg': 'Снимка на екрана',
                        'cs-cz': 'Snímek stránky',
                        'es-pe': 'Captura de pantalla',
                        'eu-es': 'Ikusleiho-argazkia',
                        'en-gb': 'Screenshot',
                        'eu': 'Ikusleiho-argazkia',
                        //'fa-ir': 'عكس فوري',
                        'fr-fr': 'Capture d\'écran',
                        'it-it': 'Cattura',
                        'ko-kr': '스크린샷',
                        'nb-no': 'Skjermdump',
                        'pl-pl': 'Zrzut ekranu',
                        'pt-br': 'Captura de tela',
                        'sr-cyrl' : 'Снимак екрана',
                        'sr-latn' : '',
                        'sl-si': 'Posnetek zaslona',
                        'tr-tr': 'Ekran Görüntüsü',
                        'vec-it': 'Catura schermada',
                        'zh-cn': '网页截图',
                        'zh-tw': '網頁截圖',
                        'ru-ru': 'Снимок экрана',
                        'sr-cs': 'Snimak еkrana',
                        'es-es': 'Captura de pantalla',
                        'en-us': 'Screenshot'
                  },
                  'ColorBlock': {
                        'de-de': 'Farbblock',
                        'bg-bg': 'Цветен блок',
                        'cs-cz': 'Barevné pozadí',
                        'es-pe': 'Bloque de color',
                        'eu-es': 'Margo Blokea',
                        'en-gb': 'Color Block',
                        'eu': 'Margo Blokea',
                        //'fa-ir': 'رنگ قطعه',
                        'fr-fr': 'Couleur de bloc',
                        'it-it': 'Blocco di colore',
                        'ko-kr': '색상 블럭',
                        'nb-no': 'Blokkfarge',
                        'pl-pl': 'Kolorowy kafelek',
                        'pt-br': 'Cor do Bloco',
                        'sr-cyrl' : 'Обојени блок',
                        'sr-latn' : 'Obojеni blok',
                        'sl-si': 'Barvni blok',
                        'tr-tr': 'Renk Bloğu',
                        'vec-it': 'Blòco coƚor',
                        'zh-cn': '色块文字',
                        'zh-tw': '色塊文字',
                        'ru-ru': 'Цвет блока',
                        'sr-cs': 'Obojеni blok',
                        'es-es': 'Bloqueo de color',
                        'en-us': 'Color Block'
                  },
                  'NoteBeenCompleteDeleted': {
                        'de-de': 'Der Rekord existierte nicht mehr. Fügen Sie Ihren Schnellzugriff wieder hinzu.',
                        'bg-bg': 'Записът вече не съществува. Добавете отново Бърз Достъп.',
                        'cs-cz': 'Záznam už neexistuje. Přidejte znovu Rychlý přístup.',
                        'es-pe': 'El registro ya no existía. Vuelva a agregar su acceso rápido.',
                        'eu-es': 'Grabaketa ez dago jadanik. Gehitu zure Sarbide Azkarra berriro.',
                        'en-gb': 'The record no longer exists. Add to your Quick Access again.',
                        'eu': 'Grabaketa ez dago jadanik. Gehitu zure Sarbide Azkarra berriro.',
                        //'fa-ir': 'این سابقه دیگر موجود نیست. بندانگشتی خود را دوباره بیفزایید.',
                        'fr-fr': 'L\'enregistrement n\'existait plus. Ajoutez à nouveau votre accès rapide.',
                        'it-it': 'Il record non esisteva più. Aggiungi nuovamente il tuo accesso rapido.',
                        'ko-kr': '레코드가 더 이상 존재하지 않습니다. 다시 빠른 액세스를 추가하십시오.',
                        'nb-no': 'Posten eksisterer ikke lenger. Legg til i Quick Access igjen.',
                        'pl-pl': 'Ta pozycja już nie istnieje. Dodaj ją ponownie do swojego Szybkiego Dostępu.',
                        'pt-br': 'O registro não existie mais. Adicione seu acesso rápido novamente.',
                        'sr-cyrl' : 'Запис више не постоји. Поново додајте Брзо бирање.',
                        'sr-latn' : 'Zapis višе nе postoji. Ponovo dodajtе Brzo biranjе.',
                        'sl-si': 'Zapis ne obstaja več. Ponovno dodajte vaš Hitri dostop.',
                        'tr-tr': 'Kayıt artık mevcut değil. Hızlı Erişim\'inizi tekrar ekleyin.',
                        'vec-it': 'El record no\'l existe altro. Xonta da novo el to Quick Access.',
                        'zh-cn': '该笔记已不存在，请重新选择。',
                        'zh-tw': '該筆記已不存在，請重新選擇。',
                        'ru-ru': 'Запись больше не существует. Добавьте свою плитку снова.',
                        'sr-cs': 'Zapis višе nе postoji. Ponovo dodajtе Brzo biranjе.',
                        'es-es': 'El registro ya no existe. Agregue su acceso rápido nuevamente',
                        'en-us': 'The record no longer existed. Add your Quick Access again.'
                  },
                  'NoteBeenDeleted': {
                        'de-de': 'Der Datensatz wurde gelöscht. Überprüfen Sie den Maxnote Trash.',
                        'bg-bg': 'Записът беше изтрит. Проверете в кошчето на Maxnote.',
                        'cs-cz': 'Záznam byl odstraněn. Zkontrolujte Koš v Maxnote.',
                        'es-pe': 'Se ha eliminado el registro. Compruebe en la Papelera de Maxnote.',
                        'eu-es': 'Grabaketa ezabatua izan da. Egiaztatu Maxnote Zakarrontzian.',
                        'en-gb': 'The record has been deleted. Check in the Maxnote Trash.',
                        'eu': 'Grabaketa ezabatua izan da. Egiaztatu Maxnote Zakarrontzian.',
                        //'fa-ir': 'سابقه مذکو Maxnote ده است. زباله دان سَبَدداده را ببینید.',
                        'fr-fr': 'L\'enregistrement a été supprimé. Vérifiez dans la poubelle de Maxnote.',
                        'it-it': 'Il record è stato eliminato. Controllate il cestino di Maxnote.',
                        'ko-kr': '레코드가 삭제되었습니다. Maxnote 휴지통을 확인하십시오.',
                        'nb-no': 'Posten er slettet. Se etter i Maxnote Trash.',
                        'pl-pl': 'Ta pozycja została skasowana. Sprawdź zawartość śmietnika Maxnote.',
                        'pt-br': 'O registro foi excluído. Verifique na lixeira do Maxnote.',
                        'sr-cyrl' : 'Запис је избрисан. Проверите отпад у Maxnote.',
                        'sr-latn' : 'Zapis jе izbrisan. Provеritе otpad u Maxnote.',
                        'sl-si': 'Zapis je bil zbrisan. Preverite v Maxnote smetnjaku.',
                        'tr-tr': 'Kayıt silindi. Maxnote Çöp Kutusunu kontrol edin.',
                        'vec-it': 'El record el xé stà scanseƚà. Varda inte i scarti de Maxnote.',
                        'zh-cn': '该笔记已被删除，请在傲游笔记回收站查看。',
                        'zh-tw': '該筆記已被刪除，請在傲遊筆記回收桶查看。',
                        'ru-ru': 'Запись была удалена. Возможно она в Корзине Maxnote.',
                        'sr-cs': 'Zapis jе izbrisan. Provеritе otpad u Maxnote.',
                        'es-es': 'Se ha eliminado el registro. Compruebe en la Papelera de Maxnote.',
                        'en-us': 'The record has been deleted. Check in the Maxnote Trash.'
                  },
                  'NewFolder': {
                        'de-de': 'Neuer Ordner',
                        'bg-bg': 'Нова папка',
                        'cs-cz': 'Nová složka',
                        'es-pe': 'Nueva carpeta',
                        'eu-es': 'Agiritegi Berria',
                        'en-gb': 'New Folder',
                        'eu': 'Agiritegi Berria',
                        //'fa-ir': 'پوشه جديد',
                        'fr-fr': 'Nouveau dossier',
                        'it-it': 'Nuova cartella',
                        'ko-kr': '새 폴더',
                        'nb-no': 'Ny mappe',
                        'pl-pl': 'Utwórz nowy katalog',
                        'pt-br': 'Nova Pasta',
                        'sr-cyrl' : 'Нова фасцикла',
                        'sr-latn' : 'Nova fascikla',
                        'sl-si': 'Nova mapa',
                        'tr-tr': 'Yeni Klasör',
                        'vec-it': 'Cartèƚa niova',
                        'zh-cn': '文件夹',
                        'zh-tw': '資料夾',
                        'ru-ru': 'Новая папка',
                        'sr-cs': 'Nova fascikla',
                        'es-es': 'Nueva carpeta',
                        'en-us': 'New Folder'
                  },
                  'DeleteFolderTitle': {
                        'de-de': 'Ordner löschen',
                        'bg-bg': 'Изтрий папка',
                        'cs-cz': 'Odstranit složku',
                        'es-pe': 'Eliminar carpeta',
                        'eu-es': 'Ezabatu agiritegia',
                        'en-gb': 'Delete folder',
                        'eu': 'Ezabatu agiritegia',
                        //'fa-ir': 'پوشه گردد',
                        'fr-fr': 'Supprimer le dossier',
                        'it-it': 'Elimina cartella',
                        'ko-kr': '폴더 삭제',
                        'nb-no': 'Slett mappe',
                        'pl-pl': 'Usuń folder',
                        'pt-br': 'Excluir pasta',
                        'sr-cyrl' : 'Избриши фасциклу',
                        'sr-latn' : '',
                        'sl-si': 'Izbriši mapo',
                        'tr-tr': 'Klasörü sil',
                        'vec-it': 'Scanseƚar ƚa cartèƚa',
                        'zh-cn': '删除文件夹',
                        'zh-tw': '刪除資料夾',
                        'ru-ru': 'Удалить папку',
                        'sr-cs': 'Izbriši fasciklu',
                        'es-es': 'Eliminar carpeta',
                        'en-us': 'Delete folder'
                  },
                  'DeleteFolderWarn': {
                        'de-de': 'Möchten Sie diesen Container wirklich löschen?',
                        'bg-bg': 'Сигурни ли сте, че искате да изтриете папката?',
                        'cs-cz': 'Opravdu chcete odstranit tuto složku?',
                        'es-pe': '¿Está seguro de eliminar esta carpeta?',
                        'eu-es': 'Zihur zaude agiritegi hau ezabatzea nahi duzula?',
                        'en-gb': 'Are you sure you want to delete this folder?',
                        'eu': 'Zihur zaude agiritegi hau ezabatzea nahi duzula?',
                        //'fa-ir': 'آیا از حذف این پوشه اطمینان دارید؟',
                        'fr-fr': 'Êtes-vous sûr de vouloir supprimer le dossier ?',
                        'it-it': 'Sei sicuro di voler eliminare la cartella?',
                        'ko-kr': '정말로 이 폴더를 삭제하시겠습니까?',
                        'nb-no': 'Er du sikker på at du vil slette mappen?',
                        'pl-pl': 'Czy jesteś pewien, że chcesz usunąć ten folder?',
                        'pt-br': 'Tem certeza de que deseja excluir esta pasta?',
                        'sr-cyrl' : 'Да ли сте сигурни да желите да избришете ову фасциклу?',
                        'sr-latn' : 'Da li stе sigurni da žеlitе da izbrišеtе ovu fasciklu?',
                        'sl-si': 'Ali zares želite izbrisati to mapo?',
                        'tr-tr': 'Bu klasörü silmek istediğinize emin misiniz?',
                        'vec-it': 'Vusto dabon scanseƚar sta cartèƚa?',
                        'zh-cn': '确定删除文件夹?',
                        'zh-tw': '確定刪除資料夾？',
                        'ru-ru': 'Вы точно хотите удалить эту папку?',
                        'sr-cs': 'Da li stе sigurni da žеlitе da izbrišеtе ovu fasciklu?',
                        'es-es': 'Confirme si desea eliminar la carpeta',
                        'en-us': 'Are you sure you want to delete this folder?'
                  },
                  'DeleteFolderContent': {
                        'de-de': 'Folder "{name}" und {count} Seite(n) werden gelöscht und können nicht wiederhergestellt werden.',
                        'bg-bg': 'Папка "{name}" и {count} сайта в нея ще бъдат изтрити и няма да могат да се възстановят.',
                        'cs-cz': 'Složka {name} a {count} stránky v ní bude odstraněna a nemůže být znovu obnovena.',
                        'es-pe': 'La carpeta "{name}" y {count} sitio(s) en él se eliminarán y no se podrán recuperar de nuevo.',
                        'eu-es': '"{name}" agiria eta {count} gune ezabatuak izango dira eta ezingo dira berreskuratu.',
                        'en-gb': 'Folder "{name}" and {count} site(s) in it will be deleted and will not be able to be recovered.',
                        'eu': '"{name}" agiria eta {count} gune ezabatuak izango dira eta ezingo dira berreskuratu.',
                        //'fa-ir': 'پوشهٔ "{name}" و پایگاه(های) {count} در آن شناسایی خواهد شد و نمیتواند دوباره بازیابی شود.',
                        'fr-fr': 'Le dossier "{name}" et les {count} site (s) contenus seront supprimés et ne pourront plus être récupérés.',
                        'it-it': 'La cartella "{name}" e {count} siti in esso verranno eliminati e non possono essere ripristinati.',
                        'ko-kr': '"{name}" 폴더 및 {count} 사이트가 삭제되며 다시 복원할 수 없습니다.',
                        'nb-no': 'Mappe "{name}" og {count} side(r) i den vil slettes og kan ikke gjenopprettes igjen.',
                        'pl-pl': 'Folder "{name}" i {count} strona/y zostanie usunięta bez możliwości ponownego przywrócenia.',
                        'pt-br': 'A Pasta "{name}" e {count} site(s) dentro dela, será excluída e não poderá ser recuperada novamente.',
                        'sr-cyrl' : 'Фасцикла "{name}" и {count} сајт(ов)а у њој ће бити избрисани и не могу се вратити поново.',
                        'sr-latn' : 'Fascikla "{name}" i {count} sajt(ov)a u njoj ćе biti izbrisani i nе mogu sе vratiti ponovo.',
                        'sl-si': 'Mapa "{name}" in{count} strani v njej bodo izbrisani in jih ne bo mogoče obnoviti.',
                        'tr-tr': 'İçindeki "{name}" klasörü ve {count} site silinecek ve tekrar kurtarılamaz.',
                        'vec-it': 'Ƚa cartèƚa "{name}" e {count} siti i vegnarà scanseƚài e no i podarà ser ricuperài.',
                        'zh-cn': '文件夹“{name}”以及其中的{count}个网址数据将被删除，删除后数据将无法恢复。',
                        'zh-tw': '資料夾"{name}"以及其中的{count}個網址資料將被刪除，刪除後資料將無法恢復。',
                        'ru-ru': 'Папка "{name}" и {count} сайтов в ней будут удалены без возможности восстановления.',
                        'sr-cs': 'Fascikla "{name}" i {count} sajt(ov)a u njoj ćе biti izbrisani i nе mogu sе vratiti ponovo.',
                        'es-es': 'La carpeta "{name}" y {count} sitios dentro de ella se eliminarán y no se pueden recuperar de nuevo.',
                        'en-us': 'Folder "{name}" and {count} site(s) in it will be deleted and will not be able to be recovered.'
                  },
                  'NewTabOpen': {
                        'de-de': 'Im Hintergrund öffnen',
                        'bg-bg': 'Отвори във фонов режим',
                        'cs-cz': 'Otevřít v kartě na pozadí',
                        'es-pe': 'Abrir en segundo plano',
                        'eu-es': 'Ireki barreneko hegatsean',
                        'en-gb': 'Open in background tab',
                        'eu': 'Ireki barreneko hegatsean',
                        //'fa-ir': 'بازکردن در زبانه پشت زمینه',
                        'fr-fr': 'Ouvrir dans un onglet en arrière-plan',
                        'it-it': 'Apri in una scheda in background',
                        'ko-kr': '백그라운드 탭에서 열기',
                        'nb-no': 'Åpne i bakgrunnsfane',
                        'pl-pl': 'Otwórz w nowej karcie w tle',
                        'pt-br': 'Abrir guia em segundo plano',
                        'sr-cyrl' : 'Отвори у картици у позадини',
                        'sr-latn' : 'Otvori u kartici u pozadini',
                        'sl-si': 'Odprto v zavihku v ozadju',
                        'tr-tr': 'Arka planda sekmede aç',
                        'vec-it': 'Vèrxi in tavèƚa background',
                        'zh-cn': '后台打开',
                        'zh-tw': '在背景開啟',
                        'ru-ru': 'Открыть в фоновой вкладке',
                        'sr-cs': 'Otvori u kartici u pozadini',
                        'es-es': 'Abrir en una pestaña en segundo plano',
                        'en-us': 'Open in background tab'
                  },
                  'NewTabOpenAll': {
                        'de-de': 'Im Hintergrund öffnen',
                        'bg-bg': 'Отваряне на всички връзки във фонов режим',
                        'cs-cz': 'Otevřít vše v kartách na pozadí',
                        'es-pe': 'Abrir todo en pestañas de fondo',
                        'eu-es': 'Ireki guztiak barreneko hegatsetan',
                        'en-gb': 'Open all in background tabs',
                        'eu': 'Ireki guztiak barreneko hegatsetan',
                        //'fa-ir': 'بازکردن همه در زبانه های پشت زمینه',
                        'fr-fr': 'Tout ouvrir dans des onglets en arrière-plan',
                        'it-it': 'Apri i link in schede in background',
                        'ko-kr': '백그라운드 탭에서 모두 열기',
                        'nb-no': 'Åpne alle i bakgrunnsfaner',
                        'pl-pl': 'Otwórz wszystkie w nowej karcie w tle',
                        'pt-br': 'Abrir tudo em guias de segundo plano',
                        'sr-cyrl' : 'Отвори све у картицима у позадини',
                        'sr-latn' : 'Otvori svе u karticima u pozadini',
                        'sl-si': 'Odprto v vseh zavihkih v ozadju',
                        'tr-tr': 'Tümünü arka planda sekmelerde aç',
                        'vec-it': 'Vèrxi tuto in tavèƚe in background',
                        'zh-cn': '后台打开全部',
                        'zh-tw': '全部於背景開啟',
                        'ru-ru': 'Открыть все в фоновых вкладках',
                        'sr-cs': 'Otvori svе u karticima u pozadini',
                        'es-es': 'Abrir vínculos en pestañas de fondo',
                        'en-us': 'Open all in background tabs'
                  },
                  'NewWindowOpen': {
                        'de-de': 'In neuem Fenster öffnen',
                        'bg-bg': 'Отвори в нов прозорец',
                        'cs-cz': 'Otevřít v novém okně',
                        'es-pe': 'Abrir una nueva ventana',
                        'eu-es': 'Ireki leiho berrian',
                        'en-gb': 'Open in new window',
                        'eu': 'Ireki leiho berrian',
                        //'fa-ir': 'درپنجره مرورجدیدبازکن',
                        'fr-fr': 'Ouvrir dans une nouvelle fenêtre',
                        'it-it': 'Apri in nuova finestra',
                        'ko-kr': '새 창에서 열기',
                        'nb-no': 'Åpne i nytt vindu',
                        'pl-pl': 'Otwórz w nowym oknie',
                        'pt-br': 'Abrir em uma nova janela',
                        'sr-cyrl' : 'Отвори у новом прозору',
                        'sr-latn' : 'Otvori u novom prozoru',
                        'sl-si': 'Odpri v novem oknu',
                        'tr-tr': 'Yeni pencerede aç',
                        'vec-it': 'Vèrxi in fenèstra niova',
                        'zh-cn': '新窗口打开',
                        'zh-tw': '開啟於新視窗',
                        'ru-ru': 'Открыть в новом окне',
                        'sr-cs': 'Otvori u novom prozoru',
                        'es-es': 'Abrir una nueva ventana',
                        'en-us': 'Open in new window'
                  },
                  'NewInvisibleOpen': {
                        'de-de': 'In neuem, privatem Fenster öffnen',
                        'bg-bg': 'Отваряне на връзката в защитен прозорец',
                        'cs-cz': 'Otevřít v soukromém okně',
                        'es-pe': 'Abrir en una ventana privada',
                        'eu-es': 'Ireki leiho pribatuan',
                        'en-gb': 'Open in private window',
                        'eu': 'Ireki leiho pribatuan',
                        //'fa-ir': 'بازکردن در پنجرهٔ خصوصی',
                        'fr-fr': 'Ouvrir dans une fenêtre privée',
                        'it-it': 'Apri in una nuova finestra privata',
                        'ko-kr': '개인 창에서 열기',
                        'nb-no': 'Åpne i privat vindu',
                        'pl-pl': 'Otwórz w oknie prywatnym',
                        'pt-br': 'Abrir em janela privativa',
                        'sr-cyrl' : 'Отвори у приватном прозору',
                        'sr-latn' : 'Otvori u privatnom prozoru',
                        'sl-si': 'Odprto v zasebnem oknu',
                        'tr-tr': 'Kişiye özel pencerede aç',
                        'vec-it': 'Vèrxi in fenèstra riservada',
                        'zh-cn': '隐身窗口打开',
                        'zh-tw': '開啟於無痕視窗',
                        'ru-ru': 'Открыть в секретном окне',
                        'sr-cs': 'Otvori u privatnom prozoru',
                        'es-es': 'Abrir todo en una ventana privada',
                        'en-us': 'Open in private window'
                  },
                  'NewWindowOpenAll': {
                        'de-de': 'Link in neuem Fenster öffnen',
                        'bg-bg': 'Отваряне на всички връзки в нов прозорец',
                        'cs-cz': 'Otevřít vše v novém okně',
                        'es-pe': 'Abrir todo en una ventana nueva',
                        'eu-es': 'Ireki guztiak leiho berrian',
                        'en-gb': 'Open all in new window',
                        'eu': 'Ireki guztiak leiho berrian',
                        //'fa-ir': 'بازکردن همه در پنجرهٔ جدید',
                        'fr-fr': 'Tout ouvrir dans une nouvelle fenêtre',
                        'it-it': 'Apri tutto in nuova finestra',
                        'ko-kr': '새 창에서 모두 열기',
                        'nb-no': 'Åpne alle i nytt vindu',
                        'pl-pl': 'Otwórz wszystko w nowym oknie',
                        'pt-br': 'Abrir tudo em uma nova janela',
                        'sr-cyrl' : 'Отвори све у новом прозору',
                        'sr-latn' : 'Otvori svе u novom prozoru',
                        'sl-si': 'Odpri vse v novem oknu',
                        'tr-tr': 'Tümünü yeni pencerede aç',
                        'vec-it': 'Vèrxi tuto in fenèstra niova',
                        'zh-cn': '新窗口打开全部',
                        'zh-tw': '全部開啟於新視窗',
                        'ru-ru': 'Открыть все в новом окне',
                        'sr-cs': 'Otvori svе u novom prozoru',
                        'es-es': 'Abrir todo en una nueva ventana',
                        'en-us': 'Open all in new window'
                  },
                  'NewInvisibleOpenAll': {
                        'de-de': 'In neuem, privatem Fenster öffnen',
                        'bg-bg': 'Отваряне на всички връзки в защитен прозорец',
                        'cs-cz': 'Otevřít vše v soukromém okně',
                        'es-pe': 'Abrir todo en una ventana privada',
                        'eu-es': 'Ireki guztiak leiho pribatuan',
                        'en-gb': 'Open all in private window',
                        'eu': 'Ireki guztiak leiho pribatuan',
                        //'fa-ir': 'بازکردن همه در پنجرهٔ خصوصی',
                        'fr-fr': 'Tout ouvrir dans une fenêtre privée',
                        'it-it': 'Apri tutto in nuova finestra privata',
                        'ko-kr': '개인 창에서 모두 열기',
                        'nb-no': 'Åpne alle i privat vindu',
                        'pl-pl': 'Otwórz wszystko w trybie prywatnym',
                        'pt-br': 'Abrir tudo em janela privativa',
                        'sr-cyrl' : 'Отвори све у приватном прозору',
                        'sr-latn' : 'Otvori svе u privatnom prozoru',
                        'sl-si': 'Odpri vse v zasebnem oknu',
                        'tr-tr': 'Tümünü kişiye özel pencerede aç',
                        'vec-it': 'Vèrxi tuto in fenèstra riservada',
                        'zh-cn': '隐身窗口打开全部',
                        'zh-tw': '全部開啟於無痕視窗',
                        'ru-ru': 'Открыть все в секретном окне',
                        'sr-cs': 'Otvori svе u privatnom prozoru',
                        'es-es': 'Abrir todo en ventana privada',
                        'en-us': 'Open all in private window'
                  },
                  hotPluginTitle: {
                        'zh-cn': '热门插件',
                        'en-us': 'Hot Extensions'
                  },
                  hotPluginAdd: {
                        'zh-cn': '添加',
                        'en-us': 'Add'
                  },
                  hotPluginMore: {
                        'zh-cn': '更多',
                        'en-us': 'More'
                  }
            },

            getLang: function (key) {
                  var result;
                  return (result = this.lang[key]) ? ((result[this.Locale]) ? result[this.Locale] : (result = result['en-us']) ? result : key) : key;
            }
      };

      Language.init = function () {
            var thiz = this;
            thiz.Locale = navigator.language.toLocaleLowerCase();
            $('title').html(Language.getLang('DocumentTitle'));
      }

      Language.init();
      window.Language = Language;
});