;$(function () {

var Api = window.Api.Maxthon;
var lang = navigator.language.toLocaleLowerCase();
var isZh = lang === 'zh-cn';

var $search = $('.search-bar');
var $searchEngine = $search.find('.search-engine');
var $changeEngine = $search.find('.change-engine');
var $searchForm = $search.find('.search-form');
var $searchInput = $search.find('.button');
var $engineList = $search.find('.engine-list');
var $searchLogo = $search.find('#s_lg_img');
var googleIcon = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACSElEQVQ4jZWTS0jUURTGf3f+//GFD3RUClSUpBIlhoIWBoGgGZGUkpTQJtpZhMtaBNKmaFULF0ElQW1cuJGMSKMiCkLKkjJtCB8jjo8ZX9PYjPr/WqjDZAb1wYXLOec737nc7xi2QJIbaAAOA6UbYR/wCug0xqxs5SSS8yXdlxSVJOdHWE54SRuIbuTyEzkmgbwXeAYURDoeEu3pZvW7DyTsklJSjtaRcuwkJi3ND9QYY74mKnskTa+FggqePy2/x8ifjQLeYgW8JZrwGI2B5i9f2pxmWpJnk2xLal+bk2bPNMmfiaYOVSh8r02xgX7FBvq1ePuGZk/VKvahTwlol2QjqVGSszLQpkA5mizbt7Xwb3AkNdpANWBc5g5ZzcCOJtzeA/HnLcdAFrgsUAwciWTbYFsYoNoGilmL4EwO4d4DVlUiWTTcWmZm0SE9xZDshvkIHPfaXK1PBih2xatdYP0EwmvbfrExsLIKEyGHwIITj9vACFYadkYpQ1OfGR7zUVexnkxNMnS2pG3c4XpXlLe+KIU5cd0RF9ADaDSvhRPzOznb18u7qU9xhdSk9eOfgifvbbLToXK3BSCgx2ptbR0GimIZ+73Pg7N8mejlTeAjkrBcFjPLIR6Pd3Hl6Wv6B3fRdDCD5ho3wAPgptk0EjAYii7kXXhxjY7hbhytUphRgGVcjCyNgxWiPreVu7UXycliBigzxgS3tfKjoS66R1/ybW4UIUoyCzlSVMm58ioscv+0ckKT35YpHIsoHIv82zIlNPmvdf4FC06Ax2OzAhwAAAAASUVORK5CYII=';
var yahooIcon = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACGUlEQVQ4jZ2TPWhTURTHfyfvpk1q37OpWqlFQRBFLKiDSNVBELoIgmMRtYOLuDiJgwqiky46iooWcawuUqS4KGqHFov1g1YdKkjbmDTRvLRJ8967xyFpWhdbPOs9/49z7v9Ir4xNAc38XxUN0L6aTgEqqgRYDEKDxADcGOCvBhyooiitXhzPMzgICn5sNeqhKj4hZx9s4dbUTk7c3kReA6wqBsAg+BqSI8BBaJdGBGFGFwiwWKCrs4VDvSkAxl8UKRHhiakS5AnY2+Wx55hHdrLCwJ0MFuX46TY6diV4dj/D/p61AKS/LjD4eJYUcariNYtBWTl6cQMAr/pyzJctZx5uBmByqET3+fUADNzI8ouADkksEbQQZ2g0z9tHeQ6cTHGwp4VyQQHov5Tmy+gcuR8hZT/iTV+e1po6gPTKWEHAzWjA7h3NXB/fjp8NUQtem+Hqvm9sPZzETRr6r6UJsTSJQ5Ue3wAokMLwfsLn42CRzu5qrl7ey5Fqj3PqZgcAH577DA//JolTd1D/RiOCBZ5cTtcfX9/N82mkSHaywvd3JbLTAU3LwPUdLLoQhIQrABQyIZ9HiszZiAvbJqhESoTSLAa7OMByB6EqjQhHzq2j7FueXkkzawNSEqcUWSxKUmJ/getLBFytBWrNRofKvMUvRDgirBBV3wAuVPMeofycqWBRGojh1Eb7R7kGmGbZOSdkSXMFMEDxD5Tv2rfaA87FAAAAAElFTkSuQmCC';

var dataEngine = {
    "lang": {
        'zh-cn': '搜索',
        'en-us': 'search'
    }
}

$search.on('submit', '.search-form', function (e) {
    // 老版标签页搜索框输入关键词回车或点击搜索按钮时触发
    var action = $(this).attr('action');
    if (action === 'http://s.maxthon.com/') {
        var key = $searchInput.val();
        if(key === '') {
            return false;
        }
        maxthon.webSend("quickaccess.multiSearch", { key: key }, function (data) { })
        return false;
    }
    showZoomBox();
});

$search.keyup(function(e){
    if(e.keyCode == 13 && (e.ctrlKey || e.altKey)){
        $searchForm[0].target = "_blank";
        $searchForm.submit();
        location.reload();
    }
})

/**
 * 点击切换搜索引擎按钮
 */
$search.on('click', '.search-engine', function (e) {
    var $engineList = $searchEngine.find('.engine-list');
    if ($engineList.is(':visible')) {
        hideEngineList();
    } else {
        // 防止国际版en切到zh-cn标识丢失
        $engineList.show();
    }
    var curIndex = 0;
    var maxLenght = $engineList.find('p').length - 1;
    $(document).off('keydown').on('keydown', function (e) {
        switch (e.keyCode) {
            case 38: //向上键
                if (curIndex < 0) {
                    curIndex = maxLenght;
                }
                // console.log(curIndex);
                $engineList.find('p').removeClass('hover');
                $engineList.find('p').eq(curIndex--).addClass('hover');
                break;
            case 40: //向下键
                if (curIndex > maxLenght) {
                    curIndex = 0;
                }
                // console.log(curIndex);
                $engineList.find('p').removeClass('hover');
                $engineList.find('p').eq(curIndex++).addClass('hover');
                break;
            case 13:
                $engineList.find('p').eq(curIndex).trigger('click');
                break;
        }
        e.preventDefault();
    });

    $changeEngine.toggleClass('down');
    e.stopPropagation();
    e.preventDefault();
});

/**
 * 设置搜索引擎
 */
function setEngine(data) {
    $searchEngine.css({'background-image' : 'url(' + parseIconUrl(data.iconURL) + ')'});
    var arrTmp = data.url.split('?');
    var action = arrTmp[0];
    if(arrTmp[1]) {
        var nameParam = arrTmp[1].match(/[\w\-]+=%[\w\-]+/g);
        var keywordName = nameParam[0].split('=')[0];
        var reg = new RegExp('&*' + nameParam + '&*', 'g');
        var param = arrTmp[1].replace(reg, '&').replace(/^&+|&+$/g, '');

        $searchInput.attr('name', keywordName);
        // 添加搜索额外参数
        param = param.replace(/^&+|&+$/g, ''); // 矫正首尾无效值
        var arr = param.split('&');
        var $extraParam = $('<div>', { 'class': 'extra-param' });
        var tmpl = '';
        for (var i = 0; i < arr.length; i++) {
            var n = arr[i].indexOf('=');
            var key = arr[i].substring(0, n);
            var value = arr[i].substring(n + 1);
            tmpl += '<input type="hidden" name="' + key + '" value="' + value + '">';
        }
        $searchForm.find('.extra-param').remove();
        $searchForm.append($extraParam);
        $extraParam.html(tmpl);
    }

    $changeEngine.text(data.displayName);
    $searchForm.attr('action', action);
    // 百度搜索特殊处理
    if (data.displayName == '百度' && !data.url.match(/^https/)) {
        $searchForm.attr('action', action.replace('http', 'https'));
    }
}

/**
 * 搜索时模拟页面跳转
 */
function showZoomBox() {
    var zoomBox = $('<div id="zoom-box"></div>');
    var rect = document.body.getBoundingClientRect();
    zoomBox.appendTo('body');
    zoomBox.css({
        left: rect.left + "px",
        top: rect.top + "px",
        right: rect.right + "px",
        bottom: rect.bottom + "px"
    });
    zoomBox.addClass('in');

    setTimeout(function () {
        zoomBox[0].style.cssText = '';
        zoomBox[0].style.opacity = 1;
    }, 10);
}

/**
 * 隐藏搜索引擎切换列表
 */
function hideEngineList() {
    $engineList.hide();
    $changeEngine.addClass('down'); // 恢复箭头方向
    $(document).off('keydown');
    $engineList.find('p').removeClass('hover');
}

/**
 * 生成搜索引擎列表
 */
function buildEngineList(ele, list) {
    var res = '<div class="engine-list-inner">';
    var _Language = dataEngine['lang'];
    list.forEach(function (item, i) {
        if (item.default) {
            setEngine(item);
        }
        res += '<p data-engine=' + i + '><img src="' + parseIconUrl(item.iconURL) + '" /><span>' + item.displayName + '</span></p>';
    });

    res += '</div>';
    ele.empty().append(res);

    $searchInput.attr('placeholder', dataEngine['lang'][lang] || dataEngine['lang']['en-us']);
    $searchEngine.attr('title', Language.getLang('SelectDefaultEngine'));
}

function parseIconUrl (icon) {
    try {
        let url = new URL(icon);
        if (/google\.[a-z]{2,4}/.test(url.host)) {
            return googleIcon;
        }
        if (/yahoo\.[a-z]{2,4}/.test(url.host)) {
            return yahooIcon;
        }
    } catch (e) {
        icon = '/static/img/icon/6000.png';
    }
    return icon;
}

function initEngineList() {
    Api.getData('getSearchEnginesList', function (err, data) {

        let searchEngineList = data.defaults;

        buildEngineList($engineList, searchEngineList);

        $search.on('click', '.engine-list p', function (e) {
            let index = $(this).index();
            var defaultSearch = searchEngineList[index];
            setEngine(defaultSearch);
            Api.setData('setDefaultSearchEngine', index);
            hideEngineList();
            e.stopPropagation();
        });
    });

    Api.useApi('config.onChange', {}, function(data) {
        if(data.key && data.key === 'browser.general.default_search_engine2') {
            setEngine(JSON.parse(data.value));
        }
    });
}

initEngineList();
$(document).off('click', hideEngineList).on('click', hideEngineList);

});
