module.exports = function(grunt) {
    require('load-grunt-tasks')(grunt);
    grunt.initConfig({
        pkg: grunt.file.readJSON('package.json'),
        path: {
            images: 'images',
            css: 'css',
            js: 'js',
            releaseDir: 'release'
        },
        clean: {
            options: {
                force: true
            },
            release: ['<%= path.releaseDir%>']
        },
        cssmin: {
            mobile: {
                files: [{
                    expand: true,
                    cwd: '<%= path.css %>/',
                    src: ['*.css'],
                    dest: '<%= path.releaseDir%>/css/'
                }]
            },
            zui: {
                files: [{
                    expand: true,
                    cwd: '<%= path.js %>/zui/css/',
                    src: ['*.css'],
                    dest: '<%= path.releaseDir%>/js/zui/css/'
                }]
            }
        },
        uglify: {
            mobile: {
                files: [{
                    expand: true,
                    cwd: '<%= path.js %>/',
                    src: ['**/*.js'],
                    dest: '<%= path.releaseDir%>/js/'
                }]
            }
        },
        copy: {
            images: {
                files: [{
                    expand: true,
                    cwd: '<%= path.images %>/',
                    src: ['*.{png,jpg,gif,svg}'],
                    dest: '<%= path.releaseDir%>/images/'
                }]
            },
            zui: {
                files: [{
                    expand: true,
                    cwd: '<%= path.js %>/zui/fonts/',
                    src: ['*.{eot,svg,ttf,woff}'],
                    dest: '<%= path.releaseDir%>/js/zui/fonts/'
                }]
            }
        }
    });
    grunt.registerTask('default', [
        'clean',
        'cssmin:mobile',
        'cssmin:zui',
        'uglify:mobile',
        'copy:images',
        'copy:zui'
    ])
}