;(function(w) {
    w.zhxxObj = {};
    zhxxObj.accdata = localStorage.getItem("accountData");
    if (!zhxxObj.accdata) {
        window.location.href="password.html";
        localStorage.removeItem("loginTime");
    } else {
        zhxxObj.list = [];
        //获取数据
        zhxxObj.init = function() {
            api.cardQueryAll({"type":"account"}, zhxxObj.querycallback, function(obj) {
                console.log("error");
                factory.errorDialogOpen();
            });
        };
        zhxxObj.querycallback = function(obj) {
            var results = obj;
            var len = results.length;
            $("#zhcounts").html("(" + len + ")");
            if (len > 0) {
                $(".nocontent").hide();
                let array = [];
                for (let i = 0; i < len; i++) {
                    let decryptval = {
                        account: results[i].account,
                        note: results[i].note
                    };
                    array.push(
                        function (cb){
                            api.pwdDecrypt({ type: 'user', content: decryptval.account }, function (data) {
                                cb(null, { type: 'account', data: data, index: i });
                            });
                        },
                        function (cb){
                            api.pwdDecrypt({ type: 'user', content: decryptval.note }, function (data) {
                                cb(null, { type: 'note', data: data, index: i });
                            });
                        }
                    );
                }
                //解密数据
                async.parallel(array,function (err, obj) {
                    obj = fixedDecryptData(obj);
                    if (err) {
                        console.log('error');
                        factory.errorDialogOpen();
                    } else {
                        var lists = [];
                        for (var i = 0; i < obj.length; i++) {
                            var listaccount = $.extend({}, results[i], obj[i]);
                            lists.push(listaccount);
                        };
                        zhxxObj.list = lists;
                        zhxxObj.list.sort(function(a, b) {
                            return parseInt(b.update_time) - parseInt(a.update_time);
                        });
                        //生成DOM
                        $(".backup0").show();
                        $("#backuptime0").text(factory.formatTime(zhxxObj.list[0].update_time));
                        zhxxObj.createDom(zhxxObj.list);
                        $("#form-search").val("");
                    }
                });
            } else {
                zhxxObj.list = [];
                $(".backup0").hide();
                $("#zhcounts").html("(" + obj.length + ")");
                $("#zh-body").html('<tr class="nocontent"><td colspan="5" id="nocontent"><img class="guid-info-img" src="images/account.png" ondragstart="return false;"><p class="guid-info-msg">'+Lang.get("AccountGuidInfo")+'</p>'
                    +'<div class="text-center addInfo2"><span class="add-info-icon"></span><span id="addInfo2">'+ Lang.get("AddInfo") +'</span></div>'+'</td></tr>');
                $(".nocontent").show();
            }
        };

        function fixedDecryptData (obj) {
            let results = [];

            for (var i = obj.length - 1; i >= 0; i--) {
                let temp = obj[i];
                if (!results[temp.index]) {
                    results[temp.index] = {};
                };
                results[temp.index][temp.type] = temp.data;
            }

            return results;
        }

        //
        zhxxObj.createDom = function(lists) {
            var trhtml = "";
            for (var i = 0; i < lists.length; i++) {
                trhtml += '<tr data-id="'+lists[i].record_key+'"><td class="catitle"><i class="title-01 item'+lists[i].res_id+'"></i>'
                                + factory.codeTransfor(lists[i].title) + '</td><td class="caname">' + factory.codeTransfor(lists[i].account) + '</td>'
                                + '<td class="capassword"><input class="originpwd" type="password" id="accountpwd" readonly value="' + lists[i].password + '"/></td><td><i class="edit"></i></td>'
                                + '<td><i class="del"></i></td></tr>';
            }
            $("#zh-body").html(trhtml);
            height = ((window.innerHeight > 0) ? window.innerHeight : window.screen.height) - 1;
            height = height > $(".row-right").height() ? height : ($(".row-right").height() + 10);
            $("#zhxx-content .row-left").css("min-height", (height) + "px");
        };
        //添加数据
        zhxxObj.addAccount = function(data) {
            (function() {
                var fecryptData = {};
                fecryptData = {
                    "account": data.account,
                    "note": data.note,
                    "password": data.password
                };

                let array = [
                    function (cb){
                        api.pwdEncry({ type: 'user', content: fecryptData.account }, function (data) {
                            cb(null, { type: 'account', data: data, index: 0 });
                        });
                    },
                    function (cb){
                        api.pwdEncry({ type: 'user', content: fecryptData.note }, function (data) {
                            cb(null, { type: 'note', data: data, index: 0 });
                        });
                    },
                    function (cb){
                        api.pwdEncry({ type: 'user', content: fecryptData.password }, function (data) {
                            cb(null, { type: 'password', data: data, index: 0 });
                        });
                    }
                ];

                async.parallel(array,function (err, obj) {
                    obj = fixedDecryptData(obj);
                    if (err) {
                        console.log('error');
                        factory.errorDialogOpen();
                    } else {
                        var listaccount = $.extend({}, data, obj[0]);
                        obj = {
                            key: listaccount.record_key,
                            type: 'account',
                            value: JSON.stringify(listaccount)
                        };
                        api.updateQuery(obj, function (obj) {
                            zhxxObj.init();
                        }, function(obj) {
                            if (obj.info == "vip") {
                                switch(obj.level) {
                                    case 0:
                                        Dialog.errorDialog({
                                            Ttitle: Lang.get("DialogVipTitle"),
                                            Ttext: Lang.get("DialogVipZTextUp") + obj.most_item + Lang.get("DialogVipZTextDown")
                                        });
                                        factory.openModal("#error-dialog");
                                        break;
                                    case 1:
                                        Dialog.errorDialog({
                                            Ttitle: Lang.get("DialogVipTitle"),
                                            Ttext: Lang.get("DialogVipFTextUp") + obj.most_item + Lang.get("DialogVipFTextDown")
                                        });
                                        factory.openModal("#error-dialog");
                                        break;
                                    case 2:
                                        Dialog.errorDialog({
                                            Ttitle: Lang.get("DialogVipTitle"),
                                            Ttext: Lang.get("DialogVipSTextUp") + obj.most_item + Lang.get("DialogVipSTextDown")
                                        });
                                        factory.openModal("#error-dialog");
                                        break;
                                }
                            } else {
                                factory.errorDialogOpen();
                            }
                        });
                    }
                });
            })();
        };
        //详情生成数据
        zhxxObj.createData = function(key) {
            var singledata = {};
            if (zhxxObj.list.length > 0) {
                for (var i = 0; i < zhxxObj.list.length; i++) {
                    if (zhxxObj.list[i].record_key === key) {
                        singledata = zhxxObj.list[i];
                        return singledata;
                    }
                }
            }
        };
        //编辑生成数据
        zhxxObj.createEditData = function(key, cb) {
            var singledata = {};
            if (zhxxObj.list.length > 0) {
                for (var i = 0; i < zhxxObj.list.length; i++) {
                    if (zhxxObj.list[i].record_key === key) {
                        singledata = zhxxObj.list[i];
                        cb(singledata);
                    }
                }
            }
        };
        //搜索生成数据
        zhxxObj.searchData = function(title) {
            var arrData = [];
            var singledata = {};
            if (zhxxObj.list.length > 0) {
                for (var i = 0; i < zhxxObj.list.length; i++) {
                    if (zhxxObj.list[i].title.indexOf(title) != -1 || zhxxObj.list[i].account.indexOf(title) != -1) {
                        singledata = zhxxObj.list[i];
                        arrData.push(singledata);
                    }
                }
                if (arrData.length > 0) {
                    $(".nocontent").hide();
                    zhxxObj.createDom(arrData);
                } else {
                    $("#zh-body").html(' <tr class="nocontent nocontent-search"><td colspan="5" id="nocontent">'+Lang.get("NoSearchContent")+'</td></tr>');
                    $(".nocontent").show();
                }
            } else {
                $("#zh-body").html('<tr class="nocontent"><td colspan="5" id="nocontent"><img class="guid-info-img" src="images/account.png" ondragstart="return false;"><p class="guid-info-msg">'+Lang.get("AccountGuidInfo")+'</p>'
                    +'<div class="text-center addInfo2"><span class="add-info-icon"></span><span id="addInfo2">'+ Lang.get("AddInfo") +'</span></div>'+'</td></tr>');
                $(".nocontent").show();
            }
        };

        //修改数据
        zhxxObj.updateAccount = function(data) {
            (function() {
                //进行加密
                let array = [
                    function (cb){
                        api.pwdEncry({ type: 'user', content: data.account }, function (data) {
                            cb(null, { type: 'account', data: data, index: 0 });
                        });
                    },
                    function (cb){
                        api.pwdEncry({ type: 'user', content: data.note }, function (data) {
                            cb(null, { type: 'note', data: data, index: 0 });
                        });
                    },
                    function (cb){
                        api.pwdEncry({ type: 'user', content: data.password }, function (data) {
                            cb(null, { type: 'password', data: data, index: 0 });
                        });
                    }
                ];

                async.parallel(array,function (err, obj) {
                    obj = fixedDecryptData(obj);
                    if (err) {
                        console.log('error');
                        factory.errorDialogOpen();
                    } else {
                        var listaccount = $.extend({}, data, obj[0]);
                        obj = {
                            key: listaccount.record_key,
                            type: 'account',
                            value: JSON.stringify(listaccount)
                        };
                        api.updateQuery(obj, function (obj) {
                            key = null;
                            listaccount = {};
                            data = {};
                            zhxxObj.init();
                        }, function(obj) {
                            console.log('error');
                            factory.errorDialogOpen();
                        });
                    }
                });
            })();
        };

        //删除数据
        zhxxObj.deleteAccount = function(key) {
            //获取key
            (function(){
                api.deleteQuery({ "type":"account","key":key } , function(obj) {
                    zhxxObj.init();
                }, function(obj) {
                    console.log("error");
                    factory.errorDialogOpen();
                });
            })();
        };

        //密码切换解密
        zhxxObj.pwdDencry = function(key, cb) {
            if (zhxxObj.list.length > 0) {
                for (var i = 0; i < zhxxObj.list.length; i++) {
                    if (zhxxObj.list[i].record_key === key) {
                        var listaccount = {};
                        listaccount = $.extend(listaccount, zhxxObj.list[i]);
                        if (listaccount.password) {
                            (function() {
                                var array = [];
                                var singledata = {};
                                singledata.password = listaccount.password;
                                array.push(singledata);
                                //解密数据
                                let value = listaccount.password;
                                api.pwdDecrypt({ type: 'user', content: value }, function(obj) {
                                    cb(obj);
                                }, function(obj) {
                                    console.log('error');
                                    factory.errorDialogOpen();
                                });
                            })();
                        } else {
                            cb(listaccount.password)
                        }
                    }
                }
            }
        };
        //密码切换加密
        zhxxObj.pwdEncry = function(value, cb) {
            var fecryptData = {
                "password": value
            };
            (function() {
                var json = [];
                json.push(fecryptData);
                //进行加密
                let value = fecryptData.password;
                api.pwdEncry({ type: 'user', content: value }, function (password) {
                    cb(password);
                }, function(obj) {
                    console.log('error');
                    factory.errorDialogOpen();
                });
            })();
        };
        //同步
        zhxxObj.syncHand = function() {
            $(".syncInfo").children(".sync-info-icon").addClass("sysc");
            $(".syncInfo").children("#syncInfo").text(Lang.get("SyncWorking"));
            api.sync('account');
        };
        // maxthon.send("magicfill.addListener", [{params:{}, callback:"window.synccallback"}]);

        api.updateServiceAddress('MAXTHON_REST_SERVICE', function () {
            api.getProfile(function (data) {
                api.isLogin(function(data) {
                    if (data) {
                        zhxxObj.init();
                    }
                });
            }, function () {
                console.log('error');
                factory.errorDialogOpen();
            });
        });
    }
 })(window);