window.apiCB = {};
window.maxthon = $.extend({}, window.maxthon, window.chrome);
window.maxthon.webSend = function () {};

var cr = cr || {};

if ( $.type(cr.webUIResponse) !== 'function' ) {
    cr.webUIResponse = function () {
        let args = Array.from(arguments);
        let [name, status, rest] = args;
        if (status === true) {
            api[name](rest);
        }
    }
}
if ($.type(cr.webUIListenerCallback) !== 'function' ) {

    cr.webUIListenerCallback = function(obj) {
        if (obj.action == 'notify' && obj.type == 'sync' && obj.value == 2) {
            if (obj.caller == "magic_account") {
                var sysnctimer = null;
                clearTimeout(sysnctimer);
                $(".syncInfo").children(".sync-info-icon").removeClass("sysc");
                $(".syncInfo").children("#syncInfo").text(Lang.get("SyncInfo"));
                $(".del-fail").addClass("del-success");
                $("#suc-text").text(Lang.get("SyncOK"));
                $(".sync-msg").show();
                sysnctimer = setTimeout(function() {
                    $(".sync-msg").hide();
                }, 5000);
                window.zhxxObj && zhxxObj.init();
            } else if (obj.caller == "magic_secret") {
                var sysnctimer1 = null;
                clearTimeout(sysnctimer1);
                $(".syncInfo1").children(".sync-info-icon").removeClass("sysc");
                $(".syncInfo1").children("#syncInfo1").text(Lang.get("SyncInfo"));
                $(".del-fail1").addClass("del-success");
                $("#suc-text1").text(Lang.get("SyncOK"));
                $(".sync-msg1").show();
                sysnctimer1 = setTimeout(function() {
                    $(".sync-msg1").hide();
                }, 5000);
                window.smxxObj && smxxObj.init();
            } else if (obj.caller == "magic_password") {
                var sysnctimer2 = null;
                clearTimeout(sysnctimer2);
                $(".syncInfo2").children(".sync-info-icon").removeClass("sysc");
                $(".syncInfo2").children("#syncInfo2").text(Lang.get("SyncInfo"));
                $(".del-fail2").addClass("del-success");
                $("#suc-text2").text(Lang.get("SyncOK"));
                $(".sync-msg2").show();
                sysnctimer2 = setTimeout(function() {
                    $(".sync-msg2").hide();
                }, 5000);
                window.screteObj && screteObj.init();
            }
        }

        if (obj.action == 'notify' && obj.type == 'sync' && obj.value == 3) {
            if (obj.caller == "magic_account") {
                var sysnctimer = null;
                clearTimeout(sysnctimer);
                $(".syncInfo").children(".sync-info-icon").removeClass("sysc");
                $(".syncInfo").children("#syncInfo").text(Lang.get("SyncInfo"));
                $("#suc-text").text(Lang.get("SyncError"));
                $(".del-fail").removeClass("del-success");
                $(".sync-msg").show();
                sysnctimer = setTimeout(function() {
                    $(".sync-msg").hide();
                }, 5000);
            } else if (obj.caller == "magic_secret") {
                var sysnctimer1 = null;
                clearTimeout(sysnctimer1);
                $(".syncInfo1").children(".sync-info-icon").removeClass("sysc");
                $(".syncInfo1").children("#syncInfo1").text(Lang.get("SyncInfo"));
                $(".del-fail1").removeClass("del-success");
                $("#suc-text1").text(Lang.get("SyncError"));
                $(".sync-msg1").show();
                sysnctimer1 = setTimeout(function() {
                    $(".sync-msg1").hide();
                }, 5000);
            } else if (obj.caller == "magic_password") {
                var sysnctimer2 = null;
                clearTimeout(sysnctimer2);
                $(".syncInfo2").children(".sync-info-icon").removeClass("sysc");
                $(".syncInfo2").children("#syncInfo2").text(Lang.get("SyncInfo"));
                $(".del-fail2").removeClass("del-success");
                $("#suc-text2").text(Lang.get("SyncError"));
                $(".sync-msg2").show();
                sysnctimer2 = setTimeout(function() {
                    $(".sync-msg2").hide();
                }, 5000);
            }
        }

        if (obj.type == "dataUpdate") {
            location.reload();
        }

        if (obj.webui_type == 'logout') {
            chrome.send('mxOpenUrlInCurrentTab', ['mx://password/guest.htm']);
        }

        if (obj.webui_type == 'login') {
            chrome.send('mxOpenUrlInCurrentTab', ['mx://password/tab.htm']);
        }
    }
}


const api = (function(W) {

    let CURRENT_PROFILE = null;
    let CURRENT_INFO = null;
    let loginStatus = false;
    let callbackIndex = 0;
    var restPort;
    var notifyPort;

    function send (method, cb, ...rest) {
        let tmp = 'tmp_callback_' + callbackIndex++;
        apiCB[tmp] = (ret) => {
            delete apiCB[tmp];
            cb(null, ret);
        };

        tmp = 'apiCB.' + tmp;

        chrome.send(method, [tmp, ...rest]);
    }

    function webSend (mxapi, method, params) {
        return new Promise(function (resolve, reject) {
            let config = {
                url: restPort + '/magicfill/' + mxapi,
                headers: {
                    "UserName": CURRENT_PROFILE.profile
                },
                method: method,
                data: params,
                dataType: 'json',
                success: function (data) {
                    resolve(data);
                },
                error: function (error) {
                    reject(error)
                }
            }
            if (method.toUpperCase() !== 'GET') {
                config.data = JSON.stringify(params);
            }
            $.ajax(config);
        });
    }

    function isLogin (cb) {
        send('account.isLogin', (err, data) => {
            if (err) {
                return;
            }
            loginStatus = data;
            if ($.type(cb) == 'function') {
                cb(data);
            }
        });
    }

    function getProfile (success, fail) {
        send('getCurrentUserProfile', (err, data) => {
            if (err) {
                fail(err);
            } else {
                CURRENT_PROFILE = data;
                success(data);
            }
        });
    };

    function getInfo (success) {
        $.ajax({
            url: restPort + '/account/get/profile',
            method: 'POST',
            headers: {
                    "UserName": CURRENT_PROFILE.profile
            },
            data: {
                profile: CURRENT_PROFILE.profile
            },
            dataType: 'json',
            success: function (data) {
                CURRENT_INFO = data;
                success(data);
            },
            error: function (err) {
                console.log("error");
                factory.errorDialogOpen();
            }
        })
    }

    function checkPassword (password, success, fail) {
        send('account.checkCurrentUserPassword', (err, data) => {
            if (err || data.status === false) {
                console.log(err || data);
                fail();
                return;
            }
            success(data);
        }, password);
    }

    function getSavedAllPasswords (success, fail) {
        send('magicfill.getSavedAllPasswords', (err, data) => {
            if (err || data.status === false) {
                console.log(err || data);
                fail();
                return;
            }
            success(data);
        });
    }

    function pwdEncry (obj, success, fail) {
        let type = obj.type != 'sys' ? 'magicfill.userEncry' : 'magicfill.systemEncry'
        send(type, (err, data) => {
            if (err || data.status === false) {
                console.log(err || data);
                fail();
                return;
            }
            success(data);
        }, obj.content);
    }

    function pwdDecrypt (obj, success, fail) {
        let type = obj.type != 'sys'  ? 'magicfill.userDecrypt' : 'magicfill.systemDecrypt'
        send(type, (err, data) => {
            if (err || data.status === false) {
                console.log(err || data);
                fail();
                return;
            }
            success(data);
        }, obj.content);
    }

    function savePassword (obj, success, fail) {
        send("magicfill.saveOnePassword", (err, data) => {
            if (err || data.status === false) {
                console.log(err || data);
                fail();
                return;
            }
            success(data);
        }, obj);
    }

    function deletePassword (obj, success, fail) {
        send("magicfill.deleteOnePassword", (err, data) => {
            if (err || data.status === false) {
                console.log(err || data);
                fail();
                return;
            }
            success(data);
        }, obj);
    }

    function cardQueryAll (obj, success, fail) {
        webSend('card/all', 'GET', obj).then((data) => {
            success(data);
        }).catch((err) => {
            fail(err);
        });
    }

    function updateQuery (obj, success, fail) {
        webSend('card/add_or_update', 'POST', obj).then((data) => {
            success(data);
        }).catch((err) => {
            fail(err);
        });
    }

    function deleteQuery (obj, success, fail) {
        webSend('card', 'DELETE', obj).then((data) => {
            success(data);
        }).catch((err) => {
            fail(err);
        });
    }

    function getCommonAuthInfo (cb) {
        webSend('common/auth_info', 'GET').then((data) => {
            cb(data);
        }).catch((err) => {
            cb(err);
        });
    }

    function setCommonAuthInfo (data, cb) {
        webSend('common/auth_info', 'POST', data).then((data) => {
            cb(data);
        }).catch((err) => {
            cb(err);
        });
    }

    function sync (type) {
        $.ajax({
            url: notifyPort + '/',
            method: 'GET',
            headers: {
                    "UserName": CURRENT_PROFILE.profile
            },
            data: {
                action: 'sync',
                caller: 'magic_' + type
            },
            success: function (data) {}
        });
    }

    function getRecords (cb) {
        $.ajax({
            url: restPort + '/account/device/record/get',
            method: 'POST',
            headers: {
                    "UserName": CURRENT_PROFILE.profile
            },
            data: {
                profile: CURRENT_PROFILE.profile
            },
            dataType: 'json',
            success: function (data) {
                if (data.records) {
                    cb(data.records);
                } else {
                    console.log("error");
                    factory.errorDialogOpen();
                }
            },
            error: function (err) {
                console.log("error");
                factory.errorDialogOpen();
            }
        })
    }

    function setRecords () {
        $.ajax({
            url: restPort + '/account/device/record/set',
            method: 'POST',
            headers: {
                    "UserName": CURRENT_PROFILE.profile
            },
            data: {
                profile: CURRENT_PROFILE.profile
            },
            success: function (data) {},
            error: function (err) {
                console.log("error");
                factory.errorDialogOpen();
            }
        })
    }

    function get2FA (cb) {
        $.ajax({
            url: restPort + '/account/misc/info/get',
            method: 'POST',
            headers: {
                    "UserName": CURRENT_PROFILE.profile
            },
            dataType: 'json',
            data: {
                profile: CURRENT_PROFILE.profile
            },
            success: function (data) {
                var obj = $.extend({}, CURRENT_PROFILE, data);
                cb(obj);
            },
            error: function (err) {
                console.log("error");
                factory.errorDialogOpen();
            }
        });
    }

    function set2FA (pwdrevalid, cb) {
        $.ajax({
            url: restPort + '/account/misc/info/set',
            method: 'POST',
            headers: {
                    "UserName": CURRENT_PROFILE.profile
            },
            data: {
                profile: CURRENT_PROFILE.profile,
                pwdrevalid: pwdrevalid
            },
            dataType: 'json',
            success: function (data) {
                cb(data);
            },
            error: function (err) {
                console.log("error");
                factory.errorDialogOpen();
            }
        });
    }

    function sendVERCode (cb) {
        $.ajax({
            url: restPort + '/account/vcode/mobile',
            method: 'POST',
            headers: {
                    "UserName": CURRENT_PROFILE.profile
            },
            data: {
                action: 'security',
                country: CURRENT_INFO.country_code,
                mobile: CURRENT_INFO.mobile
            },
            dataType: 'json',
            success: function (data) {
                cb(data);
            },
            error: function (err) {
                console.log("error");
                factory.errorDialogOpen();
            }
        });
    }

    function verifyVERCode (code, cb) {
        $.ajax({
            url: restPort + '/account/vcode/verifymobile',
            method: 'POST',
            headers: {
                    "UserName": CURRENT_PROFILE.profile
            },
            data: {
                country: CURRENT_INFO.country_code,
                mobile: CURRENT_INFO.mobile,
                vcode: code
            },
            dataType: 'json',
            success: function (data) {
                cb(data);
            },
            error: function (err) {
                console.log("error");
                factory.errorDialogOpen();
            }
        })
    }

    function updateServiceAddress(server, cb) {
        send('maxthon.getServiceAddress', function (err, data) {
            if (server == 'MAXTHON_REST_SERVICE') {
                restPort = data;
            } else if (server == 'MAXTHON_NOTIFY_SERVICE') {
                notifyPort = data;
            }
            cb(data);
        }, server);
    }

    updateServiceAddress('MAXTHON_NOTIFY_SERVICE', function () {});

    return {
        webSend,
        getProfile,
        getInfo,
        isLogin,
        checkPassword,
        getSavedAllPasswords,
        pwdEncry,
        pwdDecrypt,
        savePassword,
        deletePassword,
        cardQueryAll,
        updateQuery,
        deleteQuery,
        getCommonAuthInfo,
        setCommonAuthInfo,
        sync,
        updateServiceAddress,
        restPort,
        notifyPort,
        getRecords,
        setRecords,
        sendVERCode,
        verifyVERCode,
        get2FA,
        set2FA
    }
})(window);