var factory = (function() {
    //统计
    function statistics(data) {
        data = data || {};
        var config = {
            pt: 'passkeeper',
            dt: '',
            dr: '',
            m: '',
            n: '',
            o: '',
            p: '',
            data: ''
        };
        $.extend(true, config, data);
        window.maxthon.loginItem.setUeip2(config, function() {

        }, function() {

        });
    }
    /**
        字数统计
        textfiled:输入文字表单
        countfield:字数显示
        maxlimit:最大字数值
    */
    function textCounter(txtfiled, countfield, maxlimit) {
        var value = $(txtfiled).val() || "";
        if (textLength(value) == maxlimit || textLength(value) > maxlimit) {
            $(txtfiled).siblings(countfield).text("0");
            $(txtfiled).addClass("lenerror");
            $(txtfiled).siblings(countfield).addClass("word-count-red");
        } else {
            var lastCount = maxlimit - textLength(value);
            $(txtfiled).siblings(countfield).text(lastCount);
            if ($(txtfiled).siblings(countfield).hasClass("word-count-red") && $(txtfiled).hasClass("lenerror")) {
                $(txtfiled).siblings(countfield).removeClass("word-count-red");
                $(txtfiled).removeClass("lenerror");
            }
        };
    }

    function textLength (s) {
        if (!s) return 0;
        var n = s.length, i = 0, len = 0;
        while(i < n) {
            len += s.charCodeAt(i) > 256 ? 1 : 1;
            i++;
        }
        return len;
    }
    //检测非法字符
    function codeTransfor(val) {
        return val.replace(/</gm, '&lt;').replace(/>/gm, '&gt;').replace(/"/gi,'&quot;').replace(/'/gi,'&acute;');
    }
    //打开modal
    function openModal(obj) {
        $(obj).modal('toggle', {
            keyboard: false,
            position: 'center',
            backdrop: 'static'
        });
    }

    //errorDialog
    function errorDialogOpen(reason) {
        Dialog.errorDialog({
            Ttitle: Lang.get("ErrorTitle"),
            Ttext: reason || Lang.get("ErrorMessages_networkError")
        });
        openModal("#error-dialog");
        $("#error-dialog").on('shown.zui.modal', function(event) {
            event.preventDefault();
            var $that = $(this);
            $("#error-dialog").find('.modal-footer button:first').click(function() {
                $that.modal('toggle');
                return; // 临时
                localStorage.removeItem("loginTime");
                localStorage.removeItem("logintimes");
                localStorage.removeItem("accountData");
                location.href="password.html";
            });
        });
    }

    //添加头像
    function addAvatar(obj) {
        var sliderUl = $(obj).find(".slider-ul");
        if (sliderUl.children('li').length == 0) {
            createDomAvatar(sliderUl, 4, 36);
        }

    }
    //头像点击
    function imgTitleClick(obj) {
        $(obj).on('click', '.img-title', function(event) {
            event.preventDefault();
            if ($(this).children('i').hasClass('icon-caret-down')) {
                $(this).children('i').removeClass("icon-caret-down").addClass('icon-caret-up active');
                $(obj).find(".slider").show();
                addAvatar(obj);
                //调用动画函数
                imageSlider(obj);
                statistics({
                    m: 'addicon',
                    dt: 'ui'
                });
            } else{
                $(this).children('i').removeClass("icon-caret-up active").addClass('icon-caret-down');
                $(obj).find(".slider").hide();
            }
        });
    }
    function imgaddTitleClick(obj) {
        $(obj).on('click', '.img-title', function(event) {
            event.preventDefault();
            if ($(this).children('i').hasClass('icon-caret-down')) {
                $(this).children('i').removeClass("icon-caret-down").addClass('icon-caret-up active');
                $(obj).find(".slider").show();
                addAvatar(obj);
                //调用动画函数
                imageSlider(obj);
            } else{
                $(this).children('i').removeClass("icon-caret-up active").addClass('icon-caret-down');
                $(obj).find(".slider").hide();
            }
        });
    }

    //缓动动画
    function imageSlider(obj) {
        var sliderNav = $(obj).find(".slider-nav");
        var sliderUl = $(obj).find(".slider-ul");
        var lis = sliderUl.children();
        var sliderPrev = $(obj).find(".slider-prev");
        var sliderNext = $(obj).find(".slider-next");
        var sliderWrap = sliderUl.parent();
        var imgWidth = sliderWrap.width();
        var timer = null;
        var pic = 0;//纪录箭头序号


        //鼠标经过按钮，滚动到指定位置
        var navLis = sliderNav.children();
        //console.log(navLis);
        for (var j = 0;j < navLis.length;j++) {
            navLis[j].index = j;
            navLis[j].onmouseover = function() {
                $(this).addClass('current').siblings('li').removeClass('current');
                var target = -$(this).index() * imgWidth;
                animate(sliderUl[0], target);
                pic = $(this).index();
            }
        }

        //箭头滚动
        sliderNext.on('click', function(event) {
            event.preventDefault();
            playNext();
        });
        sliderPrev.on('click', function(event) {
            event.preventDefault();
            if (pic == 0) {
                pic = lis.length -1;
                sliderUl[0].style.left = -(lis.length -1) * imgWidth + "px";
            } else {
                pic--;
                var target = -pic * imgWidth;
                animate(sliderUl[0], target);
            }
            navLis.eq(pic).addClass('current').siblings('li').removeClass('current');
        });

        function playNext () {
            if (pic == lis.length -1) {
                sliderUl[0].style.left = 0;
                pic = 0;
            } else {
                pic++;
                var target = -pic * imgWidth;
                animate(sliderUl[0], target);
            }
            navLis.eq(pic).addClass('current').siblings('li').removeClass('current');
        }

        //自动播放
        //timer = setInterval(playNext, 5000);
        //滚动动画方法
        function animate(obj, target) {
            var step = 20;
            clearInterval(obj.timer);
            step = obj.offsetLeft < target ? step : -step;
            obj.timer = setInterval(function() {
                if (Math.abs(obj.offsetLeft - target) > Math.abs(step)) {
                    obj.style.left = obj.offsetLeft + step + "px";
                } else {
                    obj.style.left = target + "px";
                    clearInterval(obj.timer);
                }
            },25);
        }
    }

    //头像结构生成
    function createDomAvatar (obj, times, counts) {
        var li = "";
        var num = 0;
        var navLi = "";
        for (var i = 0; i < times; i++) {
            li += "<li>";
            navLi += "<li class='slider-item'></li>";
            for (var j = 0; j < counts; j++) {
                num ++;
                if (num < 111) {
                    li += "<i class='item" + num + "'></i>";
                }
            };
            li += "</li>";
        };
        obj.append(li);
        obj.parent().siblings().find(".slider-nav").append(navLi).children('li').eq(0).addClass('current');

        //选择头像
        obj.on('click', 'i', function(event) {
            event.preventDefault();
            var clName = $(this).attr('class');
            if (obj.closest('.modal').attr('id') == 'edit-dialog') {
                $(this).closest('#edit-dialog').find('.title-01').removeClass().addClass('title-01 ' + clName);
                $(this).closest('#edit-dialog').find('.title-01').siblings('i').removeClass("icon-caret-up active").addClass('icon-caret-down');
            } else if(obj.closest('.modal').attr('id') == 'add-dialog') {
                $(this).closest('#add-dialog').find('.title-01').removeClass().addClass('title-01 ' + clName);
                $(this).closest('#add-dialog').find('.title-01').siblings('i').removeClass("icon-caret-up active").addClass('icon-caret-down');
            } else if (obj.closest('.modal').attr('id') == 'edit-dialog2') {
                $(this).closest('#edit-dialog2').find('.title-01').removeClass().addClass('title-01 ' + clName);
                $(this).closest('#edit-dialog2').find('.title-01').siblings('i').removeClass("icon-caret-up active").addClass('icon-caret-down');
            } else if(obj.closest('.modal').attr('id') == 'add-dialog2') {
                $(this).closest('#add-dialog2').find('.title-01').removeClass().addClass('title-01 ' + clName);
                $(this).closest('#add-dialog2').find('.title-01').siblings('i').removeClass("icon-caret-up active").addClass('icon-caret-down');
            }

            $(this).closest('.slider').hide();
            //var num = clName.split('item')[1];
        });

    }

    function fillZero (n, l) {
        return (Math.pow(10, l) + ~~n).toString().substr(1, l);
    }
    //时间格式转化
    function formatTime(time) {
        var newTime = new Date(time*1000);
        return newTime.getFullYear() + '-' + fillZero((newTime.getMonth() + 1),2) + '-' + fillZero(newTime.getDate(),2) + ' ' + fillZero(newTime.getHours(),2) + ':' + fillZero(newTime.getMinutes(),2) + ':' + fillZero(newTime.getSeconds(),2);
    }

    //发送验证码
    function sendCode($that) {
        // window.maxthon.webSend('common.sendVERCode', {}, function(msg){
        api.sendVERCode(function(msg) {
            if (msg.errcode == '0') {
                $that.removeClass('btn-primary');
                var timeouttime = 120;
                var timeinterval = null;
                timeinterval = setInterval(function() {
                    timeouttime --;
                    $that.html(timeouttime + Lang.get("ResendIn"));
                    if (timeouttime == 0) {
                        $that.html(Lang.get("Resend"));
                        $that.addClass('btn-primary');
                        $that.attr('disabled', false);
                        clearInterval(timeinterval);
                    }
                }, 1000);
            } else if (msg.errcode == 41204) {
                $that.closest('.modal-dialog').find("#dialog-error").html('<i class="error-icon"></i>'+ Lang.get("TooMushSMS") + '');
                $that.closest('.modal-dialog').find("#dialog-error").show();
                $that.attr('disabled', false);
            } else {
                errorDialogOpen(msg.errcode + ': ' + msg.message);
            }
        });
    }

    //校验验证码
    function verifyCode($that, tfa_state, code, isFreever, flag) {
        $that.closest('.modal-dialog').find(".close").attr("disabled", "disabled");
        // window.maxthon.webSend('common.verifyVERCode', {code: code, single_verify: true},
        api.verifyVERCode(code, function(data) {
            if (data.errcode == '0') {
                if (!flag) {
                    if (tfa_state == false) {
                         toggle2FA("off", flag);
                    } else {
                        if (isFreever) {
                            localStorage.setItem('isFreever', Math.floor((new Date).getTime()/1000));
                        } else {
                            localStorage.removeItem('isFreever');
                        }
                        toggle2FA("on", flag);
                    }
                } else {
                    api.set2FA(tfa_state, function (data) {
                        if (data.errcode == '0') {
                            if (tfa_state == false) {
                                 toggle2FA("off", flag);
                                 localStorage.removeItem('isFreever');
                            } else {
                                if (isFreever) {
                                    localStorage.setItem('isFreever', Math.floor((new Date).getTime()/1000));
                                } else {
                                    localStorage.removeItem('isFreever');
                                }
                                toggle2FA("on", flag);
                            }
                        }
                    });
                }
            } else if (data.errcode == 41106 || data.errcode == 41109) {
                $that.closest('.modal-dialog').find("#dialog-error").html('<i class="error-icon"></i>'+ Lang.get("ErrorCode") + '');
                $that.closest('.modal-dialog').find("#dialog-error").show();
                $that.attr('disabled', false);
                $that.closest('.modal-dialog').find(".close").attr("disabled", false);
                //$("body").append('<div class="modal-backdrop fade in"></div>');
                $that.closest('.modal-dialog').find('.close').click(function() {
                    $(".modal-backdrop").remove();
                });
            } else if (data.errcode == 41205 || data.errcode == 41206) {
                $that.closest('.modal-dialog').find("#dialog-error").html('<i class="error-icon"></i>'+ Lang.get("ExpireError") + '');
                $that.closest('.modal-dialog').find("#dialog-error").show();
                $that.attr('disabled', false);
                $that.closest('.modal-dialog').find(".close").attr("disabled", false);
                //$("body").append('<div class="modal-backdrop fade in"></div>');
                $that.closest('.modal-dialog').find('.close').click(function() {
                    $(".modal-backdrop").remove();
                });
            } else {
                $that.closest('.modal-dialog').find("#dialog-error").show();
                $that.attr('disabled', false);
                $that.closest('.modal-dialog').find(".close").attr("disabled", false);
                //$("body").append('<div class="modal-backdrop fade in"></div>');
                $that.closest('.modal-dialog').find('.close').click(function() {
                    $(".modal-backdrop").remove();
                });
            }
        });
    }


    //开启停用二次验证
    //tfa_state二次验证的状态
    //flag区分开启、停用二次验证（true）和登录二次验证（false）
    //isNowTurnon区分立即启用、停用(true)和其他引起的短信验证(false)
    function enOrUnableTfa(showDialogName, tfa_state, flag, isNowTurnon) {
        openModal(showDialogName);
        //获取验证码
        $(showDialogName).on('shown.zui.modal', function(event) {
            event.preventDefault();
            $(this).find('.btn-send').click(function() {
                var $that = $(this);
                $that.attr('disabled', 'disabled');
                //发送验证码
                sendCode($that);
            });
        });
        //校验验证码
        $(showDialogName).on('shown.zui.modal', function(event) {
            event.preventDefault();
            $(this).find('.modal-footer button:first').click(function(event) {
                    var $that = $(this);
                    $that.attr('disabled', 'disabled');
                    var code = $("#checkcode").val().trim();
                    var isFreever = $('input[name="remeberseven"]:checked').val() ? true : false;
                    if (code == '') {
                        $that.closest('.modal-dialog').find("#dialog-error").html('<i class="error-icon"></i>'+ Lang.get("EnterCode") + '');
                        $that.closest('.modal-dialog').find("#dialog-error").show();
                        $("#checkcode").focus();
                        setTimeout(function() {
                            $that.attr('disabled', false);
                           // $("body").append('<div class="modal-backdrop fade in"></div>');
                            $that.closest('.modal-dialog').find('.close').click(function() {
                                $(".modal-backdrop").remove();
                            });
                        },1000)
                    } else {
                        //校验验证码
                        verifyCode($that, tfa_state, code, isFreever, flag)
                    }
            });
        });
        //验证码回车
        $(".dialog").on("keyup", "#checkcode", function(event) {
            if (event.keyCode == 13) {
                var $that = $(this).closest('.modal-dialog').find('.modal-footer button:first');
                $that.attr('disabled', 'disabled');
                var code = $("#checkcode").val().trim();
                var isFreever = $('input[name="remeberseven"]:checked').val() ? true : false;
                if (code == '') {
                    $that.closest('.modal-dialog').find("#dialog-error").html('<i class="error-icon"></i>'+ Lang.get("EnterCode") + '');
                    $that.closest('.modal-dialog').find("#dialog-error").show();
                    $("#checkcode").focus();
                    setTimeout(function() {
                        $that.attr('disabled', false);
                        //$("body").append('<div class="modal-backdrop fade in"></div>');
                        $that.closest('.modal-dialog').find('.close').click(function() {
                            $(".modal-backdrop").remove();
                        });
                    },1000);
                } else {
                    //校验验证码
                    verifyCode($that, tfa_state, code, isFreever, flag)
                }
            }
        });
        //关闭按钮
        if (!flag&& isNowTurnon) {
            $(showDialogName).on('shown.zui.modal', function(event) {
                $(this).find('.close').click(function() {
                    $(".modal-backdrop").remove();
                    var now = new Date().getTime();
                    localStorage.setItem("loginTime", now);
                    location.href="tab.htm";
                });
            })
        } else if (!flag && !isNowTurnon) {
             $(showDialogName).on('shown.zui.modal', function(event) {
                $(this).find('.close').click(function() {
                    $(".modal-backdrop").remove();
                });
             })
        } else {
            $(showDialogName).on('shown.zui.modal', function(event) {
                $(this).find('.close').click(function() {
                    $(".modal-backdrop").remove();
                });
             })
        }
    }

    function toggle2FA(tfa_state, flag) {
        if (tfa_state == 'on') {
            tfa_state = 'off';
            $(".tfa").each(function(index, item) {
                $(item).attr('data-tfa', tfa_state);
                $(item).find("#tfa-text").html(Lang.get("TurnOffVer"));
            })
            $(".modal-backdrop").remove();
            Dialog.enableTelSuc();
            openModal("#enableTipSu-dialog");

            $("body").removeClass('modal-open');
            $("body").css("padding-right","0");
        } else if (tfa_state == 'off') {
            tfa_state = 'on';
            $(".tfa").each(function(index, item) {
                $(item).attr('data-tfa', tfa_state);
                $(item).find("#tfa-text").html(Lang.get("TurnOnVer"));
            });
            $(".modal-backdrop").remove();
            Dialog.unenableTelTip();
            openModal("#unenableTelTip-dialog");

            $("body").removeClass('modal-open');
            $("body").css("padding-right","0");
        }
        if (!flag) {
            var now = new Date().getTime();
            localStorage.setItem("loginTime", now);
            location.href="tab.htm";
        }
    }

    function bindKeyDownEvent(select, cb) {
        $(document).off('keydown').on('keydown', function (e) {//判断按键
            e = window.event || e;
            if($(select).is(':visible') === true) {
                if(e.keyCode == 13){
                    cb && cb();
                } else if(e.keyCode == 27) {
                    $(select).find('.close').click();
                }
                return false;
            }
        });
    }



    return {
        textCounter: textCounter,
        imgTitleClick: imgTitleClick,
        openModal: openModal,
        imgaddTitleClick: imgaddTitleClick,
        errorDialogOpen: errorDialogOpen,
        codeTransfor: codeTransfor,
        statistics: statistics,
        formatTime: formatTime,
        sendCode: sendCode,
        verifyCode: verifyCode,
        enOrUnableTfa: enOrUnableTfa,
        bindKeyDownEvent: bindKeyDownEvent
    }

})();
