;(function(w) {
    w.screteObj = {};
    screteObj.accdata = localStorage.getItem("accountData");
    var flag = true;
    if (!screteObj.accdata) {
        window.location.href="password.html";
    } else {
        screteObj.list = [];
        screteObj.elements = []; //所有数据dom元素
        screteObj.pending_elements = []; //待显示的数据dom元素

        //一次性最多显示处理dom元素数量,剩余的放到pending_elements中，且设置timeout；
        // 若timeout回调执行前，页面dom又有新变动，则timeout回调可以取消执行或重新设置，而不必继续渲染上次结果
        screteObj.max_show_once = 30;

        screteObj.timer_id = null;
        screteObj.delay_time = 1000; //延迟显示剩余dom元素的时间间隔，默认1000毫秒

        //获取数据
        screteObj.init = function() {
            api.getSavedAllPasswords(screteObj.querycallback, function(obj) {
                console.log("error");
                factory.errorDialogOpen();
            });
        };
        screteObj.querycallback = function(obj) {
            var results = '';
            try{
                results = JSON.parse(obj).filter(function(item) {
                    if (!item.form.blacklist) {
                        return item;
                    }
                });
            } catch(e) {
                factory.errorDialogOpen();
            }
            var len = results.length;
            if (len > 0) {
                $(".nocontent2").hide();

                $("#sccounts").html("(" + results.length + ")");
                screteObj.list = results;
                screteObj.list.sort(function(a, b) {
                    return parseInt(b.form.datetime) - parseInt(a.form.datetime);
                });
                $(".backup2").show();
                $("#backuptime2").text(factory.formatTime(screteObj.list[0].form.datetime));
                screteObj.createDom(screteObj.list);
                $("#form-search").val("");
            } else {
                screteObj.list = [];
                screteObj.elements = [];
                screteObj.pending_elements = [];
                $(".backup2").hide();
                $("#sccounts").html("(" + results.length + ")");
                $("#zh-body2").html('<tr class="nocontent2"><td colspan="6" id="nocontent"><img class="guid-info-img" src="images/screte.png" ondragstart="return false;"><p class="guid-info-msg">'+Lang.get("ScreteGuidInfo")+'</p>'
                    +'</td></tr>');
                $(".nocontent2").show();
            }
        };
        //生成DOM
        screteObj.createDom = function(lists) {
            var trhtml = ' <tr class="nocontent2 nocontent-search"><td colspan="6" id="nocontent">'+Lang.get("NoSearchContent")+'</td></tr>';
            for (var i = 0; i < lists.length; i++) {
                trhtml += '<tr id="'+lists[i].md5+'" data-id="'+lists[i].md5+'">'
                        // + '<td class="casctitle" title="'+factory.codeTransfor(lists[i].form.title)+'">' + factory.codeTransfor(lists[i].form.title) + '</td>' +
                        + '<td class="caurl"><a href="'+lists[i].form.origin+'" target="_blank">' + factory.codeTransfor(lists[i].form.origin) + '</a></td>'
                        + '<td class="caname">' + factory.codeTransfor(lists[i].form.user_name_value) + '</td>'
                        + '<td class="capassword"><input class="originpwd" type="password" readonly value="' + lists[i].form.password_value + '"/></td>'
                        + '<td><i class="edit"></i></td><td><i class="del"></i></td></tr>';
            }
            $("#zh-body2").html(trhtml);
            $(".nocontent2").hide();
            for (var i = 0; i < lists.length; i++) {
                screteObj.elements[i] = document.getElementById(lists[i].md5);
            }

            height = ((window.innerHeight > 0) ? window.innerHeight : window.screen.height) - 1;
            height = height > $(".row-right").height() ? height : ($(".row-right").height() + 10);
            $("#zhxx-content .row-left").css("min-height", (height) + "px");
            var value = $("#form-search2").val().trim();
            screteObj.searchData(value);
        };
        //搜索生成数据
        screteObj.searchData = function(title) {
            var matched = 0;
            title = $.trim(title).toLowerCase();
            screteObj.clearPendingElements();
            if (!flag) {
                $(".nocontent2").show();
            } else {
                if (screteObj.list.length > 0) {

                    for (var i = 0; i < screteObj.list.length; i++) {
                        var form = screteObj.list[i].form;
                        if (title == "" || form.title.toLowerCase().indexOf(title) != -1
                            || form.user_name_value.toLowerCase().indexOf(title) != -1
                            || form.origin.toLowerCase().indexOf(title) != -1) {
                            if (i < screteObj.max_show_once)
                                screteObj.elements[i].style.display=""
                            else
                                screteObj.pending_elements.push(screteObj.elements[i])
                            matched ++;
                        }else {
                            screteObj.elements[i].style.display="none"
                        }
                    }

                    if (matched > 0) {
                        $(".nocontent2").hide();
                        if (screteObj.pending_elements.length > 0) {
                            screteObj.timer_id = setTimeout(screteObj.ShowPendingElements, screteObj.delay_time);
                        }
                    } else {
                        $(".nocontent2").show();
                    }
                } else {
                    $(".nocontent2").show();
                }
            }
            height = ((window.innerHeight > 0) ? window.innerHeight : window.screen.height) - 1;
            height = height > $(".row-right").height() ? height : ($(".row-right").height() + 10);
            $("#zhxx-content .row-left").css("min-height", (height) + "px");
        };

        screteObj.ShowPendingElements = function() {
            screteObj.timer_id = null;
            for (var i = 0; i < screteObj.pending_elements.length; i++)
                screteObj.pending_elements[i].style.display = "";
            screteObj.pending_elements.length = 0;
        }

        screteObj.clearPendingElements = function() {
            if (screteObj.timer_id) {
                clearTimeout(screteObj.timer_id);
            }
            screteObj.timer_id = null;
            screteObj.pending_elements.length = 0;
        }

        //删除数据
        screteObj.deleteAccount = function(key) {
            api.deletePassword(key, function(obj) {
                screteObj.init();
            }, function(obj) {
                console.log("error");
                factory.errorDialogOpen();
            });
        };
        //密码切换解密
        screteObj.pwdDencry = function(key, cb) {
            if (screteObj.list.length > 0) {
                for (var i = 0; i < screteObj.list.length; i++) {
                    if (screteObj.list[i].md5 === key) {
                        (function() {
                            var listaccount = {};
                            listaccount = $.extend({}, listaccount, screteObj.list[i].form);
                            if (listaccount.password_value) {
                                var array = [];
                                var singledata = {};
                                singledata.password_value = listaccount.password_value;
                                array.push(singledata);
                                if(listaccount.elements) {
                                    var elementsAll = listaccount.elements;
                                    var eleLen = elementsAll.length;
                                    for (var ele = 0; ele < eleLen; ele++) {
                                        var elements = {};
                                        if(elementsAll[ele].type === "password") {
                                            elements.password_value = elementsAll[ele].value;
                                            array.push(elements);
                                        }
                                    }
                                }
                                //解密数据
                                let value = listaccount.password_value;
                                api.pwdDecrypt({ type: 'sys', content: value }, function(obj) {
                                    cb(obj);
                                }, function(obj) {
                                    console.log('error   pwdDencry');
                                    factory.errorDialogOpen();
                                });
                            } else {
                                cb(listaccount.password_value);
                            }
                        })();
                    }
                }
            }
        };


        //密码切换加密
        screteObj.pwdEncry = function(value, cb) {
            //进行加密
            api.pwdEncry({ type:'sys', content: value }, function(obj) {
                cb(obj);
            }, function(obj) {
                console.log('error');
                factory.errorDialogOpen();
            });
        };
        //解密
        screteObj.pwdFormDencry = function(value, cb) {
            //进行解密
            api.pwdDencry({ type: 'sys', content: value }, function (obj) {
                cb(obj);
            }, function(obj) {
                console.log('error');
                factory.errorDialogOpen();
            });
        };
        //详情生成数据
        screteObj.createData = function(key) {
            var singledata = {};
            if (screteObj.list.length > 0) {
                for (var i = 0; i < screteObj.list.length; i++) {
                    if (screteObj.list[i].md5 === key) {
                        singledata = screteObj.list[i];
                        return singledata;
                    }
                }
            }
        };
        //编辑生成数据
        screteObj.createEditData = function(key, cb) {
            var singledata = {};
            if (screteObj.list.length > 0) {
                for (var i = 0; i < screteObj.list.length; i++) {
                    if (screteObj.list[i].md5 === key) {
                        singledata = screteObj.list[i];
                        cb(singledata);
                    }
                }
            }
        };
        //修改数据
        screteObj.updateAccount = function(data) {
            var key = null;
            key = data.md5;
            (function() {
                api.pwdEncry({ type:'sys', content: data.form.password_value }, function (result) {
                    data.form.password_value = result;
                    api.savePassword({"key":key,"value":JSON.stringify(data)}, function(formobj) {
                        key = null;
                        listaccount = {};
                        data = {};
                        screteObj.init();
                    }, function(obj) {
                        console.log('error');
                        factory.errorDialogOpen();
                    });
                });
            })();
        };
        //例外网站
        screteObj.showWebsite = function(cb) {
            (function() {
                api.getSavedAllPasswords(function(obj) {
                    var websites = '';
                    try{
                        websites = JSON.parse(obj).filter(function(item) {
                            if (item.form.blacklist) {
                                return item;
                            }
                        });
                        cb(websites)
                    } catch(e) {
                        factory.errorDialogOpen();
                    }
                }, function(obj) {
                    console.log("error");
                    factory.errorDialogOpen();
                });
            })();
        };
        //同步
        screteObj.syncHand = function() {
            $(".syncInfo2").children(".sync-info-icon").addClass("sysc");
            $(".syncInfo2").children("#syncInfo2").text(Lang.get("SyncWorking"));
            api.sync('password');
        }

        //如果智能填表被关闭，则不显示数据
        // screteObj.dbGetMagicfillConfig = function() {
        //     (function() {
        //         SendByQueue('getConfig', {key: "browser.magicfill.enabled"}, function(obj) {
        //             if (parseInt(obj.value) === 1 || parseInt(obj.value) === 2) {
        //                 flag = true;
        //                 screteObj.init();
        //                 identityObj.init();
        //                 $(".sccounts").show();
        //                 $(".identity").show();
        //                 $(".addInfo4").show();
        //                 $(".syncInfo2").show();
        //                 $(".syncInfo3").show();
        //                 $(".backup2").show();
        //                 $(".website_wrap").show();
        //             } else if (parseInt(obj.value) === 0) {
        //                 flag = false;
        //                 $(".sccounts").hide();
        //                 $(".identity").hide();
        //                 $(".backup2").hide();
        //                 $("#zh-body2").html(' <tr class="nocontent2 nocontent-search"><td colspan="6" id="nocontent">'+Lang.get("MagicfillConfig")+'<a href="mx://options/#general" target="_blank">'+Lang.get("MagicfillConfigHref")+'</a></td></tr>');
        //                 $(".nocontent2").show();
        //                 $("#zh-body3").html(' <tr class="nocontent3 nocontent-search"><td colspan="6" id="nocontent">'+Lang.get("MagicfillConfig")+'<a href="mx://options/#general" target="_blank">'+Lang.get("MagicfillConfigHref")+'</a></td></tr>');
        //                 $(".nocontent3").show();
        //                 $(".addInfo4").hide();
        //                 $(".syncInfo2").hide();
        //                 $(".syncInfo3").hide();
        //                 $(".website_wrap").hide();
        //             }
        //         }, function(obj) {
        //             console.log("error");
        //             factory.errorDialogOpen();
        //         });
        //     })();
        // };
        // //监听设置更改
        // screteObj.onConfigStateChange = function() {
        //     maxthon.send("onConfigStateChange", [{params:{}, callback:"window.onConfigStateChangeCallback"}]); //传入必须带有callback参数
        // }
        // window.onConfigStateChangeCallback = function(msg) {
        //     var event = msg.result;
        //     // multi search default engine
        //     if(event.key == "browser.magicfill.enabled"){
        //         location.reload();
        //         return;
        //     }
        // }
        // screteObj.dbGetMagicfillConfig();
        // screteObj.onConfigStateChange();
        // 先从读取配置决定打开与否的逻辑中提出
        api.getProfile(function (data) {
            api.isLogin(function(data) {
                screteObj.init();
            })
        }, function () {
            console.log('error');
            factory.errorDialogOpen();
        });
    }

 })(window)