/*******************  MCAFEE CONFIDENTIAL AND PROPRIETARY  *******************
*                                                                            *
*  Copyright (c) 2007 McAfee, Inc.  All Rights Reserved.                     *
*                                                                            *
*  This file and the information contained herein is the confidential and    *
*  proprietary information of McAfee, Inc.  Your rights to this file and its *
*  information are subject to the terms of the license agreement between     *
*  McAfee and you or your company.                                           *
*                                                                            *
********************  MCAFEE CONFIDENTIAL AND PROPRIETARY  ******************/

////////////////////////////////////////////////////////////////////////////////////////////////////////
//Initialize the plugin
////////////////////////////////////////////////////////////////////////////////////////////////////////

var msktbirdComponent;
var fileContent = ""; //this is used for the folder listener
var spamFolderCreated = false;
var inboxURI = "";  // The current scanned inbox URI
var isScaning =false;   // Is the script scanning the inbox now? 
var inboxURIs = new Array();  // Store all inbox URIs from all servers

var scanCount =0;    // The index of current scanning inbox
var copyCompleteFlag=true;   // The flag determine if the copy action during the scanning process is completed or not
var inbox_scanned =false;   // The flag states if the current inbox has been scanned or not

//here we create the mail session
//the mail session is where we can add the folderlistener, so that functions can be called when a certain event occurs
var mailSession = Components.classes["@mozilla.org/messenger/services/session;1"].getService(Components.interfaces.nsIMsgMailSession);
const copyService = Components.classes["@mozilla.org/messenger/messagecopyservice;1"].getService(Components.interfaces.nsIMsgCopyService);


//we construct the folderlistener structure
//most of them are empty functions, meaning we dont want to do anything for that type of event
//otherwise we specify a function for it to call when that type of event occurs

//This listener is used to wait for the event where the inbox receives new email
//It is added in entryCode which calls initListener
//If there are no accounts configured this will fail to be added
var MSK_folderListener = 
{
	OnItemAdded: myOnItemAdded,//myOnItemAdded, //function(parent, item, viewString) {},
	OnItemRemoved: function(parent, item, viewString) {},
	OnItemPropertyChanged: function(parent, item, viewString) 
	{

	},
	OnItemIntPropertyChanged: function(item, property, oldValue, newValue) 
	{
	}, //function(item, property, oldValue, newValue) {}, //myOnIntPropertyChanged, //
	OnItemBoolPropertyChanged: function(item, property, oldValue, newValue) 
	{
	},
	OnItemUnicharPropertyChanged: function(item, property, oldValue, newValue) 
	{
	},

	OnItemPropertyFlagChanged: function( item, property, oldFlag, newFlag ) 
	{ 
	}, //myOnItemPropertyFlagChanged, //
	OnItemEvent: function(item, event) 
	{

	},
	OnFolderLoaded: function(aFolder) {  },
	OnDeleteOrMoveMessagesCompleted: function( aFolder) 
	{
	},
}


//this listener is used to wait for the event the first user account is created
//it is not used if there are pre-existing user accounts in order to be able to load MSK_folderListener when an account is configured
var MSK_configurationfolderListener = 
{
	OnItemAdded: ConfigurationOnItemAdded,//myOnItemAdded, //function(parent, item, viewString) {},
	OnItemRemoved: function(parent, item, viewString) {},
	OnItemPropertyChanged: function(parent, item, viewString) 
	{

	},
	OnItemIntPropertyChanged: function(item, property, oldValue, newValue) 
	{
	}, //function(item, property, oldValue, newValue) {}, //myOnIntPropertyChanged, //
	OnItemBoolPropertyChanged: function(item, property, oldValue, newValue) 
	{
	},
	OnItemUnicharPropertyChanged: function(item, property, oldValue, newValue) 
	{
	},
	OnItemPropertyFlagChanged: function( item, property, oldFlag, newFlag ) 
	{ 
	}, //myOnItemPropertyFlagChanged, //
	OnItemEvent: function(item, event) 
	{

	},
	OnFolderLoaded: function(aFolder) {  },
	OnDeleteOrMoveMessagesCompleted: function( aFolder) 
	{
	},
}



function entryCode(event)
{
	//if the javascript is not loaded by root window then we don't do the initialization
	
	// Get the current window Type
	var cWintype = document.documentElement.getAttribute('windowtype');
	// If the new window open is only a messageWindow then we don't need to load the initilization code	
	var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
	var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"].getService(Components.interfaces.nsIVersionComparator);
		if (cWintype != "mail:3pane") 
		{
			
			// Hide both toolbar and menubar in the pop-up windows
			document.getElementById('menu_MskTbird_v1').hidden = true;
			document.getElementById('menu_MskTbird_v2').hidden = true;
			
			// Check if the version for Thunderbird is 1.5 family.
			if((versionChecker.compare(appInfo.version, "2.0b1") < 0 ) && (versionChecker.compare(appInfo.version, "1.5") >= 0 ))
			{
			
			var currToolbar = document.getElementById('mail-toolbar-menubar2');		
			currToolbar.setAttribute("hidden", "true");
			document.getElementById('mail-bar2').hidden = true;		
			var mailbarID = getToolbarID();
			document.persist("mail-bar","currentset"); 
			
			
			}
			// it is for Thunderbird 2.0+
			else
			{
			
			var currToolbar = document.getElementById('mail-toolbar-menubar');		
			currToolbar.setAttribute("hidden", "true");
			document.getElementById('mail-bar').hidden = true;		
			var mailbarID = getToolbarID();
			document.persist("mail-bar2","currentset"); 
			}
			
			return; 
		}		
	
				
	initComponent();		// initialize my XPCom Component
	TbirdVersion();			// Check for Thunderbird version and apply the appropiate toolbar buttons and menu items.
	
	//get the Inbox URI, gotta do this first becuase the subsequent functions need it
	if ( isTB_Enabled() ) 
	{
		insertButtons();
		loadSetting();
		var result = unconfiguredCheck();	
		//initalize new mail notification system
		if ( result == 0 )
		{	
			TbirdVersion();
			initListener();
		}
	}
	else
	{
		removeButtons();		
	} 
}

function unloadCode(event)
{
	mailSession.RemoveFolderListener(MSK_folderListener);		
}

window.addEventListener("load", entryCode, false);
window.addEventListener("unload", unloadCode, false); 

//*********************************************************************************************
//  TbirdVersion() - function that loads the appropiate toolbars based on Thunderbird version.
//                          This is required because some toolbars in TBird v2.0 have been renamed (from TBird 1.5)
//*********************************************************************************************
function TbirdVersion()
{
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
  var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"].getService(Components.interfaces.nsIVersionComparator);
  
			// Check if the version for Thunderbird is 1.5 family.
	if((versionChecker.compare(appInfo.version, "2.0b1") < 0 ) && (versionChecker.compare(appInfo.version, "1.5") >= 0 ))
	{
		document.getElementById('menu_MskTbird_v1').hidden = false;
		
		// Hide the TBird 2.0 menu system on Tbird 1.5
		var currToolbar = document.getElementById('mail-toolbar-menubar2');		
		currToolbar.setAttribute("hidden", "true");
		
		// Hide the TBird 2.0 toolbar system on Tbird 1.5
		document.getElementById('mail-bar2').hidden = true;
	}
	else	// Else the version is of the Thunderbird 2.0 family.
	{
		document.getElementById('menu_MskTbird_v2').hidden = false;
		
		// Hide the TBird 1.5 menu system on TBird 2.0.
		var currToolbar = document.getElementById('mail-toolbar-menubar');		
		currToolbar.setAttribute("hidden", "true");
		
		// Hide the TBird 1.5 toolbar system on Tbird 2.0
		document.getElementById('mail-bar').hidden = true;
	}
}

// *****************************************************************************
// getToolbarID() - function that returns the ID of the toolbar based on Thunderbird version.
// postconditions: if TBird v1.5, returns "mail-bar", else returns "mail-bar2" (assumed Tbird 2.0+)
// *****************************************************************************
function getToolbarID()
{
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
  var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"].getService(Components.interfaces.nsIVersionComparator);
  
			// Check if the version for Thunderbird is 1.5 family.
	if((versionChecker.compare(appInfo.version, "2.0b1") < 0 ) && (versionChecker.compare(appInfo.version, "1.5") >= 0 ))
	{
		return "mail-bar";
	}
	else	// Else the version is of the Thunderbird 2.0 family.
	{
		return "mail-bar2";
	}
}

// *****************************************************************************
// getMSKMenuID() - function that returns the ID of the MSK menu based on Thunderbird version.
// postconditions: if TBird v1.5, returns "menu_MskTbird_v1", else returns "menu_MskTbird_v1" (assumed Tbird 2.0+)
// *****************************************************************************
function getMSKMenuID()
{
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
  var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"].getService(Components.interfaces.nsIVersionComparator);
  
			// Check if the version for Thunderbird is 1.5 family.
	if((versionChecker.compare(appInfo.version, "2.0b1") < 0 ) && (versionChecker.compare(appInfo.version, "1.5") >= 0 ))
	{
		return "menu_MskTbird_v1";
	}
	else	// Else the version is of the Thunderbird 2.0 family.
	{
		return "menu_MskTbird_v2";
	}
}

// *************************************************************************************************
// Function that insert toolbar buttons and unhide the menu bar buttons
// *************************************************************************************************
function insertButtons()
{
	var mailbarID = getToolbarID();
	var currentset = document.getElementById(mailbarID).currentSet; 

	// check for string "msk-toolbar-items"
	var findSpamKillerButton = currentset.indexOf("msk-toolbar-items"); 
	if (findSpamKillerButton == -1 ) 
	{
		var findIndex = currentset.indexOf("spring"); 
		// if we don't find spring then we will attach the buttons to the back of all toolbar buttons
		if (findIndex == -1 ) 
		{
			currentset = currentset + ",msk-toolbar-items"; 	
		}
		else
		{
			var firstStr = currentset.substring(0,findIndex-1); 
			var secondStr = currentset.substring(findIndex-1); 
			var addedStr = ",msk-toolbar-items"; 
			currentset= firstStr+ addedStr + secondStr; 
		}
	}

	document.getElementById(mailbarID).setAttribute("currentset",currentset); 
	document.getElementById(mailbarID).currentSet = currentset; 
	// document.persist("mail-bar","currentset"); 

	// Show the menu buttons
	var menu_item = document.getElementById(getMSKMenuID()); 
	if (menu_item == 0) return ;
	menu_item.hidden = false; 
}

// *************************************************************************************************
// Function that remove toolbar buttons and hide the menu bar buttons
// *************************************************************************************************
function removeButtons()
{
	var mailbarID = getToolbarID();
	var currentset = document.getElementById(mailbarID).currentSet; 
	
	// check for string "msk-toolbar-items"
	var spamKillerButtonsIndex = currentset.indexOf("msk-toolbar-items"); 

		if (spamKillerButtonsIndex>-1)
		{
			var firstStr = currentset.substring(0,spamKillerButtonsIndex); 
			var secondStr = currentset.substring(spamKillerButtonsIndex+18); 
			currentset = firstStr+ secondStr; 
			document.getElementById(mailbarID).setAttribute("currentset",currentset); 
			document.getElementById(mailbarID).currentSet = currentset; 
			document.persist(mailbarID,"currentset"); 
		}

	// Hide the menu buttons
	
	var menu_item = document.getElementById(getMSKMenuID()); 
	if (menu_item == 0) return;
	menu_item.hidden = true; 
}
/*
    UpdateFolderName : 
	funcation that updates the foldername from "SpamKiller" to "McAfee Anti-Spam"
	@author: Abeer Rahman
	@modified: April 04 2007
*/
function UpdateFolderName(strBaseURI)
{
	// General declarations for getting pointers for message window, Inbox.
	var baseURI = strBaseURI; 	
	var msgWindow = Components.classes["@mozilla.org/messenger/msgwindow;1"].createInstance(Components.interfaces.nsIMsgWindow);
	var msgFolder = GetMsgFolderFromUri(baseURI /* folderURI */, false /* checkFolderAttributes */ );
	var strSpamKiller 		= "SpamKiller";
	var strMcAfeeAntiSpam 	= "McAfee Anti-Spam";
	
	// Check if "SpamKiller" folder exists.
	if (msgFolder.containsChildNamed(strSpamKiller))
	{
		// First check if any of the folder is named "McAfee Anti-Spam".
		if(!msgFolder.containsChildNamed(strMcAfeeAntiSpam))
		{
			// If the folder name "SpamKiller" exists, rename it to "McAfee Anti-Spam". This case occurs when an upgrade is done.
			var folderSpamKiller = msgFolder.getChildWithURI ( baseURI + "/" + strSpamKiller , true , true /* PRBool caseInsensitive */ ); 
			folderSpamKiller.rename(strMcAfeeAntiSpam, msgWindow);
		}
		else
		{
			/*  Should not come here! Error! */ 
		}
	
	}
}


// *******************************************************************************
// Function that loads up the user setting and preprocessed messages (ex: Scan msgs. Moving msgs from Anti-Spam to inbox or vice versa)
// *******************************************************************************

function loadSetting()
{
	try
	{
		// If we do need the spam folder then we scan Inbox and move all the mails that is MSK+SPAM tagged mails to spamKiller folder
		storeAllInboxAccounts(); 
		if ( needSpamFolder() ) 
		{
			// create all spamKiller folder

			createAllSpamFolder(); 
						
			inboxURI=inboxURIs[scanCount]; 		

		// We no longer scan the inbox to move the spam messages at the start up.
		//	newScanInbox();
		//	scanAllInbox(); 
				
		}
	}
	catch ( err )
	{ 
		logMessage(err); 
		// alert( err );
	}
	
	
}

// ********************************************************************************
// Function that scan all inboxes 
// ********************************************************************************
function scanAllInbox()
{
	
	if (inbox_scanned==true &&  scanCount< inboxURIs.length && copyCompleteFlag)
	{
		inbox_scanned=false; 
		inboxURI = inboxURIs[scanCount]; 
		
		newScanInbox(); 
		scanAllInbox(); 
	}
	else if (scanCount == inboxURIs.length)
	{
		return; 
	}
	else
	{
		setTimeout("scanAllInbox()",1000);
	}

}

// *******************************************************************************
// Function that collect all accounts for each server
// *******************************************************************************
function storeAllInboxAccounts() 
{


	var msgAccountManager = Components.classes["@mozilla.org/messenger/account-manager;1"].getService(Components.interfaces.nsIMsgAccountManager);
	var allServers = msgAccountManager.allServers;
	
	if (allServers instanceof Components.interfaces.nsICollection) 
	{
		for (var i = 0; i < allServers.Count(); i++) 
		{
			var server = allServers.GetElementAt(i);

			if (server instanceof Components.interfaces.nsIMsgIncomingServer) 
			{
				if ((server.type == "pop3") ) 
				{
					var inbox = getInboxFolder(server);					
				}
			}
		}
	}
	
}

// ******************************************************************************
// Store the inboxFolder and returns the Inbox folder of the given server 
// ******************************************************************************
function getInboxFolder(server) 
{
	try 
	{
		var rootMsgFolder = server.rootMsgFolder;

		// now find Inbox
		var outNumFolders = new Object();
		var inboxFolder = rootMsgFolder.getFoldersWithFlag(MSG_FOLDER_FLAG_INBOX,1,outNumFolders); // MSG_FOLDER_FLAG_INBOX is defined in commandglue.js

		if (inboxFolder != null) 
		{
			inboxURIs.push(inboxFolder.URI); 
			return inboxFolder.QueryInterface(Components.interfaces.nsIMsgFolder);
		} // else return null
	} 
	catch (ex) 
	{
		myDump("getInboxFolder\n\n" + ex);
	}

	return null;
}



// Need to delay scanInbox until all the messages are successfully retrived.
function newScanInbox()
{
	var inboxFolder = RDF.GetResource(inboxURI).QueryInterface(Components.interfaces.nsIMsgFolder);
	
	// if we are downloading new mails, then we need to delay the scanning inbox
	if (inboxFolder.manyHeadersToDownload)
	{
		setTimeout("newScanInbox()",2000);
	}
	else if (!inbox_scanned)
	{
		scanInbox(); 
		inbox_scanned=true; 
		scanCount++;   // Now we have finish scanning the current inboxURI, so now we can increment the index to the next inboxURI
	}
}


// Scan Inbox to move all Spam tagged and MSK process messages to Anti-Spam folder
function scanInbox()
{
	
	var inboxFolder = RDF.GetResource(inboxURI).QueryInterface(Components.interfaces.nsIMsgFolder);
	isScaning=true;

	var msgWindow = Components.classes["@mozilla.org/messenger/msgwindow;1"].createInstance(Components.interfaces.nsIMsgWindow);
	var bodyAndHdr=null; 
	var dbHdr=null;
		
	var spamFolder = GetMsgFolderFromUri(getSpamKillerURL(inboxURI, false));
	
	
	if (msgWindow==null || inboxFolder ==null) 
	{
		isScaning=false;
		return; 
	}	
	
	var msgHeaders = inboxFolder.getMessages(msgWindow);  // An enumeration of DBHdrs
	
	var numMsgHeaders =0;      // Get total number of message headers
	var numMessages = inboxFolder.getTotalMessages(true);   // Get total number of messages, this should be the same as numMsgHeaders, but it doesn't rely 
								// on msgwindow
	var msgMoved=0; 
	
	
	if (numMessages==0) 
	{
		isScaning=false;
		return; 
	}
	
	// A listener that is attached to the copy action during inbox scanning
	
	var copyServiceListener =
			{
				QueryInterface: function(iid)  
				{
					if ( iid.equals(Components.interfaces.nsIMsgCopyServiceListener) || iid.equals(Components.interfaces.nsISupports) )
					{
						return this;
					}
			
					throw Components.results.NS_NOINTERFACE;
					return 0;
				},
	
				OnProgress: function (progress, progressMax) 
				{
				},
				
				OnStartCopy: function () 
				{
					copyCompleteFlag=false; 
				},
				
				OnStopCopy: function (status)
				{
				
					_stepProgBar(); 
					msgMoved++; 

					// Set scanning flag after finish copying messages
					if (msgMoved == numMsgHeaders) 
					{
						isScaning=false;
						copyCompleteFlag=true; 
					}
				},
				
				SetMessageKey: function (key) 
				{				
				}
			}

		
	// Store the spam messages header into an array
	while (msgHeaders.hasMoreElements ( ) )
	{
		dbHdr = msgHeaders.getNext(); 
		dbHdr = dbHdr.QueryInterface(Components.interfaces.nsIMsgDBHdr);
		bodyAndHdr = getMsgHdr(dbHdr, inboxURI); 

		if (checkMSK(bodyAndHdr) )
		{
			var spamMessages = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsISupportsArray);
			spamMessages.AppendElement(dbHdr);    

			copyService.CopyMessages(inboxFolder,spamMessages,spamFolder,true,copyServiceListener,null,false); // move it	

			numMsgHeaders++; 
		}
	}
	
	// if we don't need to copy spam message then we set the scanning flag to false
	if (numMsgHeaders==0)
	{
		isScaning=false;
	}
	
	_showProgBar(numMsgHeaders); 
	spamFolder.copyDataDone();

}




////////////////////////////////////////////////////////////////////////////////////////////////////////
//Attempting to access XPCOM componentTest functions
////////////////////////////////////////////////////////////////////////////////////////////////////////

//initializes the XPCOM component
function initComponent()
{
	try
	{
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
		const cid = "@mydomain.com/mskTB;1";

		msktbirdComponent = Components.classes[cid].createInstance();		
		msktbirdComponent = msktbirdComponent.QueryInterface(Components.interfaces.IMskTB);
	}
	catch (err)
	{
		logMessage(err);
	}
}

/*
Due to some memory issues this is how the component works
You set the getTag property of the component by calling the methods setSpamTag, or setPhishTag
Right afterwards you assign the getTag property of the component to a JavaScript variable
A note about using component methods, parameters have to be new JavaScript Objects and to get their value, use objectname.value
*/

//returns a string that holds the spam tag
function mcGetSpamTag()
{
	try
	{	
		var spamTag;
		//msktbirdComponent.setSpamTag();  //this wont need to be called since phish tag buttons will never be used anyway
		spamTag = msktbirdComponent.getTag;
		
		return spamTag;
	}
	catch (err)
	{
		logMessage(err);
	}
}

//returns a string that holds the phish tag
function mcGetPhishTag()
{
	try
	{
		var phishTag;
		
		msktbirdComponent.setPhishTag();				
		phishTag = msktbirdComponent.getTag;
		
		return phishTag;
	}
	catch (err)
	{
		logMessage(err);
	}
}

// ************************************************************************************************
// Function that checks for the availabilty of the buttons and update the status of the buttons
// ************************************************************************************************
function checkVaildility()
{

	//buttons will be enabled at all times and the buttons will handle when to do nothing
	//rather than become disabled when they should not do anything
	updateButtons_AllEnable();

	/*
	var selectedURI = GetSelectedFolderURI();   // method from "widgetglue.js"
	var inboxFolder; 
	var inbox_URI; 

	inbox_URI = getCurrentInbox(selectedURI)  // Get the current selected URI (its corresponding inbox)
	inboxFolder = GetMsgFolderFromUri(inbox_URI, false);
	if (inboxFolder ==null) return; 

	// If we are downloading news emails, disable all buttons. This is the only case, when we disable all buttons

	if (inboxFolder.manyHeadersToDownload)
	{	
		// Due to a bug in mozilla (some problem regarding how the manyHeadersToDownload flag is not properly set), this is the way to hack it.
		if (inboxFolder.getTotalMessages(true)!=0)
		{
			updateButtons_AllDisable();	
			return; 
		}
	}

	var spamFolder_URI = getSpamKillerURL(selectedURI);  
	var resultProcessed = checkMSK_Processed(selectedURI,spamFolder_URI ); 


	var resultMSKTag = checkMSK_Tagged(selectedURI,spamFolder_URI);  // Array of oresult, [0]=all tagged? , [1] = all not tagged? 


	if (! resultProcessed )
	{
		friendButtonEnabled(); 
	}
	else if (resultMSKTag[0] && isValidInbox(selectedURI))
	{
		updateButtons_SpamFolder();
	}
	else if (resultMSKTag[1] && isValidInbox(selectedURI) )
	{
		updateButtons_Inbox();
	}
	else if (resultMSKTag[0] && isValidSpamURI(selectedURI))
	{
		updateButtons_SpamFolder();
	}
	else if (resultMSKTag[1] && isValidSpamURI(selectedURI))
	{
		updateButtons_Inbox();
	}
	else 
	{
		friendButtonEnabled(); 
	}
	*/
}

// *********************************************
// Check to see if the URI is a valid inbox URI
// *********************************************
function isValidInbox(temp_inboxURI)
{
	for (var i = 0; i < inboxURIs.length; i++)
	{
		if (inboxURIs[i] == temp_inboxURI) 
		{
			return true; 
		}
	}

	return false; 
}

// *********************************************
// Check to see if the URI is a valid spam URI
// *********************************************
function isValidSpamURI(temp_spamURI)
{
	for (var i=0; i< inboxURIs.length; i++)
	{
		var tempS = inboxURIs[i]; 
		var sFolderURI = tempS.substring(0, tempS.indexOf("Inbox") ) + "McAfee%20Anti-Spam"; 

		if (sFolderURI == temp_spamURI)  
		{
			return true; 
		}
	}

	return false; 
}

// ****************************************************
// Progress Bar Code
// ****************************************************

// Add the progress bar function

function _showProgBar(numSelected)
{
    if(numSelected >= 20)
	    msktbirdComponent.showProgBar(numSelected); 
}

function _stepProgBar()
{
	msktbirdComponent.stepProgBar(); 
}



// Function that reads user setting and determine if Anti-Spam folder is needed.

function needSpamFolder()
{
    return msktbirdComponent.needSpamFolder(); 
}

function isTB_Enabled()
{
    return msktbirdComponent.isTBEnabled();
}


function reportSpam(isSpam, data, dataLength)
{
	msktbirdComponent.reportSpam(isSpam, data, dataLength);  
}

function headerOnly()
{
     return msktbirdComponent.headerOnly(); 
}

function updateFalsePositiveCount(fpCount)
{
    msktbirdComponent.updateFalsePositiveCount(fpCount);
}

function updateFalseNegativeCount(fnCount)
{
    msktbirdComponent.updateFalseNegativeCount(fnCount);
}
// ******************************************************************************************************************
// Function that check whether the messages selected have subjects contains "X-MSK" (MSK Processed)
// Output:  An Array "result", 
//          result: Return true only if all selected msg are X-MSKTag tagged
    
// ******************************************************************************************************************
function checkMSK_Processed(inbox_URI, spamFolder_URI )
{
	var selectMsgs = GetSelectedMessages();
	
	var result = new Array(); 
	result= true;  // Store the result as true if all selected message are all spamTagged
	
	// if no msgs are selected then we do nothing
	if (selectMsgs == null) 
	{
		return; 
	}

	for(var i=0; i< selectMsgs.length; i++)
	{
		var tMsg = selectMsgs[i];
		var temp = messenger.msgHdrFromURI(tMsg);
		var tMsgFolder = temp.folder; 

		if ( tMsgFolder.URI != inbox_URI && tMsgFolder.URI != spamFolder_URI ) 
		{
			return false; 
		}
			
		var msgHdr_Body = getMsgHdr(temp /* nsIMsgDBHdr */, gDBView.msgFolder.URI);   
		var text = new String(msgHdr_Body  );
		result = result & isMSK_processed(text); 
	}		

	return result; 
}

// ******************************************************************************************************************
// A helper method that takes in the header text and determine if the header contains "X-MSK"
// ******************************************************************************************************************
function isMSK_processed(text)
{

	var MSKTag = "X-MSK"; 
	var hdrstr = text.indexOf("\r\n\r\n"); //marks the end of the //headers
	var headers= new String(); 
	headers = text.substring( 0, hdrstr+1 );

	if ( headers.indexOf(MSKTag) == -1) 
	{
		return false; 
	}

	return true; 	
}

// ******************************************************************************************************************
// Function that check whether the messages selected have subjects contains "[Spam]" or "userDefined Tag", are all Spam Tagged
// Output:  An Array "result", 
//          result[0]: Return true only if all selected msg are spam tagged
//          result[1]: Return true only if all selected msgs are NOT spam tagged 
// ******************************************************************************************************************
function checkMSK_Tagged(inbox_URI, spamFolder_URI)
{
	var selectMsgs = GetSelectedMessages();

	// Get the SpamTag
	var spamTag = "X-MSKTag";
	var result = new Array(); 

	result[0]= true;  // Store the result as true if all selected message are all spamTagged
	result[1]= true;  // Store the result as true if all selected message are not all spamTagged

	if (selectMsgs == null) 
	{
		return; 
	}

	for( var i=0; i < selectMsgs.length; i++ )
	{
	
		var tMsg = selectMsgs[i];
		var temp = messenger.msgHdrFromURI(tMsg);
		var tMsgFolder = temp.folder; 

		if ( tMsgFolder.URI != inbox_URI && tMsgFolder.URI != spamFolder_URI ) 
		{
			return false; 
		}
			
		var msgHdr_Body = getMsgHdr(temp /* nsIMsgDBHdr */, gDBView.msgFolder.URI);   
		var text = new String(msgHdr_Body  );
		
		result[0] = result[0] & checkMSK(text); 
		result[1] = result[1] & (!checkMSK(text)); 	
	}
		
	return result; 
}

// ******************************************************************************************************************
// A helper method that takes in the header text and determine if the header contains X-MSKTag
// ******************************************************************************************************************
function checkMSK(text)
{

	var MSKTag = "X-MSKTag"; 
	var hdrstr = text.indexOf("\r\n\r\n"); //marks the end of the //headers
	var headers= new String(); 
	headers = text.substring(0,hdrstr+1);

	if ( headers.indexOf(MSKTag) == -1) 
	{
		return false; 
	}

	return true; 
}


// ******************************************************************************************************************
// Functions mark as spam and mark as not spam
// ******************************************************************************************************************

function markAsSpam()
{
	// If plug in is disable, we don't do anything
	if (!isTB_Enabled()) 
	{
		logMessage("Spam Killer Thunderbird Plug-In is not enabled");
		return; 
	}

	try
	{
		//get the selected messages using core thunderbird function
		var selectedMessages = GetSelectedMessages();

		//if the user selected no messages then abort
		if ( !selectedMessages )
		{
			return;
		}
		
		var item = messenger.msgHdrFromURI( selectedMessages[0] );
		var item_Folder = item.folder; 
		var item_FolderURI = item_Folder.URI; 
		var dFolderURI; 

		//if the folder isnt inbox, abort!
		/*
		if ( item_FolderURI.indexOf("Inbox") == -1 )
		{
			return;
		}
		*/
		
		//if this is not the nobody local folders account AND not an account with a valid inbox we will abort operations
		if( item_FolderURI.indexOf("mailbox://nobody@Local%20Folders") == -1 && isValidInbox( item_Folder.rootFolder.URI + "/Inbox" ) == false )
		{
			return;
		}

		//if this is the trash, drafts, sent, unsent, templates can abort
		if ( item_FolderURI.indexOf("Trash") != -1 || item_FolderURI.indexOf("Drafts") != -1 || item_FolderURI.indexOf("Unsent") != -1 || item_FolderURI.indexOf("Templates") != -1 || item_FolderURI.indexOf("Sent") != -1  )
		{
			return;
		}

		//try to grab the URI of the inbox that corresponds to this email
		if (isValidInbox(item_FolderURI) )
		{
			//just directly grab the folder URI from the message if its from a valid inbox
			dFolderURI = item_FolderURI; 
		}
		else if (  item_FolderURI.indexOf("mailbox://nobody@Local%20Folders") != -1 )
		{
			//if the user uses separate inboxes for the different accounts, nobody's inbox fails isValidInbox
			//user might get confused if we move it out of this account so we'll move the message around in the nobody account
			dFolderURI = "mailbox://nobody@Local%20Folders/Inbox";
		}
		else if ( item_FolderURI.indexOf("McAfee%20Anti-Spam") != -1 )
		{
			//figure out the correct corresponding inbox for this message
			dFolderURI = item_FolderURI.substring(0, item_FolderURI.indexOf("McAfee%20Anti-Spam") ) + "Inbox";
		}
		else
		{
			//figure out the correct corresponding inbox for this message
			dFolderURI =  item_Folder.rootFolder.URI + "/Inbox";
		}

		var inboxFolder = RDF.GetResource(dFolderURI).QueryInterface(Components.interfaces.nsIMsgFolder);
		
		//Original code.
		/*
		//if messages are being downloaded then abort!		
		if ( inboxFolder.manyHeadersToDownload )
		{	
			//due to bug in mozilla manyHeadersToDownload doesnt work properly, this second if statement is apparently some kind of hack
			if ( inboxFolder.getTotalMessages(true) != 0 )
			{			
				//alert( "dl in progress" );
				logMessage("dl in progress"); 
				
				return; 
			}
		}
		*/
		
		// Bug 315502 fix.		@author: Abeer Rahman		@date: Jan 04 2007
		// Note: New code fix may interfere with bug 307351 fix .
	
		// Check if the current folder is locked. If so, then exit this function.
		if((inboxFolder.locked)){
			return;
		}
	
        _showProgBar(selectedMessages.length);

		for( var i = 0; i < selectedMessages.length; i++ )
		{
			var selectedMessageHdr = messenger.msgHdrFromURI( selectedMessages[i] );			

			changeHeadersToSpam( selectedMessageHdr );
			// _stepProgBar(); 
		}
		
		// update False Negative Count to MSK settings database
		updateFalseNegativeCount(selectedMessages.length);
	}
	catch (err)
	{
		logMessage(err); 
	}
}

// "mailbox://nobody@Local%20Folders/SpamKiller";
function markAsSpamFunctionality( text, selectedMessageHdr )
{
	try
	{
		var treeView = gDBView.QueryInterface(Components.interfaces.nsITreeView);
		// Store the index of the selected message
		var msgKey= selectedMessageHdr.messageKey; 
		var lastSelectedIndex = gDBView.findIndexFromKey(msgKey, true); 
		
		
		var dFolderURI; //destination folder
		var intPos = text.indexOf("X-MSKTag");
		
		var newHdr = "";
		
		//we figure out if this email is from inbox, spamkiller or other folder
		//if ( selectedMessageHdr.folder.URI.indexOf("SpamKiller") != -1 )
		if( isSpamkillerFolder( selectedMessageHdr.folder ) )
		{
			//email is from spamkiller box

			//if tagged we do nothing
			//if not tagged we tag

			//check messages for previous existance of X-MSKTag header
			if (intPos > -1) 
			{
				//tagged
				return;
			}
			else
			{
				//not tagged
				// Separate the headers and body
				var hdrstr = text.indexOf("\r\n\r\n"); //marks the end of the //headers
				var headers= new String(); 
				headers = text.substring(0,hdrstr+1);
				var body = new String(); 
				body = text.substring(hdrstr+1);

				// Find the Subject index
				var subjectIndex = headers.indexOf("Subject:"); 
				var firstStr = headers.substring(0,subjectIndex+8);   
				var spamStr = mcGetSpamTag(); 
				var MSK_index = headers.indexOf("X-MSK"); 
				// we can not assume the message was processed by MSK server so that
				// there always is a "x-msk" tag available in the message header
				var secondStr = "";
				var thirdStr = "";
				var lastStr = "";
				var mskTagStr = "X-MSKTag:" + mcGetSpamTag() + "\r\n";
				
				if(MSK_index > -1)
				{
				    secondStr = text.substring(subjectIndex+8, MSK_index); 

				    // Find the MSK Tag index
				    var MSK_end_index= text.indexOf("\r\n", MSK_index)
				    thirdStr = text.substring(MSK_index, MSK_end_index+2);
				    lastStr = text.substring(MSK_end_index, hdrstr+1);
                		}
                		else
                		{
                		    secondStr = headers.substring(subjectIndex+8);
                		    
                		}
				newHdr += firstStr + spamStr + secondStr + mskTagStr + thirdStr + lastStr; 

				var newEmail = newHdr + body; 

				dFolderURI = selectedMessageHdr.folder.URI;			
					
				// Report the spam mail to McAfee if the setting agrees
				reportSpam(true, newEmail, newEmail.length); 
				changeHeader( selectedMessageHdr , dFolderURI , newEmail );
			}	
		}
		else
		{		
			//email is from inbox or other folder, we do the same thing
			//if tagged we move to spamkiller folder with no changes
			//if not tagged, we tag and move to spamkiller folder

			//check messages for previous existance of X-MSKTag header
			if (intPos > -1) 
			{			
				//tagged

				var inboxFolder = selectedMessageHdr.folder;
				var inboxFolderURI = selectedMessageHdr.folder.URI; 
				
				//get inbox URI to get spamkiller URL
				//try to grab the URI of the inbox that corresponds to this email
				if (isValidInbox(inboxFolderURI) )
				{
					//just directly grab the folder URI from the message if its from a valid inbox
					inboxFolderURI = inboxFolderURI; 
				}
				else if (  inboxFolderURI.indexOf("mailbox://nobody@Local%20Folders") != -1 )
				{
					//if the user uses separate inboxes for the different accounts, nobody's inbox fails isValidInbox
					//user might get confused if we move it out of this account so we'll move the message around in the nobody account
					inboxFolderURI = "mailbox://nobody@Local%20Folders/Inbox";
				}
				else if ( inboxFolderURI.indexOf("McAfee%20Anti-Spam") != -1 )
				{
					//figure out the correct corresponding inbox for this message
					inboxFolderURI = inboxFolderURI.substring(0, item_FolderURI.indexOf("McAfee%20Anti-Spam") ) + "Inbox";
				}
				else
				{
					//figure out the correct corresponding inbox for this message
					inboxFolderURI =  inboxFolder.rootFolder.URI + "/Inbox";
				}
												
				dFolderURI = getSpamKillerURL(inboxFolderURI); 
				
				//check where we move to the item to
				if ( !needSpamFolder() ) 
				{
					//dFolderURI = inboxFolderURI;
					dFolderURI = selectedMessageHdr.folder.URI;
				}

				//move the item
				var newEmail = text;
				reportSpam(true, newEmail, newEmail.length);
				changeHeader( selectedMessageHdr , dFolderURI , newEmail );
			}
			else
			{
				//not tagged

				// Separate the headers and body
				var hdrstr = text.indexOf("\r\n\r\n"); //marks the end of the //headers
				
				// Sometimes "\r\n\r\n" do not exist as the marker of end of header. 
				//  In such cases, just check for two empty lines.
				if (hdrstr == -1)
				{
					hdrstr = text.indexOf("\n\n");
				}
				
				var headers= new String(); 
				headers = text.substring(0,hdrstr+1);
				var body = new String(); 
				body = text.substring(hdrstr+1);

				// Find the Subject index
				var subjectIndex = headers.indexOf("Subject:"); 
				var firstStr = headers.substring(0,subjectIndex+8);   
				var spamStr = mcGetSpamTag(); 
				var MSK_index = headers.indexOf("X-MSK"); 

				// Find the Subject index
				// we can not assume the message was processed by MSK server so that
				// there always is a "x-msk" tag available in the message header
				var secondStr = "";
				var thirdStr = "";
				var lastStr = "";
				var mskTagStr = "X-MSKTag:" + mcGetSpamTag() + "\r\n";
				
				if(MSK_index > -1)
				{
				    secondStr = text.substring(subjectIndex+8, MSK_index); 

				    // Find the MSK Tag index
				    var MSK_end_index= text.indexOf("\r\n", MSK_index)
				    thirdStr = text.substring(MSK_index, MSK_end_index+2);
				    lastStr = text.substring(MSK_end_index, hdrstr+1);
                		}
                		else
                		{
                		    secondStr = headers.substring(subjectIndex+8);
                		}				
				
				newHdr += firstStr + spamStr + secondStr + mskTagStr + thirdStr + lastStr; 
				var newEmail = newHdr + body; 

				//get URI of email's folder
				var inboxFolder = selectedMessageHdr.folder;
				var inboxFolderURI = selectedMessageHdr.folder.URI; 
				
				//get inbox URI to get spamkiller URL
				//try to grab the URI of the inbox that corresponds to this email
				if (isValidInbox(inboxFolderURI) )
				{
					//just directly grab the folder URI from the message if its from a valid inbox
					inboxFolderURI = inboxFolderURI; 
				}
				else if (  inboxFolderURI.indexOf("mailbox://nobody@Local%20Folders") != -1 )
				{
					//if the user uses separate inboxes for the different accounts, nobody's inbox fails isValidInbox
					//user might get confused if we move it out of this account so we'll move the message around in the nobody account
					inboxFolderURI = "mailbox://nobody@Local%20Folders/Inbox";
				}
				else if ( inboxFolderURI.indexOf("McAfee%20Anti-Spam") != -1 )
				{
					//figure out the correct corresponding inbox for this message
					inboxFolderURI = inboxFolderURI.substring(0, item_FolderURI.indexOf("McAfee%20Anti-Spam") ) + "Inbox";
				}
				else
				{
					//figure out the correct corresponding inbox for this message
					inboxFolderURI =  inboxFolder.rootFolder.URI + "/Inbox";
				}

				dFolderURI = getSpamKillerURL(inboxFolderURI); 
							
				if ( !needSpamFolder() ) 
				{
					//dFolderURI = inboxFolderURI;
					dFolderURI = selectedMessageHdr.folder.URI;
				}
					
				// Report the spam mail to McAfee if the setting agrees				
				reportSpam(true, newEmail, newEmail.length);
				changeHeader( selectedMessageHdr , dFolderURI , newEmail );
			}	
		}	
		
		// Set the focus to the next message
		var treeSelection = treeView.selection; 		
		// Get the total number of messages in the view panel
		var viewSize = treeView.rowCount;
			
		var currentSelectIndex = lastSelectedIndex; 
		if (viewSize==0) {
		    currentSelectIndex=-2; // default value mozilla uses	
		}
		else if (lastSelectedIndex == viewSize)
		{
		    currentSelectIndex = lastSelectedIndex-1;
		    if (currentSelectIndex<0) currentSelectIndex=0; 
		}
					
		treeSelection.select(currentSelectIndex);
			
		return;
	}
	catch( err )
	{
		// alert( err );
		logMessage(err);
	}
}



function markAsNotSpam()
{
	// If plug in is disable, we don't do anything
	if (!isTB_Enabled()) 
	{
		logMessage("Spam Killer Thunderbird Plug-In is not enabled");
		return; 
	}

 
	try
	{
		//get the selected messages using core thunderbird function
		// if no messages were selected, do nothing
		var selectedMessages = GetSelectedMessages();

		//if the user selected no messages then abort
		if ( !selectedMessages )
		{
			return;
		}

		var item = messenger.msgHdrFromURI( selectedMessages[0] );
		var item_Folder = item.folder; 
		var item_FolderURI = item_Folder.URI; 
		var dFolderURI; 
		
		//if this is not the nobody local folders account AND not an account with a valid inbox we will abort operations
		if( item_FolderURI.indexOf("mailbox://nobody@Local%20Folders") == -1 && isValidInbox( item_Folder.rootFolder.URI + "/Inbox" ) == false )
		{
			return;
		}

		//if folder is trash, drafts, unsent, sent, templates then abort
		if ( item_FolderURI.indexOf("Trash") != -1 || item_FolderURI.indexOf("Drafts") != -1 || item_FolderURI.indexOf("Unsent") != -1 || item_FolderURI.indexOf("Templates") != -1 || item_FolderURI.indexOf("Sent") != -1  )
		{
			return;
		}

		//if the folder isnt inbox or spamkiller, abort!
		/*
		if ( item_FolderURI.indexOf("Inbox") == -1 && item_FolderURI.indexOf("SpamKiller") == -1 )
		{
			return;
		}
		*/

		//try to grab the URI of the inbox that corresponds to this email
		if (isValidInbox(item_FolderURI) )
		{
			//just directly grab the folder URI from the message if its from a valid inbox
			dFolderURI = item_FolderURI; 
		}
		else if (  item_FolderURI.indexOf("mailbox://nobody@Local%20Folders") != -1 )
		{
			//if the user uses separate inboxes for the different accounts, nobody's inbox fails isValidInbox
			//user might get confused if we move it out of this account so we'll move the message around in the nobody account
			dFolderURI = "mailbox://nobody@Local%20Folders/Inbox";
		}
		else if ( item_FolderURI.indexOf("McAfee%20Anti-Spam") != -1 )
		{
			//figure out the correct corresponding inbox for this message
			dFolderURI = item_FolderURI.substring(0, item_FolderURI.indexOf("McAfee%20Anti-Spam") ) + "Inbox";
		}
		else
		{
			//figure out the correct corresponding inbox for this message
			dFolderURI =  item_Folder.rootFolder.URI + "/Inbox";
		}

		var inboxFolder = RDF.GetResource(dFolderURI).QueryInterface(Components.interfaces.nsIMsgFolder);
		
		//Original code commented.
		//if messages are being downloaded then abort!		
		/*
		if ( inboxFolder.manyHeadersToDownload )
		{	
			//due to bug in mozilla manyHeadersToDownload doesnt work properly, this second if statement is apparently some kind of hack
			if ( inboxFolder.getTotalMessages(true) != 0 )
			{
				//alert( "dl in progress" );
				return; 
			}
		}		
		*/
		
		// Bug 315502 fix.		@author: Abeer Rahman		@date: Jan 04 2007
		// Note: New code fix may interfere with bug 307351 fix .
	
		// Check if the current folder is locked. If so, then exit this function.
		if((inboxFolder.locked)){
			return;
		}
		
		
       	_showProgBar(selectedMessages.length);

		for( var i = 0; i < selectedMessages.length; i++ )
		{	
			var selectedMessageHdr = messenger.msgHdrFromURI( selectedMessages[i] );		

			//test code			
			changeHeadersToNotSpam( selectedMessageHdr );	
			// _stepProgBar();	
		}
		// update False Positive Count to MSK settings database
		updateFalsePositiveCount(selectedMessages.length);		
	}
	catch (err)
	{
		alert(err)
	}		
}


function markAsNotSpamFunctionality( text, selectedMessageHdr )
{
	try
	{
		var treeView = gDBView.QueryInterface(Components.interfaces.nsITreeView);
		// Store the index of the selected message
		var msgKey= selectedMessageHdr.messageKey; 
		var lastSelectedIndex = gDBView.findIndexFromKey(msgKey, true); 
		
		var intPos = text.indexOf("X-MSKTag");
		var dFolderURI; //destination folder

		//we figure out if the folder is inbox, spamkiller or other
		var newHdr = ""; 
		
		if( isSpamkillerFolder( selectedMessageHdr.folder ) )
		{
			//email is from spamkiller box
			//if tagged we untag and move to inbox
			//if not tagged we move to inbox

			//check messages for previous existance of X-MSKTag header
			if (intPos > -1) 
			{			
				//tagged

				// Separate the headers and body
				var hdrstr = text.indexOf("\r\n\r\n"); //marks the end of the //headers
				
				// Sometimes "\r\n\r\n" do not exist as the marker of end of header. 
				//  In such cases, just check for two empty lines.
				if (hdrstr == -1)
				{
					hdrstr = text.indexOf("\n\n");
				}
				
				var headers= new String(); 
				headers = text.substring(0,hdrstr+1);
				var body = new String(); 
				body = text.substring(hdrstr+1);

				
				// Get the spamTag string				
				var spamTagIndex = headers.indexOf("X-MSKTag:"); 
				var spamTag_end_Index = headers.indexOf("\r\n",spamTagIndex); 
				var spamStr = headers.substring(spamTagIndex + 9, spamTag_end_Index); 

				// Find the Subject index
				var subjectIndex = headers.indexOf("Subject:"); 
				var firstStr = headers.substring(0,subjectIndex+8);   
					
				var secondStr = headers.substring(subjectIndex+spamStr.length+8 , spamTagIndex);   
				
				var thirdStr = headers.substring(spamTagIndex+ spamStr.length + 11, hdrstr); 
				
				newHdr += firstStr +  secondStr + thirdStr; 
				var newEmail = newHdr + body; 
				// We need to get the corresponding inbox URI	
				var item_Folder = selectedMessageHdr.folder; 
				var item_FolderURI = item_Folder.URI; 
				
				
				if (isValidInbox(item_FolderURI) )
				{
					dFolderURI = item_FolderURI; 
				}
				else if (  item_FolderURI.indexOf("mailbox://nobody@Local%20Folders") != -1 )
				{
					//if the user uses separate inboxes for the different accounts, nobody's inbox fails isValidInbox
					dFolderURI = "mailbox://nobody@Local%20Folders/Inbox";
				}				
				else if ( item_FolderURI.indexOf("McAfee%20Anti-Spam") != -1 )
				{
					//figure out the correct corresponding inbox for this message
					dFolderURI = item_FolderURI.substring(0, item_FolderURI.indexOf("McAfee%20Anti-Spam") ) + "Inbox";
				}
				else
				{
					//figure out the correct corresponding inbox for this message
					dFolderURI =  item_Folder.rootFolder.URI + "/Inbox";
				}
 				
				// Report the spam mail to McAfee if the setting agrees									
				if ( headerOnly() )
				{
					// report the original header 
					headers += "\r\n\r\n";
					reportSpam(false, newHdr, newHdr.length); 
				}
				else
				{
					reportSpam(false, newEmail, newEmail.length); 
				}
				
				changeHeader( selectedMessageHdr , dFolderURI , newEmail );     // Since dFolderURI is inbox in the case, we got 2 identical

			}
			else
			{				
				//not tagged
				
				// We need to get the corresponding inbox URI	
				var item_Folder = selectedMessageHdr.folder; 
				var item_FolderURI = item_Folder.URI; 

								
				if (isValidInbox(item_FolderURI) )
				{
					dFolderURI = item_FolderURI; 
				}
				else if (  item_FolderURI.indexOf("mailbox://nobody@Local%20Folders") != -1 )
				{
					//if the user uses separate inboxes for the different accounts, nobody's inbox fails isValidInbox
					dFolderURI = "mailbox://nobody@Local%20Folders/Inbox";
				}
				else if ( item_FolderURI.indexOf("McAfee%20Anti-Spam") != -1 )
				{
					//figure out the correct corresponding inbox for this message
					dFolderURI = item_FolderURI.substring(0, item_FolderURI.indexOf("McAfee%20Anti-Spam") ) + "Inbox";
				}
				else
				{
					//figure out the correct corresponding inbox for this message
					dFolderURI =  item_Folder.rootFolder.URI + "/Inbox";
				}
				
				var newEmail = text;

				// Report the spam mail to McAfee if the setting agrees									
				if ( headerOnly() )
				{
					// report the original header 
					headers += "\r\n\r\n";
					reportSpam(false, newHdr, newHdr.length); 
				}
				else
				{
					reportSpam(false, newEmail, newEmail.length); 
				}
				
				changeHeader( selectedMessageHdr , dFolderURI , newEmail );
			}	
		}
		else
		{
			//email is from inbox or other folder, we do the same thing
			//if tagged we untag
			//if not tagged we do nothing
			
			// Separate the headers and body
			var hdrstr = text.indexOf("\r\n\r\n"); //marks the end of the //headers
			var headers= new String(); 
			headers = text.substring(0,hdrstr+1);
			var body = new String(); 
			body = text.substring(hdrstr+1);
			
			//check messages for previous existance of X-MSKTag header
			if (intPos > -1) 	//tagged	
			{			
				
				// Get the spamTag string				
				var spamTagIndex = headers.indexOf("X-MSKTag:"); 
								
				var spamTag_end_Index = headers.indexOf("\r\n",spamTagIndex); 
				var spamStr = headers.substring(spamTagIndex + 9, spamTag_end_Index); 
				// Find the Subject index
				var subjectIndex = headers.indexOf("Subject:"); 
				var firstStr = headers.substring(0,subjectIndex+8);   
				
				var secondStr = headers.substring(subjectIndex+spamStr.length+8 , spamTagIndex);   
			
				var thirdStr = headers.substring(spamTagIndex+ spamStr.length + 11, hdrstr); 
			
				var newHdr = ""+ firstStr +  secondStr + thirdStr; 
				var newEmail = newHdr + body;	
				
				//leave it in the same folder				
				dFolderURI = selectedMessageHdr.folder.URI;
				changeHeader( selectedMessageHdr , dFolderURI , newEmail );		
				
			}
			else
			{
				// ** Bug fix 322720 ** 	@author: Abeer Rahman		 @date: Feb 21 2007
				// Get the subject line and check for the default spam tag: "[SPAM]"  (this was used in MSK 7.0)
				//  If the default tag exists, then remove the tag from the subject line.
				var indSubjectStart = headers.indexOf("Subject:");						// Get the index of "Subject:"
				var indSubjectEnd = headers.indexOf("\r\n", indSubjectStart);			// Get the index of subject line's last character
				var strSubjectWithTag = headers.substring(indSubjectStart + 9, indSubjectEnd);	// Get the subject string with the spam tag.
				var hasSpamTag = strSubjectWithTag.indexOf("[SPAM]");				// Check if the [SPAM] tag exists in the first 8 characters of the subject.
				
				if (hasSpamTag == 0)												// [SPAM] exists at the beginning of the subject line.
				{	
					var firstStr = headers.substring(0, indSubjectStart + 8);   		// Upto and include the word "Subject"
					var strSubjectWithoutTag = strSubjectWithTag.substring(6);   		// Cut off "[SPAM]"
					var thirdStr = headers.substring(indSubjectEnd); 					// End of subject line to end of message.
					newHdr += firstStr +  strSubjectWithoutTag + thirdStr; 
					var newEmail = newHdr + body;	
					
					//leave it in the same folder				
					dFolderURI = selectedMessageHdr.folder.URI;
					changeHeader( selectedMessageHdr , dFolderURI , newEmail );		
				}
			}	
		}
		
		// Set the focus to the next message
		var treeSelection = treeView.selection; 		
		// Get the total number of messages in the view panel
		var viewSize = treeView.rowCount;
				
		var currentSelectIndex = lastSelectedIndex; 
		if (viewSize==0) {
		    currentSelectIndex=-2; // default value mozilla uses	
		}
		else if (lastSelectedIndex == viewSize)
		{
	            currentSelectIndex = lastSelectedIndex-1;
	            if (currentSelectIndex<0) currentSelectIndex=0; 
		}
			
		treeSelection.select(currentSelectIndex);

		return;
	}
	catch (err)
	{
		// alert( err );
		logMessage(err);
	}
}




////////////////////////////////////////////////////////////////////////////////////////////////////////
//Attempting to move a message to a different folder
////////////////////////////////////////////////////////////////////////////////////////////////////////

//messageHdrs is an array of nsIDBMsgHdr
//inboxFolderURI, junkFolderURI is a string like "mailbox://nobody@Local%20Folders/Inbox"
function McMsgMoveMessage(messageHdrs, inboxFolderURI, junkFolderURI) //destUri) //old argument destFolder
{

	try 
	{
		//using gDBView.doCommandWithFolder(nsMsgViewCommandType.moveMessages, destMsgFolder) works in a mysterious fashion
		//using tree selection with doCommandWithFolder requires the user to have the correct folder selected otherwise it doesnt
		//work, which makes it useless
		
		var msgWindow = Components.classes["@mozilla.org/messenger/msgwindow;1"].createInstance(Components.interfaces.nsIMsgWindow);
		
		var inbox = GetMsgFolderFromUri(inboxFolderURI, false);

		var junk = GetMsgFolderFromUri(junkFolderURI, false);
		
		if (messageHdrs != null && !junk.locked){
			junk.copyMessages(inbox, messageHdrs, true /*isMove*/, msgWindow /* nsIMsgWindow */, null /* listener */, false /* isFolder */, false /*allowUndo*/ );	
		}
		
	}
	catch (ex) 
	{
		// alert("MsgMoveMessage failed: " + ex + "\n");
		logMessage("MsgMoveMessage failed: " + ex + "\n");
				
	}

}


////////////////////////////////////////////////////////////////////////////////////////////////////////
//Attempting to create a new folder
////////////////////////////////////////////////////////////////////////////////////////////////////////

/*
function does not work if run at the start of Thunderbird
because it thinks all folders do not exist, but when it tries to create the folder and it does exist it will give an error
thunderbird's UI will then be utterly screwed up

this will run at least once, if the spamfolder is created it will set a bool variable to true and this function
will not run again until Thunderbird is restarted

using doRFCommand appears to not work at all
*/
function CreateSpamFolder()
{
	try
	{
		var baseURI = "mailbox://nobody@Local%20Folders";
		var msgWindow = Components.classes["@mozilla.org/messenger/msgwindow;1"].createInstance(Components.interfaces.nsIMsgWindow);
		var msgFolder = GetMsgFolderFromUri(baseURI, false);
		UpdateFolderName(baseURI);
		
		//if i try to grab the message folder SpamKiller thunderbird thinks it exists no matter what
		//you have to call this particular function, this is the ONLY one that i have found that
		//truthfully returns whether or not the folder exists, everything else says it exists when it doesnt!
		if ( !msgFolder.containsChildNamed("McAfee Anti-Spam") )
		{			
			msgFolder.createSubfolder("McAfee Anti-Spam", msgWindow );
		}
		else
		{
			//do nothing but set bool variable to true
			spamFolderCreated = true;
		}		
	}
	catch (err)
	{
		// alert(err);
		logMessage(err); 
		
	}
}


function createAllSpamFolder()
{

	try
	{
		for (var k=0; k<inboxURIs.length; k++)
		{

			var inboxTempURI = inboxURIs[k];
			var baseURI = inboxTempURI.substring(0, inboxTempURI.indexOf("Inbox")-1); 
			var msgWindow = Components.classes["@mozilla.org/messenger/msgwindow;1"].createInstance(Components.interfaces.nsIMsgWindow);
			UpdateFolderName(baseURI);			// Update the folder name.
			var msgFolder = GetMsgFolderFromUri(baseURI /* folderURI */, false /* checkFolderAttributes */ );
			
			//if i try to grab the message folder SpamKiller thunderbird thinks it exists no matter what
			//you have to call this particular function, this is the ONLY one that i have found that
			//truthfully returns whether or not the folder exists, everything else says it exists when it doesnt!
			if ( !msgFolder.containsChildNamed( "McAfee%20Anti-Spam" ) )
			{	
				var spamkillerFolder = GetMsgFolderFromUri(baseURI + "/McAfee%20Anti-Spam" /* folderURI */, false /* checkFolderAttributes */ );

				if ( spamkillerFolder.getTotalMessages(false) == -1 )
				{
					//if the value of total messages is -1, the folder does not exist
					msgFolder.createSubfolder("McAfee Anti-Spam", msgWindow );
			
				}
					
			}
			else
			{
				// Do nothing
			}
			spamFolderCreated = true;
		}	
	}
	catch (err)
	{
		// Log file the error
	}

}




////////////////////////////////////////////////////////////////////////////////////////////////////////
//Attempting to get new mail notification area
////////////////////////////////////////////////////////////////////////////////////////////////////////

// the listening function that will react to changes
function myOnIntPropertyChanged(item, property, oldValue, newValue) 
{

}

// the listening function that will move spam to spamkiller folder depending on settings
function myOnItemAdded(parent, item, viewString)
{

	try
	{
		// If the atom added to Inbox, we will start process it		
		var currentFolder = parent.QueryInterface(Components.interfaces.nsIMsgFolder);
		var currentFolderURI = currentFolder.URI; 
		
		// Get all the mail servers
		var msgAccountManager = Components.classes["@mozilla.org/messenger/account-manager;1"].getService(Components.interfaces.nsIMsgAccountManager);
		var allServers = msgAccountManager.allServers;
		// Check if we are currently downloading messages, we don't want to move the message if the added item is not a downloaded mail 
		var isDownloading = false;
		
		for (var i=0;i<allServers.Count();i++)
		{
			var currentServer = allServers.GetElementAt(i).QueryInterface(Components.interfaces.nsIMsgIncomingServer);	
		   
			if (currentServer.type == "pop3" && currentServer.serverBusy)
		        {
	
		             	     isDownloading = true;
		        }
				
		}
			
		if ( (isValidInbox(currentFolderURI) ) /* && !isScaning */ && isDownloading )
		{
		// We only move the messages to SpamKiller folder if the user's setting needs one 

			if ( needSpamFolder())
			{
				item = item.QueryInterface(Components.interfaces.nsIMsgDBHdr);
				// Create spamFolder if needed to handle when the user decided to rename the anti-spam folder while the message is downloaded
				CreateSpamFolder();
				if (item == null) 
				{
					return; 
				}

				mcTestMsg( item, currentFolderURI );
			}
		}
	}
	catch (err)
	{
		//the item probably wasn't an email, so do nothing
	}
}

// the listening function that will create the spamkiller folder for when an account is configured and there were no previous accounts
function ConfigurationOnItemAdded(parent, item, viewString)
{
	try
	{
		storeAllInboxAccounts();
		var currentFolder = parent.QueryInterface(Components.interfaces.nsIMsgFolder);
		var currentFolderURI = currentFolder.URI; 
		
		// ***** Bug Fix 342537 By Kenny ************
		// Whenever thunderbird started for the first time (fresh install), it will call the mailstream listener twice,
		// even prior to the retrival of new mails, therefore we need to make sure if the 
		
		if ( isValidInbox(currentFolderURI) )
		{
			CreateSpamFolder();
			//remove the event listener that adds in spamkiller folder
			mailSession.RemoveFolderListener(MSK_configurationfolderListener);
			//start up the listener that will resume normal operations of the Thunderbird plugin
			loadSetting();
			initListener();	
		
		}
			
		
	}
	catch (err)
	{
		//item most likely not a folder so do nothing

		//alert(err);
		logMessage(err); 
	}
}


// *****************************************************************************
// A helper method that retrives the spamkiller URI that corresponds to the inbox folder
// *****************************************************************************
function getSpamKillerURL(inbox_URI)
{	
	var tmpString = inbox_URI.substring(0, inbox_URI.indexOf("Inbox"))+ "McAfee%20Anti-Spam"; 
	return tmpString; 
}



function isURI_Inbox(folderURI)
{
	
	var inboxStringIndex = folderURI.indexOf("Inbox"); 
	var checkedString = folderURI.substring(inboxStringIndex); 
	return (checkedString == "Inbox"); 
	
}


function initListener()
{
	try
	{
		//add an eventlistener to change the availability of buttons
		//the function checkValidity now simply enables all buttons as per user request
		var threadTree = GetThreadTree();
		threadTree.addEventListener("select", checkVaildility ,true);
		
		//mailSession is a global variable		
		//the second argument is a flag, the values i found at http://xulplanet.com/references/xpcomref/ifaces/nsIFolderListener.html
		var notifyFlags = Components.interfaces.nsIFolderListener.all;
		mailSession.AddFolderListener(MSK_folderListener, notifyFlags);		
				
		//we don't add an atom since its functionality is unknown (no documentation on how to use it)
	}
	catch (err)
	{		
		// alert(err);
		logMessage(err); 
	}	
}


// Update the status of the buttons according to the msgs selected
function update_Buttons_SelectMsgs()
{
	var selectedMessages = GetSelectedMessages();
}


////////////////////////////////////////////////////////////////////////////////////////////////////////
//Attempting to get the message header section
////////////////////////////////////////////////////////////////////////////////////////////////////////

//function accepts an nsIMsgDBHdr to get a message's body and header
function getMsgHdr(item /* nsIMsgDBHdr */, folderURI)
{

//var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance();

	try
	{
		//the folder has to be specified, so that folder specification is done in one place
		var inbox = GetMsgFolderFromUri(folderURI, false);
		
		//check the message content
		var offset = new Object();
		var messageSize = new Object();
		
		// If the dbheader passed in is corruptted then we don't use it to retrieve the message body 
		if (item.messageSize == 0) return; 
		
		var is = inbox.getOfflineFileStream(item.messageKey, offset, messageSize);

		var factory = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance();
		var sis = factory.QueryInterface(Components.interfaces.nsIScriptableInputStream);
		sis.init(is);

		//it was stated on some blog that the offset -10 should be used otherwise the stream includes a bit from the end of the previous message
		var bodyAndHdr = sis.read(item.messageSize - 10);
		sis.close;
		is.close;
		return bodyAndHdr;		
	}
	catch(err)
	{
		// alert(err);
		logMessage(err); 
	}
}

function changeHeadersToSpam( msgHdr ) 
{
	if (msgHdr == null)
	{
		return; 
	}
	
	var uri = msgHdr.folder.getUriForMsg( msgHdr );
	
	//processing messages requires the use of a listener, this will invoke the proper function to mark a message as spam
	//directly changing the message appears to affect the state of thunderbird in some unintended manner and cause an eventual crash	
	var streamListener = 
	{
		listenerMsgHdr : null,
		mStream : null,
		src: '',

		QueryInterface : function(iid)  
		{
			if (iid.equals(Components.interfaces.nsIStreamListener) ||
				iid.equals(Components.interfaces.nsIMsgHeaderSink) ||
				iid.equals(Components.interfaces.nsISupports))
			 return this;

			throw Components.results.NS_NOINTERFACE;
			return 0;
		},
        
		onStartRequest : function (aRequest, aContext) {
			
			this.mStream = Components.classes['@mozilla.org/binaryinputstream;1'].createInstance(Components.interfaces.nsIBinaryInputStream);
				
			var channel = aRequest.QueryInterface(Components.interfaces.nsIChannel);
			channel.URI.QueryInterface(Components.interfaces.nsIMsgMailNewsUrl);
			channel.URI.msgHeaderSink = this;
		},
		
		onStopRequest : function (aRequest, aContext, aStatusCode) {
			this.mStream = null;
			fileContent = this.src;
			markAsSpamFunctionality( fileContent, this.listenerMsgHdr );			
			
		},
		
		onDataAvailable : function (aRequest, aContext, aInputStream, aOffset, aCount) {
			
			this.mStream.setInputStream(aInputStream);
			var chunk = this.mStream.readBytes(aCount);
			this.src += chunk;
		},
		
		
	}  
	
	
	
	var mms = messenger.messageServiceFromURI(uri).QueryInterface(Components.interfaces.nsIMsgMessageService);
	var aStreamLisner = streamListener;
	var duri = new Object();

	aStreamLisner.listenerMsgHdr = msgHdr;

	mms.DisplayMessage(uri, aStreamLisner, null , null, null, duri);
	return;
}

function changeHeadersToNotSpam( msgHdr ) 
{
	//processing messages requires the use of a listener, this will invoke the proper function to mark a message as not spam
	//directly changing the message appears to affect the state of thunderbird in some unintended manner and cause an eventual crash
	var streamListener = 
	{
		listenerMsgHdr : null,
		mStream : null,
		src: '',

		QueryInterface : function(iid)  
		{
			if (iid.equals(Components.interfaces.nsIStreamListener) ||
				iid.equals(Components.interfaces.nsIMsgHeaderSink) ||
				iid.equals(Components.interfaces.nsISupports))
			 return this;

			throw Components.results.NS_NOINTERFACE;
			return 0;
		},
        
		onStartRequest : function (aRequest, aContext) {
			
			this.mStream = Components.classes['@mozilla.org/binaryinputstream;1'].createInstance(Components.interfaces.nsIBinaryInputStream);
			var channel = aRequest.QueryInterface(Components.interfaces.nsIChannel);
			channel.URI.QueryInterface(Components.interfaces.nsIMsgMailNewsUrl);
			channel.URI.msgHeaderSink = this;
		},
		
		onStopRequest : function (aRequest, aContext, aStatusCode) {
			this.mStream = null;
			fileContent = this.src;

			markAsNotSpamFunctionality( fileContent, this.listenerMsgHdr );
		},
		
		onDataAvailable : function (aRequest, aContext, aInputStream, aOffset, aCount) {
			
			this.mStream.setInputStream(aInputStream);
			var chunk = this.mStream.readBytes(aCount);
			this.src += chunk;
		},
		
		onStartHeaders: function() {
		},
	
		onEndHeaders: function() {
		},
	
		processHeaders: function(headerNameEnumerator, headerValueEnumerator, dontCollectAddress) {
		},
	
		handleAttachment: function(contentType, url, displayName, uri, isExternalAttachment) {
		},
		
		onEndAllAttachments: function() {
		},
	
		onEndMsgDownload: function(url) {
		},
	
		onEndMsgHeaders: function(url) { 
		},
	
		onMsgHasRemoteContent: function(aMsgHdr) {
		},
	
		getSecurityInfo: function() {
		},
		
		setSecurityInfo: function(aSecurityInfo) {
		},
	
		getDummyMsgHeader: function() {
		}
	}  

	var uri = msgHdr.folder.getUriForMsg( msgHdr );
	var mms = messenger.messageServiceFromURI(uri).QueryInterface(Components.interfaces.nsIMsgMessageService);
	var aStreamLisner = streamListener;
	var duri = new Object();

	aStreamLisner.listenerMsgHdr = msgHdr;

	mms.DisplayMessage(uri, aStreamLisner, null, null, null, duri);
	return;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////
//Attempting to get the message keys of messages in a folder and check if its spam
////////////////////////////////////////////////////////////////////////////////////////////////////////


//assumes item is a nsiDBMsgHdr
function mcTestMsg( item, inbox_URI )
{
	try
	{		
		var msgToBeMoved = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsISupportsArray);		
		item = item.QueryInterface(Components.interfaces.nsIMsgDBHdr);
		//get the message content so that we can check the headers
		
		
		var bodyAndHdr = getMsgHdr(item, inbox_URI); 

		//look for the X-MSKtag in the x headers
		var stringHeaders = new String(bodyAndHdr.toString());
		var intFind = stringHeaders.indexOf("X-MSKTag"); //X-MSKtag
		
		if ( intFind != -1)
		{
			//select this message to be moved, since the msktag was found
			msgToBeMoved.AppendElement(item);

			//if you try to move zero messages to the spamkiller folder it becomes locked and any attempt to
			//do anything with spamkiller folder will result in an error, although it does unlock it
			if ( msgToBeMoved.Count() > 0 )
			{
				var junkFolderURI = getSpamKillerURL(inbox_URI); 
				McMsgMoveMessage(msgToBeMoved, inbox_URI, junkFolderURI);					
			}			
		}
	}
	catch (err)
	{
		// alert(err);
		logMessage(err); 
	}
}

// Get the corresponding inbox URI to the URI given in the parameter

function getCurrentInbox(currentURI)
{
	var inbox_URI; 

	if (isValidInbox(currentURI)) 
	{
		return currentURI; 
		
	}
	else if (isValidSpamURI(currentURI))
	{
		inbox_URI = currentURI.substring(0, currentURI.indexOf("McAfee%20Anti-Spam") ) + "Inbox"; 
		return inbox_URI; 
	}
}


////////////////////////////////////////////////////////////////////////////////////////////////////////
//Function to change the msghdr
////////////////////////////////////////////////////////////////////////////////////////////////////////


//this function will change the headers in an email by destroying the email and recreating it with the
//new values
function changeHeader( selectedMessageHdr, destFolderURI, text )
{
	try
	{		
		// Create a temperary file for re-header the spam messages
		
		var file = Components.classes["@mozilla.org/file/directory_service;1"]
		                     .getService(Components.interfaces.nsIProperties)
		                     .get("TmpD", Components.interfaces.nsIFile);
		
		file.append("tmpEmail.tmp");
		var tempFileNativePath = file.path;
		if ( ! file.exists() )
		{
		file.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0664);
		}
			
		
		//write the text to the temp file
		var stream = Components.classes['@mozilla.org/network/file-output-stream;1'].createInstance(Components.interfaces.nsIFileOutputStream);
		stream.init(file, 2, 0x200, false); // open as "write only"
		stream.write( text, text.length );
		stream.close();	

		var flags = selectedMessageHdr.flags;

		//delete the original email
		var msgWindow = Components.classes["@mozilla.org/messenger/msgwindow;1"].createInstance(Components.interfaces.nsIMsgWindow); //err...
		var list = Components.classes["@mozilla.org/supports-array;1"].createInstance(Components.interfaces.nsISupportsArray);
		list.AppendElement( selectedMessageHdr );

		var msgFolder = selectedMessageHdr.folder;
		msgFolder.deleteMessages( list /*nsISupportsArray*/, msgWindow , true /*deleteStorage*/, false /*isMove*/, null /*listener*/, false /*allowUndo*/ );

		//make an email out of the temp file
		var fileSpec = Components.classes["@mozilla.org/filespec;1"].createInstance();
		fileSpec = fileSpec.QueryInterface( Components.interfaces.nsIFileSpec);
		fileSpec.nativePath = tempFileNativePath;

		//copy the temp file to the junk folder
		var destFolder = GetMsgFolderFromUri( destFolderURI, false);

		var copyServiceListener =
		{
			QueryInterface: function(iid)  
			{
				if ( iid.equals(Components.interfaces.nsIMsgCopyServiceListener) || iid.equals(Components.interfaces.nsISupports) )
				{
					return this;
				}
		
				throw Components.results.NS_NOINTERFACE;
				return 0;
			},

			OnProgress: function (progress, progressMax) 
			{
			},
			
			OnStartCopy: function () 
			{
			},
			
			OnStopCopy: function (status)
			{
			},
			
			SetMessageKey: function (key) 
			{				
			}
		}
				
		
		if (!destFolder.locked) destFolder.copyFileMessage(fileSpec /*fileSpec*/, null /*msgToReplace*/, false /*isDraft*/, flags /*newMsgFlags*/, msgWindow /*msgWindow*/, copyServiceListener);			
		destFolder.copyDataDone(); 
		//delete temp folder and file
		file.remove(true);		
		_stepProgBar(); 
			
		
	}
	catch (err)
	{
		// alert(err);
		logMessage(err); 
		_stepProgBar(); 
	}

}

////////////////////////////////////////////////////////////////////////////////////////////////////////
//Function to add friends
////////////////////////////////////////////////////////////////////////////////////////////////////////

function markSenderAsFriend()
{
	// If plug in is disable, we don't do anything
	if (!isTB_Enabled()) 
	{
		// alert("Spam Killer Thunderbird Plug-In is not enabled"); 
		logMessage("Spam Killer Thunderbird Plug-In is not enabled"); 
		return; 
		
	}

	try
	{
		var selectedMessages = GetSelectedMessages();
		var numFailed =0; 

		if ( !selectedMessages )
		{
			return;
		}

		 _showProgBar(selectedMessages.length);
		for( var i = 0; i < selectedMessages.length; i++ )
		{
			var temp = messenger.msgHdrFromURI( selectedMessages[i] );
			var text = new String( getMsgHdr(temp, gDBView.msgFolder.URI) );

			//built-in javascript function that splits text into an array separated by \n
			var textArray = text.split('\n');
			
			for( var j = 0; j < textArray.length; j++ )
			{
				var tempLine = new String( textArray[j] );
				var fromStrIndex = tempLine.indexOf("From:"); 
				
				var startNameIndex = fromStrIndex+6; 
				var endNameIndex = textArray[j].indexOf("<") - 1 ; 
				
				if (textArray[j].indexOf("\"") > -1) 
				{
					startNameIndex = startNameIndex +1; 
					endNameIndex = endNameIndex-1; 
				}
				
				if ( fromStrIndex > -1 )
				{
					//extract the email address of sender
					//format of From: "Name" <email@dot.com>
					var senderEmail = new String( textArray[j].substring( textArray[j].indexOf("<") + 1, textArray[j].indexOf(">") ) );
									
					var senderName = new String( textArray[j].substring( startNameIndex, endNameIndex ));

					//add the friend... one by one!
					senderEmail = senderEmail.toLowerCase();
					
					if ( checkEmail(senderEmail) )
					{
						msktbirdComponent.addFriend( senderEmail, senderName );
					}
					else
					{
						//extract the email address of sender
						//format of From: email@dot.com (Name)
						var senderEmail = new String( textArray[j].substring( textArray[j].indexOf(" ") + 1, textArray[j].indexOf("(") - 1 ) );
						var senderName = new String( textArray[j].substring( textArray[j].indexOf("(") + 1, textArray[j].indexOf(")") ) );

						//add the friend... one by one!
						senderEmail = senderEmail.toLowerCase();
						
						if ( checkEmail(senderEmail) )
						{
							msktbirdComponent.addFriend( senderEmail, senderName );
						}
						else
						{
							numFailed++; 
						}
					}
					
					break;	
				}
			}
			
			_stepProgBar();	
		}

		if ( numFailed > 0 ) 
		{
			alert("Warning! "+ numFailed + "  invalid email address(es) found. "); 
			
		}
	}
	catch (err)
	{
		// alert(err);
		logMessage(err); 
		
	}
}

// This function checks for the email address format

function checkEmail( addr )
{

	var validEmail = /^([a-zA-Z0-9_\.\-])+\@((([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{1,4})+|(\[([0-9]{1,3}\.){3}([0-9]{1,3})\]))$/;

	return validEmail.test(addr); 

}



function updateButtons_Inbox()
{

	var spamButton = document.getElementById("button-markAsSpam");
	var notSpamButton = document.getElementById("button-markAsNotSpam");
	var friendButton = document.getElementById("button-addFriend");
	var menu_spamButton = document.getElementById("menuButton-markAsSpam");
	var menu_notSpamButton = document.getElementById("menuButton-markAsNotSpam");
	var menu_friendButton = document.getElementById("menuButton-markAsFriend");

	if (spamButton ==0) return; 
	if (notSpamButton==0) return; 
	if (friendButton==0) return; 
	
	spamButton.setAttribute("disabled", "false"); 
	notSpamButton.setAttribute("disabled", "true"); 
	friendButton.setAttribute("disabled", "false"); 
	menu_spamButton.setAttribute("disabled", "false"); 
	menu_notSpamButton.setAttribute("disabled", "true"); 
	menu_friendButton.setAttribute("disabled", "false"); 

}

function updateButtons_SpamFolder()
{
	var spamButton = document.getElementById("button-markAsSpam");
	var notSpamButton = document.getElementById("button-markAsNotSpam");
	var friendButton = document.getElementById("button-addFriend");
	var menu_spamButton = document.getElementById("menuButton-markAsSpam");
	var menu_notSpamButton = document.getElementById("menuButton-markAsNotSpam");
	var menu_friendButton = document.getElementById("menuButton-markAsFriend");
	
	if (spamButton ==0) return; 
	if (notSpamButton==0) return; 
	if (friendButton==0) return; 
	
	
	spamButton.setAttribute("disabled", "true");
	notSpamButton.setAttribute("disabled", "false"); 
	friendButton.setAttribute("disabled", "false"); 
	menu_spamButton.setAttribute("disabled", "true");
	menu_notSpamButton.setAttribute("disabled", "false"); 
	menu_friendButton.setAttribute("disabled", "false"); 
	
}

function updateButtons_AllDisable()
{
	var spamButton = document.getElementById("button-markAsSpam");
	var notSpamButton = document.getElementById("button-markAsNotSpam");
	var friendButton = document.getElementById("button-addFriend");
	var menu_spamButton = document.getElementById("menuButton-markAsSpam");
	var menu_notSpamButton = document.getElementById("menuButton-markAsNotSpam");
	var menu_friendButton = document.getElementById("menuButton-markAsFriend");
	
	
	if (spamButton ==0) return; 
	if (notSpamButton==0) return; 
	if (friendButton==0) return; 
	
	
	spamButton.setAttribute("disabled", "true"); 
	notSpamButton.setAttribute("disabled", "true"); 
	friendButton.setAttribute("disabled", "true"); 
	menu_spamButton.setAttribute("disabled", "true"); 
	menu_notSpamButton.setAttribute("disabled", "true"); 
	menu_friendButton.setAttribute("disabled", "true"); 

}

function friendButtonEnabled()
{

	var spamButton = document.getElementById("button-markAsSpam");
	var notSpamButton = document.getElementById("button-markAsNotSpam");
	var friendButton = document.getElementById("button-addFriend");
	var menu_spamButton = document.getElementById("menuButton-markAsSpam");
	var menu_notSpamButton = document.getElementById("menuButton-markAsNotSpam");
	var menu_friendButton = document.getElementById("menuButton-markAsFriend");
		
		
	if (spamButton ==0) return; 
	if (notSpamButton==0) return; 
	if (friendButton==0) return; 
		
		
	spamButton.setAttribute("disabled", "true"); 
	notSpamButton.setAttribute("disabled", "true"); 
	friendButton.setAttribute("disabled", "false"); 
	menu_spamButton.setAttribute("disabled", "true"); 
	menu_notSpamButton.setAttribute("disabled", "true"); 
	menu_friendButton.setAttribute("disabled", "false"); 

}

function updateButtons_AllEnable()
{
	var spamButton = document.getElementById("button-markAsSpam");
	var notSpamButton = document.getElementById("button-markAsNotSpam");
	var friendButton = document.getElementById("button-addFriend");
	var menu_spamButton = document.getElementById("menuButton-markAsSpam");
	var menu_notSpamButton = document.getElementById("menuButton-markAsNotSpam");
	var menu_friendButton = document.getElementById("menuButton-markAsFriend");
	
	
	if (spamButton ==0) return; 
	if (notSpamButton==0) return; 
	if (friendButton==0) return; 
	
	
	spamButton.setAttribute("disabled", "false"); 
	notSpamButton.setAttribute("disabled", "false"); 
	friendButton.setAttribute("disabled", "false"); 
	menu_spamButton.setAttribute("disabled", "false"); 
	menu_notSpamButton.setAttribute("disabled", "false"); 
	menu_friendButton.setAttribute("disabled", "false"); 

}


////////////////////////////////////////////////////////////////////////////////////////////////////////
//Function to check if there are no accounts configured and takes step to resolve this problem
////////////////////////////////////////////////////////////////////////////////////////////////////////

//if there are no accounts configured the spamkiller folder will not be created and spam will move into the inbox
function unconfiguredCheck()
{
	try
	{
		//get the number of inboxes, if the user has not configured anything there should be zero
		
		if( inboxURIs.length < 1)
		{
			var baseURI = "mailbox://nobody@Local%20Folders";
			var msgWindow = Components.classes["@mozilla.org/messenger/msgwindow;1"].createInstance(Components.interfaces.nsIMsgWindow);
			var msgFolder = GetMsgFolderFromUri(baseURI, false);
			
			// UpdateFolderName(baseURI);			// Change the name of the folder.
			
			//We check if there is already a spamkiller folder or not
			//The listener MSK_configurationfolderListener will add a SpamKiller folder when the user creates his/her account
			if ( !msgFolder.containsChildNamed("McAfee%20Anti-Spam") )
			{			
				var notifyFlags = Components.interfaces.nsIFolderListener.all;
				mailSession.AddFolderListener(MSK_configurationfolderListener, notifyFlags);

				//TEMP ERROR CHECK
				logMessage("Spamkiller folder not found in unconfiguredCheck() "); 
			}

			return 1;
		}
		else
		{
			return 0;
		}
	}
	catch (err)
	{
		// alert(err);
		logMessage(err); 
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
//Function to check if the folder is the SpamKiller folder based on the URI and its parent folder
////////////////////////////////////////////////////////////////////////////////////////////////////////

function isSpamkillerFolder( itemFolder /* nsimsgFolder */ )
{
	return ( (itemFolder.parent.URI == itemFolder.rootFolder.URI) && (itemFolder.URI.indexOf("McAfee%20Anti-Spam") != -1) ) ;
}


// ******************************************************************************************************************
// Function that is used to log file to MCLOGS
// ******************************************************************************************************************

function logMessage(strLog)
{
	msktbirdComponent.logError(strLog); 
}

