/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.McoServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.LongConfirmationScreen;
import com.mojang.realmsclient.gui.LongRunningMcoTaskScreen;
import com.mojang.realmsclient.gui.LongRunningTask;
import com.mojang.realmsclient.gui.ScreenWithCallback;
import com.mojang.realmsclient.gui.StartMinigameWorldScreen;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class ModifyMinigameWorldScreen
extends ScreenWithCallback<WorldTemplate> {
    private static final Logger LOGGER = LogManager.getLogger();
    private RealmsScreen lastScreen;
    private McoServer serverData;
    private final int SWITCH_BUTTON_ID = 1;
    private final int END_BUTTON_ID = 2;
    private final int CANCEL_BUTTON = 3;

    public ModifyMinigameWorldScreen(RealmsScreen lastScreen, McoServer serverData) {
        this.lastScreen = lastScreen;
        this.serverData = serverData;
    }

    public void tick() {
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.buttonsAdd(ModifyMinigameWorldScreen.newButton((int)1, (int)(this.width() / 2 - 100), (int)116, (int)200, (int)20, (String)ModifyMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.changeButton")));
        this.buttonsAdd(ModifyMinigameWorldScreen.newButton((int)2, (int)(this.width() / 2 - 100), (int)70, (int)200, (int)20, (String)ModifyMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.stopButton")));
        this.buttonsAdd(ModifyMinigameWorldScreen.newButton((int)3, (int)(this.width() / 2 - 45), (int)(this.height() / 4 + 120 + 12), (int)97, (int)20, (String)ModifyMinigameWorldScreen.getLocalizedString((String)"gui.cancel")));
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 3) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        } else if (button.id() == 1) {
            Realms.setScreen((RealmsScreen)new StartMinigameWorldScreen(this.lastScreen, this.serverData));
        } else if (button.id() == 2) {
            String line2 = ModifyMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.restore.question.line1");
            String line3 = ModifyMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.restore.question.line2");
            Realms.setScreen((RealmsScreen)new LongConfirmationScreen(this, LongConfirmationScreen.Type.Info, line2, line3, 2));
        }
    }

    public void confirmResult(boolean result, int id) {
        if (id == 2) {
            if (result) {
                this.stopMinigame();
            } else {
                Realms.setScreen((RealmsScreen)this);
            }
        }
    }

    private void stopMinigame() {
        StopMinigameTask stopMinigameTask = new StopMinigameTask();
        LongRunningMcoTaskScreen longRunningMcoTaskScreen = new LongRunningMcoTaskScreen(this.lastScreen, stopMinigameTask);
        longRunningMcoTaskScreen.start();
        Realms.setScreen((RealmsScreen)longRunningMcoTaskScreen);
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(ModifyMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.modify.title"), this.width() / 2, 17, 0xFFFFFF);
        this.drawCenteredString(ModifyMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.modify.new"), this.width() / 2, 102, 0xFFFFFF);
        this.drawCenteredString(ModifyMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.modify.end"), this.width() / 2, 56, 0xFFFFFF);
        super.render(xm, ym, a);
    }

    @Override
    void callback(WorldTemplate t) {
    }

    private class StopMinigameTask
    extends LongRunningTask {
        @Override
        public void run() {
            RealmsClient client = RealmsClient.createRealmsClient();
            String title = RealmsScreen.getLocalizedString((String)"mco.minigame.world.restore");
            this.setTitle(title);
            try {
                boolean closeResult = client.putIntoNormalMode(((ModifyMinigameWorldScreen)ModifyMinigameWorldScreen.this).serverData.id);
                Thread.sleep(2000L);
                if (closeResult) {
                    ((ModifyMinigameWorldScreen)ModifyMinigameWorldScreen.this).serverData.worldType = McoServer.WorldType.NORMAL;
                    ((ModifyMinigameWorldScreen)ModifyMinigameWorldScreen.this).serverData.motd = "";
                    this.init();
                }
                Realms.setScreen((RealmsScreen)ModifyMinigameWorldScreen.this.lastScreen);
            }
            catch (RealmsServiceException e) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't start mini game!");
                this.error(e.toString());
            }
            catch (Exception e) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't start mini game!");
                this.error(e.toString());
            }
        }
    }
}

