/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.Level;

public class LanguageRegistry {
    private static final LanguageRegistry INSTANCE = new LanguageRegistry();
    private Map<String, Properties> modLanguageData = new HashMap<String, Properties>();
    private static final Pattern assetENUSLang = Pattern.compile("assets/(.*)/lang/(.*).lang");

    public static LanguageRegistry instance() {
        return INSTANCE;
    }

    public String getStringLocalization(String key) {
        return this.getStringLocalization(key, FMLCommonHandler.instance().getCurrentLanguage());
    }

    public String getStringLocalization(String key, String lang) {
        String localizedString = "";
        Properties langPack = this.modLanguageData.get(lang);
        if (langPack != null && langPack.getProperty(key) != null) {
            localizedString = langPack.getProperty(key);
        }
        return localizedString;
    }

    @Deprecated
    public void addStringLocalization(String key, String value) {
        this.addStringLocalization(key, "en_US", value);
    }

    @Deprecated
    public void addStringLocalization(String key, String lang, String value) {
        Properties langPack = this.modLanguageData.get(lang);
        if (langPack == null) {
            langPack = new Properties();
            this.modLanguageData.put(lang, langPack);
        }
        langPack.put(key, value);
    }

    @Deprecated
    public void addStringLocalization(Properties langPackAdditions) {
        this.addStringLocalization(langPackAdditions, "en_US");
    }

    @Deprecated
    public void addStringLocalization(Properties langPackAdditions, String lang) {
        Properties langPack = this.modLanguageData.get(lang);
        if (langPack == null) {
            langPack = new Properties();
            this.modLanguageData.put(lang, langPack);
        }
        if (langPackAdditions != null) {
            langPack.putAll((Map<?, ?>)langPackAdditions);
        }
    }

    @Deprecated
    public void addNameForObject(Object objectToName, String lang, String name) {
        String objectName;
        if (objectToName instanceof adb) {
            objectName = ((adb)objectToName).a();
        } else if (objectToName instanceof aji) {
            objectName = ((aji)objectToName).a();
        } else if (objectToName instanceof add) {
            objectName = ((add)objectToName).b().a((add)objectToName);
        } else {
            throw new IllegalArgumentException(String.format("Illegal object for naming %s", objectToName));
        }
        objectName = objectName + ".name";
        this.addStringLocalization(objectName, lang, name);
    }

    @Deprecated
    public static void addName(Object objectToName, String name) {
        LanguageRegistry.instance().addNameForObject(objectToName, "en_US", name);
    }

    @Deprecated
    public void mergeLanguageTable(Map field_135032_a, String lang) {
        Properties usPack;
        Properties langPack = this.modLanguageData.get(lang);
        if (langPack != null) {
            this.mergeWithoutOverwrite(langPack, field_135032_a);
        }
        if ((usPack = this.modLanguageData.get("en_US")) != null) {
            this.mergeWithoutOverwrite(usPack, field_135032_a);
        }
    }

    @Deprecated
    private <K, V> void mergeWithoutOverwrite(Map<? extends K, ? extends V> from, Map<K, V> to) {
        for (Map.Entry<K, V> e : from.entrySet()) {
            if (to.containsKey(e.getKey())) continue;
            to.put(e.getKey(), e.getValue());
        }
    }

    @Deprecated
    public void loadLocalization(String localizationFile, String lang, boolean isXML) {
        URL urlResource = this.getClass().getResource(localizationFile);
        if (urlResource != null) {
            this.loadLocalization(urlResource, lang, isXML);
        } else {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            if (activeModContainer != null) {
                FMLLog.log(activeModContainer.getModId(), Level.ERROR, "The language resource %s cannot be located on the classpath. This is a programming error.", localizationFile);
            } else {
                FMLLog.log(Level.ERROR, "The language resource %s cannot be located on the classpath. This is a programming error.", localizationFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void loadLocalization(URL localizationFile, String lang, boolean isXML) {
        InputStream langStream = null;
        Properties langPack = new Properties();
        try {
            langStream = localizationFile.openStream();
            if (isXML) {
                langPack.loadFromXML(langStream);
            } else {
                langPack.load(new InputStreamReader(langStream, Charsets.UTF_8));
            }
            this.addStringLocalization(langPack, lang);
        }
        catch (IOException e) {
            FMLLog.log(Level.ERROR, e, "Unable to load localization from file %s", localizationFile);
        }
        finally {
            try {
                if (langStream != null) {
                    langStream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void injectLanguage(String language, HashMap<String, String> parsedLangFile) {
        Properties p = this.modLanguageData.get(language);
        if (p == null) {
            p = new Properties();
            this.modLanguageData.put(language, p);
        }
        p.putAll((Map<?, ?>)parsedLangFile);
    }

    public void loadLanguagesFor(ModContainer container, Side side) {
        File source = container.getSource();
        try {
            if (source.isDirectory()) {
                this.searchDirForLanguages(source, "", side);
            } else {
                this.searchZipForLanguages(source, side);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private void searchZipForLanguages(File source, Side side) throws IOException {
        ZipFile zf = new ZipFile(source);
        for (ZipEntry zipEntry : Collections.list(zf.entries())) {
            Matcher matcher = assetENUSLang.matcher(zipEntry.getName());
            if (!matcher.matches()) continue;
            String lang = matcher.group(2);
            FMLLog.fine("Injecting found translation data for lang %s in zip file %s at %s into language system", lang, source.getName(), zipEntry.getName());
            LanguageRegistry.instance().injectLanguage(lang, de.parseLangFile((InputStream)zf.getInputStream(zipEntry)));
            if (!"en_US".equals(lang) || side != Side.SERVER) continue;
            de.inject((InputStream)zf.getInputStream(zipEntry));
        }
        zf.close();
    }

    private void searchDirForLanguages(File source, String path, Side side) throws IOException {
        for (File file : source.listFiles()) {
            Matcher matcher;
            String currPath = path + file.getName();
            if (file.isDirectory()) {
                this.searchDirForLanguages(file, currPath + '/', side);
            }
            if (!(matcher = assetENUSLang.matcher(currPath)).matches()) continue;
            String lang = matcher.group(2);
            FMLLog.fine("Injecting found translation assets for lang %s at %s into language system", lang, currPath);
            LanguageRegistry.instance().injectLanguage(lang, de.parseLangFile((InputStream)new FileInputStream(file)));
            if (!"en_US".equals(lang) || side != Side.SERVER) continue;
            de.inject((InputStream)new FileInputStream(file));
        }
    }
}

